
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#include <QTextStream>
#include <iostream>
#include "grpgroupingmonitor.h"

namespace pappso {
GrpGroupingMonitor::GrpGroupingMonitor()
{
      _p_out = new QTextStream(stderr, QIODevice::WriteOnly);
}

GrpGroupingMonitor::~GrpGroupingMonitor()
{
  
  _p_out->flush();
  delete _p_out;
}

void GrpGroupingMonitor::startGrouping(std::size_t total_number_protein) {
  _total_number_protein = total_number_protein;
  _current_protein = 0;
  (*_p_out) << "start grouping\n";
  _p_out->flush();
}
void GrpGroupingMonitor::groupingProtein(){
  _current_protein++;
  (*_p_out) << "grouping protein " << _current_protein << " on " << _total_number_protein << "\n";
  _p_out->flush();
}
void GrpGroupingMonitor::startRemovingNonInformativeSubGroupsInAllGroups(std::size_t total_number_group){
  (*_p_out) << "removing non informative subgroups in all groups (" << total_number_group << ")\n";
  _p_out->flush();
}
void GrpGroupingMonitor::stopRemovingNonInformativeSubGroupsInAllGroups(std::size_t total_number_group){
    (*_p_out) << "removing non informative subgroups finished, remaining " << total_number_group << " groups\n";
  _p_out->flush();
}
void GrpGroupingMonitor::removingNonInformativeSubGroupsInGroup(){
     (*_p_out) << "removing non informative on a single group\n";
     _p_out->flush();
}
void GrpGroupingMonitor::startNumberingAllGroups(std::size_t total_number_group){
  (*_p_out) << "numbering " << total_number_group << " groups\n";
  _p_out->flush();
}
void GrpGroupingMonitor::stopGrouping(){
  (*_p_out) << "grouping finished\n";
  _p_out->flush();
}

}