
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/

#ifndef GRPEXPERIMENT_H
#define GRPEXPERIMENT_H


#include <memory>
#include <map>
#include <QString>
#include <QDebug>
#include "../types.h"
#include "grpgroupingmonitor.h"
#include "grppeptideset.h"

namespace pappso {

class GrpPeptide;


class GrpProtein;
typedef std::shared_ptr<const GrpProtein> GrpProteinSpConst;
typedef std::shared_ptr<GrpProtein> GrpProteinSp;
typedef std::shared_ptr<const GrpPeptide> GrpPeptideSpConst;
typedef std::shared_ptr<GrpPeptide> GrpPeptideSp;

class GrpGroup;
typedef std::shared_ptr<const GrpGroup> GrpGroupSpConst;
typedef std::shared_ptr<GrpGroup> GrpGroupSp;

class GrpSubGroup;
typedef std::shared_ptr<const GrpSubGroup> GrpSubGroupSpConst;
typedef std::shared_ptr<GrpSubGroup> GrpSubGroupSp;

class GrpSubGroupSet;

class GrpExperiment
{

public:
    GrpProteinSp & getGrpProteinSp(const QString & acc, const QString & description);
    GrpPeptideSp & setGrpPeptide(const GrpProteinSp & proteinSp,const QString & sequence, pappso_double mass);

    GrpExperiment(GrpGroupingMonitorInterface * p_monitor);
    ~GrpExperiment();

    void startGrouping();

    std::vector<GrpProteinSpConst> getGrpProteinSpList() const;

    void setRemoveNonInformativeSubgroups(bool ok) {
        _remove_non_informative_subgroups=ok;
    };
    void addPostGroupingGrpProteinSpRemoval(GrpProteinSp sp_protein);
    
    std::vector <GrpGroupSpConst> getGrpGroupSpList() const;

private:

    void addSubGroupSp(GrpSubGroupSp & grpSubGroupSp);
    void numbering();
    void removeNonInformativeSubGroups();


private :
    GrpGroupingMonitorInterface * _p_monitor=nullptr;
    bool _remove_non_informative_subgroups = true;
    std::map<QString, GrpProteinSp> _map_proteins;
    std::map<QString, std::map<unsigned long, GrpPeptideSp> > _map_peptides;

    std::list<GrpPeptideSp> _grpPeptideList;
    std::list<GrpProteinSp> _grpProteinList;
    bool _groupingStarted = false;
    std::list<GrpProtein *> _remainingGrpProteinList;
    
    GrpPeptideSet _grp_post_grouping_protein_list_removal;

    std::list <GrpGroupSp> _grpGroupSpList;

protected:
    void addSubGroupInGroupList(std::list< GrpGroupSp > & new_group_sp_list, GrpSubGroupSp & sub_group_sp) const;
};
}
#endif // GRPEXPERIMENT_H
