/**
 * \file pappsomspp/core/processing/cbor/mzcbor/spectrum.h
 * \date 24/11/2025
 * \author Olivier Langella
 * \brief PSI spectrum object for mzML/mzCBOR
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include <QString>
#include "pappsomspp/core/trace/trace.h"
#include "pappsomspp/core/processing/cbor/cborstreamreader.h"
#include "pappsomspp/core/processing/cbor/mzcbor/cvparam.h"
#include "pappsomspp/core/processing/cbor/mzcbor/precursor.h"
#include "pappsomspp/core/processing/cbor/mzcbor/binarydataarray.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @todo write docs
 */
struct Spectrum
{
  void fromCbor(CborStreamReader &reader, bool want_binary_data);
  static std::map<QString, pappso::cbor::mzcbor::CvParam>
  readScanCvParams(CborStreamReader &reader);

  void decodeTrace(pappso::Trace &trace);

  uint getMsLevel() const;
  double getRtInSeconds() const;

  QString id;
  std::size_t index;
  std::size_t defaultArrayLength;

  std::map<QString, pappso::cbor::mzcbor::CvParam> cvParamMap;
  std::map<QString, pappso::cbor::mzcbor::CvParam> scanListCvParamMap;
  std::map<QString, pappso::cbor::mzcbor::CvParam> scanCvParamMap;
  std::map<QString, pappso::cbor::mzcbor::CvParam> precursorListCvParamMap;
  QCborMap cborScanList;
  std::vector<Precursor> precursorList;
  std::vector<BinaryDataArray> binaryDataArrayList;
  QCborMap cborBinaryDataArray;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
