/**
 * \file pappsomspp/core/processing/cbor/mzcbor/mzcborindexreader.cpp
 * \date 03/12/2025
 * \author Olivier Langella
 * \brief read mzcbor index file
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#include "mzcborindexreader.h"


pappso::cbor::mzcbor::MzcborIndexReader::MzcborIndexReader()
{
}

pappso::cbor::mzcbor::MzcborIndexReader::~MzcborIndexReader()
{
}

void
pappso::cbor::mzcbor::MzcborIndexReader::close()
{
}

void
pappso::cbor::mzcbor::MzcborIndexReader::readCbor(QFile *cborp)
{
  qDebug();
  initCborReader(cborp);

  qDebug();
  if(mpa_cborReader->isMap())
    {
      readRoot();
    }
  qDebug();
}


void
pappso::cbor::mzcbor::MzcborIndexReader::readRoot()
{
  qDebug();
  mpa_cborReader->enterContainer();

  while(getExpectedString())
    {

      if(m_expectedString == "informations")
        {
          QCborMap cbor_informations;
          mpa_cborReader->readCborMap(cbor_informations);
        }
      else if(m_expectedString == "from")
        {
          m_isMzcborIndex = true;
          qDebug() << m_expectedString;
          if(getExpectedString())
            {
              m_from = m_expectedString;
            }
        }
      else if(m_expectedString == "runIdList")
        {
          mpa_cborReader->readArray(m_runIdList);
        }
      else if(m_expectedString == "runSpectrumIndexList")
        {
          std::size_t length = mpa_cborReader->length();
          mpa_cborReader->enterContainer();
          for(std::size_t i = 0; i < length; i++)
            {
              m_runAndSpectrumOffsetList.push_back(std::vector<qint64>());
              mpa_cborReader->readArray(m_runAndSpectrumOffsetList.back());
            }
          mpa_cborReader->leaveContainer();
        }
      else if(m_expectedString == "runSpectrumNativeIdList")
        {
          std::size_t length = mpa_cborReader->length();
          mpa_cborReader->enterContainer();
          for(std::size_t i = 0; i < length; i++)
            {
              m_runAndSpectrumIdList.push_back(std::vector<QString>());
              mpa_cborReader->readArray(m_runAndSpectrumIdList.back());
            }
          mpa_cborReader->leaveContainer();
        }
    }
  mpa_cborReader->leaveContainer();
}


bool
pappso::cbor::mzcbor::MzcborIndexReader::isMzcborIndex() const
{
  return m_isMzcborIndex;
}


const std::vector<QString> &
pappso::cbor::mzcbor::MzcborIndexReader::getRunIdList() const
{

  return m_runIdList;
}

const std::vector<std::vector<qint64>> &
pappso::cbor::mzcbor::MzcborIndexReader::getRunAndSpectrumOffsetList() const
{
  return m_runAndSpectrumOffsetList;
}

const std::vector<std::vector<QString>> &
pappso::cbor::mzcbor::MzcborIndexReader::getRunAndSpectrumIdList() const
{
  return m_runAndSpectrumIdList;
}
