# This file should be included if the command line reads like this:
# x86_64-w64-mingw32.shared-cmake -DMXE=1 -G "Unix Makefiles" -DCMAKE_BUILD_TYPE=Release ../../development

MESSAGE("MXE (M cross environment) https://mxe.cc/")
message("Please run the configuration like this:")
message("x86_64-w64-mingw32.shared-cmake -DMXE=1 -G "Unix Makefiles" -DCMAKE_BUILD_TYPE=Release ../../development")


set(HOME_DEVEL_DIR "/home/rusconi/devel")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)
set(CMAKE_C_IMPLICIT_LINK_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/bin)

set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)
set(CMAKE_CXX_IMPLICIT_LINK_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/bin)


if(WIN32 OR _WIN32)
	message(STATUS "Building with WIN32 defined.")
endif()


find_package(ZLIB REQUIRED)

# Unfortunately no CMake configuration file is available.
# find_package(QUAZIP REQUIRED)

set(QUAZIP_FOUND 1)
set(QUAZIP_INCLUDE_DIR "${HOME_DEVEL_DIR}/quazip/development/quazip")
set(QUAZIP_LIBRARIES "${HOME_DEVEL_DIR}/quazip/build-area/mxe/quazip/libquazip1-qt6.dll")
set(QUAZIP_ZLIB_INCLUDE_DIR ${ZLIB_INCLUDE_DIRS})
set(QUAZIP_INCLUDE_DIRS ${QUAZIP_INCLUDE_DIR} ${QUAZIP_ZLIB_INCLUDE_DIR})

message(STATUS "QUAZIP_INCLUDE_DIR :${QUAZIP_INCLUDE_DIR}")

if(NOT TARGET QuaZip::QuaZip)
	add_library(QuaZip::QuaZip UNKNOWN IMPORTED)
	set_target_properties(QuaZip::QuaZip PROPERTIES
		IMPORTED_LOCATION             ${QUAZIP_LIBRARIES}
		INTERFACE_INCLUDE_DIRECTORIES ${QUAZIP_INCLUDE_DIR})
endif()
