#include <odsstream/tsvdirectorywriter.h>
#include <odsstream/tsvoutputstream.h>
#include <QDebug>
#include <iostream>
#include <odsstream/writer/options/odscolorscale.h>
#include <odsstream/odsexception.h>

using namespace std;

int
main(int argc, char **argv)
{

  // file.open(QIODevice::WriteOnly);
  try
    {
      TsvDirectoryWriter writer(QDir("test"));

      QString test("truc");

      writer.writeSheet("classeur");
      writer.setCellAnnotation("test annot");
      writer.writeCell(test);
      writer.writeLine();
      writer.writeEmptyCell();
      writer.writeCell("coucou");
      bool vf(0);
      writer.writeCell(vf);
      writer.writeCellPercentage(0.23565654545);

      writer.clearTableCellStyleRef();
      writer.writeLine();
      writer.writeLine();
      writer.writeLine();
      writer.writeCell(1);
      QString start_position = writer.getOdsCellCoordinate();
      writer.writeCell(2);
      writer.writeCell(3);
      writer.writeCell(4);
      writer.writeCell(5);

      writer.writeLine();
      writer.writeCell(6);
      writer.writeCell(7);
      writer.writeCell(8);
      writer.writeCell(9);
      writer.writeCell(10);
      QString end_position = writer.getOdsCellCoordinate();

      OdsColorScale color_scale(start_position, end_position);
      writer.addColorScale(color_scale);


      writer.writeSheet("classeur2");
      writer.setCellAnnotation("test annot");
      writer.writeCell(test);
      writer.writeLine();
      writer.writeEmptyCell();
      writer.writeCell("coucou");

      QDateTime currentdate(QDateTime::currentDateTime());

      writer.writeCell(currentdate);

      writer.close();

      QTextStream terminalOut(stdout, QIODevice::WriteOnly);
      TsvOutputStream writero(terminalOut);


      writero.writeSheet("classeur");
      writero.writeCell(test);
      writero.writeLine();
      writero.writeEmptyCell();
      writero.setCellAnnotation("ne sera pas prise en compte en TSV");
      writero.writeCell("coucou");
      writero.writeCell(vf);


      writero.writeCell(currentdate);

      writero.close();
    }
  catch(OdsException &ods_error)
    {
      cerr << QObject::tr("error writing test directory:\n %1")
                .arg(ods_error.qwhat())
                .toStdString()
                .c_str();
      return 1;
    }

  // SUCCESS
  return 0;
}
