#download Qt5 mingw64 environment from :
#http://www.rpmfind.net//linux/RPM/fedora/21/x86_64/m/mingw64-qt5-qtbase-5.3.2-1.fc21.noarch.html
#ftp://195.220.108.108/linux/sourceforge/p/ps/pspp4windows/used-repositories/2015-06-19/win64/src/mingw64-zlib-1.2.8-8.13.src.rpm
#http://rpm.pbone.net/index.php3/stat/4/idpl/24061932/dir/opensuse_12.x/com/mingw64-quazip-0.4.4-2.39.noarch.rpm.html

# cd buildwin64
# cmake -DCMAKE_BUILD_TYPE=Release -DCMAKE_TOOLCHAIN_FILE=../win64/Toolchain-mingw64.cmake ..

SET (QT_DEFINITIONS "QT_DLL")

SET (MINGW 1)
SET (USEQT4 1)
SET (USEQT5 1)
SET (BUILD_WITH_QT4 1)

# this one is important
SET(CMAKE_SYSTEM_NAME Windows)
#this one not so much
SET(CMAKE_SYSTEM_VERSION 1)

SET (WINDAUBE_ENV_PATH /opt/win64)
# it worked on 27 nov 2013 :
# download and install from http://download.qt-project.org/archive/qt/4.8/4.8.2/ the mingw32 version

#SET(QMAKE_PREFIX    /usr/bin/qmake-qt4 -spec win32-crossCompil-g++ CONFIG=release)
#SET(QT_PREFIX    /usr/local/src/mingw32_f15/qt-4.7.1/i686-pc-mingw32/sys-root/mingw)
#SET(QT_PREFIX    /usr/local/src/mingw_qt/usr/i686-pc-mingw32/sys-root/mingw)
SET(QT_PREFIX    ${WINDAUBE_ENV_PATH}/Qt64-4.8.6)

SET (ZLIB_PREFIX   ${WINDAUBE_ENV_PATH}/zlib-1.2.8)

SET(QT5_PREFIX    ${WINDAUBE_ENV_PATH}/Qt64-5.3.2)

set (QUAZIP_INCLUDE_DIR ${WINDAUBE_ENV_PATH}/quazip-0.7.1)
set (QUAZIP_LIBRARIES 1)
INCLUDE_DIRECTORIES(${QUAZIP_INCLUDE_DIR})

set (QUAZIP_QT5_LIBRARIES ${WINDAUBE_ENV_PATH}/quazip-0.7.1/buildwin64/libquazip.dll.a)

set (QUAZIP_QT4_LIBRARIES ${WINDAUBE_ENV_PATH}/quazip-0.7.1/buildwin64/libquazip.dll.a)



SET (Qt5Core_DIR "/usr/lib/x86_64-linux-gnu/cmake/Qt5Core")
SET (Qt5Concurrent_DIR "/usr/lib/x86_64-linux-gnu/cmake/Qt5Concurrent")
SET (Qt5Gui_DIR "/usr/lib/x86_64-linux-gnu/cmake/Qt5Gui")
SET (Qt5Xml_DIR "/usr/lib/x86_64-linux-gnu/cmake/Qt5Xml")

IF (USEQT5)
SET (CMAKE_MODULE_PATH "${Qt5Core_DIR} ${Qt5Concurrent_DIR} ${Qt5Gui_DIR}")
message( "CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH}")
  SET (CMAKE_FIND_LIBRARY_PREFIXES "${QT5_PREFIX}/lib")
  SET (CMAKE_FIND_LIBRARY_SUFFIXES ".dll")
  FIND_PACKAGE( Qt5Core REQUIRED )
  FIND_PACKAGE( Qt5Concurrent REQUIRED )
  FIND_PACKAGE( Qt5Gui REQUIRED )
  FIND_PACKAGE( Qt5Xml REQUIRED )
  
   set(Qt5Core_LIBRARY_DIRS "${QT5_PREFIX}/lib") 
  SET(Qt5Core_LIBRARY "Qt5Core.dll")
  SET(Qt5Core_LIBRARIES ${Qt5Core_LIBRARY})
  
  
  set(Qt5Core_HEADERS_DIR ${QT5_PREFIX}/include)
  set(Qt5Core_LIBRARY_DIRS ${QT5_PREFIX}/lib)

  set(Qt5Core_LIBRARY ${QT5_PREFIX}/lib/libQt5Core.dll.a)
  set(Qt5Core_LIBRARY_RELEASE ${QT5_PREFIX}/lib/libQt5Core.dll.a)
  set(Qt5Core_INCLUDE_DIR ${QT5_PREFIX}/include/QtCore)

  SET(Qt5Core_FOUND 1)
ENDIF(USEQT5)

#SET(QT_MOC_EXECUTABLE      /usr/local/src/QtSDK/Desktop/Qt/4.8.1/gcc/bin/moc)
#SET(QMAKE_UIC      /usr/local/src/QtSDK/Desktop/Qt/4.8.1/gcc/bin/uic)
#SET(QMAKE_RCC      /usr/local/src/QtSDK/Desktop/Qt/4.8.1/gcc/bin/rcc)

# specify the cross compiler
#cc++
SET(CMAKE_C_COMPILER   /usr/bin/x86_64-w64-mingw32-gcc)
SET(CMAKE_CXX_COMPILER /usr/bin/x86_64-w64-mingw32-g++)
SET(CMAKE_RC_COMPILER /usr/bin/x86_64-w64-mingw32-windres)

# where is the target environment
#http://qt.nokia.com/downloads/windows-cpp
SET(CMAKE_FIND_ROOT_PATH  /usr/i586-mingw32msvc ${QT_PREFIX} )

# search for programs in the build host directories
SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
# for libraries and headers in the target directories
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)


set (CMAKE_CXX_FLAGS " -fexceptions -mthreads -fmessage-length=0 -fident ")

set(ADD_MINGW_EXE_LINKER_FLAGS
  " -static-libgcc -static-libstdc++ "
  )
#--enable-auto-import
#set(CMAKE_EXE_LINKER_FLAGS
#"${CMAKE_EXE_LINKER_FLAGS} -Wl,--enable-auto-import"
#)
# remove console
#set(CMAKE_EXE_LINKER_FLAGS
#"${CMAKE_EXE_LINKER_FLAGS} -Wl,--subsystem,windows"
#)

#set(
#CMAKE_SHARED_LIBRARY_CXX_FLAGS
#"${CMAKE_SHARED_LIBRARY_CXX_FLAGS} -Wl,--enable-auto-import "
#)
set(
CMAKE_SHARED_LIBRARY_CXX_FLAGS
"${CMAKE_SHARED_LIBRARY_CXX_FLAGS} -shared -Wl,--subsystem,windows -DDLL"
)

set(QT_HEADERS_DIR ${QT_PREFIX}/include)
set(QT_LIBRARY_DIR ${QT_PREFIX}/lib)

set(QT_QTCORE_LIBRARY ${QT_PREFIX}/lib/libQtCore4.dll.a)
set(QT_QTCORE_LIBRARY_RELEASE ${QT_PREFIX}/lib/libQtCore4.dll.a)
set(QT_QTCORE_INCLUDE_DIR ${QT_PREFIX}/include/QtCore)

set(QT_QTXML_LIBRARY ${QT_PREFIX}/lib/libQtXml4.dll.a)
set(QT_QTXML_LIBRARY_RELEASE ${QT_PREFIX}/lib/libQtXml4.dll.a)
set(QT_QTXML_INCLUDE_DIR ${QT_PREFIX}/include/QtXml)


#set(QT_BINARY_DIR   ${QT_PREFIX}/bin)
#set(QT_LIBRARY_DIR  ${QT_PREFIX}/lib)
#set(QT_QTCORE_LIBRARY   ${QT_PREFIX}/lib/libQtCore4.dll.a)
#set(QT_QTCORE_INCLUDE_DIR ${QT_PREFIX}/include/QtCore)
#set(QT_MOC_EXECUTABLE  ${QT_PREFIX}/moc)
#set(QT_QMAKE_EXECUTABLE  ${QT_PREFIX}/qmake)
#set(QT_UIC_EXECUTABLE  ${QT_PREFIX}/uic)

SET (ZLIB_LIBRARY ${ZLIB_PREFIX}/lib/libz.dll.a)
SET (ZLIB_INCLUDE_DIR ${ZLIB_PREFIX}/include)