/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2013  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef ODSDOCREADER_H
#define ODSDOCREADER_H

#include <quazip/quazip.h>

#include "reader/odscell.h"

class SaxHandlerContentXml;

class OdsDocReader
{
friend SaxHandlerContentXml;
public:
    /**
     * creates an ODS reader from an input stream
     *
     * @Param QIODevice * device a pointer on the ODS stream to read
     */

    OdsDocReader(QIODevice * device);
    virtual ~OdsDocReader();
    /**
     * callback that indicates the begining of a data sheet. Override it in
     * order to retrieve information about the current data sheet.
     *
     */
    virtual void startSheet(const QString & sheet_name) {};

    /**
    * callback that indicates the end of the current data sheet. Override it if
    * needed
    */
    virtual void endSheet() {};

    /**
     * callback that indicates a new line start. Override it if needed.
     */

    virtual void startLine() {};

    /**
     * callback that indicates a line ending. Override it if needed.
     */

    virtual void endLine() {};

    /**
     * callback that report the content of the current cell in a dedicated Cell
     * object. Override it if you need to retrieve cell content.
     */
    virtual void setCell(const OdsCell &) {};

    /**
     * callback that report the end of the ODS document. Override it if you need
     * to know that reading is finished.
     */
    virtual void endDocument() {};
private:
    void setInsideCell(const OdsCell & cell);
    void startInsideLine();

    
    QuaZip * _p_quaZip;

    uint _column_number;
};

#endif // ODSDOCREADER_H
