/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2013  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "metaxml.h"
#include <QDateTime>

#include <quazip/quazipfile.h>
QHash<QString, QString> * MetaXml::_p_hashNamespaceURI = new  QHash<QString, QString>();

const QString & MetaXml::getNamespaceURI(const QString & xml_namespace) {
    if (_p_hashNamespaceURI->size() == 0) {
        _p_hashNamespaceURI->insert("anim","urn:oasis:names:tc:opendocument:xmlns:animation:1.0");
        _p_hashNamespaceURI->insert("chart",
                                    "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        _p_hashNamespaceURI->insert("config",
                                    "urn:oasis:names:tc:opendocument:xmlns:config:1.0");
        _p_hashNamespaceURI->insert("db",
                                    "urn:oasis:names:tc:opendocument:xmlns:database:1.0");
        _p_hashNamespaceURI->insert("dc",
                                    "http://purl.org/dc/elements/1.1/");
        _p_hashNamespaceURI->insert("dr3d",
                                    "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        _p_hashNamespaceURI->insert("draw",
                                    "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        _p_hashNamespaceURI->insert("fo",
                                    "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        _p_hashNamespaceURI->insert("form",
                                    "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        _p_hashNamespaceURI->insert("grddl",
                                    "http://www.w3.org/2003/g/data-view#");
        _p_hashNamespaceURI->insert("math",
                                    "http://www.w3.org/1998/Math/MathML");
        _p_hashNamespaceURI->insert("meta",
                                    "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        _p_hashNamespaceURI->insert("number",
                                    "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        _p_hashNamespaceURI->insert("of",
                                    "urn:oasis:names:tc:opendocument:xmlns:of:1.2");
        _p_hashNamespaceURI->insert("office",
                                    "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        _p_hashNamespaceURI->insert("ooo",
                                    "http://openoffice.org/2004/office");
        _p_hashNamespaceURI->insert("presentation",
                                    "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0");
        _p_hashNamespaceURI->insert("script",
                                    "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        _p_hashNamespaceURI->insert("smil",
                                    "urn:oasis:names:tc:opendocument:xmlns:smil-compatible:1.0");
        _p_hashNamespaceURI->insert("style",
                                    "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        _p_hashNamespaceURI->insert("svg",
                                    "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        _p_hashNamespaceURI->insert("table",
                                    "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        _p_hashNamespaceURI->insert("text",
                                    "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        _p_hashNamespaceURI->insert("xforms",
                                    "http://www.w3.org/2002/xforms");
        _p_hashNamespaceURI->insert("xhtml","http://www.w3.org/1999/xhtml");
        _p_hashNamespaceURI->insert("xlink","http://www.w3.org/1999/xlink");

    }
    return _p_hashNamespaceURI->operator[](xml_namespace);
}


MetaXml::MetaXml(QuaZip * p_quaZip): _p_quaZip(p_quaZip)
{
    QuaZipFile outFile(_p_quaZip);
    QuaZipNewInfo info("meta.xml");
    outFile.open(QIODevice::WriteOnly,info);
    _p_writer = new QXmlStreamWriter(&outFile);
    _p_writer->setAutoFormatting(true);

    this->WriteHeader();

    _p_writer->writeStartElement(MetaXml::getNamespaceURI("office"), "meta");

    /*
     * see RFC2616, or 3.1.1 in the oasis doc : meta:generator
     */
    _p_writer->writeStartElement(MetaXml::getNamespaceURI("meta"), "generator");
    _p_writer->writeCharacters("LibOdsStream/0.0.1");
    _p_writer->writeEndElement();

    QDateTime currentdate (QDateTime::currentDateTime());

    _p_writer->writeStartElement(MetaXml::getNamespaceURI("meta"), "creation-date");
    _p_writer->writeCharacters(currentdate.toString("yyyy-MM-dd'T'HH:mm:ss"));
    _p_writer->writeEndElement();

    _p_writer->writeStartElement(MetaXml::getNamespaceURI("dc"), "date");
    _p_writer->writeCharacters(currentdate.toString("yyyy-MM-dd'T'HH:mm:ss"));
    _p_writer->writeEndElement();

    _p_writer->writeStartElement(MetaXml::getNamespaceURI("meta"), "editing-cycles");
    _p_writer->writeCharacters("1");
    _p_writer->writeEndElement();

    _p_writer->writeStartElement(MetaXml::getNamespaceURI("meta"), "editing-duration");
    _p_writer->writeCharacters("PT0.602S");
    _p_writer->writeEndElement();

    _p_writer->writeEndDocument();

    delete _p_writer;

    outFile.close();
}

void MetaXml::WriteHeader() {
    _p_writer->writeStartDocument("UTF-8", "1.0");
    MetaXml::getNamespaceURI("office");
    QHash<QString, QString>::iterator i;
    for (i = MetaXml::_p_hashNamespaceURI->begin(); i != MetaXml::_p_hashNamespaceURI->end(); ++i) {
        _p_writer->writeNamespace(i.value(), i.key());
    }

    // <manifest:manifest
    // xmlns:manifest="urn:oasis:names:tc:opendocument:xmlns:manifest:1.0"
    // manifest:version="1.2" >
    _p_writer->writeStartElement(MetaXml::getNamespaceURI("office"), "document-meta");
    _p_writer->writeAttribute(MetaXml::getNamespaceURI("office"),"version", "1.2");
    // writer.setPrefix("manifest", namespaceURI);
    // writer.setDefaultNamespace(namespaceURI);
    // writer.writeStartElement("mzXML");

}


MetaXml::~MetaXml()
{

}

