/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2013  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef CONTENTXML_H
#define CONTENTXML_H

#include <quazip/quazip.h>
#include <quazip/quazipfile.h>
#include <QXmlStreamWriter>
#include <QUrl>
#include <QDate>
#include <QDateTime>



class ContentXml
{
public :
    ContentXml(QuaZip * p_quaZip);
    virtual ~ContentXml();
    void writeSheet(const QString & sheetName);
    void writeCell(double value);
    void writeCell(int value);
    void writeCell(const QString & value);
    void writeCell(const QDate &);
    void writeCell(const QDateTime &);
    void writeCell(const QUrl &, const QString &);
    void writeCell(bool value);
    void writeLine();
    void close();
private:
    void writeCellFloat(const QString & value, const QString & representation);
    void writeSheet();

    void WriteHeader();
    void writeFontFaceDecls();
    void writeAutomaticStyles();

    QuaZipFile _outFile;

    static QString _xsdNamespaceURI;
    static QString _xsiNamespaceURI;


    QuaZip * _p_quaZip;
    QXmlStreamWriter * _p_writer;

    bool _tableStarted;

    bool _tableRowStarted;

};

#endif // CONTENTXML_H
