/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2013  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef ODSDOCWRITER_H
#define ODSDOCWRITER_H

#include <QIODevice>
#include <QString>
#include <QUrl>

#include <quazip/quazip.h>
#include "structure/contentxml.h"

class OdsDocWriter
{
public:
    OdsDocWriter(QIODevice * device);

    void close();

    void writeSheet(const QString & sheetName);
    void writeLine();
    void writeCell(const char *);
    void writeCell(const QString &);
    void writeEmptyCell();
    void writeCell(int);
    void writeCell(float);
    void writeCell(double);
    void writeCell(bool);
    void writeCell(const QDate &);
    void writeCell(const QDateTime &);
    void writeCell(const QUrl &, const QString &);

private:
    ContentXml * _p_content;
    QuaZip * _p_quaZip;
};

#endif // ODSDOCWRITER_H
