## DIctionnary of known mods in unimod website to be used for gp-read-diann.py


UNIMOD = {
	"UniMod:1":{"unimod": "UniMod:1", "mass_modification":42.010565
, "name":"Acetyl", "descr":"Acetylation"},
	"UniMod:2":{"unimod": "UniMod:2", "mass_modification":-0.984016
, "name":"Amidated", "descr":"Amidation"},
	"UniMod:3":{"unimod": "UniMod:3", "mass_modification":226.077598
, "name":"Biotin", "descr":"Biotinylation"},
	"UniMod:4":{"unimod": "UniMod:4", "mass_modification":57.021464
, "name":"Carbamidomethyl", "descr":"Iodoacetamide derivative"},
	"UniMod:5":{"unimod": "UniMod:5", "mass_modification":43.005814
, "name":"Carbamyl", "descr":"Carbamylation"},
	"UniMod:6":{"unimod": "UniMod:6", "mass_modification":58.005479
, "name":"Carboxymethyl", "descr":"Iodoacetic acid derivative"},
	"UniMod:7":{"unimod": "UniMod:7", "mass_modification":0.984016
, "name":"Deamidated", "descr":"Deamidation"},
	"UniMod:8":{"unimod": "UniMod:8", "mass_modification":486.251206
, "name":"ICAT-G", "descr":"Gygi ICAT(TM) d0"},
	"UniMod:9":{"unimod": "UniMod:9", "mass_modification":494.30142
, "name":"ICAT-G:2H(8)", "descr":"Gygi ICAT(TM) d8"},
	"UniMod:10":{"unimod": "UniMod:10", "mass_modification":-29.992806
, "name":"Met->Hse", "descr":"Homoserine"},
	"UniMod:11":{"unimod": "UniMod:11", "mass_modification":-48.003371
, "name":"Met->Hsl", "descr":"Homoserine lactone"},
	"UniMod:12":{"unimod": "UniMod:12", "mass_modification":450.275205
, "name":"ICAT-D:2H(8)", "descr":"Applied Biosystems original ICAT(TM) d8"},
	"UniMod:13":{"unimod": "UniMod:13", "mass_modification":442.224991
, "name":"ICAT-D", "descr":"Applied Biosystems original ICAT(TM) d0"},
	"UniMod:17":{"unimod": "UniMod:17", "mass_modification":99.068414
, "name":"NIPCAM", "descr":"N-isopropylcarboxamidomethyl"},
	"UniMod:20":{"unimod": "UniMod:20", "mass_modification":414.193691
, "name":"PEO-Iodoacetyl-LC-Biotin", "descr":"Biotinyl-iodoacetamidyl-3,6-dioxaoctanediamine"},
	"UniMod:21":{"unimod": "UniMod:21", "mass_modification":79.966331
, "name":"Phospho", "descr":"Phosphorylation"},
	"UniMod:2007":{"unimod": "UniMod:2007", "mass_modification":108.975121
, "name":"Methamidophos-S", "descr":"S-methyl amino phosphinate"},
	"UniMod:23":{"unimod": "UniMod:23", "mass_modification":-18.010565
, "name":"Dehydrated", "descr":"Dehydration"},
	"UniMod:24":{"unimod": "UniMod:24", "mass_modification":71.037114
, "name":"Propionamide", "descr":"Acrylamide adduct"},
	"UniMod:25":{"unimod": "UniMod:25", "mass_modification":119.037114
, "name":"Pyridylacetyl", "descr":"pyridylacetyl"},
	"UniMod:26":{"unimod": "UniMod:26", "mass_modification":39.994915
, "name":"Pyro-carbamidomethyl", "descr":"S-carbamoylmethylcysteine cyclization (N-terminus)"},
	"UniMod:27":{"unimod": "UniMod:27", "mass_modification":-18.010565
, "name":"Glu->pyro-Glu", "descr":"Pyro-glu from E"},
	"UniMod:28":{"unimod": "UniMod:28", "mass_modification":-17.026549
, "name":"Gln->pyro-Glu", "descr":"Pyro-glu from Q"},
	"UniMod:29":{"unimod": "UniMod:29", "mass_modification":127.063329
, "name":"SMA", "descr":"N-Succinimidyl-2-morpholine acetate"},
	"UniMod:30":{"unimod": "UniMod:30", "mass_modification":21.981943
, "name":"Cation:Na", "descr":"Sodium adduct"},
	"UniMod:31":{"unimod": "UniMod:31", "mass_modification":105.057849
, "name":"Pyridylethyl", "descr":"S-pyridylethylation"},
	"UniMod:34":{"unimod": "UniMod:34", "mass_modification":14.01565
, "name":"Methyl", "descr":"Methylation"},
	"UniMod:35":{"unimod": "UniMod:35", "mass_modification":15.994915
, "name":"Oxidation", "descr":"Oxidation or Hydroxylation"},
	"UniMod:36":{"unimod": "UniMod:36", "mass_modification":28.0313
, "name":"Dimethyl", "descr":"di-Methylation"},
	"UniMod:37":{"unimod": "UniMod:37", "mass_modification":42.04695
, "name":"Trimethyl", "descr":"tri-Methylation"},
	"UniMod:39":{"unimod": "UniMod:39", "mass_modification":45.987721
, "name":"Methylthio", "descr":"Beta-methylthiolation"},
	"UniMod:40":{"unimod": "UniMod:40", "mass_modification":79.956815
, "name":"Sulfo", "descr":"O-Sulfonation"},
	"UniMod:41":{"unimod": "UniMod:41", "mass_modification":162.052824
, "name":"Hex", "descr":"Hexose"},
	"UniMod:42":{"unimod": "UniMod:42", "mass_modification":188.032956
, "name":"Lipoyl", "descr":"Lipoyl"},
	"UniMod:43":{"unimod": "UniMod:43", "mass_modification":203.079373
, "name":"HexNAc", "descr":"N-Acetylhexosamine"},
	"UniMod:44":{"unimod": "UniMod:44", "mass_modification":204.187801
, "name":"Farnesyl", "descr":"Farnesylation"},
	"UniMod:45":{"unimod": "UniMod:45", "mass_modification":210.198366
, "name":"Myristoyl", "descr":"Myristoylation"},
	"UniMod:46":{"unimod": "UniMod:46", "mass_modification":229.014009
, "name":"PyridoxalPhosphate", "descr":"Pyridoxal phosphate"},
	"UniMod:47":{"unimod": "UniMod:47", "mass_modification":238.229666
, "name":"Palmitoyl", "descr":"Palmitoylation"},
	"UniMod:48":{"unimod": "UniMod:48", "mass_modification":272.250401
, "name":"GeranylGeranyl", "descr":"Geranyl-geranyl"},
	"UniMod:49":{"unimod": "UniMod:49", "mass_modification":340.085794
, "name":"Phosphopantetheine", "descr":"Phosphopantetheine"},
	"UniMod:50":{"unimod": "UniMod:50", "mass_modification":783.141486
, "name":"FAD", "descr":"Flavin adenine dinucleotide"},
	"UniMod:51":{"unimod": "UniMod:51", "mass_modification":788.725777
, "name":"Tripalmitate", "descr":"N-acyl diglyceride cysteine"},
	"UniMod:52":{"unimod": "UniMod:52", "mass_modification":42.021798
, "name":"Guanidinyl", "descr":"Guanidination"},
	"UniMod:53":{"unimod": "UniMod:53", "mass_modification":156.11503
, "name":"HNE", "descr":"4-hydroxynonenal (HNE)"},
	"UniMod:54":{"unimod": "UniMod:54", "mass_modification":176.032088
, "name":"Glucuronyl", "descr":"hexuronic acid"},
	"UniMod:55":{"unimod": "UniMod:55", "mass_modification":305.068156
, "name":"Glutathione", "descr":"glutathione disulfide"},
	"UniMod:56":{"unimod": "UniMod:56", "mass_modification":45.029395
, "name":"Acetyl:2H(3)", "descr":"Acetate labeling reagent (N-term & K) (heavy form, +3amu)"},
	"UniMod:58":{"unimod": "UniMod:58", "mass_modification":56.026215
, "name":"Propionyl", "descr":"Propionate labeling reagent light form (N-term & K)"},
	"UniMod:59":{"unimod": "UniMod:59", "mass_modification":59.036279
, "name":"Propionyl:13C(3)", "descr":"Propionate labeling reagent heavy form (+3amu), N-term & K"},
	"UniMod:60":{"unimod": "UniMod:60", "mass_modification":127.099714
, "name":"GIST-Quat", "descr":"Quaternary amine labeling reagent light form (N-term & K)"},
	"UniMod:61":{"unimod": "UniMod:61", "mass_modification":130.118544
, "name":"GIST-Quat:2H(3)", "descr":"Quaternary amine labeling reagent heavy (+3amu) form, N-term & K"},
	"UniMod:62":{"unimod": "UniMod:62", "mass_modification":133.137375
, "name":"GIST-Quat:2H(6)", "descr":"Quaternary amine labeling reagent heavy form (+6amu), N-term & K"},
	"UniMod:63":{"unimod": "UniMod:63", "mass_modification":136.156205
, "name":"GIST-Quat:2H(9)", "descr":"Quaternary amine labeling reagent heavy form (+9amu), N-term & K"},
	"UniMod:64":{"unimod": "UniMod:64", "mass_modification":100.016044
, "name":"Succinyl", "descr":"Succinic anhydride labeling reagent light form (N-term & K)"},
	"UniMod:65":{"unimod": "UniMod:65", "mass_modification":104.041151
, "name":"Succinyl:2H(4)", "descr":"Succinic anhydride labeling reagent, heavy form (+4amu, 4H2), N-term & K"},
	"UniMod:66":{"unimod": "UniMod:66", "mass_modification":104.029463
, "name":"Succinyl:13C(4)", "descr":"Succinic anhydride labeling reagent, heavy form (+4amu, 4C13), N-term & K"},
	"UniMod:357":{"unimod": "UniMod:357", "mass_modification":258.115047
, "name":"probiotinhydrazide", "descr":"oxidized proline biotinylated with biotin hydrazide"},
	"UniMod:359":{"unimod": "UniMod:359", "mass_modification":13.979265
, "name":"Pro->pyro-Glu", "descr":"proline oxidation to pyroglutamic acid"},
	"UniMod:348":{"unimod": "UniMod:348", "mass_modification":-23.015984
, "name":"His->Asn", "descr":"His->Asn substitution"},
	"UniMod:349":{"unimod": "UniMod:349", "mass_modification":-22.031969
, "name":"His->Asp", "descr":"His->Asp substitution"},
	"UniMod:350":{"unimod": "UniMod:350", "mass_modification":19.989829
, "name":"Trp->Hydroxykynurenin", "descr":"tryptophan oxidation to hydroxykynurenin"},
	"UniMod:256":{"unimod": "UniMod:256", "mass_modification":40.0313
, "name":"Delta:H(4)C(3)", "descr":"Propionaldehyde +40"},
	"UniMod:255":{"unimod": "UniMod:255", "mass_modification":28.0313
, "name":"Delta:H(4)C(2)", "descr":"Acetaldehyde +28"},
	"UniMod:368":{"unimod": "UniMod:368", "mass_modification":-33.987721
, "name":"Cys->Dha", "descr":"Dehydroalanine (from Cysteine)"},
	"UniMod:344":{"unimod": "UniMod:344", "mass_modification":-43.053433
, "name":"Arg->GluSA", "descr":"Arginine oxidation to glutamic semialdehyde"},
	"UniMod:345":{"unimod": "UniMod:345", "mass_modification":47.984744
, "name":"Trioxidation", "descr":"cysteine oxidation to cysteic acid"},
	"UniMod:89":{"unimod": "UniMod:89", "mass_modification":225.093583
, "name":"Iminobiotin", "descr":"Iminobiotinylation"},
	"UniMod:90":{"unimod": "UniMod:90", "mass_modification":338.177647
, "name":"ESP", "descr":"ESP-Tag light d0"},
	"UniMod:91":{"unimod": "UniMod:91", "mass_modification":348.240414
, "name":"ESP:2H(10)", "descr":"ESP-Tag heavy d10"},
	"UniMod:92":{"unimod": "UniMod:92", "mass_modification":339.161662
, "name":"NHS-LC-Biotin", "descr":"NHS-LC-Biotin"},
	"UniMod:93":{"unimod": "UniMod:93", "mass_modification":601.206246
, "name":"EDT-maleimide-PEO-biotin", "descr":"EDT-maleimide-PEO-biotin"},
	"UniMod:94":{"unimod": "UniMod:94", "mass_modification":68.037448
, "name":"IMID", "descr":"IMID d0"},
	"UniMod:95":{"unimod": "UniMod:95", "mass_modification":72.062555
, "name":"IMID:2H(4)", "descr":"IMID d4"},
	"UniMod:353":{"unimod": "UniMod:353", "mass_modification":241.088497
, "name":"Lysbiotinhydrazide", "descr":"oxidized Lysine biotinylated with biotin hydrazide"},
	"UniMod:97":{"unimod": "UniMod:97", "mass_modification":74.055944
, "name":"Propionamide:2H(3)", "descr":"Acrylamide d3"},
	"UniMod:354":{"unimod": "UniMod:354", "mass_modification":44.985078
, "name":"Nitro", "descr":"Oxidation to nitro"},
	"UniMod:105":{"unimod": "UniMod:105", "mass_modification":227.126991
, "name":"ICAT-C", "descr":"Applied Biosystems cleavable ICAT(TM) light"},
	"UniMod:254":{"unimod": "UniMod:254", "mass_modification":26.01565
, "name":"Delta:H(2)C(2)", "descr":"Acetaldehyde +26"},
	"UniMod:351":{"unimod": "UniMod:351", "mass_modification":3.994915
, "name":"Trp->Kynurenin", "descr":"tryptophan oxidation to kynurenin"},
	"UniMod:352":{"unimod": "UniMod:352", "mass_modification":-1.031634
, "name":"Lys->Allysine", "descr":"Lysine oxidation to aminoadipic semialdehyde"},
	"UniMod:106":{"unimod": "UniMod:106", "mass_modification":236.157185
, "name":"ICAT-C:13C(9)", "descr":"Applied Biosystems cleavable ICAT(TM) heavy"},
	"UniMod:107":{"unimod": "UniMod:107", "mass_modification":159.035399
, "name":"FormylMet", "descr":"Addition of N-formyl met"},
	"UniMod:108":{"unimod": "UniMod:108", "mass_modification":125.047679
, "name":"Nethylmaleimide", "descr":"N-ethylmaleimide on cysteines"},
	"UniMod:112":{"unimod": "UniMod:112", "mass_modification":354.172562
, "name":"OxLysBiotinRed", "descr":"Oxidized lysine biotinylated with biotin-LC-hydrazide, reduced"},
	"UniMod:119":{"unimod": "UniMod:119", "mass_modification":316.138088
, "name":"IBTP", "descr":"Thio Ether Formation - BTP Adduct"},
	"UniMod:113":{"unimod": "UniMod:113", "mass_modification":352.156911
, "name":"OxLysBiotin", "descr":"Oxidized lysine biotinylated with biotin-LC-hydrazide"},
	"UniMod:114":{"unimod": "UniMod:114", "mass_modification":371.199111
, "name":"OxProBiotinRed", "descr":"Oxidized proline biotinylated with biotin-LC-hydrazide, reduced"},
	"UniMod:115":{"unimod": "UniMod:115", "mass_modification":369.183461
, "name":"OxProBiotin", "descr":"Oxidized Proline biotinylated with biotin-LC-hydrazide"},
	"UniMod:116":{"unimod": "UniMod:116", "mass_modification":310.135113
, "name":"OxArgBiotin", "descr":"Oxidized arginine biotinylated with biotin-LC-hydrazide"},
	"UniMod:117":{"unimod": "UniMod:117", "mass_modification":312.150763
, "name":"OxArgBiotinRed", "descr":"Oxidized arginine biotinylated with biotin-LC-hydrazide, reduced"},
	"UniMod:118":{"unimod": "UniMod:118", "mass_modification":490.174218
, "name":"EDT-iodoacetyl-PEO-biotin", "descr":"EDT-iodo-PEO-biotin"},
	"UniMod:121":{"unimod": "UniMod:121", "mass_modification":114.042927
, "name":"GG", "descr":"ubiquitinylation residue"},
	"UniMod:122":{"unimod": "UniMod:122", "mass_modification":27.994915
, "name":"Formyl", "descr":"Formylation"},
	"UniMod:123":{"unimod": "UniMod:123", "mass_modification":345.097915
, "name":"ICAT-H", "descr":"N-iodoacetyl, p-chlorobenzyl-12C6-glucamine"},
	"UniMod:124":{"unimod": "UniMod:124", "mass_modification":351.118044
, "name":"ICAT-H:13C(6)", "descr":"N-iodoacetyl, p-chlorobenzyl-13C6-glucamine"},
	"UniMod:530":{"unimod": "UniMod:530", "mass_modification":37.955882
, "name":"Cation:K", "descr":"Replacement of proton by potassium"},
	"UniMod:126":{"unimod": "UniMod:126", "mass_modification":87.998285
, "name":"Xlink:DTSSP[88]", "descr":"Cleaved and reduced DSP/DTSSP crosslinker"},
	"UniMod:1897":{"unimod": "UniMod:1897", "mass_modification":226.047738
, "name":"Xlink:EGS[226]", "descr":"Intact EGS cross-linker"},
	"UniMod:127":{"unimod": "UniMod:127", "mass_modification":17.990578
, "name":"Fluoro", "descr":"fluorination"},
	"UniMod:128":{"unimod": "UniMod:128", "mass_modification":387.074287
, "name":"Fluorescein", "descr":"5-Iodoacetamidofluorescein (Molecular Probe, Eugene, OR)"},
	"UniMod:129":{"unimod": "UniMod:129", "mass_modification":125.896648
, "name":"Iodo", "descr":"Iodination"},
	"UniMod:130":{"unimod": "UniMod:130", "mass_modification":251.793296
, "name":"Diiodo", "descr":"di-Iodination"},
	"UniMod:131":{"unimod": "UniMod:131", "mass_modification":377.689944
, "name":"Triiodo", "descr":"tri-Iodination"},
	"UniMod:134":{"unimod": "UniMod:134", "mass_modification":208.182715
, "name":"Myristoleyl", "descr":"(cis-delta 5)-tetradecaenoyl"},
	"UniMod:360":{"unimod": "UniMod:360", "mass_modification":-30.010565
, "name":"Pro->Pyrrolidinone", "descr":"Proline oxidation to pyrrolidinone"},
	"UniMod:135":{"unimod": "UniMod:135", "mass_modification":206.167065
, "name":"Myristoyl+Delta:H(-4)", "descr":"(cis,cis-delta 5, delta 8)-tetradecadienoyl"},
	"UniMod:136":{"unimod": "UniMod:136", "mass_modification":104.026215
, "name":"Benzoyl", "descr":"labeling reagent light form (N-term & K)"},
	"UniMod:137":{"unimod": "UniMod:137", "mass_modification":1216.422863
, "name":"Hex(5)HexNAc(2)", "descr":"M5/Man5"},
	"UniMod:139":{"unimod": "UniMod:139", "mass_modification":233.051049
, "name":"Dansyl", "descr":"5-dimethylaminonaphthalene-1-sulfonyl"},
	"UniMod:140":{"unimod": "UniMod:140", "mass_modification":-46.005479
, "name":"a-type-ion", "descr":"ISD a-series (C-Term)"},
	"UniMod:141":{"unimod": "UniMod:141", "mass_modification":41.026549
, "name":"Amidine", "descr":"amidination of lysines or N-terminal amines with methyl acetimidate"},
	"UniMod:142":{"unimod": "UniMod:142", "mass_modification":349.137281
, "name":"HexNAc(1)dHex(1)", "descr":"HexNAc1dHex1"},
	"UniMod:143":{"unimod": "UniMod:143", "mass_modification":406.158745
, "name":"HexNAc(2)", "descr":"HexNAc2"},
	"UniMod:144":{"unimod": "UniMod:144", "mass_modification":486.158471
, "name":"Hex(3)", "descr":"Hex3"},
	"UniMod:145":{"unimod": "UniMod:145", "mass_modification":495.19519
, "name":"HexNAc(1)dHex(2)", "descr":"HexNAc1dHex2"},
	"UniMod:146":{"unimod": "UniMod:146", "mass_modification":511.190105
, "name":"Hex(1)HexNAc(1)dHex(1)", "descr":"Hex1HexNAc1dHex1"},
	"UniMod:147":{"unimod": "UniMod:147", "mass_modification":552.216654
, "name":"HexNAc(2)dHex(1)", "descr":"HexNAc2dHex1"},
	"UniMod:148":{"unimod": "UniMod:148", "mass_modification":568.211569
, "name":"Hex(1)HexNAc(2)", "descr":"Hex1HexNAc2"},
	"UniMod:149":{"unimod": "UniMod:149", "mass_modification":656.227613
, "name":"Hex(1)HexNAc(1)NeuAc(1)", "descr":"Hex1HexNAc1NeuAc1"},
	"UniMod:150":{"unimod": "UniMod:150", "mass_modification":698.274563
, "name":"HexNAc(2)dHex(2)", "descr":"HexNAc2dHex2"},
	"UniMod:151":{"unimod": "UniMod:151", "mass_modification":700.253828
, "name":"Hex(1)HexNAc(2)Pent(1)", "descr":"Hex1HexNAc2Pent1"},
	"UniMod:152":{"unimod": "UniMod:152", "mass_modification":714.269478
, "name":"Hex(1)HexNAc(2)dHex(1)", "descr":"Hex1HexNAc2dHex1"},
	"UniMod:153":{"unimod": "UniMod:153", "mass_modification":730.264392
, "name":"Hex(2)HexNAc(2)", "descr":"Hex2HexNAc2"},
	"UniMod:154":{"unimod": "UniMod:154", "mass_modification":821.280102
, "name":"Hex(3)HexNAc(1)Pent(1)", "descr":"Hex3HexNAc1Pent1"},
	"UniMod:155":{"unimod": "UniMod:155", "mass_modification":846.311736
, "name":"Hex(1)HexNAc(2)dHex(1)Pent(1)", "descr":"Hex1HexNAc2dHex1Pent1"},
	"UniMod:156":{"unimod": "UniMod:156", "mass_modification":860.327386
, "name":"Hex(1)HexNAc(2)dHex(2)", "descr":"Hex1HexNAc2dHex2"},
	"UniMod:157":{"unimod": "UniMod:157", "mass_modification":862.306651
, "name":"Hex(2)HexNAc(2)Pent(1)", "descr":"Hex2HexNAc2Pent1"},
	"UniMod:158":{"unimod": "UniMod:158", "mass_modification":876.322301
, "name":"Hex(2)HexNAc(2)dHex(1)", "descr":"Hex2HexNAc2dHex1"},
	"UniMod:159":{"unimod": "UniMod:159", "mass_modification":892.317216
, "name":"Hex(3)HexNAc(2)", "descr":"M3/Man3"},
	"UniMod:160":{"unimod": "UniMod:160", "mass_modification":947.323029
, "name":"Hex(1)HexNAc(1)NeuAc(2)", "descr":"Hex HexNAc NeuAc(2) ---OR--- Hex HexNAc(3) HexA"},
	"UniMod:161":{"unimod": "UniMod:161", "mass_modification":972.283547
, "name":"Hex(3)HexNAc(2)Phos(1)", "descr":"Hex(3) HexNAc(2) Phos"},
	"UniMod:162":{"unimod": "UniMod:162", "mass_modification":47.944449
, "name":"Delta:S(-1)Se(1)", "descr":"Selenium replaces sulfur"},
	"UniMod:171":{"unimod": "UniMod:171", "mass_modification":159.008578
, "name":"NBS:13C(6)", "descr":"Shimadzu NBS-13C"},
	"UniMod:329":{"unimod": "UniMod:329", "mass_modification":18.037835
, "name":"Methyl:2H(3)13C(1)", "descr":"monomethylation"},
	"UniMod:330":{"unimod": "UniMod:330", "mass_modification":36.07567
, "name":"Dimethyl:2H(6)13C(2)", "descr":"dimethylation"},
	"UniMod:172":{"unimod": "UniMod:172", "mass_modification":152.988449
, "name":"NBS", "descr":"Shimadzu NBS-12C"},
	"UniMod:170":{"unimod": "UniMod:170", "mass_modification":2.988261
, "name":"Delta:H(-1)N(-1)18O(1)", "descr":"glycosylated asparagine 18O labeling"},
	"UniMod:195":{"unimod": "UniMod:195", "mass_modification":171.149738
, "name":"QAT", "descr":"APTA-d0"},
	"UniMod:176":{"unimod": "UniMod:176", "mass_modification":218.167065
, "name":"BHT", "descr":"Michael addition of BHT quinone methide to Cysteine and Lysine"},
	"UniMod:327":{"unimod": "UniMod:327", "mass_modification":44.008456
, "name":"Delta:H(4)C(2)O(-1)S(1)", "descr":"S-Ethylcystine from Serine"},
	"UniMod:178":{"unimod": "UniMod:178", "mass_modification":87.050655
, "name":"DAET", "descr":"phosphorylation to amine thiol"},
	"UniMod:369":{"unimod": "UniMod:369", "mass_modification":-27.994915
, "name":"Pro->Pyrrolidone", "descr":"Pyrrolidone from Proline"},
	"UniMod:184":{"unimod": "UniMod:184", "mass_modification":9.030193
, "name":"Label:13C(9)", "descr":"13C(9) Silac label"},
	"UniMod:185":{"unimod": "UniMod:185", "mass_modification":88.996524
, "name":"Label:13C(9)+Phospho", "descr":"C13 label (Phosphotyrosine)"},
	"UniMod:188":{"unimod": "UniMod:188", "mass_modification":6.020129
, "name":"Label:13C(6)", "descr":"13C(6) Silac label"},
	"UniMod:186":{"unimod": "UniMod:186", "mass_modification":132.021129
, "name":"HPG", "descr":"Hydroxyphenylglyoxal arginine"},
	"UniMod:187":{"unimod": "UniMod:187", "mass_modification":282.052824
, "name":"2HPG", "descr":"bis(hydroxphenylglyoxal) arginine"},
	"UniMod:196":{"unimod": "UniMod:196", "mass_modification":174.168569
, "name":"QAT:2H(3)", "descr":"APTA d3"},
	"UniMod:193":{"unimod": "UniMod:193", "mass_modification":4.008491
, "name":"Label:18O(2)", "descr":"O18 label at both C-terminal oxygens"},
	"UniMod:194":{"unimod": "UniMod:194", "mass_modification":170.048013
, "name":"AccQTag", "descr":"6-aminoquinolyl-N-hydroxysuccinimidyl carbamate"},
	"UniMod:199":{"unimod": "UniMod:199", "mass_modification":32.056407
, "name":"Dimethyl:2H(4)", "descr":"DiMethyl-CHD2"},
	"UniMod:197":{"unimod": "UniMod:197", "mass_modification":184.157563
, "name":"EQAT", "descr":"EAPTA d0"},
	"UniMod:198":{"unimod": "UniMod:198", "mass_modification":189.188947
, "name":"EQAT:2H(5)", "descr":"EAPTA d5"},
	"UniMod:200":{"unimod": "UniMod:200", "mass_modification":75.980527
, "name":"Ethanedithiol", "descr":"EDT"},
	"UniMod:212":{"unimod": "UniMod:212", "mass_modification":90.084148
, "name":"NEIAA:2H(5)", "descr":"N-ethyl iodoacetamide-d5"},
	"UniMod:205":{"unimod": "UniMod:205", "mass_modification":94.041865
, "name":"Delta:H(6)C(6)O(1)", "descr":"Acrolein addition +94"},
	"UniMod:206":{"unimod": "UniMod:206", "mass_modification":56.026215
, "name":"Delta:H(4)C(3)O(1)", "descr":"Acrolein addition +56"},
	"UniMod:207":{"unimod": "UniMod:207", "mass_modification":38.01565
, "name":"Delta:H(2)C(3)", "descr":"Acrolein addition +38"},
	"UniMod:208":{"unimod": "UniMod:208", "mass_modification":76.0313
, "name":"Delta:H(4)C(6)", "descr":"Acrolein addition +76"},
	"UniMod:209":{"unimod": "UniMod:209", "mass_modification":112.05243
, "name":"Delta:H(8)C(6)O(2)", "descr":"Acrolein addition +112"},
	"UniMod:213":{"unimod": "UniMod:213", "mass_modification":541.06111
, "name":"ADP-Ribosyl", "descr":"ADP  Ribose addition"},
	"UniMod:211":{"unimod": "UniMod:211", "mass_modification":85.052764
, "name":"NEIAA", "descr":"N-ethyl iodoacetamide-d0"},
	"UniMod:214":{"unimod": "UniMod:214", "mass_modification":144.102063
, "name":"iTRAQ4plex", "descr":"Representative mass and accurate mass for 116 & 117"},
	"UniMod:253":{"unimod": "UniMod:253", "mass_modification":70.041865
, "name":"Crotonaldehyde", "descr":"Crotonaldehyde"},
	"UniMod:340":{"unimod": "UniMod:340", "mass_modification":77.910511
, "name":"Bromo", "descr":"bromination"},
	"UniMod:342":{"unimod": "UniMod:342", "mass_modification":15.010899
, "name":"Amino", "descr":"Tyrosine oxidation to 2-aminotyrosine"},
	"UniMod:343":{"unimod": "UniMod:343", "mass_modification":199.066699
, "name":"Argbiotinhydrazide", "descr":"oxidized Arginine biotinylated with biotin hydrazide"},
	"UniMod:258":{"unimod": "UniMod:258", "mass_modification":2.004246
, "name":"Label:18O(1)", "descr":"O18 Labeling"},
	"UniMod:259":{"unimod": "UniMod:259", "mass_modification":8.014199
, "name":"Label:13C(6)15N(2)", "descr":"13C(6) 15N(2) Silac label"},
	"UniMod:260":{"unimod": "UniMod:260", "mass_modification":95.943487
, "name":"Thiophospho", "descr":"Thiophosphorylation"},
	"UniMod:261":{"unimod": "UniMod:261", "mass_modification":214.971084
, "name":"SPITC", "descr":"4-sulfophenyl isothiocyanate"},
	"UniMod:243":{"unimod": "UniMod:243", "mass_modification":296.016039
, "name":"IGBP", "descr":"Light IDBEST tag for quantitation"},
	"UniMod:270":{"unimod": "UniMod:270", "mass_modification":362.136553
, "name":"Cytopiloyne", "descr":"nucleophilic addtion to cytopiloyne"},
	"UniMod:271":{"unimod": "UniMod:271", "mass_modification":380.147118
, "name":"Cytopiloyne+water", "descr":"nucleophilic addition to cytopiloyne+H2O"},
	"UniMod:267":{"unimod": "UniMod:267", "mass_modification":10.008269
, "name":"Label:13C(6)15N(4)", "descr":"13C(6) 15N(4) Silac label"},
	"UniMod:269":{"unimod": "UniMod:269", "mass_modification":10.027228
, "name":"Label:13C(9)15N(1)", "descr":"13C(9) 15N(1) Silac label"},
	"UniMod:262":{"unimod": "UniMod:262", "mass_modification":3.01883
, "name":"Label:2H(3)", "descr":"Trideuteration"},
	"UniMod:268":{"unimod": "UniMod:268", "mass_modification":6.013809
, "name":"Label:13C(5)15N(1)", "descr":"13C(5) 15N(1) Silac label"},
	"UniMod:264":{"unimod": "UniMod:264", "mass_modification":121.035005
, "name":"PET", "descr":"phosphorylation to pyridyl thiol"},
	"UniMod:272":{"unimod": "UniMod:272", "mass_modification":135.983029
, "name":"CAF", "descr":"sulfonation of N-terminus"},
	"UniMod:1905":{"unimod": "UniMod:1905", "mass_modification":96.021129
, "name":"Xlink:BS2G[96]", "descr":"Intact BS2-G crosslinker"},
	"UniMod:275":{"unimod": "UniMod:275", "mass_modification":28.990164
, "name":"Nitrosyl", "descr":"nitrosylation"},
	"UniMod:2022":{"unimod": "UniMod:2022", "mass_modification":220.058303
, "name":"Ser/Thr-KDO", "descr":"Glycosylation of Serine/Threonine residues with KDO"},
	"UniMod:276":{"unimod": "UniMod:276", "mass_modification":183.035399
, "name":"AEBS", "descr":"Aminoethylbenzenesulfonylation"},
	"UniMod:278":{"unimod": "UniMod:278", "mass_modification":44.026215
, "name":"Ethanolyl", "descr":"Ethanolation"},
	"UniMod:987":{"unimod": "UniMod:987", "mass_modification":36.045499
, "name":"Label:13C(6)15N(2)+Dimethyl", "descr":"Dimethyl 13C(6)15N(2) Silac label"},
	"UniMod:371":{"unimod": "UniMod:371", "mass_modification":86.036779
, "name":"HMVK", "descr":"Michael addition of hydroxymethylvinyl ketone to cysteine"},
	"UniMod:280":{"unimod": "UniMod:280", "mass_modification":28.0313
, "name":"Ethyl", "descr":"Ethylation"},
	"UniMod:281":{"unimod": "UniMod:281", "mass_modification":765.09956
, "name":"CoenzymeA", "descr":"Cysteine modified Coenzyme A"},
	"UniMod:528":{"unimod": "UniMod:528", "mass_modification":14.999666
, "name":"Methyl+Deamidated", "descr":"Deamidation followed by a methylation"},
	"UniMod:529":{"unimod": "UniMod:529", "mass_modification":29.039125
, "name":"Delta:H(5)C(2)", "descr":"Dimethylation of proline residue"},
	"UniMod:284":{"unimod": "UniMod:284", "mass_modification":16.028204
, "name":"Methyl:2H(2)", "descr":"Deuterium Methylation of Lysine"},
	"UniMod:285":{"unimod": "UniMod:285", "mass_modification":155.004099
, "name":"SulfanilicAcid", "descr":"Light Sulfanilic Acid (SA) C12"},
	"UniMod:286":{"unimod": "UniMod:286", "mass_modification":161.024228
, "name":"SulfanilicAcid:13C(6)", "descr":"Heavy Sulfanilic Acid (SA) C13"},
	"UniMod:289":{"unimod": "UniMod:289", "mass_modification":356.188212
, "name":"Biotin-PEO-Amine", "descr":"Biotin polyethyleneoxide amine"},
	"UniMod:288":{"unimod": "UniMod:288", "mass_modification":13.979265
, "name":"Trp->Oxolactone", "descr":"Tryptophan oxidation to oxolactone"},
	"UniMod:290":{"unimod": "UniMod:290", "mass_modification":428.191582
, "name":"Biotin-HPDP", "descr":"Pierce EZ-Link Biotin-HPDP"},
	"UniMod:291":{"unimod": "UniMod:291", "mass_modification":201.970617
, "name":"Delta:Hg(1)", "descr":"Mercury Mercaptan"},
	"UniMod:292":{"unimod": "UniMod:292", "mass_modification":322.020217
, "name":"IodoU-AMP", "descr":"(Iodo)-uracil MP"},
	"UniMod:293":{"unimod": "UniMod:293", "mass_modification":145.019749
, "name":"CAMthiopropanoyl", "descr":"3-(carbamidomethylthio)propanoyl"},
	"UniMod:294":{"unimod": "UniMod:294", "mass_modification":326.141261
, "name":"IED-Biotin", "descr":"biotinoyl-iodoacetyl-ethylenediamine"},
	"UniMod:295":{"unimod": "UniMod:295", "mass_modification":146.057909
, "name":"dHex", "descr":"Fucose"},
	"UniMod:298":{"unimod": "UniMod:298", "mass_modification":17.03448
, "name":"Methyl:2H(3)", "descr":"deuterated methyl ester"},
	"UniMod:299":{"unimod": "UniMod:299", "mass_modification":43.989829
, "name":"Carboxy", "descr":"Carboxylation"},
	"UniMod:301":{"unimod": "UniMod:301", "mass_modification":190.074228
, "name":"Bromobimane", "descr":"Monobromobimane derivative"},
	"UniMod:302":{"unimod": "UniMod:302", "mass_modification":170.036779
, "name":"Menadione", "descr":"Menadione quinone derivative"},
	"UniMod:303":{"unimod": "UniMod:303", "mass_modification":75.998285
, "name":"DeStreak", "descr":"Cysteine mercaptoethanol"},
	"UniMod:305":{"unimod": "UniMod:305", "mass_modification":1444.53387
, "name":"dHex(1)Hex(3)HexNAc(4)", "descr":"FA2/G0F"},
	"UniMod:307":{"unimod": "UniMod:307", "mass_modification":1606.586693
, "name":"dHex(1)Hex(4)HexNAc(4)", "descr":"FA2G1/G1F"},
	"UniMod:2035":{"unimod": "UniMod:2035", "mass_modification":129.042593
, "name":"Pro+O(2)", "descr":"Photo-induced Proline adduct"},
	"UniMod:308":{"unimod": "UniMod:308", "mass_modification":1768.639517
, "name":"dHex(1)Hex(5)HexNAc(4)", "descr":"FA2G2/G2F"},
	"UniMod:309":{"unimod": "UniMod:309", "mass_modification":1298.475961
, "name":"Hex(3)HexNAc(4)", "descr":"A2/G0"},
	"UniMod:310":{"unimod": "UniMod:310", "mass_modification":1460.528784
, "name":"Hex(4)HexNAc(4)", "descr":"A2G1/G1"},
	"UniMod:311":{"unimod": "UniMod:311", "mass_modification":1622.581608
, "name":"Hex(5)HexNAc(4)", "descr":"A2G2/G2"},
	"UniMod:312":{"unimod": "UniMod:312", "mass_modification":119.004099
, "name":"Cysteinyl", "descr":"Cysteinylation"},
	"UniMod:313":{"unimod": "UniMod:313", "mass_modification":-128.094963
, "name":"Lys-loss", "descr":"Loss of Lysine"},
	"UniMod:314":{"unimod": "UniMod:314", "mass_modification":111.032028
, "name":"Nmethylmaleimide", "descr":"Nmethylmaleimide"},
	"UniMod:494":{"unimod": "UniMod:494", "mass_modification":672.298156
, "name":"CyDye-Cy3", "descr":"Cy3 CyDye DIGE Fluor saturation dye"},
	"UniMod:316":{"unimod": "UniMod:316", "mass_modification":78.04695
, "name":"DimethylpyrroleAdduct", "descr":"2,5-dimethypyrrole"},
	"UniMod:318":{"unimod": "UniMod:318", "mass_modification":62.01565
, "name":"Delta:H(2)C(5)", "descr":"MDA adduct +62"},
	"UniMod:319":{"unimod": "UniMod:319", "mass_modification":54.010565
, "name":"Delta:H(2)C(3)O(1)", "descr":"MDA adduct +54"},
	"UniMod:320":{"unimod": "UniMod:320", "mass_modification":143.058243
, "name":"Nethylmaleimide+water", "descr":"Nethylmaleimidehydrolysis"},
	"UniMod:768":{"unimod": "UniMod:768", "mass_modification":59.045045
, "name":"Methyl+Acetyl:2H(3)", "descr":"Mono-methylated lysine labelled with Acetyl_heavy"},
	"UniMod:323":{"unimod": "UniMod:323", "mass_modification":713.093079
, "name":"Xlink:B10621", "descr":"bis-((N-iodoacetyl)piperazinyl)sulfonerhodamine"},
	"UniMod:324":{"unimod": "UniMod:324", "mass_modification":87.01427
, "name":"Xlink:DTBP[87]", "descr":"Cleaved and reduced DTBP crosslinker"},
	"UniMod:325":{"unimod": "UniMod:325", "mass_modification":572.316129
, "name":"FP-Biotin", "descr":"10-ethoxyphosphinyl-N-(biotinamidopentyl)decanamide"},
	"UniMod:332":{"unimod": "UniMod:332", "mass_modification":525.142894
, "name":"Thiophos-S-S-biotin", "descr":"thiophosphate labeled with biotin-HPDP"},
	"UniMod:333":{"unimod": "UniMod:333", "mass_modification":447.195679
, "name":"Can-FP-biotin", "descr":"6-N-biotinylaminohexyl isopropyl phosphate"},
	"UniMod:335":{"unimod": "UniMod:335", "mass_modification":158.13068
, "name":"HNE+Delta:H(2)", "descr":"reduced 4-Hydroxynonenal"},
	"UniMod:361":{"unimod": "UniMod:361", "mass_modification":240.104482
, "name":"Thrbiotinhydrazide", "descr":"oxidized Threonine biotinylated with biotin hydrazide"},
	"UniMod:337":{"unimod": "UniMod:337", "mass_modification":13.031634
, "name":"Methylamine", "descr":"Michael addition with methylamine"},
	"UniMod:362":{"unimod": "UniMod:362", "mass_modification":164.060231
, "name":"Diisopropylphosphate", "descr":"O-Diisopropylphosphorylation"},
	"UniMod:363":{"unimod": "UniMod:363", "mass_modification":122.013281
, "name":"Isopropylphospho", "descr":"O-Isopropylphosphorylation"},
	"UniMod:364":{"unimod": "UniMod:364", "mass_modification":111.041593
, "name":"ICPL:13C(6)", "descr":"Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, heavy form"},
	"UniMod:893":{"unimod": "UniMod:893", "mass_modification":209.018035
, "name":"CarbamidomethylDTT", "descr":"Carbamidomethylated DTT modification of cysteine"},
	"UniMod:365":{"unimod": "UniMod:365", "mass_modification":105.021464
, "name":"ICPL", "descr":"Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, light form"},
	"UniMod:366":{"unimod": "UniMod:366", "mass_modification":2.988261
, "name":"Deamidated:18O(1)", "descr":"Deamidation in presence of O18"},
	"UniMod:372":{"unimod": "UniMod:372", "mass_modification":-42.021798
, "name":"Arg->Orn", "descr":"Ornithine from Arginine"},
	"UniMod:531":{"unimod": "UniMod:531", "mass_modification":61.921774
, "name":"Cation:Cu[I]", "descr":"Replacement of proton by copper"},
	"UniMod:374":{"unimod": "UniMod:374", "mass_modification":-1.007825
, "name":"Dehydro", "descr":"Half of a disulfide bridge"},
	"UniMod:375":{"unimod": "UniMod:375", "mass_modification":142.110613
, "name":"Diphthamide", "descr":"Diphthamide"},
	"UniMod:376":{"unimod": "UniMod:376", "mass_modification":220.182715
, "name":"Hydroxyfarnesyl", "descr":"hydroxyfarnesyl"},
	"UniMod:377":{"unimod": "UniMod:377", "mass_modification":576.511761
, "name":"Diacylglycerol", "descr":"diacylglycerol"},
	"UniMod:378":{"unimod": "UniMod:378", "mass_modification":72.021129
, "name":"Carboxyethyl", "descr":"carboxyethyl"},
	"UniMod:379":{"unimod": "UniMod:379", "mass_modification":87.068414
, "name":"Hypusine", "descr":"hypusine"},
	"UniMod:380":{"unimod": "UniMod:380", "mass_modification":266.203451
, "name":"Retinylidene", "descr":"retinal"},
	"UniMod:381":{"unimod": "UniMod:381", "mass_modification":14.96328
, "name":"Lys->AminoadipicAcid", "descr":"alpha-amino adipic acid"},
	"UniMod:382":{"unimod": "UniMod:382", "mass_modification":-33.003705
, "name":"Cys->PyruvicAcid", "descr":"pyruvic acid from N-term cys"},
	"UniMod:385":{"unimod": "UniMod:385", "mass_modification":-17.026549
, "name":"Ammonia-loss", "descr":"Loss of ammonia"},
	"UniMod:387":{"unimod": "UniMod:387", "mass_modification":586.279135
, "name":"Phycocyanobilin", "descr":"phycocyanobilin"},
	"UniMod:388":{"unimod": "UniMod:388", "mass_modification":588.294785
, "name":"Phycoerythrobilin", "descr":"phycoerythrobilin"},
	"UniMod:389":{"unimod": "UniMod:389", "mass_modification":584.263485
, "name":"Phytochromobilin", "descr":"phytochromobilin"},
	"UniMod:390":{"unimod": "UniMod:390", "mass_modification":616.177295
, "name":"Heme", "descr":"heme"},
	"UniMod:391":{"unimod": "UniMod:391", "mass_modification":521.884073
, "name":"Molybdopterin", "descr":"molybdopterin"},
	"UniMod:392":{"unimod": "UniMod:392", "mass_modification":29.974179
, "name":"Quinone", "descr":"quinone"},
	"UniMod:393":{"unimod": "UniMod:393", "mass_modification":340.100562
, "name":"Glucosylgalactosyl", "descr":"glucosylgalactosyl hydroxylysine"},
	"UniMod:394":{"unimod": "UniMod:394", "mass_modification":123.00853
, "name":"GPIanchor", "descr":"glycosylphosphatidylinositol"},
	"UniMod:395":{"unimod": "UniMod:395", "mass_modification":881.146904
, "name":"PhosphoribosyldephosphoCoA", "descr":"phosphoribosyl dephospho-coenzyme A"},
	"UniMod:396":{"unimod": "UniMod:396", "mass_modification":197.04531
, "name":"GlycerylPE", "descr":"glycerylphosphorylethanolamine"},
	"UniMod:397":{"unimod": "UniMod:397", "mass_modification":469.716159
, "name":"Triiodothyronine", "descr":"triiodo"},
	"UniMod:398":{"unimod": "UniMod:398", "mass_modification":595.612807
, "name":"Thyroxine", "descr":"tetraiodo"},
	"UniMod:400":{"unimod": "UniMod:400", "mass_modification":-94.041865
, "name":"Tyr->Dha", "descr":"Dehydroalanine (from Tyrosine)"},
	"UniMod:401":{"unimod": "UniMod:401", "mass_modification":-2.01565
, "name":"Didehydro", "descr":"2-amino-3-oxo-butanoic_acid"},
	"UniMod:402":{"unimod": "UniMod:402", "mass_modification":-17.992806
, "name":"Cys->Oxoalanine", "descr":"oxoalanine"},
	"UniMod:403":{"unimod": "UniMod:403", "mass_modification":-15.010899
, "name":"Ser->LacticAcid", "descr":"lactic acid from N-term Ser"},
	"UniMod:451":{"unimod": "UniMod:451", "mass_modification":258.085186
, "name":"GluGlu", "descr":"diglutamyl"},
	"UniMod:405":{"unimod": "UniMod:405", "mass_modification":329.05252
, "name":"Phosphoadenosine", "descr":"AMP"},
	"UniMod:450":{"unimod": "UniMod:450", "mass_modification":129.042593
, "name":"Glu", "descr":"monoglutamyl"},
	"UniMod:407":{"unimod": "UniMod:407", "mass_modification":146.036779
, "name":"Hydroxycinnamyl", "descr":"hydroxycinnamyl"},
	"UniMod:408":{"unimod": "UniMod:408", "mass_modification":148.037173
, "name":"Glycosyl", "descr":"glycosyl-L-hydroxyproline"},
	"UniMod:409":{"unimod": "UniMod:409", "mass_modification":454.088965
, "name":"FMNH", "descr":"flavin mononucleotide"},
	"UniMod:410":{"unimod": "UniMod:410", "mass_modification":634.662782
, "name":"Archaeol", "descr":"S-diphytanylglycerol diether"},
	"UniMod:411":{"unimod": "UniMod:411", "mass_modification":119.037114
, "name":"Phenylisocyanate", "descr":"phenyl isocyanate"},
	"UniMod:412":{"unimod": "UniMod:412", "mass_modification":124.068498
, "name":"Phenylisocyanate:2H(5)", "descr":"d5-phenyl isocyanate"},
	"UniMod:413":{"unimod": "UniMod:413", "mass_modification":345.047435
, "name":"Phosphoguanosine", "descr":"phospho-guanosine"},
	"UniMod:414":{"unimod": "UniMod:414", "mass_modification":30.010565
, "name":"Hydroxymethyl", "descr":"hydroxymethyl"},
	"UniMod:415":{"unimod": "UniMod:415", "mass_modification":1620.930224
, "name":"MolybdopterinGD+Delta:S(-1)Se(1)", "descr":"L-selenocysteinyl molybdenum bis(molybdopterin guanine dinucleotide)"},
	"UniMod:416":{"unimod": "UniMod:416", "mass_modification":418.137616
, "name":"Dipyrrolylmethanemethyl", "descr":"dipyrrolylmethanemethyl"},
	"UniMod:417":{"unimod": "UniMod:417", "mass_modification":306.025302
, "name":"PhosphoUridine", "descr":"uridine phosphodiester"},
	"UniMod:419":{"unimod": "UniMod:419", "mass_modification":154.00311
, "name":"Glycerophospho", "descr":"glycerophospho"},
	"UniMod:420":{"unimod": "UniMod:420", "mass_modification":15.977156
, "name":"Carboxy->Thiocarboxy", "descr":"thiocarboxylic acid"},
	"UniMod:421":{"unimod": "UniMod:421", "mass_modification":31.972071
, "name":"Sulfide", "descr":"persulfide"},
	"UniMod:422":{"unimod": "UniMod:422", "mass_modification":70.005479
, "name":"PyruvicAcidIminyl", "descr":"N-pyruvic acid 2-iminyl"},
	"UniMod:423":{"unimod": "UniMod:423", "mass_modification":79.91652
, "name":"Delta:Se(1)", "descr":"selenyl"},
	"UniMod:424":{"unimod": "UniMod:424", "mass_modification":1572.985775
, "name":"MolybdopterinGD", "descr":"molybdenum bis(molybdopterin guanine dinucleotide)"},
	"UniMod:425":{"unimod": "UniMod:425", "mass_modification":31.989829
, "name":"Dioxidation", "descr":"dihydroxy"},
	"UniMod:426":{"unimod": "UniMod:426", "mass_modification":126.104465
, "name":"Octanoyl", "descr":"octanoyl"},
	"UniMod:428":{"unimod": "UniMod:428", "mass_modification":283.045704
, "name":"PhosphoHexNAc", "descr":"N-acetylglucosamine-1-phosphoryl"},
	"UniMod:429":{"unimod": "UniMod:429", "mass_modification":242.019154
, "name":"PhosphoHex", "descr":"phosphoglycosyl-D-mannose-1-phosphoryl"},
	"UniMod:431":{"unimod": "UniMod:431", "mass_modification":236.214016
, "name":"Palmitoleyl", "descr":"palmitoleyl"},
	"UniMod:432":{"unimod": "UniMod:432", "mass_modification":368.344302
, "name":"Cholesterol", "descr":"cholesterol ester"},
	"UniMod:433":{"unimod": "UniMod:433", "mass_modification":264.187801
, "name":"Didehydroretinylidene", "descr":"3,4-didehydroretinylidene"},
	"UniMod:434":{"unimod": "UniMod:434", "mass_modification":294.183109
, "name":"CHDH", "descr":"cis-14-hydroxy-10,13-dioxo-7-heptadecenoic ester"},
	"UniMod:435":{"unimod": "UniMod:435", "mass_modification":109.052764
, "name":"Methylpyrroline", "descr":"4-methyl-delta-1-pyrroline-5-carboxyl"},
	"UniMod:436":{"unimod": "UniMod:436", "mass_modification":614.161645
, "name":"Hydroxyheme", "descr":"hydroxyheme"},
	"UniMod:437":{"unimod": "UniMod:437", "mass_modification":386.110369
, "name":"MicrocinC7", "descr":"(3-aminopropyl)(L-aspartyl-1-amino)phosphoryl-5-adenosine"},
	"UniMod:438":{"unimod": "UniMod:438", "mass_modification":24.995249
, "name":"Cyano", "descr":"cyano"},
	"UniMod:439":{"unimod": "UniMod:439", "mass_modification":342.786916
, "name":"Diironsubcluster", "descr":"hydrogenase diiron subcluster"},
	"UniMod:440":{"unimod": "UniMod:440", "mass_modification":42.021798
, "name":"Amidino", "descr":"amidino"},
	"UniMod:442":{"unimod": "UniMod:442", "mass_modification":438.094051
, "name":"FMN", "descr":"O3-(riboflavin phosphoryl)"},
	"UniMod:443":{"unimod": "UniMod:443", "mass_modification":456.104615
, "name":"FMNC", "descr":"S-(4a-FMN)"},
	"UniMod:444":{"unimod": "UniMod:444", "mass_modification":922.834855
, "name":"CuSMo", "descr":"copper sulfido molybdopterin cytosine dinuncleotide"},
	"UniMod:445":{"unimod": "UniMod:445", "mass_modification":59.04969
, "name":"Hydroxytrimethyl", "descr":"5-hydroxy-N6,N6,N6-trimethyl"},
	"UniMod:447":{"unimod": "UniMod:447", "mass_modification":-15.994915
, "name":"Deoxy", "descr":"reduction"},
	"UniMod:448":{"unimod": "UniMod:448", "mass_modification":831.197041
, "name":"Microcin", "descr":"microcin E492 siderophore ester from serine"},
	"UniMod:449":{"unimod": "UniMod:449", "mass_modification":154.135765
, "name":"Decanoyl", "descr":"lipid"},
	"UniMod:452":{"unimod": "UniMod:452", "mass_modification":387.127779
, "name":"GluGluGlu", "descr":"triglutamyl"},
	"UniMod:453":{"unimod": "UniMod:453", "mass_modification":516.170373
, "name":"GluGluGluGlu", "descr":"tetraglutamyl"},
	"UniMod:454":{"unimod": "UniMod:454", "mass_modification":161.068808
, "name":"HexN", "descr":"Hexosamine"},
	"UniMod:455":{"unimod": "UniMod:455", "mass_modification":154.110613
, "name":"Xlink:DMP[154]", "descr":"Free monolink of DMP crosslinker"},
	"UniMod:457":{"unimod": "UniMod:457", "mass_modification":175.042199
, "name":"NDA", "descr":"naphthalene-2,3-dicarboxaldehyde"},
	"UniMod:464":{"unimod": "UniMod:464", "mass_modification":220.991213
, "name":"SPITC:13C(6)", "descr":"4-sulfophenyl isothiocyanate (Heavy C13)"},
	"UniMod:477":{"unimod": "UniMod:477", "mass_modification":137.16403
, "name":"TMAB:2H(9)", "descr":"d9-4-trimethyllammoniumbutyryl-"},
	"UniMod:476":{"unimod": "UniMod:476", "mass_modification":128.107539
, "name":"TMAB", "descr":"4-trimethyllammoniumbutyryl-"},
	"UniMod:478":{"unimod": "UniMod:478", "mass_modification":421.073241
, "name":"FTC", "descr":"fluorescein-5-thiosemicarbazide"},
	"UniMod:472":{"unimod": "UniMod:472", "mass_modification":59.019355
, "name":"AEC-MAEC", "descr":"aminoethylcysteine"},
	"UniMod:493":{"unimod": "UniMod:493", "mass_modification":340.167459
, "name":"BADGE", "descr":"Bisphenol A diglycidyl ether derivative"},
	"UniMod:481":{"unimod": "UniMod:481", "mass_modification":4.025107
, "name":"Label:2H(4)", "descr":"4,4,5,5-D4 Lysine"},
	"UniMod:490":{"unimod": "UniMod:490", "mass_modification":192.063388
, "name":"Hep", "descr":"Heptose"},
	"UniMod:495":{"unimod": "UniMod:495", "mass_modification":684.298156
, "name":"CyDye-Cy5", "descr":"Cy5 CyDye DIGE Fluor saturation dye"},
	"UniMod:488":{"unimod": "UniMod:488", "mass_modification":118.065674
, "name":"DHP", "descr":"Dehydropyrrolizidine alkaloid (dehydroretronecine) on cysteines"},
	"UniMod:498":{"unimod": "UniMod:498", "mass_modification":234.16198
, "name":"BHTOH", "descr":"Michael addition of t-butyl hydroxylated BHT (BHTOH) to C, H or K"},
	"UniMod:499":{"unimod": "UniMod:499", "mass_modification":298.022748
, "name":"IGBP:13C(2)", "descr":"Heavy IDBEST tag for quantitation"},
	"UniMod:500":{"unimod": "UniMod:500", "mass_modification":129.042593
, "name":"Nmethylmaleimide+water", "descr":"Nmethylmaleimidehydrolysis"},
	"UniMod:501":{"unimod": "UniMod:501", "mass_modification":134.048013
, "name":"PyMIC", "descr":"3-methyl-2-pyridyl isocyanate"},
	"UniMod:503":{"unimod": "UniMod:503", "mass_modification":332.19876
, "name":"LG-lactam-K", "descr":"Levuglandinyl - lysine lactam adduct"},
	"UniMod:519":{"unimod": "UniMod:519", "mass_modification":594.091928
, "name":"BisANS", "descr":"4,4\'-dianilino-1,1\'-binaphthyl-5,5\'-disulfonic acid"},
	"UniMod:520":{"unimod": "UniMod:520", "mass_modification":68.0626
, "name":"Piperidine", "descr":"Piperidination"},
	"UniMod:518":{"unimod": "UniMod:518", "mass_modification":56.0626
, "name":"Diethyl", "descr":"Diethylation, analogous to Dimethylation"},
	"UniMod:504":{"unimod": "UniMod:504", "mass_modification":348.193674
, "name":"LG-Hlactam-K", "descr":"Levuglandinyl - lysine hydroxylactam adduct"},
	"UniMod:510":{"unimod": "UniMod:510", "mass_modification":34.063117
, "name":"Dimethyl:2H(4)13C(2)", "descr":"DiMethyl-C13HD2"},
	"UniMod:513":{"unimod": "UniMod:513", "mass_modification":227.224915
, "name":"C8-QAT", "descr":"[3-(2,5)-Dioxopyrrolidin-1-yloxycarbonyl)-propyl]dimethyloctylammonium"},
	"UniMod:512":{"unimod": "UniMod:512", "mass_modification":324.105647
, "name":"Hex(2)", "descr":"Lactosylation"},
	"UniMod:505":{"unimod": "UniMod:505", "mass_modification":290.176961
, "name":"LG-lactam-R", "descr":"Levuglandinyl - arginine lactam adduct"},
	"UniMod:1036":{"unimod": "UniMod:1036", "mass_modification":470.266839
, "name":"Withaferin", "descr":"Modification of cystein by withaferin"},
	"UniMod:1037":{"unimod": "UniMod:1037", "mass_modification":443.291294
, "name":"Biotin:Thermo-88317", "descr":"desthiobiotin fluorophosphonate"},
	"UniMod:525":{"unimod": "UniMod:525", "mass_modification":141.098318
, "name":"CLIP_TRAQ_2", "descr":"CLIP_TRAQ_2"},
	"UniMod:506":{"unimod": "UniMod:506", "mass_modification":306.171876
, "name":"LG-Hlactam-R", "descr":"Levuglandinyl - arginine hydroxylactam adduct"},
	"UniMod:522":{"unimod": "UniMod:522", "mass_modification":525.225719
, "name":"Maleimide-PEO2-Biotin", "descr":"Maleimide-Biotin"},
	"UniMod:523":{"unimod": "UniMod:523", "mass_modification":452.245726
, "name":"Sulfo-NHS-LC-LC-Biotin", "descr":"Biot_LC_LC"},
	"UniMod:515":{"unimod": "UniMod:515", "mass_modification":427.069202
, "name":"FNEM", "descr":"fluorescein-5-maleimide"},
	"UniMod:514":{"unimod": "UniMod:514", "mass_modification":232.064354
, "name":"PropylNAGthiazoline", "descr":"propyl-1,2-dideoxy-2\'-methyl-alpha-D-glucopyranoso-[2,1-d]-Delta2\'-thiazoline"},
	"UniMod:526":{"unimod": "UniMod:526", "mass_modification":-48.003371
, "name":"Dethiomethyl", "descr":"Prompt loss of side chain from oxidised Met"},
	"UniMod:532":{"unimod": "UniMod:532", "mass_modification":144.105918
, "name":"iTRAQ4plex114", "descr":"Accurate mass for 114"},
	"UniMod:533":{"unimod": "UniMod:533", "mass_modification":144.099599
, "name":"iTRAQ4plex115", "descr":"Accurate mass for 115"},
	"UniMod:534":{"unimod": "UniMod:534", "mass_modification":155.821022
, "name":"Dibromo", "descr":"Dibromo"},
	"UniMod:535":{"unimod": "UniMod:535", "mass_modification":383.228103
, "name":"LRGG", "descr":"Ubiquitination"},
	"UniMod:536":{"unimod": "UniMod:536", "mass_modification":271.148736
, "name":"CLIP_TRAQ_3", "descr":"CLIP_TRAQ_3"},
	"UniMod:537":{"unimod": "UniMod:537", "mass_modification":244.101452
, "name":"CLIP_TRAQ_4", "descr":"CLIP_TRAQ_4"},
	"UniMod:538":{"unimod": "UniMod:538", "mass_modification":626.386577
, "name":"Biotin:Cayman-10141", "descr":"was 15dB-biotin"},
	"UniMod:539":{"unimod": "UniMod:539", "mass_modification":660.428442
, "name":"Biotin:Cayman-10013", "descr":"was PGA1-biotin"},
	"UniMod:540":{"unimod": "UniMod:540", "mass_modification":15.994915
, "name":"Ala->Ser", "descr":"Ala->Ser substitution"},
	"UniMod:541":{"unimod": "UniMod:541", "mass_modification":30.010565
, "name":"Ala->Thr", "descr":"Ala->Thr substitution"},
	"UniMod:542":{"unimod": "UniMod:542", "mass_modification":43.989829
, "name":"Ala->Asp", "descr":"Ala->Asp substitution"},
	"UniMod:543":{"unimod": "UniMod:543", "mass_modification":26.01565
, "name":"Ala->Pro", "descr":"Ala->Pro substitution"},
	"UniMod:544":{"unimod": "UniMod:544", "mass_modification":-14.01565
, "name":"Ala->Gly", "descr":"Ala->Gly substitution"},
	"UniMod:545":{"unimod": "UniMod:545", "mass_modification":58.005479
, "name":"Ala->Glu", "descr":"Ala->Glu substitution"},
	"UniMod:546":{"unimod": "UniMod:546", "mass_modification":28.0313
, "name":"Ala->Val", "descr":"Ala->Val substitution"},
	"UniMod:547":{"unimod": "UniMod:547", "mass_modification":44.059229
, "name":"Cys->Phe", "descr":"Cys->Phe substitution"},
	"UniMod:548":{"unimod": "UniMod:548", "mass_modification":-15.977156
, "name":"Cys->Ser", "descr":"Cys->Ser substitution"},
	"UniMod:549":{"unimod": "UniMod:549", "mass_modification":83.070128
, "name":"Cys->Trp", "descr":"Cys->Trp substitution"},
	"UniMod:550":{"unimod": "UniMod:550", "mass_modification":60.054144
, "name":"Cys->Tyr", "descr":"Cys->Tyr substitution"},
	"UniMod:551":{"unimod": "UniMod:551", "mass_modification":53.091927
, "name":"Cys->Arg", "descr":"Cys->Arg substitution"},
	"UniMod:552":{"unimod": "UniMod:552", "mass_modification":-45.987721
, "name":"Cys->Gly", "descr":"Cys->Gly substitution"},
	"UniMod:553":{"unimod": "UniMod:553", "mass_modification":-43.989829
, "name":"Asp->Ala", "descr":"Asp->Ala substitution"},
	"UniMod:554":{"unimod": "UniMod:554", "mass_modification":22.031969
, "name":"Asp->His", "descr":"Asp->His substitution"},
	"UniMod:555":{"unimod": "UniMod:555", "mass_modification":-0.984016
, "name":"Asp->Asn", "descr":"Asp->Asn substitution"},
	"UniMod:556":{"unimod": "UniMod:556", "mass_modification":-58.005479
, "name":"Asp->Gly", "descr":"Asp->Gly substitution"},
	"UniMod:557":{"unimod": "UniMod:557", "mass_modification":48.036386
, "name":"Asp->Tyr", "descr":"Asp->Tyr substitution"},
	"UniMod:558":{"unimod": "UniMod:558", "mass_modification":14.01565
, "name":"Asp->Glu", "descr":"Asp->Glu substitution"},
	"UniMod:559":{"unimod": "UniMod:559", "mass_modification":-15.958529
, "name":"Asp->Val", "descr":"Asp->Val substitution"},
	"UniMod:560":{"unimod": "UniMod:560", "mass_modification":-58.005479
, "name":"Glu->Ala", "descr":"Glu->Ala substitution"},
	"UniMod:561":{"unimod": "UniMod:561", "mass_modification":-0.984016
, "name":"Glu->Gln", "descr":"Glu->Gln substitution"},
	"UniMod:562":{"unimod": "UniMod:562", "mass_modification":-14.01565
, "name":"Glu->Asp", "descr":"Glu->Asp substitution"},
	"UniMod:563":{"unimod": "UniMod:563", "mass_modification":-0.94763
, "name":"Glu->Lys", "descr":"Glu->Lys substitution"},
	"UniMod:564":{"unimod": "UniMod:564", "mass_modification":-72.021129
, "name":"Glu->Gly", "descr":"Glu->Gly substitution"},
	"UniMod:565":{"unimod": "UniMod:565", "mass_modification":-29.974179
, "name":"Glu->Val", "descr":"Glu->Val substitution"},
	"UniMod:566":{"unimod": "UniMod:566", "mass_modification":-60.036386
, "name":"Phe->Ser", "descr":"Phe->Ser substitution"},
	"UniMod:567":{"unimod": "UniMod:567", "mass_modification":-44.059229
, "name":"Phe->Cys", "descr":"Phe->Cys substitution"},
	"UniMod:568":{"unimod": "UniMod:568", "mass_modification":-33.98435
, "name":"Phe->Xle", "descr":"Phe->Leu/Ile substitution"},
	"UniMod:569":{"unimod": "UniMod:569", "mass_modification":15.994915
, "name":"Phe->Tyr", "descr":"Phe->Tyr substitution"},
	"UniMod:570":{"unimod": "UniMod:570", "mass_modification":-48
, "name":"Phe->Val", "descr":"Phe->Val substitution"},
	"UniMod:571":{"unimod": "UniMod:571", "mass_modification":14.01565
, "name":"Gly->Ala", "descr":"Gly->Ala substitution"},
	"UniMod:572":{"unimod": "UniMod:572", "mass_modification":30.010565
, "name":"Gly->Ser", "descr":"Gly->Ser substitution"},
	"UniMod:573":{"unimod": "UniMod:573", "mass_modification":129.057849
, "name":"Gly->Trp", "descr":"Gly->Trp substitution"},
	"UniMod:574":{"unimod": "UniMod:574", "mass_modification":72.021129
, "name":"Gly->Glu", "descr":"Gly->Glu substitution"},
	"UniMod:575":{"unimod": "UniMod:575", "mass_modification":42.04695
, "name":"Gly->Val", "descr":"Gly->Val substitution"},
	"UniMod:576":{"unimod": "UniMod:576", "mass_modification":58.005479
, "name":"Gly->Asp", "descr":"Gly->Asp substitution"},
	"UniMod:577":{"unimod": "UniMod:577", "mass_modification":45.987721
, "name":"Gly->Cys", "descr":"Gly->Cys substitution"},
	"UniMod:578":{"unimod": "UniMod:578", "mass_modification":99.079647
, "name":"Gly->Arg", "descr":"Gly->Arg substitution"},
	"UniMod:698":{"unimod": "UniMod:698", "mass_modification":109.048119
, "name":"dNIC", "descr":"deuterated Nicotinic Acid"},
	"UniMod:580":{"unimod": "UniMod:580", "mass_modification":-40.006148
, "name":"His->Pro", "descr":"His->Pro substitution"},
	"UniMod:581":{"unimod": "UniMod:581", "mass_modification":26.004417
, "name":"His->Tyr", "descr":"His->Tyr substitution"},
	"UniMod:582":{"unimod": "UniMod:582", "mass_modification":-9.000334
, "name":"His->Gln", "descr":"His->Gln substitution"},
	"UniMod:697":{"unimod": "UniMod:697", "mass_modification":105.021464
, "name":"NIC", "descr":"Nicotinic Acid"},
	"UniMod:584":{"unimod": "UniMod:584", "mass_modification":19.042199
, "name":"His->Arg", "descr":"His->Arg substitution"},
	"UniMod:585":{"unimod": "UniMod:585", "mass_modification":-23.974848
, "name":"His->Xle", "descr":"His->Leu/Ile substitution"},
	"UniMod:1125":{"unimod": "UniMod:1125", "mass_modification":-42.04695
, "name":"Xle->Ala", "descr":"Leu/Ile->Ala substitution"},
	"UniMod:588":{"unimod": "UniMod:588", "mass_modification":-12.036386
, "name":"Xle->Thr", "descr":"Leu/Ile->Thr substitution"},
	"UniMod:589":{"unimod": "UniMod:589", "mass_modification":0.958863
, "name":"Xle->Asn", "descr":"Leu/Ile->Asn substitution"},
	"UniMod:590":{"unimod": "UniMod:590", "mass_modification":15.010899
, "name":"Xle->Lys", "descr":"Leu/Ile->Lys substitution"},
	"UniMod:594":{"unimod": "UniMod:594", "mass_modification":-27.047285
, "name":"Lys->Thr", "descr":"Lys->Thr substitution"},
	"UniMod:595":{"unimod": "UniMod:595", "mass_modification":-14.052036
, "name":"Lys->Asn", "descr":"Lys->Asn substitution"},
	"UniMod:596":{"unimod": "UniMod:596", "mass_modification":0.94763
, "name":"Lys->Glu", "descr":"Lys->Glu substitution"},
	"UniMod:597":{"unimod": "UniMod:597", "mass_modification":-0.036386
, "name":"Lys->Gln", "descr":"Lys->Gln substitution"},
	"UniMod:598":{"unimod": "UniMod:598", "mass_modification":2.945522
, "name":"Lys->Met", "descr":"Lys->Met substitution"},
	"UniMod:599":{"unimod": "UniMod:599", "mass_modification":28.006148
, "name":"Lys->Arg", "descr":"Lys->Arg substitution"},
	"UniMod:600":{"unimod": "UniMod:600", "mass_modification":-15.010899
, "name":"Lys->Xle", "descr":"Lys->Leu/Ile substitution"},
	"UniMod:601":{"unimod": "UniMod:601", "mass_modification":-26.052036
, "name":"Xle->Ser", "descr":"Leu/Ile->Ser substitution"},
	"UniMod:602":{"unimod": "UniMod:602", "mass_modification":33.98435
, "name":"Xle->Phe", "descr":"Leu/Ile->Phe substitution"},
	"UniMod:603":{"unimod": "UniMod:603", "mass_modification":72.995249
, "name":"Xle->Trp", "descr":"Leu/Ile->Trp substitution"},
	"UniMod:604":{"unimod": "UniMod:604", "mass_modification":-16.0313
, "name":"Xle->Pro", "descr":"Leu/Ile->Pro substitution"},
	"UniMod:605":{"unimod": "UniMod:605", "mass_modification":-14.01565
, "name":"Xle->Val", "descr":"Leu/Ile->Val substitution"},
	"UniMod:606":{"unimod": "UniMod:606", "mass_modification":23.974848
, "name":"Xle->His", "descr":"Leu/Ile->His substitution"},
	"UniMod:607":{"unimod": "UniMod:607", "mass_modification":14.974514
, "name":"Xle->Gln", "descr":"Leu/Ile->Gln substitution"},
	"UniMod:608":{"unimod": "UniMod:608", "mass_modification":17.956421
, "name":"Xle->Met", "descr":"Leu/Ile->Met substitution"},
	"UniMod:609":{"unimod": "UniMod:609", "mass_modification":43.017047
, "name":"Xle->Arg", "descr":"Leu/Ile->Arg substitution"},
	"UniMod:610":{"unimod": "UniMod:610", "mass_modification":-29.992806
, "name":"Met->Thr", "descr":"Met->Thr substitution"},
	"UniMod:611":{"unimod": "UniMod:611", "mass_modification":25.060626
, "name":"Met->Arg", "descr":"Met->Arg substitution"},
	"UniMod:613":{"unimod": "UniMod:613", "mass_modification":-2.945522
, "name":"Met->Lys", "descr":"Met->Lys substitution"},
	"UniMod:614":{"unimod": "UniMod:614", "mass_modification":-17.956421
, "name":"Met->Xle", "descr":"Met->Leu/Ile substitution"},
	"UniMod:615":{"unimod": "UniMod:615", "mass_modification":-31.972071
, "name":"Met->Val", "descr":"Met->Val substitution"},
	"UniMod:616":{"unimod": "UniMod:616", "mass_modification":-27.010899
, "name":"Asn->Ser", "descr":"Asn->Ser substitution"},
	"UniMod:617":{"unimod": "UniMod:617", "mass_modification":-12.995249
, "name":"Asn->Thr", "descr":"Asn->Thr substitution"},
	"UniMod:618":{"unimod": "UniMod:618", "mass_modification":14.052036
, "name":"Asn->Lys", "descr":"Asn->Lys substitution"},
	"UniMod:619":{"unimod": "UniMod:619", "mass_modification":49.020401
, "name":"Asn->Tyr", "descr":"Asn->Tyr substitution"},
	"UniMod:620":{"unimod": "UniMod:620", "mass_modification":23.015984
, "name":"Asn->His", "descr":"Asn->His substitution"},
	"UniMod:621":{"unimod": "UniMod:621", "mass_modification":0.984016
, "name":"Asn->Asp", "descr":"Asn->Asp substitution"},
	"UniMod:622":{"unimod": "UniMod:622", "mass_modification":-0.958863
, "name":"Asn->Xle", "descr":"Asn->Leu/Ile substitution"},
	"UniMod:623":{"unimod": "UniMod:623", "mass_modification":-10.020735
, "name":"Pro->Ser", "descr":"Pro->Ser substitution"},
	"UniMod:624":{"unimod": "UniMod:624", "mass_modification":-26.01565
, "name":"Pro->Ala", "descr":"Pro->Ala substitution"},
	"UniMod:625":{"unimod": "UniMod:625", "mass_modification":40.006148
, "name":"Pro->His", "descr":"Pro->His substitution"},
	"UniMod:626":{"unimod": "UniMod:626", "mass_modification":31.005814
, "name":"Pro->Gln", "descr":"Pro->Gln substitution"},
	"UniMod:627":{"unimod": "UniMod:627", "mass_modification":3.994915
, "name":"Pro->Thr", "descr":"Pro->Thr substitution"},
	"UniMod:628":{"unimod": "UniMod:628", "mass_modification":59.048347
, "name":"Pro->Arg", "descr":"Pro->Arg substitution"},
	"UniMod:629":{"unimod": "UniMod:629", "mass_modification":16.0313
, "name":"Pro->Xle", "descr":"Pro->Leu/Ile substitution"},
	"UniMod:630":{"unimod": "UniMod:630", "mass_modification":-31.005814
, "name":"Gln->Pro", "descr":"Gln->Pro substitution"},
	"UniMod:631":{"unimod": "UniMod:631", "mass_modification":0.036386
, "name":"Gln->Lys", "descr":"Gln->Lys substitution"},
	"UniMod:632":{"unimod": "UniMod:632", "mass_modification":0.984016
, "name":"Gln->Glu", "descr":"Gln->Glu substitution"},
	"UniMod:633":{"unimod": "UniMod:633", "mass_modification":9.000334
, "name":"Gln->His", "descr":"Gln->His substitution"},
	"UniMod:634":{"unimod": "UniMod:634", "mass_modification":28.042534
, "name":"Gln->Arg", "descr":"Gln->Arg substitution"},
	"UniMod:635":{"unimod": "UniMod:635", "mass_modification":-14.974514
, "name":"Gln->Xle", "descr":"Gln->Leu/Ile substitution"},
	"UniMod:636":{"unimod": "UniMod:636", "mass_modification":-69.069083
, "name":"Arg->Ser", "descr":"Arg->Ser substitution"},
	"UniMod:637":{"unimod": "UniMod:637", "mass_modification":29.978202
, "name":"Arg->Trp", "descr":"Arg->Trp substitution"},
	"UniMod:638":{"unimod": "UniMod:638", "mass_modification":-55.053433
, "name":"Arg->Thr", "descr":"Arg->Thr substitution"},
	"UniMod:639":{"unimod": "UniMod:639", "mass_modification":-59.048347
, "name":"Arg->Pro", "descr":"Arg->Pro substitution"},
	"UniMod:640":{"unimod": "UniMod:640", "mass_modification":-28.006148
, "name":"Arg->Lys", "descr":"Arg->Lys substitution"},
	"UniMod:641":{"unimod": "UniMod:641", "mass_modification":-19.042199
, "name":"Arg->His", "descr":"Arg->His substitution"},
	"UniMod:642":{"unimod": "UniMod:642", "mass_modification":-28.042534
, "name":"Arg->Gln", "descr":"Arg->Gln substitution"},
	"UniMod:643":{"unimod": "UniMod:643", "mass_modification":-25.060626
, "name":"Arg->Met", "descr":"Arg->Met substitution"},
	"UniMod:644":{"unimod": "UniMod:644", "mass_modification":-53.091927
, "name":"Arg->Cys", "descr":"Arg->Cys substitution"},
	"UniMod:645":{"unimod": "UniMod:645", "mass_modification":-43.017047
, "name":"Arg->Xle", "descr":"Arg->Leu/Ile substitution"},
	"UniMod:646":{"unimod": "UniMod:646", "mass_modification":-99.079647
, "name":"Arg->Gly", "descr":"Arg->Gly substitution"},
	"UniMod:647":{"unimod": "UniMod:647", "mass_modification":60.036386
, "name":"Ser->Phe", "descr":"Ser->Phe substitution"},
	"UniMod:648":{"unimod": "UniMod:648", "mass_modification":-15.994915
, "name":"Ser->Ala", "descr":"Ser->Ala substitution"},
	"UniMod:649":{"unimod": "UniMod:649", "mass_modification":99.047285
, "name":"Ser->Trp", "descr":"Ser->Trp substitution"},
	"UniMod:650":{"unimod": "UniMod:650", "mass_modification":14.01565
, "name":"Ser->Thr", "descr":"Ser->Thr substitution"},
	"UniMod:651":{"unimod": "UniMod:651", "mass_modification":27.010899
, "name":"Ser->Asn", "descr":"Ser->Asn substitution"},
	"UniMod:652":{"unimod": "UniMod:652", "mass_modification":10.020735
, "name":"Ser->Pro", "descr":"Ser->Pro substitution"},
	"UniMod:653":{"unimod": "UniMod:653", "mass_modification":76.0313
, "name":"Ser->Tyr", "descr":"Ser->Tyr substitution"},
	"UniMod:654":{"unimod": "UniMod:654", "mass_modification":15.977156
, "name":"Ser->Cys", "descr":"Ser->Cys substitution"},
	"UniMod:655":{"unimod": "UniMod:655", "mass_modification":69.069083
, "name":"Ser->Arg", "descr":"Ser->Arg substitution"},
	"UniMod:656":{"unimod": "UniMod:656", "mass_modification":26.052036
, "name":"Ser->Xle", "descr":"Ser->Leu/Ile substitution"},
	"UniMod:657":{"unimod": "UniMod:657", "mass_modification":-30.010565
, "name":"Ser->Gly", "descr":"Ser->Gly substitution"},
	"UniMod:658":{"unimod": "UniMod:658", "mass_modification":-14.01565
, "name":"Thr->Ser", "descr":"Thr->Ser substitution"},
	"UniMod:659":{"unimod": "UniMod:659", "mass_modification":-30.010565
, "name":"Thr->Ala", "descr":"Thr->Ala substitution"},
	"UniMod:660":{"unimod": "UniMod:660", "mass_modification":12.995249
, "name":"Thr->Asn", "descr":"Thr->Asn substitution"},
	"UniMod:661":{"unimod": "UniMod:661", "mass_modification":27.047285
, "name":"Thr->Lys", "descr":"Thr->Lys substitution"},
	"UniMod:662":{"unimod": "UniMod:662", "mass_modification":-3.994915
, "name":"Thr->Pro", "descr":"Thr->Pro substitution"},
	"UniMod:663":{"unimod": "UniMod:663", "mass_modification":29.992806
, "name":"Thr->Met", "descr":"Thr->Met substitution"},
	"UniMod:664":{"unimod": "UniMod:664", "mass_modification":12.036386
, "name":"Thr->Xle", "descr":"Thr->Leu/Ile substitution"},
	"UniMod:665":{"unimod": "UniMod:665", "mass_modification":55.053433
, "name":"Thr->Arg", "descr":"Thr->Arg substitution"},
	"UniMod:666":{"unimod": "UniMod:666", "mass_modification":48
, "name":"Val->Phe", "descr":"Val->Phe substitution"},
	"UniMod:667":{"unimod": "UniMod:667", "mass_modification":-28.0313
, "name":"Val->Ala", "descr":"Val->Ala substitution"},
	"UniMod:668":{"unimod": "UniMod:668", "mass_modification":29.974179
, "name":"Val->Glu", "descr":"Val->Glu substitution"},
	"UniMod:669":{"unimod": "UniMod:669", "mass_modification":31.972071
, "name":"Val->Met", "descr":"Val->Met substitution"},
	"UniMod:670":{"unimod": "UniMod:670", "mass_modification":15.958529
, "name":"Val->Asp", "descr":"Val->Asp substitution"},
	"UniMod:671":{"unimod": "UniMod:671", "mass_modification":14.01565
, "name":"Val->Xle", "descr":"Val->Leu/Ile substitution"},
	"UniMod:672":{"unimod": "UniMod:672", "mass_modification":-42.04695
, "name":"Val->Gly", "descr":"Val->Gly substitution"},
	"UniMod:673":{"unimod": "UniMod:673", "mass_modification":-99.047285
, "name":"Trp->Ser", "descr":"Trp->Ser substitution"},
	"UniMod:674":{"unimod": "UniMod:674", "mass_modification":-83.070128
, "name":"Trp->Cys", "descr":"Trp->Cys substitution"},
	"UniMod:675":{"unimod": "UniMod:675", "mass_modification":-29.978202
, "name":"Trp->Arg", "descr":"Trp->Arg substitution"},
	"UniMod:676":{"unimod": "UniMod:676", "mass_modification":-129.057849
, "name":"Trp->Gly", "descr":"Trp->Gly substitution"},
	"UniMod:677":{"unimod": "UniMod:677", "mass_modification":-72.995249
, "name":"Trp->Xle", "descr":"Trp->Leu/Ile substitution"},
	"UniMod:678":{"unimod": "UniMod:678", "mass_modification":-15.994915
, "name":"Tyr->Phe", "descr":"Tyr->Phe substitution"},
	"UniMod:679":{"unimod": "UniMod:679", "mass_modification":-76.0313
, "name":"Tyr->Ser", "descr":"Tyr->Ser substitution"},
	"UniMod:680":{"unimod": "UniMod:680", "mass_modification":-49.020401
, "name":"Tyr->Asn", "descr":"Tyr->Asn substitution"},
	"UniMod:681":{"unimod": "UniMod:681", "mass_modification":-26.004417
, "name":"Tyr->His", "descr":"Tyr->His substitution"},
	"UniMod:682":{"unimod": "UniMod:682", "mass_modification":-48.036386
, "name":"Tyr->Asp", "descr":"Tyr->Asp substitution"},
	"UniMod:683":{"unimod": "UniMod:683", "mass_modification":-60.054144
, "name":"Tyr->Cys", "descr":"Tyr->Cys substitution"},
	"UniMod:684":{"unimod": "UniMod:684", "mass_modification":253.010225
, "name":"BDMAPP", "descr":"Mass Defect Tag on lysine e-amino"},
	"UniMod:685":{"unimod": "UniMod:685", "mass_modification":325.225309
, "name":"NA-LNO2", "descr":"Nitroalkylation by Nitro Linoleic Acid"},
	"UniMod:686":{"unimod": "UniMod:686", "mass_modification":327.240959
, "name":"NA-OA-NO2", "descr":"Nitroalkylation by Nitro Oleic Acid"},
	"UniMod:687":{"unimod": "UniMod:687", "mass_modification":109.046571
, "name":"ICPL:2H(4)", "descr":"Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, medium form"},
	"UniMod:894":{"unimod": "UniMod:894", "mass_modification":210.00205
, "name":"CarboxymethylDTT", "descr":"Carboxymethylated DTT modification of cysteine"},
	"UniMod:730":{"unimod": "UniMod:730", "mass_modification":304.20536
, "name":"iTRAQ8plex", "descr":"Representative mass and accurate mass for 113, 114, 116 & 117"},
	"UniMod:695":{"unimod": "UniMod:695", "mass_modification":7.017164
, "name":"Label:13C(6)15N(1)", "descr":"13C(6) 15N(1) Silac label"},
	"UniMod:696":{"unimod": "UniMod:696", "mass_modification":17.07069
, "name":"Label:2H(9)13C(6)15N(2)", "descr":"13C(6) 15N(2) (D)9 SILAC label"},
	"UniMod:720":{"unimod": "UniMod:720", "mass_modification":138.104465
, "name":"HNE-Delta:H(2)O", "descr":"Dehydrated 4-hydroxynonenal"},
	"UniMod:721":{"unimod": "UniMod:721", "mass_modification":154.09938
, "name":"4-ONE", "descr":"4-Oxononenal (ONE)"},
	"UniMod:723":{"unimod": "UniMod:723", "mass_modification":107.997631
, "name":"O-Dimethylphosphate", "descr":"O-Dimethylphosphorylation"},
	"UniMod:724":{"unimod": "UniMod:724", "mass_modification":93.981981
, "name":"O-Methylphosphate", "descr":"O-Methylphosphorylation"},
	"UniMod:725":{"unimod": "UniMod:725", "mass_modification":136.028931
, "name":"Diethylphosphate", "descr":"O-Diethylphosphorylation"},
	"UniMod:726":{"unimod": "UniMod:726", "mass_modification":107.997631
, "name":"Ethylphosphate", "descr":"O-Ethylphosphorylation"},
	"UniMod:727":{"unimod": "UniMod:727", "mass_modification":162.080967
, "name":"O-pinacolylmethylphosphonate", "descr":"O-pinacolylmethylphosphonylation"},
	"UniMod:728":{"unimod": "UniMod:728", "mass_modification":77.987066
, "name":"Methylphosphonate", "descr":"Methylphosphonylation"},
	"UniMod:729":{"unimod": "UniMod:729", "mass_modification":120.034017
, "name":"O-Isopropylmethylphosphonate", "descr":"O-Isopropylmethylphosphonylation"},
	"UniMod:731":{"unimod": "UniMod:731", "mass_modification":304.19904
, "name":"iTRAQ8plex:13C(6)15N(2)", "descr":"Accurate mass for 115, 118, 119 & 121"},
	"UniMod:735":{"unimod": "UniMod:735", "mass_modification":136.001656
, "name":"BEMAD_ST", "descr":"Beta elimination of modified S or T followed by Michael addition of DTT"},
	"UniMod:734":{"unimod": "UniMod:734", "mass_modification":43.042199
, "name":"Ethanolamine", "descr":"Carboxyl modification with ethanolamine"},
	"UniMod:737":{"unimod": "UniMod:737", "mass_modification":229.162932
, "name":"TMT6plex", "descr":"Sixplex Tandem Mass Tag®"},
	"UniMod:736":{"unimod": "UniMod:736", "mass_modification":120.0245
, "name":"BEMAD_C", "descr":"Beta elimination of alkylated Cys followed by Michael addition of DTT"},
	"UniMod:738":{"unimod": "UniMod:738", "mass_modification":225.155833
, "name":"TMT2plex", "descr":"Duplex Tandem Mass Tag®"},
	"UniMod:739":{"unimod": "UniMod:739", "mass_modification":224.152478
, "name":"TMT", "descr":"Native Tandem Mass Tag®"},
	"UniMod:740":{"unimod": "UniMod:740", "mass_modification":972.365219
, "name":"ExacTagThiol", "descr":"ExacTag Thiol label mass for 2-4-7-10 plex"},
	"UniMod:741":{"unimod": "UniMod:741", "mass_modification":1046.347854
, "name":"ExacTagAmine", "descr":"ExacTag Amine label mass for 2-4-7-10 plex"},
	"UniMod:744":{"unimod": "UniMod:744", "mass_modification":251.036462
, "name":"NO_SMX_SEMD", "descr":"Nitroso Sulfamethoxazole Sulphenamide thiol adduct"},
	"UniMod:743":{"unimod": "UniMod:743", "mass_modification":136.088815
, "name":"4-ONE+Delta:H(-2)O(-1)", "descr":"Dehydrated 4-Oxononenal Michael adduct"},
	"UniMod:2052":{"unimod": "UniMod:2052", "mass_modification":922.465403
, "name":"Biotin:Aha-DADPS", "descr":"Intact DADPS Biotin Alkyne tag"},
	"UniMod:746":{"unimod": "UniMod:746", "mass_modification":267.031377
, "name":"NO_SMX_SIMD", "descr":"Nitroso Sulfamethoxazole Sulfinamide thiol adduct"},
	"UniMod:747":{"unimod": "UniMod:747", "mass_modification":86.000394
, "name":"Malonyl", "descr":"Malonylation"},
	"UniMod:748":{"unimod": "UniMod:748", "mass_modification":183.983029
, "name":"3sulfo", "descr":"derivatization by N-term modification using 3-Sulfobenzoic succinimidyl ester"},
	"UniMod:750":{"unimod": "UniMod:750", "mass_modification":53.971735
, "name":"trifluoro", "descr":"trifluoroleucine replacement of leucine"},
	"UniMod:751":{"unimod": "UniMod:751", "mass_modification":210.986535
, "name":"TNBS", "descr":"tri nitro benzene"},
	"UniMod:774":{"unimod": "UniMod:774", "mass_modification":626.263502
, "name":"Biotin-phenacyl", "descr":"Alkylation by biotinylated form of phenacyl bromide"},
	"UniMod:764":{"unimod": "UniMod:764", "mass_modification":126.062161
, "name":"BEMAD_C:2H(6)", "descr":"Beta elimination of alkylated Cys followed by Michael addition of labelled DTT"},
	"UniMod:771":{"unimod": "UniMod:771", "mass_modification":240.11503
, "name":"lapachenole", "descr":"lapachenole photochemically added to cysteine"},
	"UniMod:772":{"unimod": "UniMod:772", "mass_modification":5.016774
, "name":"Label:13C(5)", "descr":"13C(5) Silac label"},
	"UniMod:773":{"unimod": "UniMod:773", "mass_modification":97.016378
, "name":"maleimide", "descr":"maleimide"},
	"UniMod:762":{"unimod": "UniMod:762", "mass_modification":214.990469
, "name":"IDEnT", "descr":"Isotope Distribution Encoded Tag"},
	"UniMod:763":{"unimod": "UniMod:763", "mass_modification":142.039317
, "name":"BEMAD_ST:2H(6)", "descr":"Beta elimination of modified S or T followed by Michael addition of labelled DTT"},
	"UniMod:765":{"unimod": "UniMod:765", "mass_modification":-131.040485
, "name":"Met-loss", "descr":"Removal of initiator methionine from protein N-terminus"},
	"UniMod:766":{"unimod": "UniMod:766", "mass_modification":-89.02992
, "name":"Met-loss+Acetyl", "descr":"Removal of initiator methionine from protein N-terminus, then acetylation of the new N-terminus"},
	"UniMod:767":{"unimod": "UniMod:767", "mass_modification":172.05243
, "name":"Menadione-HQ", "descr":"Menadione hydroquinone derivative"},
	"UniMod:775":{"unimod": "UniMod:775", "mass_modification":60.012189
, "name":"Carboxymethyl:13C(2)", "descr":"Iodoacetic acid derivative w/ 13C label"},
	"UniMod:776":{"unimod": "UniMod:776", "mass_modification":130.079062
, "name":"NEM:2H(5)", "descr":"D5 N-ethylmaleimide on cysteines"},
	"UniMod:822":{"unimod": "UniMod:822", "mass_modification":-58.005479
, "name":"Gly-loss+Amide", "descr":"Enzymatic glycine removal leaving an amidated C-terminus"},
	"UniMod:827":{"unimod": "UniMod:827", "mass_modification":572.181134
, "name":"TMPP-Ac", "descr":"tris(2,4,6-trimethoxyphenyl)phosphonium acetic acid N-hydroxysuccinimide ester derivative"},
	"UniMod:799":{"unimod": "UniMod:799", "mass_modification":120.063056
, "name":"Label:13C(6)+GG", "descr":"13C6 labeled ubiquitinylation residue"},
	"UniMod:837":{"unimod": "UniMod:837", "mass_modification":80.985078
, "name":"Arg->Npo", "descr":"Arginine replacement by Nitropyrimidyl ornithine"},
	"UniMod:834":{"unimod": "UniMod:834", "mass_modification":46.035672
, "name":"Label:2H(4)+Acetyl", "descr":"Acetyl 4,4,5,5-D4 Lysine"},
	"UniMod:801":{"unimod": "UniMod:801", "mass_modification":70.07825
, "name":"Pentylamine", "descr":"Labeling transglutaminase substrate on glutamine side chain"},
	"UniMod:800":{"unimod": "UniMod:800", "mass_modification":311.166748
, "name":"Biotin:Thermo-21345", "descr":"was PentylamineBiotin"},
	"UniMod:830":{"unimod": "UniMod:830", "mass_modification":72.021129
, "name":"Dihydroxyimidazolidine", "descr":"Dihydroxy methylglyoxal adduct"},
	"UniMod:825":{"unimod": "UniMod:825", "mass_modification":163.985807
, "name":"Xlink:DFDNB", "descr":"Intact DFDNB crosslinker"},
	"UniMod:821":{"unimod": "UniMod:821", "mass_modification":682.24612
, "name":"Cy3b-maleimide", "descr":"fluorescent dye that labels cysteines"},
	"UniMod:793":{"unimod": "UniMod:793", "mass_modification":365.132196
, "name":"Hex(1)HexNAc(1)", "descr":"Hex1HexNAc1"},
	"UniMod:792":{"unimod": "UniMod:792", "mass_modification":63.044462
, "name":"AEC-MAEC:2H(4)", "descr":"deuterium cysteamine modification to S or T"},
	"UniMod:824":{"unimod": "UniMod:824", "mass_modification":220.048407
, "name":"Xlink:BMOE", "descr":"Intact or monolink BMOE crosslinker"},
	"UniMod:811":{"unimod": "UniMod:811", "mass_modification":487.246455
, "name":"Biotin:Thermo-21360", "descr":"was Biotin-PEO4-hydrazide"},
	"UniMod:835":{"unimod": "UniMod:835", "mass_modification":48.030694
, "name":"Label:13C(6)+Acetyl", "descr":"Acetyl 13C(6) Silac label"},
	"UniMod:836":{"unimod": "UniMod:836", "mass_modification":50.024764
, "name":"Label:13C(6)15N(2)+Acetyl", "descr":"Acetyl_13C(6) 15N(2) Silac label"},
	"UniMod:846":{"unimod": "UniMod:846", "mass_modification":484.228162
, "name":"EQIGG", "descr":"Sumo mutant Smt3-WT tail following trypsin digestion"},
	"UniMod:849":{"unimod": "UniMod:849", "mass_modification":343.031785
, "name":"cGMP", "descr":"S-guanylation"},
	"UniMod:851":{"unimod": "UniMod:851", "mass_modification":150.041585
, "name":"cGMP+RMP-loss", "descr":"S-guanylation-2"},
	"UniMod:888":{"unimod": "UniMod:888", "mass_modification":140.094963
, "name":"mTRAQ", "descr":"mTRAQ light"},
	"UniMod:848":{"unimod": "UniMod:848", "mass_modification":266.057909
, "name":"Arg2PG", "descr":"Adduct of phenylglyoxal with Arg"},
	"UniMod:853":{"unimod": "UniMod:853", "mass_modification":118.068034
, "name":"Label:2H(4)+GG", "descr":"Ubiquitination 2H4 lysine"},
	"UniMod:1420":{"unimod": "UniMod:1420", "mass_modification":185.189198
, "name":"spermine", "descr":"spermine adduct"},
	"UniMod:862":{"unimod": "UniMod:862", "mass_modification":4.022185
, "name":"Label:13C(1)2H(3)", "descr":"SILAC"},
	"UniMod:861":{"unimod": "UniMod:861", "mass_modification":758.380841
, "name":"ZGB", "descr":"NHS ester linked Green Fluorescent Bodipy Dye"},
	"UniMod:859":{"unimod": "UniMod:859", "mass_modification":54.010565
, "name":"MG-H1", "descr":"Methylglyoxal-derived hydroimidazolone"},
	"UniMod:860":{"unimod": "UniMod:860", "mass_modification":39.994915
, "name":"G-H1", "descr":"Glyoxal-derived hydroimiadazolone"},
	"UniMod:864":{"unimod": "UniMod:864", "mass_modification":122.057126
, "name":"Label:13C(6)15N(2)+GG", "descr":"13C(6) 15N(2) Lysine glygly"},
	"UniMod:866":{"unimod": "UniMod:866", "mass_modification":115.0667
, "name":"ICPL:13C(6)2H(4)", "descr":"Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, +10 Da form"},
	"UniMod:890":{"unimod": "UniMod:890", "mass_modification":940.1999
, "name":"DyLight-maleimide", "descr":"Thiol-reactive dye for fluorescence labelling of proteins"},
	"UniMod:889":{"unimod": "UniMod:889", "mass_modification":144.102063
, "name":"mTRAQ:13C(3)15N(1)", "descr":"mTRAQ medium"},
	"UniMod:891":{"unimod": "UniMod:891", "mass_modification":710.383719
, "name":"Methyl-PEO12-Maleimide", "descr":"Methyl-PEO12-Maleimide"},
	"UniMod:887":{"unimod": "UniMod:887", "mass_modification":383.148121
, "name":"MDCC", "descr":"covalent linkage of maleimidyl coumarin probe (Molecular Probes D-10253)"},
	"UniMod:877":{"unimod": "UniMod:877", "mass_modification":599.266339
, "name":"QQQTGG", "descr":"SUMOylation by SUMO-2/3"},
	"UniMod:876":{"unimod": "UniMod:876", "mass_modification":600.250354
, "name":"QEQTGG", "descr":"SUMOylation by SUMO-1"},
	"UniMod:886":{"unimod": "UniMod:886", "mass_modification":108.021129
, "name":"HydroxymethylOP", "descr":"2-ammonio-6-[4-(hydroxymethyl)-3-oxidopyridinium-1-yl]- hexanoate"},
	"UniMod:884":{"unimod": "UniMod:884", "mass_modification":695.310118
, "name":"Biotin:Thermo-21325", "descr":"was ChromoBiotin"},
	"UniMod:885":{"unimod": "UniMod:885", "mass_modification":20.0171
, "name":"Label:13C(1)2H(3)+Oxidation", "descr":"Oxidised methionine 13C(1)2H(3) SILAC label"},
	"UniMod:2050":{"unimod": "UniMod:2050", "mass_modification":313.231019
, "name":"shTMTpro", "descr":"Super Heavy TMTpro"},
	"UniMod:895":{"unimod": "UniMod:895", "mass_modification":578.317646
, "name":"Biotin-PEG-PRA", "descr":"Biotin polyethyleneoxide (n=3) alkyne"},
	"UniMod:896":{"unimod": "UniMod:896", "mass_modification":-4.986324
, "name":"Met->Aha", "descr":"Methionine replacement by azido homoalanine"},
	"UniMod:897":{"unimod": "UniMod:897", "mass_modification":3.98814
, "name":"Label:15N(4)", "descr":"SILAC 15N(4)"},
	"UniMod:898":{"unimod": "UniMod:898", "mass_modification":159.932662
, "name":"pyrophospho", "descr":"pyrophosphorylation of Ser/Thr"},
	"UniMod:899":{"unimod": "UniMod:899", "mass_modification":-21.987721
, "name":"Met->Hpg", "descr":"methionine replacement by homopropargylglycine"},
	"UniMod:901":{"unimod": "UniMod:901", "mass_modification":372.142033
, "name":"4AcAllylGal", "descr":"2,3,4,6-tetra-O-Acetyl-1-allyl-alpha-D-galactopyranoside modification of cysteine"},
	"UniMod:902":{"unimod": "UniMod:902", "mass_modification":103.960719
, "name":"DimethylArsino", "descr":"Reaction with dimethylarsinous (AsIII) acid"},
	"UniMod:903":{"unimod": "UniMod:903", "mass_modification":31.935685
, "name":"Lys->CamCys", "descr":"Lys->Cys substitution and carbamidomethylation"},
	"UniMod:904":{"unimod": "UniMod:904", "mass_modification":12.962234
, "name":"Phe->CamCys", "descr":"Phe->Cys substitution and carbamidomethylation"},
	"UniMod:905":{"unimod": "UniMod:905", "mass_modification":33.951335
, "name":"Leu->MetOx", "descr":"Leu->Met substitution and sulfoxidation"},
	"UniMod:906":{"unimod": "UniMod:906", "mass_modification":18.940436
, "name":"Lys->MetOx", "descr":"Lys->Met substitution and sulfoxidation"},
	"UniMod:907":{"unimod": "UniMod:907", "mass_modification":178.047738
, "name":"Galactosyl", "descr":"Gluconoylation"},
	"UniMod:908":{"unimod": "UniMod:908", "mass_modification":321.205242
, "name":"Xlink:SMCC[321]", "descr":"Monolink of SMCC terminated with 3-(dimethylamino)-1-propylamine"},
	"UniMod:910":{"unimod": "UniMod:910", "mass_modification":228.111007
, "name":"Bacillosamine", "descr":"2,4-diacetamido-2,4,6-trideoxyglucopyranose"},
	"UniMod:911":{"unimod": "UniMod:911", "mass_modification":184.07961
, "name":"MTSL", "descr":"Cys modification by (1-oxyl-2,2,5,5-tetramethyl-3-pyrroline-3-methyl)methanesulfonate (MTSL)"},
	"UniMod:912":{"unimod": "UniMod:912", "mass_modification":511.319226
, "name":"HNE-BAHAH", "descr":"4-hydroxy-2-nonenal and biotinamidohexanoic acid hydrazide, reduced"},
	"UniMod:2039":{"unimod": "UniMod:2039", "mass_modification":416.147118
, "name":"LTX+Lophotoxin", "descr":"addition of lophotoxin to tyrosine"},
	"UniMod:914":{"unimod": "UniMod:914", "mass_modification":100.016044
, "name":"Methylmalonylation", "descr":"Methylmalonylation on Serine"},
	"UniMod:938":{"unimod": "UniMod:938", "mass_modification":820.336015
, "name":"AROD", "descr":"Cysteine modifier"},
	"UniMod:939":{"unimod": "UniMod:939", "mass_modification":-2.945522
, "name":"Cys->methylaminoAla", "descr":"carbamidomethylated Cys that undergoes beta-elimination and Michael addition of methylamine"},
	"UniMod:940":{"unimod": "UniMod:940", "mass_modification":11.070128
, "name":"Cys->ethylaminoAla", "descr":"Carbamidomethylated Cys that undergoes beta-elimination and Michael addition of ethylamine"},
	"UniMod:923":{"unimod": "UniMod:923", "mass_modification":120.050417
, "name":"Label:13C(4)15N(2)+GG", "descr":"13C(4) 15N(2) Lysine glygly"},
	"UniMod:926":{"unimod": "UniMod:926", "mass_modification":27.047285
, "name":"ethylamino", "descr":"ethyl amino"},
	"UniMod:928":{"unimod": "UniMod:928", "mass_modification":60.003371
, "name":"MercaptoEthanol", "descr":"2-OH-ethyl thio-Ser"},
	"UniMod:935":{"unimod": "UniMod:935", "mass_modification":474.250515
, "name":"Atto495Maleimide", "descr":"High molecular absorption maleimide label for proteins"},
	"UniMod:934":{"unimod": "UniMod:934", "mass_modification":502.202341
, "name":"AMTzHexNAc2", "descr":"Photocleavable Biotin + GalNAz on O-GlcNAc"},
	"UniMod:931":{"unimod": "UniMod:931", "mass_modification":29.015316
, "name":"Ethyl+Deamidated", "descr":"deamidation followed by esterification with ethanol"},
	"UniMod:932":{"unimod": "UniMod:932", "mass_modification":845.403166
, "name":"VFQQQTGG", "descr":"SUMOylation by SUMO-2/3 (formic acid cleavage)"},
	"UniMod:933":{"unimod": "UniMod:933", "mass_modification":1203.577168
, "name":"VIEVYQEQTGG", "descr":"SUMOylation by SUMO-1 (formic acid cleavage)"},
	"UniMod:936":{"unimod": "UniMod:936", "mass_modification":33.961028
, "name":"Chlorination", "descr":"Chlorination of tyrosine residues"},
	"UniMod:937":{"unimod": "UniMod:937", "mass_modification":67.922055
, "name":"dichlorination", "descr":"Dichlorination"},
	"UniMod:941":{"unimod": "UniMod:941", "mass_modification":198.981352
, "name":"DNPS", "descr":"2,4-Dinitrobenzenesulfenyl"},
	"UniMod:942":{"unimod": "UniMod:942", "mass_modification":458.162391
, "name":"SulfoGMBS", "descr":"High molecular absorption label for proteins"},
	"UniMod:943":{"unimod": "UniMod:943", "mass_modification":267.158292
, "name":"DimethylamineGMBS", "descr":"Modified GMBS X linker"},
	"UniMod:944":{"unimod": "UniMod:944", "mass_modification":11.050561
, "name":"Label:15N(2)2H(9)", "descr":"SILAC label"},
	"UniMod:946":{"unimod": "UniMod:946", "mass_modification":314.188195
, "name":"LG-anhydrolactam", "descr":"Levuglandinyl-lysine anhydrolactam adduct"},
	"UniMod:947":{"unimod": "UniMod:947", "mass_modification":316.203845
, "name":"LG-pyrrole", "descr":"Levuglandinyl-lysine pyrrole adduct"},
	"UniMod:948":{"unimod": "UniMod:948", "mass_modification":298.19328
, "name":"LG-anhyropyrrole", "descr":"Levuglandinyl-lysine anhyropyrrole adduct"},
	"UniMod:949":{"unimod": "UniMod:949", "mass_modification":144.042259
, "name":"3-deoxyglucosone", "descr":"Condensation product of 3-deoxyglucosone"},
	"UniMod:950":{"unimod": "UniMod:950", "mass_modification":6.008178
, "name":"Cation:Li", "descr":"Replacement of proton by lithium"},
	"UniMod:951":{"unimod": "UniMod:951", "mass_modification":37.946941
, "name":"Cation:Ca[II]", "descr":"Replacement of 2 protons by calcium"},
	"UniMod:952":{"unimod": "UniMod:952", "mass_modification":53.919289
, "name":"Cation:Fe[II]", "descr":"Replacement of 2 protons by iron"},
	"UniMod:953":{"unimod": "UniMod:953", "mass_modification":55.919696
, "name":"Cation:Ni[II]", "descr":"Replacement of 2 protons by nickel"},
	"UniMod:954":{"unimod": "UniMod:954", "mass_modification":61.913495
, "name":"Cation:Zn[II]", "descr":"Replacement of 2 protons by zinc"},
	"UniMod:955":{"unimod": "UniMod:955", "mass_modification":105.897267
, "name":"Cation:Ag", "descr":"Replacement of proton by silver"},
	"UniMod:956":{"unimod": "UniMod:956", "mass_modification":21.969392
, "name":"Cation:Mg[II]", "descr":"Replacement of 2 protons by magnesium"},
	"UniMod:957":{"unimod": "UniMod:957", "mass_modification":116.010959
, "name":"2-succinyl", "descr":"S-(2-succinyl) cysteine"},
	"UniMod:958":{"unimod": "UniMod:958", "mass_modification":37.031634
, "name":"Propargylamine", "descr":"propargylamine"},
	"UniMod:959":{"unimod": "UniMod:959", "mass_modification":116.997965
, "name":"Phosphopropargyl", "descr":"phospho-propargylamine"},
	"UniMod:960":{"unimod": "UniMod:960", "mass_modification":2135.920496
, "name":"SUMO2135", "descr":"SUMOylation by SUMO-1 after tryptic cleavage"},
	"UniMod:961":{"unimod": "UniMod:961", "mass_modification":3549.536568
, "name":"SUMO3549", "descr":"SUMOylation by SUMO-2/3 after tryptic cleavage"},
	"UniMod:1992":{"unimod": "UniMod:1992", "mass_modification":159.068414
, "name":"serotonylation", "descr":"5-glutamyl serotonin"},
	"UniMod:978":{"unimod": "UniMod:978", "mass_modification":149.02992
, "name":"BITC", "descr":"Benzyl isothiocyanate"},
	"UniMod:977":{"unimod": "UniMod:977", "mass_modification":57.021464
, "name":"Carbofuran", "descr":"2,3-dihydro-2,2-dimethyl-7-benzofuranol N-methyl carbamate"},
	"UniMod:979":{"unimod": "UniMod:979", "mass_modification":163.04557
, "name":"PEITC", "descr":"Phenethyl isothiocyanate"},
	"UniMod:967":{"unimod": "UniMod:967", "mass_modification":159.035399
, "name":"thioacylPA", "descr":"membrane protein extraction"},
	"UniMod:971":{"unimod": "UniMod:971", "mass_modification":969.366232
, "name":"maleimide3", "descr":"maleimide-3-saccharide"},
	"UniMod:972":{"unimod": "UniMod:972", "mass_modification":1293.471879
, "name":"maleimide5", "descr":"maleimide-5-saccharide"},
	"UniMod:973":{"unimod": "UniMod:973", "mass_modification":453.212452
, "name":"Puromycin", "descr":"Puromycin"},
	"UniMod:981":{"unimod": "UniMod:981", "mass_modification":160.037173
, "name":"glucosone", "descr":"Condensation product of glucosone"},
	"UniMod:986":{"unimod": "UniMod:986", "mass_modification":34.051429
, "name":"Label:13C(6)+Dimethyl", "descr":"Dimethyl 13C(6) Silac label"},
	"UniMod:984":{"unimod": "UniMod:984", "mass_modification":299.166748
, "name":"cysTMT", "descr":"Native cysteine-reactive Tandem Mass Tag®"},
	"UniMod:985":{"unimod": "UniMod:985", "mass_modification":304.177202
, "name":"cysTMT6plex", "descr":"cysteine-reactive Sixplex Tandem Mass Tag®"},
	"UniMod:991":{"unimod": "UniMod:991", "mass_modification":-15.010899
, "name":"ISD_z+2_ion", "descr":"ISD (z+2)-series"},
	"UniMod:989":{"unimod": "UniMod:989", "mass_modification":17.026549
, "name":"Ammonium", "descr":"replacement of proton with ammonium ion"},
	"UniMod:993":{"unimod": "UniMod:993", "mass_modification":449.17329
, "name":"Biotin:Sigma-B1267", "descr":"was Biotin-maleimide"},
	"UniMod:994":{"unimod": "UniMod:994", "mass_modification":0.997035
, "name":"Label:15N(1)", "descr":"15N(1)"},
	"UniMod:995":{"unimod": "UniMod:995", "mass_modification":1.99407
, "name":"Label:15N(2)", "descr":"15N(2)"},
	"UniMod:996":{"unimod": "UniMod:996", "mass_modification":2.991105
, "name":"Label:15N(3)", "descr":"15N(3)"},
	"UniMod:997":{"unimod": "UniMod:997", "mass_modification":94.967714
, "name":"sulfo+amino", "descr":"aminotyrosine with sulfation"},
	"UniMod:1000":{"unimod": "UniMod:1000", "mass_modification":107.077339
, "name":"AHA-Alkyne", "descr":"Azidohomoalanine (AHA) bound to propargylglycine-NH2 (alkyne)"},
	"UniMod:1001":{"unimod": "UniMod:1001", "mass_modification":695.280074
, "name":"AHA-Alkyne-KDDDD", "descr":"Azidohomoalanine (AHA) bound to DDDDK-propargylglycine-NH2 (alkyne)"},
	"UniMod:1002":{"unimod": "UniMod:1002", "mass_modification":456.069261
, "name":"EGCG1", "descr":"(-)-epigallocatechin-3-gallate"},
	"UniMod:1003":{"unimod": "UniMod:1003", "mass_modification":287.055563
, "name":"EGCG2", "descr":"(-)-dehydroepigallocatechin"},
	"UniMod:1004":{"unimod": "UniMod:1004", "mass_modification":24.023919
, "name":"Label:13C(6)15N(4)+Methyl", "descr":"Monomethylated Arg13C(6) 15N(4)"},
	"UniMod:1005":{"unimod": "UniMod:1005", "mass_modification":38.039569
, "name":"Label:13C(6)15N(4)+Dimethyl", "descr":"Dimethylated Arg13C(6) 15N(4)"},
	"UniMod:1006":{"unimod": "UniMod:1006", "mass_modification":28.046104
, "name":"Label:13C(6)15N(4)+Methyl:2H(3)13C(1)", "descr":"2H(3) 13C(1) monomethylated Arg13C(6) 15N(4)"},
	"UniMod:1007":{"unimod": "UniMod:1007", "mass_modification":46.083939
, "name":"Label:13C(6)15N(4)+Dimethyl:2H(6)13C(2)", "descr":"2H(6) 13C(2) Dimethylated Arg13C(6) 15N(4)"},
	"UniMod:1008":{"unimod": "UniMod:1008", "mass_modification":104.965913
, "name":"Cys->CamSec", "descr":"Sec Iodoacetamide derivative"},
	"UniMod:1009":{"unimod": "UniMod:1009", "mass_modification":12
, "name":"Thiazolidine", "descr":"formaldehyde adduct"},
	"UniMod:1010":{"unimod": "UniMod:1010", "mass_modification":1970.824411
, "name":"DEDGFLYMVYASQETFG", "descr":"Addition of DEDGFLYMVYASQETFG"},
	"UniMod:1012":{"unimod": "UniMod:1012", "mass_modification":523.210069
, "name":"Biotin:Invitrogen-M1602", "descr":"Nalpha-(3-maleimidylpropionyl)biocytin"},
	"UniMod:1020":{"unimod": "UniMod:1020", "mass_modification":156.078644
, "name":"Xlink:DSS[156]", "descr":"Water-quenched monolink of DSS/BS3 crosslinker"},
	"UniMod:1017":{"unimod": "UniMod:1017", "mass_modification":111.068414
, "name":"DMPO", "descr":"DMPO spin-trap nitrone adduct"},
	"UniMod:1014":{"unimod": "UniMod:1014", "mass_modification":87.032028
, "name":"glycidamide", "descr":"glycidamide adduct"},
	"UniMod:1015":{"unimod": "UniMod:1015", "mass_modification":309.205242
, "name":"Ahx2+Hsl", "descr":"C-terminal homoserine lactone and two aminohexanoic acids"},
	"UniMod:1018":{"unimod": "UniMod:1018", "mass_modification":138.06808
, "name":"ICDID", "descr":"Isotope-Coded Dimedone light form"},
	"UniMod:1019":{"unimod": "UniMod:1019", "mass_modification":144.10574
, "name":"ICDID:2H(6)", "descr":"Isotope-Coded Dimedone heavy form"},
	"UniMod:1021":{"unimod": "UniMod:1021", "mass_modification":244.058303
, "name":"Xlink:EGS[244]", "descr":"Water quenched monolink of EGS cross-linker"},
	"UniMod:1022":{"unimod": "UniMod:1022", "mass_modification":132.005873
, "name":"Xlink:DST[132]", "descr":"Water quenched monolink of DST crosslinker"},
	"UniMod:1023":{"unimod": "UniMod:1023", "mass_modification":191.991486
, "name":"Xlink:DTSSP[192]", "descr":"Water quenched monolink of DSP/DTSSP crosslinker"},
	"UniMod:1024":{"unimod": "UniMod:1024", "mass_modification":237.100108
, "name":"Xlink:SMCC[237]", "descr":"Water quenched monolink of SMCC"},
	"UniMod:1032":{"unimod": "UniMod:1032", "mass_modification":135.032028
, "name":"2-nitrobenzyl", "descr":"Tyrosine caged with 2-nitrobenzyl (ONB)"},
	"UniMod:1027":{"unimod": "UniMod:1027", "mass_modification":140.094963
, "name":"Xlink:DMP[140]", "descr":"Water quenched monolink of DMP crosslinker"},
	"UniMod:1028":{"unimod": "UniMod:1028", "mass_modification":115.026943
, "name":"Xlink:EGS[115]", "descr":"Cleavage product of EGS protein crosslinks by hydroylamine treatment"},
	"UniMod:1033":{"unimod": "UniMod:1033", "mass_modification":172.992127
, "name":"Cys->SecNEM", "descr":"N-ethylmaleimide on selenocysteines"},
	"UniMod:1034":{"unimod": "UniMod:1034", "mass_modification":178.023511
, "name":"Cys->SecNEM:2H(5)", "descr":"D5 N-ethylmaleimide on selenocysteines"},
	"UniMod:1035":{"unimod": "UniMod:1035", "mass_modification":174.025169
, "name":"Thiadiazole", "descr":"Thiadiazolydation of Cys"},
	"UniMod:1031":{"unimod": "UniMod:1031", "mass_modification":196.121178
, "name":"Biotin:Thermo-88310", "descr":"desthiobiotin modification of lysine"},
	"UniMod:1038":{"unimod": "UniMod:1038", "mass_modification":659.312423
, "name":"TAMRA-FP", "descr":"TAMRA fluorophosphonate modification of serine"},
	"UniMod:1039":{"unimod": "UniMod:1039", "mass_modification":543.236284
, "name":"Biotin:Thermo-21901+H2O", "descr":"Maleimide-Biotin + Water"},
	"UniMod:1041":{"unimod": "UniMod:1041", "mass_modification":71.073499
, "name":"Deoxyhypusine", "descr":"Deoxyhypusine"},
	"UniMod:1042":{"unimod": "UniMod:1042", "mass_modification":113.084064
, "name":"Acetyldeoxyhypusine", "descr":"Acetyldeoxyhypusine"},
	"UniMod:1043":{"unimod": "UniMod:1043", "mass_modification":129.078979
, "name":"Acetylhypusine", "descr":"Acetylhypusine"},
	"UniMod:1044":{"unimod": "UniMod:1044", "mass_modification":31.972071
, "name":"Ala->Cys", "descr":"Ala->Cys substitution"},
	"UniMod:1045":{"unimod": "UniMod:1045", "mass_modification":76.0313
, "name":"Ala->Phe", "descr":"Ala->Phe substitution"},
	"UniMod:1046":{"unimod": "UniMod:1046", "mass_modification":66.021798
, "name":"Ala->His", "descr":"Ala->His substitution"},
	"UniMod:1047":{"unimod": "UniMod:1047", "mass_modification":42.04695
, "name":"Ala->Xle", "descr":"Ala->Leu/Ile substitution"},
	"UniMod:1048":{"unimod": "UniMod:1048", "mass_modification":57.057849
, "name":"Ala->Lys", "descr":"Ala->Lys substitution"},
	"UniMod:1049":{"unimod": "UniMod:1049", "mass_modification":60.003371
, "name":"Ala->Met", "descr":"Ala->Met substitution"},
	"UniMod:1050":{"unimod": "UniMod:1050", "mass_modification":43.005814
, "name":"Ala->Asn", "descr":"Ala->Asn substitution"},
	"UniMod:1051":{"unimod": "UniMod:1051", "mass_modification":57.021464
, "name":"Ala->Gln", "descr":"Ala->Gln substitution"},
	"UniMod:1052":{"unimod": "UniMod:1052", "mass_modification":85.063997
, "name":"Ala->Arg", "descr":"Ala->Arg substitution"},
	"UniMod:1053":{"unimod": "UniMod:1053", "mass_modification":115.042199
, "name":"Ala->Trp", "descr":"Ala->Trp substitution"},
	"UniMod:1054":{"unimod": "UniMod:1054", "mass_modification":92.026215
, "name":"Ala->Tyr", "descr":"Ala->Tyr substitution"},
	"UniMod:1055":{"unimod": "UniMod:1055", "mass_modification":-31.972071
, "name":"Cys->Ala", "descr":"Cys->Ala substitution"},
	"UniMod:1056":{"unimod": "UniMod:1056", "mass_modification":12.017759
, "name":"Cys->Asp", "descr":"Cys->Asp substitution"},
	"UniMod:1057":{"unimod": "UniMod:1057", "mass_modification":26.033409
, "name":"Cys->Glu", "descr":"Cys->Glu substitution"},
	"UniMod:1058":{"unimod": "UniMod:1058", "mass_modification":34.049727
, "name":"Cys->His", "descr":"Cys->His substitution"},
	"UniMod:1059":{"unimod": "UniMod:1059", "mass_modification":10.07488
, "name":"Cys->Xle", "descr":"Cys->Leu/Ile substitution"},
	"UniMod:1060":{"unimod": "UniMod:1060", "mass_modification":25.085779
, "name":"Cys->Lys", "descr":"Cys->Lys substitution"},
	"UniMod:1061":{"unimod": "UniMod:1061", "mass_modification":28.0313
, "name":"Cys->Met", "descr":"Cys->Met substitution"},
	"UniMod:1062":{"unimod": "UniMod:1062", "mass_modification":11.033743
, "name":"Cys->Asn", "descr":"Cys->Asn substitution"},
	"UniMod:1063":{"unimod": "UniMod:1063", "mass_modification":-5.956421
, "name":"Cys->Pro", "descr":"Cys->Pro substitution"},
	"UniMod:1064":{"unimod": "UniMod:1064", "mass_modification":25.049393
, "name":"Cys->Gln", "descr":"Cys->Gln substitution"},
	"UniMod:1065":{"unimod": "UniMod:1065", "mass_modification":-1.961506
, "name":"Cys->Thr", "descr":"Cys->Thr substitution"},
	"UniMod:1066":{"unimod": "UniMod:1066", "mass_modification":-3.940771
, "name":"Cys->Val", "descr":"Cys->Val substitution"},
	"UniMod:1067":{"unimod": "UniMod:1067", "mass_modification":-12.017759
, "name":"Asp->Cys", "descr":"Asp->Cys substitution"},
	"UniMod:1068":{"unimod": "UniMod:1068", "mass_modification":32.041471
, "name":"Asp->Phe", "descr":"Asp->Phe substitution"},
	"UniMod:1069":{"unimod": "UniMod:1069", "mass_modification":-1.942879
, "name":"Asp->Xle", "descr":"Asp->Leu/Ile substitution"},
	"UniMod:1070":{"unimod": "UniMod:1070", "mass_modification":13.06802
, "name":"Asp->Lys", "descr":"Asp->Lys substitution"},
	"UniMod:1071":{"unimod": "UniMod:1071", "mass_modification":16.013542
, "name":"Asp->Met", "descr":"Asp->Met substitution"},
	"UniMod:1072":{"unimod": "UniMod:1072", "mass_modification":-17.974179
, "name":"Asp->Pro", "descr":"Asp->Pro substitution"},
	"UniMod:1073":{"unimod": "UniMod:1073", "mass_modification":13.031634
, "name":"Asp->Gln", "descr":"Asp->Gln substitution"},
	"UniMod:1074":{"unimod": "UniMod:1074", "mass_modification":41.074168
, "name":"Asp->Arg", "descr":"Asp->Arg substitution"},
	"UniMod:1075":{"unimod": "UniMod:1075", "mass_modification":-27.994915
, "name":"Asp->Ser", "descr":"Asp->Ser substitution"},
	"UniMod:1076":{"unimod": "UniMod:1076", "mass_modification":-13.979265
, "name":"Asp->Thr", "descr":"Asp->Thr substitution"},
	"UniMod:1077":{"unimod": "UniMod:1077", "mass_modification":71.05237
, "name":"Asp->Trp", "descr":"Asp->Trp substitution"},
	"UniMod:1078":{"unimod": "UniMod:1078", "mass_modification":-26.033409
, "name":"Glu->Cys", "descr":"Glu->Cys substitution"},
	"UniMod:1079":{"unimod": "UniMod:1079", "mass_modification":18.025821
, "name":"Glu->Phe", "descr":"Glu->Phe substitution"},
	"UniMod:1080":{"unimod": "UniMod:1080", "mass_modification":8.016319
, "name":"Glu->His", "descr":"Glu->His substitution"},
	"UniMod:1081":{"unimod": "UniMod:1081", "mass_modification":-15.958529
, "name":"Glu->Xle", "descr":"Glu->Leu/Ile substitution"},
	"UniMod:1082":{"unimod": "UniMod:1082", "mass_modification":1.997892
, "name":"Glu->Met", "descr":"Glu->Met substitution"},
	"UniMod:1083":{"unimod": "UniMod:1083", "mass_modification":-14.999666
, "name":"Glu->Asn", "descr":"Glu->Asn substitution"},
	"UniMod:1084":{"unimod": "UniMod:1084", "mass_modification":-31.989829
, "name":"Glu->Pro", "descr":"Glu->Pro substitution"},
	"UniMod:1085":{"unimod": "UniMod:1085", "mass_modification":27.058518
, "name":"Glu->Arg", "descr":"Glu->Arg substitution"},
	"UniMod:1086":{"unimod": "UniMod:1086", "mass_modification":-42.010565
, "name":"Glu->Ser", "descr":"Glu->Ser substitution"},
	"UniMod:1087":{"unimod": "UniMod:1087", "mass_modification":-27.994915
, "name":"Glu->Thr", "descr":"Glu->Thr substitution"},
	"UniMod:1088":{"unimod": "UniMod:1088", "mass_modification":57.03672
, "name":"Glu->Trp", "descr":"Glu->Trp substitution"},
	"UniMod:1089":{"unimod": "UniMod:1089", "mass_modification":34.020735
, "name":"Glu->Tyr", "descr":"Glu->Tyr substitution"},
	"UniMod:1090":{"unimod": "UniMod:1090", "mass_modification":-76.0313
, "name":"Phe->Ala", "descr":"Phe->Ala substitution"},
	"UniMod:1091":{"unimod": "UniMod:1091", "mass_modification":-32.041471
, "name":"Phe->Asp", "descr":"Phe->Asp substitution"},
	"UniMod:1092":{"unimod": "UniMod:1092", "mass_modification":-18.025821
, "name":"Phe->Glu", "descr":"Phe->Glu substitution"},
	"UniMod:1093":{"unimod": "UniMod:1093", "mass_modification":-90.04695
, "name":"Phe->Gly", "descr":"Phe->Gly substitution"},
	"UniMod:1094":{"unimod": "UniMod:1094", "mass_modification":-10.009502
, "name":"Phe->His", "descr":"Phe->His substitution"},
	"UniMod:1095":{"unimod": "UniMod:1095", "mass_modification":-18.973451
, "name":"Phe->Lys", "descr":"Phe->Lys substitution"},
	"UniMod:1096":{"unimod": "UniMod:1096", "mass_modification":-16.027929
, "name":"Phe->Met", "descr":"Phe->Met substitution"},
	"UniMod:1097":{"unimod": "UniMod:1097", "mass_modification":-33.025486
, "name":"Phe->Asn", "descr":"Phe->Asn substitution"},
	"UniMod:1098":{"unimod": "UniMod:1098", "mass_modification":-50.01565
, "name":"Phe->Pro", "descr":"Phe->Pro substitution"},
	"UniMod:1099":{"unimod": "UniMod:1099", "mass_modification":-19.009836
, "name":"Phe->Gln", "descr":"Phe->Gln substitution"},
	"UniMod:1100":{"unimod": "UniMod:1100", "mass_modification":9.032697
, "name":"Phe->Arg", "descr":"Phe->Arg substitution"},
	"UniMod:1101":{"unimod": "UniMod:1101", "mass_modification":-46.020735
, "name":"Phe->Thr", "descr":"Phe->Thr substitution"},
	"UniMod:1102":{"unimod": "UniMod:1102", "mass_modification":39.010899
, "name":"Phe->Trp", "descr":"Phe->Trp substitution"},
	"UniMod:1103":{"unimod": "UniMod:1103", "mass_modification":90.04695
, "name":"Gly->Phe", "descr":"Gly->Phe substitution"},
	"UniMod:1104":{"unimod": "UniMod:1104", "mass_modification":80.037448
, "name":"Gly->His", "descr":"Gly->His substitution"},
	"UniMod:1105":{"unimod": "UniMod:1105", "mass_modification":56.0626
, "name":"Gly->Xle", "descr":"Gly->Leu/Ile substitution"},
	"UniMod:1106":{"unimod": "UniMod:1106", "mass_modification":71.073499
, "name":"Gly->Lys", "descr":"Gly->Lys substitution"},
	"UniMod:1107":{"unimod": "UniMod:1107", "mass_modification":74.019021
, "name":"Gly->Met", "descr":"Gly->Met substitution"},
	"UniMod:1108":{"unimod": "UniMod:1108", "mass_modification":57.021464
, "name":"Gly->Asn", "descr":"Gly->Asn substitution"},
	"UniMod:1109":{"unimod": "UniMod:1109", "mass_modification":40.0313
, "name":"Gly->Pro", "descr":"Gly->Pro substitution"},
	"UniMod:1110":{"unimod": "UniMod:1110", "mass_modification":71.037114
, "name":"Gly->Gln", "descr":"Gly->Gln substitution"},
	"UniMod:1111":{"unimod": "UniMod:1111", "mass_modification":44.026215
, "name":"Gly->Thr", "descr":"Gly->Thr substitution"},
	"UniMod:1112":{"unimod": "UniMod:1112", "mass_modification":106.041865
, "name":"Gly->Tyr", "descr":"Gly->Tyr substitution"},
	"UniMod:1113":{"unimod": "UniMod:1113", "mass_modification":-66.021798
, "name":"His->Ala", "descr":"His->Ala substitution"},
	"UniMod:1114":{"unimod": "UniMod:1114", "mass_modification":-34.049727
, "name":"His->Cys", "descr":"His->Cys substitution"},
	"UniMod:1115":{"unimod": "UniMod:1115", "mass_modification":-8.016319
, "name":"His->Glu", "descr":"His->Glu substitution"},
	"UniMod:1116":{"unimod": "UniMod:1116", "mass_modification":10.009502
, "name":"His->Phe", "descr":"His->Phe substitution"},
	"UniMod:1117":{"unimod": "UniMod:1117", "mass_modification":-80.037448
, "name":"His->Gly", "descr":"His->Gly substitution"},
	"UniMod:1119":{"unimod": "UniMod:1119", "mass_modification":-8.963949
, "name":"His->Lys", "descr":"His->Lys substitution"},
	"UniMod:1120":{"unimod": "UniMod:1120", "mass_modification":-6.018427
, "name":"His->Met", "descr":"His->Met substitution"},
	"UniMod:1121":{"unimod": "UniMod:1121", "mass_modification":-50.026883
, "name":"His->Ser", "descr":"His->Ser substitution"},
	"UniMod:1122":{"unimod": "UniMod:1122", "mass_modification":-36.011233
, "name":"His->Thr", "descr":"His->Thr substitution"},
	"UniMod:1123":{"unimod": "UniMod:1123", "mass_modification":-37.990498
, "name":"His->Val", "descr":"His->Val substitution"},
	"UniMod:1124":{"unimod": "UniMod:1124", "mass_modification":49.020401
, "name":"His->Trp", "descr":"His->Trp substitution"},
	"UniMod:1126":{"unimod": "UniMod:1126", "mass_modification":-10.07488
, "name":"Xle->Cys", "descr":"Leu/Ile->Cys substitution"},
	"UniMod:1127":{"unimod": "UniMod:1127", "mass_modification":1.942879
, "name":"Xle->Asp", "descr":"Leu/Ile->Asp substitution"},
	"UniMod:1128":{"unimod": "UniMod:1128", "mass_modification":15.958529
, "name":"Xle->Glu", "descr":"Leu/Ile->Glu substitution"},
	"UniMod:1129":{"unimod": "UniMod:1129", "mass_modification":-56.0626
, "name":"Xle->Gly", "descr":"Leu/Ile->Gly substitution"},
	"UniMod:1130":{"unimod": "UniMod:1130", "mass_modification":49.979265
, "name":"Xle->Tyr", "descr":"Leu/Ile->Tyr substitution"},
	"UniMod:1131":{"unimod": "UniMod:1131", "mass_modification":-57.057849
, "name":"Lys->Ala", "descr":"Lys->Ala substitution"},
	"UniMod:1132":{"unimod": "UniMod:1132", "mass_modification":-25.085779
, "name":"Lys->Cys", "descr":"Lys->Cys substitution"},
	"UniMod:1133":{"unimod": "UniMod:1133", "mass_modification":-13.06802
, "name":"Lys->Asp", "descr":"Lys->Asp substitution"},
	"UniMod:1134":{"unimod": "UniMod:1134", "mass_modification":18.973451
, "name":"Lys->Phe", "descr":"Lys->Phe substitution"},
	"UniMod:1135":{"unimod": "UniMod:1135", "mass_modification":-71.073499
, "name":"Lys->Gly", "descr":"Lys->Gly substitution"},
	"UniMod:1136":{"unimod": "UniMod:1136", "mass_modification":8.963949
, "name":"Lys->His", "descr":"Lys->His substitution"},
	"UniMod:1137":{"unimod": "UniMod:1137", "mass_modification":-31.042199
, "name":"Lys->Pro", "descr":"Lys->Pro substitution"},
	"UniMod:1138":{"unimod": "UniMod:1138", "mass_modification":-41.062935
, "name":"Lys->Ser", "descr":"Lys->Ser substitution"},
	"UniMod:1139":{"unimod": "UniMod:1139", "mass_modification":-29.026549
, "name":"Lys->Val", "descr":"Lys->Val substitution"},
	"UniMod:1140":{"unimod": "UniMod:1140", "mass_modification":57.98435
, "name":"Lys->Trp", "descr":"Lys->Trp substitution"},
	"UniMod:1141":{"unimod": "UniMod:1141", "mass_modification":34.968366
, "name":"Lys->Tyr", "descr":"Lys->Tyr substitution"},
	"UniMod:1142":{"unimod": "UniMod:1142", "mass_modification":-60.003371
, "name":"Met->Ala", "descr":"Met->Ala substitution"},
	"UniMod:1143":{"unimod": "UniMod:1143", "mass_modification":-28.0313
, "name":"Met->Cys", "descr":"Met->Cys substitution"},
	"UniMod:1144":{"unimod": "UniMod:1144", "mass_modification":-16.013542
, "name":"Met->Asp", "descr":"Met->Asp substitution"},
	"UniMod:1145":{"unimod": "UniMod:1145", "mass_modification":-1.997892
, "name":"Met->Glu", "descr":"Met->Glu substitution"},
	"UniMod:1146":{"unimod": "UniMod:1146", "mass_modification":16.027929
, "name":"Met->Phe", "descr":"Met->Phe substitution"},
	"UniMod:1147":{"unimod": "UniMod:1147", "mass_modification":-74.019021
, "name":"Met->Gly", "descr":"Met->Gly substitution"},
	"UniMod:1148":{"unimod": "UniMod:1148", "mass_modification":6.018427
, "name":"Met->His", "descr":"Met->His substitution"},
	"UniMod:1149":{"unimod": "UniMod:1149", "mass_modification":-16.997557
, "name":"Met->Asn", "descr":"Met->Asn substitution"},
	"UniMod:1150":{"unimod": "UniMod:1150", "mass_modification":-33.987721
, "name":"Met->Pro", "descr":"Met->Pro substitution"},
	"UniMod:1151":{"unimod": "UniMod:1151", "mass_modification":-2.981907
, "name":"Met->Gln", "descr":"Met->Gln substitution"},
	"UniMod:1152":{"unimod": "UniMod:1152", "mass_modification":-44.008456
, "name":"Met->Ser", "descr":"Met->Ser substitution"},
	"UniMod:1153":{"unimod": "UniMod:1153", "mass_modification":55.038828
, "name":"Met->Trp", "descr":"Met->Trp substitution"},
	"UniMod:1154":{"unimod": "UniMod:1154", "mass_modification":32.022844
, "name":"Met->Tyr", "descr":"Met->Tyr substitution"},
	"UniMod:1155":{"unimod": "UniMod:1155", "mass_modification":-43.005814
, "name":"Asn->Ala", "descr":"Asn->Ala substitution"},
	"UniMod:1156":{"unimod": "UniMod:1156", "mass_modification":-11.033743
, "name":"Asn->Cys", "descr":"Asn->Cys substitution"},
	"UniMod:1157":{"unimod": "UniMod:1157", "mass_modification":14.999666
, "name":"Asn->Glu", "descr":"Asn->Glu substitution"},
	"UniMod:1158":{"unimod": "UniMod:1158", "mass_modification":33.025486
, "name":"Asn->Phe", "descr":"Asn->Phe substitution"},
	"UniMod:1159":{"unimod": "UniMod:1159", "mass_modification":-57.021464
, "name":"Asn->Gly", "descr":"Asn->Gly substitution"},
	"UniMod:1160":{"unimod": "UniMod:1160", "mass_modification":16.997557
, "name":"Asn->Met", "descr":"Asn->Met substitution"},
	"UniMod:1161":{"unimod": "UniMod:1161", "mass_modification":-16.990164
, "name":"Asn->Pro", "descr":"Asn->Pro substitution"},
	"UniMod:1162":{"unimod": "UniMod:1162", "mass_modification":14.01565
, "name":"Asn->Gln", "descr":"Asn->Gln substitution"},
	"UniMod:1163":{"unimod": "UniMod:1163", "mass_modification":42.058184
, "name":"Asn->Arg", "descr":"Asn->Arg substitution"},
	"UniMod:1164":{"unimod": "UniMod:1164", "mass_modification":-14.974514
, "name":"Asn->Val", "descr":"Asn->Val substitution"},
	"UniMod:1165":{"unimod": "UniMod:1165", "mass_modification":72.036386
, "name":"Asn->Trp", "descr":"Asn->Trp substitution"},
	"UniMod:1166":{"unimod": "UniMod:1166", "mass_modification":5.956421
, "name":"Pro->Cys", "descr":"Pro->Cys substitution"},
	"UniMod:1167":{"unimod": "UniMod:1167", "mass_modification":17.974179
, "name":"Pro->Asp", "descr":"Pro->Asp substitution"},
	"UniMod:1168":{"unimod": "UniMod:1168", "mass_modification":31.989829
, "name":"Pro->Glu", "descr":"Pro->Glu substitution"},
	"UniMod:1169":{"unimod": "UniMod:1169", "mass_modification":50.01565
, "name":"Pro->Phe", "descr":"Pro->Phe substitution"},
	"UniMod:1170":{"unimod": "UniMod:1170", "mass_modification":-40.0313
, "name":"Pro->Gly", "descr":"Pro->Gly substitution"},
	"UniMod:1171":{"unimod": "UniMod:1171", "mass_modification":31.042199
, "name":"Pro->Lys", "descr":"Pro->Lys substitution"},
	"UniMod:1172":{"unimod": "UniMod:1172", "mass_modification":33.987721
, "name":"Pro->Met", "descr":"Pro->Met substitution"},
	"UniMod:1173":{"unimod": "UniMod:1173", "mass_modification":16.990164
, "name":"Pro->Asn", "descr":"Pro->Asn substitution"},
	"UniMod:1174":{"unimod": "UniMod:1174", "mass_modification":2.01565
, "name":"Pro->Val", "descr":"Pro->Val substitution"},
	"UniMod:1175":{"unimod": "UniMod:1175", "mass_modification":89.026549
, "name":"Pro->Trp", "descr":"Pro->Trp substitution"},
	"UniMod:1176":{"unimod": "UniMod:1176", "mass_modification":66.010565
, "name":"Pro->Tyr", "descr":"Pro->Tyr substitution"},
	"UniMod:1177":{"unimod": "UniMod:1177", "mass_modification":-57.021464
, "name":"Gln->Ala", "descr":"Gln->Ala substitution"},
	"UniMod:1178":{"unimod": "UniMod:1178", "mass_modification":-25.049393
, "name":"Gln->Cys", "descr":"Gln->Cys substitution"},
	"UniMod:1179":{"unimod": "UniMod:1179", "mass_modification":-13.031634
, "name":"Gln->Asp", "descr":"Gln->Asp substitution"},
	"UniMod:1180":{"unimod": "UniMod:1180", "mass_modification":19.009836
, "name":"Gln->Phe", "descr":"Gln->Phe substitution"},
	"UniMod:1181":{"unimod": "UniMod:1181", "mass_modification":-71.037114
, "name":"Gln->Gly", "descr":"Gln->Gly substitution"},
	"UniMod:1182":{"unimod": "UniMod:1182", "mass_modification":2.981907
, "name":"Gln->Met", "descr":"Gln->Met substitution"},
	"UniMod:1183":{"unimod": "UniMod:1183", "mass_modification":-14.01565
, "name":"Gln->Asn", "descr":"Gln->Asn substitution"},
	"UniMod:1184":{"unimod": "UniMod:1184", "mass_modification":-41.026549
, "name":"Gln->Ser", "descr":"Gln->Ser substitution"},
	"UniMod:1185":{"unimod": "UniMod:1185", "mass_modification":-27.010899
, "name":"Gln->Thr", "descr":"Gln->Thr substitution"},
	"UniMod:1186":{"unimod": "UniMod:1186", "mass_modification":-28.990164
, "name":"Gln->Val", "descr":"Gln->Val substitution"},
	"UniMod:1187":{"unimod": "UniMod:1187", "mass_modification":58.020735
, "name":"Gln->Trp", "descr":"Gln->Trp substitution"},
	"UniMod:1188":{"unimod": "UniMod:1188", "mass_modification":35.004751
, "name":"Gln->Tyr", "descr":"Gln->Tyr substitution"},
	"UniMod:1189":{"unimod": "UniMod:1189", "mass_modification":-85.063997
, "name":"Arg->Ala", "descr":"Arg->Ala substitution"},
	"UniMod:1190":{"unimod": "UniMod:1190", "mass_modification":-41.074168
, "name":"Arg->Asp", "descr":"Arg->Asp substitution"},
	"UniMod:1191":{"unimod": "UniMod:1191", "mass_modification":-27.058518
, "name":"Arg->Glu", "descr":"Arg->Glu substitution"},
	"UniMod:1192":{"unimod": "UniMod:1192", "mass_modification":-42.058184
, "name":"Arg->Asn", "descr":"Arg->Asn substitution"},
	"UniMod:1193":{"unimod": "UniMod:1193", "mass_modification":-57.032697
, "name":"Arg->Val", "descr":"Arg->Val substitution"},
	"UniMod:1194":{"unimod": "UniMod:1194", "mass_modification":6.962218
, "name":"Arg->Tyr", "descr":"Arg->Tyr substitution"},
	"UniMod:1195":{"unimod": "UniMod:1195", "mass_modification":-9.032697
, "name":"Arg->Phe", "descr":"Arg->Phe substitution"},
	"UniMod:1196":{"unimod": "UniMod:1196", "mass_modification":27.994915
, "name":"Ser->Asp", "descr":"Ser->Asp substitution"},
	"UniMod:1197":{"unimod": "UniMod:1197", "mass_modification":42.010565
, "name":"Ser->Glu", "descr":"Ser->Glu substitution"},
	"UniMod:1198":{"unimod": "UniMod:1198", "mass_modification":50.026883
, "name":"Ser->His", "descr":"Ser->His substitution"},
	"UniMod:1199":{"unimod": "UniMod:1199", "mass_modification":41.062935
, "name":"Ser->Lys", "descr":"Ser->Lys substitution"},
	"UniMod:1200":{"unimod": "UniMod:1200", "mass_modification":44.008456
, "name":"Ser->Met", "descr":"Ser->Met substitution"},
	"UniMod:1201":{"unimod": "UniMod:1201", "mass_modification":41.026549
, "name":"Ser->Gln", "descr":"Ser->Gln substitution"},
	"UniMod:1202":{"unimod": "UniMod:1202", "mass_modification":12.036386
, "name":"Ser->Val", "descr":"Ser->Val substitution"},
	"UniMod:1203":{"unimod": "UniMod:1203", "mass_modification":1.961506
, "name":"Thr->Cys", "descr":"Thr->Cys substitution"},
	"UniMod:1204":{"unimod": "UniMod:1204", "mass_modification":13.979265
, "name":"Thr->Asp", "descr":"Thr->Asp substitution"},
	"UniMod:1205":{"unimod": "UniMod:1205", "mass_modification":27.994915
, "name":"Thr->Glu", "descr":"Thr->Glu substitution"},
	"UniMod:1206":{"unimod": "UniMod:1206", "mass_modification":46.020735
, "name":"Thr->Phe", "descr":"Thr->Phe substitution"},
	"UniMod:1207":{"unimod": "UniMod:1207", "mass_modification":-44.026215
, "name":"Thr->Gly", "descr":"Thr->Gly substitution"},
	"UniMod:1208":{"unimod": "UniMod:1208", "mass_modification":36.011233
, "name":"Thr->His", "descr":"Thr->His substitution"},
	"UniMod:1209":{"unimod": "UniMod:1209", "mass_modification":27.010899
, "name":"Thr->Gln", "descr":"Thr->Gln substitution"},
	"UniMod:1210":{"unimod": "UniMod:1210", "mass_modification":-1.979265
, "name":"Thr->Val", "descr":"Thr->Val substitution"},
	"UniMod:1211":{"unimod": "UniMod:1211", "mass_modification":85.031634
, "name":"Thr->Trp", "descr":"Thr->Trp substitution"},
	"UniMod:1212":{"unimod": "UniMod:1212", "mass_modification":62.01565
, "name":"Thr->Tyr", "descr":"Thr->Tyr substitution"},
	"UniMod:1213":{"unimod": "UniMod:1213", "mass_modification":3.940771
, "name":"Val->Cys", "descr":"Val->Cys substitution"},
	"UniMod:1214":{"unimod": "UniMod:1214", "mass_modification":37.990498
, "name":"Val->His", "descr":"Val->His substitution"},
	"UniMod:1215":{"unimod": "UniMod:1215", "mass_modification":29.026549
, "name":"Val->Lys", "descr":"Val->Lys substitution"},
	"UniMod:1216":{"unimod": "UniMod:1216", "mass_modification":14.974514
, "name":"Val->Asn", "descr":"Val->Asn substitution"},
	"UniMod:1217":{"unimod": "UniMod:1217", "mass_modification":-2.01565
, "name":"Val->Pro", "descr":"Val->Pro substitution"},
	"UniMod:1218":{"unimod": "UniMod:1218", "mass_modification":28.990164
, "name":"Val->Gln", "descr":"Val->Gln substitution"},
	"UniMod:1219":{"unimod": "UniMod:1219", "mass_modification":57.032697
, "name":"Val->Arg", "descr":"Val->Arg substitution"},
	"UniMod:1220":{"unimod": "UniMod:1220", "mass_modification":-12.036386
, "name":"Val->Ser", "descr":"Val->Ser substitution"},
	"UniMod:1221":{"unimod": "UniMod:1221", "mass_modification":1.979265
, "name":"Val->Thr", "descr":"Val->Thr substitution"},
	"UniMod:1222":{"unimod": "UniMod:1222", "mass_modification":87.010899
, "name":"Val->Trp", "descr":"Val->Trp substitution"},
	"UniMod:1223":{"unimod": "UniMod:1223", "mass_modification":63.994915
, "name":"Val->Tyr", "descr":"Val->Tyr substitution"},
	"UniMod:1224":{"unimod": "UniMod:1224", "mass_modification":-115.042199
, "name":"Trp->Ala", "descr":"Trp->Ala substitution"},
	"UniMod:1225":{"unimod": "UniMod:1225", "mass_modification":-71.05237
, "name":"Trp->Asp", "descr":"Trp->Asp substitution"},
	"UniMod:1226":{"unimod": "UniMod:1226", "mass_modification":-57.03672
, "name":"Trp->Glu", "descr":"Trp->Glu substitution"},
	"UniMod:1227":{"unimod": "UniMod:1227", "mass_modification":-39.010899
, "name":"Trp->Phe", "descr":"Trp->Phe substitution"},
	"UniMod:1228":{"unimod": "UniMod:1228", "mass_modification":-49.020401
, "name":"Trp->His", "descr":"Trp->His substitution"},
	"UniMod:1229":{"unimod": "UniMod:1229", "mass_modification":-57.98435
, "name":"Trp->Lys", "descr":"Trp->Lys substitution"},
	"UniMod:1230":{"unimod": "UniMod:1230", "mass_modification":-55.038828
, "name":"Trp->Met", "descr":"Trp->Met substitution"},
	"UniMod:1231":{"unimod": "UniMod:1231", "mass_modification":-72.036386
, "name":"Trp->Asn", "descr":"Trp->Asn substitution"},
	"UniMod:1232":{"unimod": "UniMod:1232", "mass_modification":-89.026549
, "name":"Trp->Pro", "descr":"Trp->Pro substitution"},
	"UniMod:1233":{"unimod": "UniMod:1233", "mass_modification":-58.020735
, "name":"Trp->Gln", "descr":"Trp->Gln substitution"},
	"UniMod:1234":{"unimod": "UniMod:1234", "mass_modification":-85.031634
, "name":"Trp->Thr", "descr":"Trp->Thr substitution"},
	"UniMod:1235":{"unimod": "UniMod:1235", "mass_modification":-87.010899
, "name":"Trp->Val", "descr":"Trp->Val substitution"},
	"UniMod:1236":{"unimod": "UniMod:1236", "mass_modification":-23.015984
, "name":"Trp->Tyr", "descr":"Trp->Tyr substitution"},
	"UniMod:1237":{"unimod": "UniMod:1237", "mass_modification":-92.026215
, "name":"Tyr->Ala", "descr":"Tyr->Ala substitution"},
	"UniMod:1238":{"unimod": "UniMod:1238", "mass_modification":-34.020735
, "name":"Tyr->Glu", "descr":"Tyr->Glu substitution"},
	"UniMod:1239":{"unimod": "UniMod:1239", "mass_modification":-106.041865
, "name":"Tyr->Gly", "descr":"Tyr->Gly substitution"},
	"UniMod:1240":{"unimod": "UniMod:1240", "mass_modification":-34.968366
, "name":"Tyr->Lys", "descr":"Tyr->Lys substitution"},
	"UniMod:1241":{"unimod": "UniMod:1241", "mass_modification":-32.022844
, "name":"Tyr->Met", "descr":"Tyr->Met substitution"},
	"UniMod:1242":{"unimod": "UniMod:1242", "mass_modification":-66.010565
, "name":"Tyr->Pro", "descr":"Tyr->Pro substitution"},
	"UniMod:1243":{"unimod": "UniMod:1243", "mass_modification":-35.004751
, "name":"Tyr->Gln", "descr":"Tyr->Gln substitution"},
	"UniMod:1244":{"unimod": "UniMod:1244", "mass_modification":-6.962218
, "name":"Tyr->Arg", "descr":"Tyr->Arg substitution"},
	"UniMod:1245":{"unimod": "UniMod:1245", "mass_modification":-62.01565
, "name":"Tyr->Thr", "descr":"Tyr->Thr substitution"},
	"UniMod:1246":{"unimod": "UniMod:1246", "mass_modification":-63.994915
, "name":"Tyr->Val", "descr":"Tyr->Val substitution"},
	"UniMod:1247":{"unimod": "UniMod:1247", "mass_modification":23.015984
, "name":"Tyr->Trp", "descr":"Tyr->Trp substitution"},
	"UniMod:1248":{"unimod": "UniMod:1248", "mass_modification":-49.979265
, "name":"Tyr->Xle", "descr":"Tyr->Leu/Ile substitution"},
	"UniMod:1249":{"unimod": "UniMod:1249", "mass_modification":195.075625
, "name":"AHA-SS", "descr":"Azidohomoalanine coupled to reductively cleaved tag"},
	"UniMod:1250":{"unimod": "UniMod:1250", "mass_modification":252.097088
, "name":"AHA-SS_CAM", "descr":"carbamidomethylated form of reductively cleaved tag coupled to azidohomoalanine"},
	"UniMod:1251":{"unimod": "UniMod:1251", "mass_modification":548.223945
, "name":"Biotin:Thermo-33033", "descr":"Sulfo-SBED Label Photoreactive Biotin Crosslinker"},
	"UniMod:1252":{"unimod": "UniMod:1252", "mass_modification":546.208295
, "name":"Biotin:Thermo-33033-H", "descr":"Sulfo-SBED Label Photoreactive Biotin Crosslinker minus Hydrogen"},
	"UniMod:1253":{"unimod": "UniMod:1253", "mass_modification":130.026609
, "name":"2-monomethylsuccinyl", "descr":"S-(2-monomethylsuccinyl) cysteine"},
	"UniMod:1254":{"unimod": "UniMod:1254", "mass_modification":106.041865
, "name":"Saligenin", "descr":"o-toluene"},
	"UniMod:1255":{"unimod": "UniMod:1255", "mass_modification":170.013281
, "name":"Cresylphosphate", "descr":"o-toluyl-phosphorylation"},
	"UniMod:1256":{"unimod": "UniMod:1256", "mass_modification":276.055146
, "name":"CresylSaligeninPhosphate", "descr":"Cresyl-Saligenin-phosphorylation"},
	"UniMod:1257":{"unimod": "UniMod:1257", "mass_modification":100.063663
, "name":"Ub-Br2", "descr":"Ub Bromide probe addition"},
	"UniMod:1258":{"unimod": "UniMod:1258", "mass_modification":172.084792
, "name":"Ub-VME", "descr":"Ubiquitin vinylmethylester"},
	"UniMod:1261":{"unimod": "UniMod:1261", "mass_modification":597.209772
, "name":"Ub-fluorescein", "descr":"Ub Fluorescein probe addition"},
	"UniMod:1262":{"unimod": "UniMod:1262", "mass_modification":144.042259
, "name":"2-dimethylsuccinyl", "descr":"S-(2-dimethylsuccinyl) cysteine"},
	"UniMod:1263":{"unimod": "UniMod:1263", "mass_modification":57.021464
, "name":"Gly", "descr":"Addition of Glycine"},
	"UniMod:1264":{"unimod": "UniMod:1264", "mass_modification":243.085521
, "name":"pupylation", "descr":"addition of GGE"},
	"UniMod:1266":{"unimod": "UniMod:1266", "mass_modification":4.013419
, "name":"Label:13C(4)", "descr":"13C4 Methionine label"},
	"UniMod:1271":{"unimod": "UniMod:1271", "mass_modification":133.019749
, "name":"HCysteinyl", "descr":"S-homocysteinylation"},
	"UniMod:1267":{"unimod": "UniMod:1267", "mass_modification":20.008334
, "name":"Label:13C(4)+Oxidation", "descr":"Oxidised 13C4 labelled Methionine"},
	"UniMod:1276":{"unimod": "UniMod:1276", "mass_modification":1106.48935
, "name":"UgiJoullie", "descr":"Side reaction of HisTag"},
	"UniMod:1270":{"unimod": "UniMod:1270", "mass_modification":117.024835
, "name":"HCysThiolactone", "descr":"N-Homocysteine thiolactone"},
	"UniMod:1282":{"unimod": "UniMod:1282", "mass_modification":154.074228
, "name":"UgiJoullieProGly", "descr":"Side reaction of PG with Side chain of aspartic or glutamic acid"},
	"UniMod:1277":{"unimod": "UniMod:1277", "mass_modification":225.090212
, "name":"Dipyridyl", "descr":"Cys modified with dipy ligand"},
	"UniMod:1278":{"unimod": "UniMod:1278", "mass_modification":66.010565
, "name":"Furan", "descr":"Chemical modification of the iodinated sites of thyroglobulin by Suzuki reaction"},
	"UniMod:1279":{"unimod": "UniMod:1279", "mass_modification":132.021129
, "name":"Difuran", "descr":"Chemical modification of the diiodinated sites of thyroglobulin by Suzuki reaction"},
	"UniMod:1281":{"unimod": "UniMod:1281", "mass_modification":263.131014
, "name":"BMP-piperidinol", "descr":"1-methyl-3-benzoyl-4-hydroxy-4-phenylpiperidine"},
	"UniMod:1283":{"unimod": "UniMod:1283", "mass_modification":308.148455
, "name":"UgiJoullieProGlyProGly", "descr":"Side reaction of PGPG with Side chain of aspartic or glutamic acid"},
	"UniMod:1287":{"unimod": "UniMod:1287", "mass_modification":-156.101111
, "name":"Arg-loss", "descr":"Loss of arginine due to transpeptidation"},
	"UniMod:1288":{"unimod": "UniMod:1288", "mass_modification":156.101111
, "name":"Arg", "descr":"Addition of arginine due to transpeptidation"},
	"UniMod:1286":{"unimod": "UniMod:1286", "mass_modification":688.199683
, "name":"IMEHex(2)NeuAc(1)", "descr":"Glycosylation with IME linked Hex(2) NeuAc"},
	"UniMod:1289":{"unimod": "UniMod:1289", "mass_modification":70.041865
, "name":"Butyryl", "descr":"Butyryl"},
	"UniMod:1290":{"unimod": "UniMod:1290", "mass_modification":114.042927
, "name":"Dicarbamidomethyl", "descr":"Double Carbamidomethylation"},
	"UniMod:1291":{"unimod": "UniMod:1291", "mass_modification":34.068961
, "name":"Dimethyl:2H(6)", "descr":"Dimethyl-Medium"},
	"UniMod:1292":{"unimod": "UniMod:1292", "mass_modification":242.101505
, "name":"GGQ", "descr":"SUMOylation leaving GlyGlyGln"},
	"UniMod:1293":{"unimod": "UniMod:1293", "mass_modification":343.149184
, "name":"QTGG", "descr":"SUMOylation leaving GlnThrGlyGly"},
	"UniMod:1297":{"unimod": "UniMod:1297", "mass_modification":4.007099
, "name":"Label:13C(3)15N(1)", "descr":"SILAC or AQUA label"},
	"UniMod:1296":{"unimod": "UniMod:1296", "mass_modification":3.010064
, "name":"Label:13C(3)", "descr":"13C3 label for SILAC"},
	"UniMod:1298":{"unimod": "UniMod:1298", "mass_modification":5.010454
, "name":"Label:13C(4)15N(1)", "descr":"13C4 15N1 label for SILAC"},
	"UniMod:1299":{"unimod": "UniMod:1299", "mass_modification":10.062767
, "name":"Label:2H(10)", "descr":"2H(10) label"},
	"UniMod:1300":{"unimod": "UniMod:1300", "mass_modification":5.028462
, "name":"Label:2H(4)13C(1)", "descr":"Label:2H(4)13C(1)"},
	"UniMod:1301":{"unimod": "UniMod:1301", "mass_modification":128.094963
, "name":"Lys", "descr":"Addition of lysine due to transpeptidation"},
	"UniMod:1302":{"unimod": "UniMod:1302", "mass_modification":148.109162
, "name":"mTRAQ:13C(6)15N(2)", "descr":"mTRAQ heavy"},
	"UniMod:1303":{"unimod": "UniMod:1303", "mass_modification":291.095417
, "name":"NeuAc", "descr":"N-acetyl neuraminic acid"},
	"UniMod:1304":{"unimod": "UniMod:1304", "mass_modification":307.090331
, "name":"NeuGc", "descr":"N-glycoyl neuraminic acid"},
	"UniMod:1305":{"unimod": "UniMod:1305", "mass_modification":42.04695
, "name":"Propyl", "descr":"Propyl"},
	"UniMod:1306":{"unimod": "UniMod:1306", "mass_modification":48.084611
, "name":"Propyl:2H(6)", "descr":"Propyl:2H(6)"},
	"UniMod:1310":{"unimod": "UniMod:1310", "mass_modification":132.057515
, "name":"Propiophenone", "descr":"Propiophenone"},
	"UniMod:1345":{"unimod": "UniMod:1345", "mass_modification":120.021129
, "name":"PS_Hapten", "descr":"reaction with phenyl salicylate (PS)"},
	"UniMod:1348":{"unimod": "UniMod:1348", "mass_modification":753.262796
, "name":"Cy3-maleimide", "descr":"Cy3 Maleimide mono-Reactive dye"},
	"UniMod:1312":{"unimod": "UniMod:1312", "mass_modification":58.041865
, "name":"Delta:H(6)C(3)O(1)", "descr":"Reduced acrolein addition +58"},
	"UniMod:1313":{"unimod": "UniMod:1313", "mass_modification":96.057515
, "name":"Delta:H(8)C(6)O(1)", "descr":"Reduced acrolein addition +96"},
	"UniMod:1314":{"unimod": "UniMod:1314", "mass_modification":298.146347
, "name":"biotinAcrolein298", "descr":"biotin hydrazide labeled acrolein addition +298"},
	"UniMod:1315":{"unimod": "UniMod:1315", "mass_modification":265.146664
, "name":"MM-diphenylpentanone", "descr":"3-methyl-5-(methylamino)-1,3-diphenylpentan-1-one"},
	"UniMod:1317":{"unimod": "UniMod:1317", "mass_modification":266.13068
, "name":"EHD-diphenylpentanone", "descr":"2-ethyl-3-hydroxy-1,3-diphenylpentan-1-one"},
	"UniMod:1349":{"unimod": "UniMod:1349", "mass_modification":132.068748
, "name":"benzylguanidine", "descr":"modification of the lysine side chain from NH2 to guanidine with a H removed in favor of a benzyl group"},
	"UniMod:1350":{"unimod": "UniMod:1350", "mass_modification":162.079313
, "name":"CarboxymethylDMAP", "descr":"A fixed +1 charge tag attached to the N-terminus of peptides"},
	"UniMod:1320":{"unimod": "UniMod:1320", "mass_modification":561.246849
, "name":"Biotin:Thermo-21901+2H2O", "descr":"Maleimide-Biotin + 2Water"},
	"UniMod:1321":{"unimod": "UniMod:1321", "mass_modification":145.12
, "name":"DiLeu4plex115", "descr":"Accurate mass for DiLeu 115 isobaric tag"},
	"UniMod:1322":{"unimod": "UniMod:1322", "mass_modification":145.132163
, "name":"DiLeu4plex", "descr":"Accurate mass for DiLeu 116 isobaric tag"},
	"UniMod:1323":{"unimod": "UniMod:1323", "mass_modification":145.128307
, "name":"DiLeu4plex117", "descr":"Accurate mass for DiLeu 117 isobaric tag"},
	"UniMod:1324":{"unimod": "UniMod:1324", "mass_modification":145.140471
, "name":"DiLeu4plex118", "descr":"Accurate mass for DiLeu 118 isobaric tag"},
	"UniMod:1887":{"unimod": "UniMod:1887", "mass_modification":213.111341
, "name":"Xlink:BuUrBu[213]", "descr":"Ammonia quenched monolink of BuUrBu crosslinker"},
	"UniMod:1330":{"unimod": "UniMod:1330", "mass_modification":434.178299
, "name":"bisANS-sulfonates", "descr":"BisANS with loss of both sulfonates"},
	"UniMod:1331":{"unimod": "UniMod:1331", "mass_modification":166.001457
, "name":"DNCB_hapten", "descr":"Chemical reaction with 2,4-dinitro-1-chloro benzene (DNCB)"},
	"UniMod:1326":{"unimod": "UniMod:1326", "mass_modification":157.019749
, "name":"NEMsulfur", "descr":"N-ethylmaleimideSulfur"},
	"UniMod:1327":{"unimod": "UniMod:1327", "mass_modification":63.9619
, "name":"SulfurDioxide", "descr":"SulfurDioxide"},
	"UniMod:1328":{"unimod": "UniMod:1328", "mass_modification":175.030314
, "name":"NEMsulfurWater", "descr":"N-ethylmaleimideSulfurWater"},
	"UniMod:1389":{"unimod": "UniMod:1389", "mass_modification":131.094629
, "name":"HN3_mustard", "descr":"Modification by hydroxylated tris-(2-chloroethyl)amine (HN-3)"},
	"UniMod:1387":{"unimod": "UniMod:1387", "mass_modification":167.982375
, "name":"3-phosphoglyceryl", "descr":"3-phosphoglyceryl"},
	"UniMod:1388":{"unimod": "UniMod:1388", "mass_modification":101.084064
, "name":"HN2_mustard", "descr":"Modification by hydroxylated mechloroethamine (HN-2)"},
	"UniMod:1358":{"unimod": "UniMod:1358", "mass_modification":148.089627
, "name":"NEM:2H(5)+H2O", "descr":"D5 N-ethylmaleimide+water on cysteines"},
	"UniMod:1363":{"unimod": "UniMod:1363", "mass_modification":68.026215
, "name":"Crotonyl", "descr":"Crotonylation"},
	"UniMod:1364":{"unimod": "UniMod:1364", "mass_modification":135.044916
, "name":"O-Et-N-diMePhospho", "descr":"O-ethyl, N-dimethyl phosphate"},
	"UniMod:1365":{"unimod": "UniMod:1365", "mass_modification":107.013615
, "name":"N-dimethylphosphate", "descr":"N-dimethylphosphate"},
	"UniMod:1356":{"unimod": "UniMod:1356", "mass_modification":212.00859
, "name":"phosphoRibosyl", "descr":"phosphate-ribosylation"},
	"UniMod:1355":{"unimod": "UniMod:1355", "mass_modification":-20.026215
, "name":"azole", "descr":"Formation of five membered aromatic heterocycle"},
	"UniMod:1340":{"unimod": "UniMod:1340", "mass_modification":921.461652
, "name":"Biotin:Thermo-21911", "descr":"Biotin-PEG11-maleimide"},
	"UniMod:1341":{"unimod": "UniMod:1341", "mass_modification":324.216141
, "name":"iodoTMT", "descr":"Native iodoacetyl Tandem Mass Tag®"},
	"UniMod:1342":{"unimod": "UniMod:1342", "mass_modification":329.226595
, "name":"iodoTMT6plex", "descr":"Sixplex iodoacetyl Tandem Mass Tag®"},
	"UniMod:1787":{"unimod": "UniMod:1787", "mass_modification":4.00078
, "name":"Label:13C(2)15N(2)", "descr":"13C(2) 15N(2)"},
	"UniMod:1344":{"unimod": "UniMod:1344", "mass_modification":258.014069
, "name":"Phosphogluconoylation", "descr":"Phosphogluconoylation"},
	"UniMod:1368":{"unimod": "UniMod:1368", "mass_modification":62.063875
, "name":"Methyl:2H(3)+Acetyl:2H(3)", "descr":"3-fold methylated lysine labelled with Acetyl_heavy"},
	"UniMod:1367":{"unimod": "UniMod:1367", "mass_modification":308.110732
, "name":"dHex(1)Hex(1)", "descr":"Hex1dHex1"},
	"UniMod:1380":{"unimod": "UniMod:1380", "mass_modification":106.00885
, "name":"methylsulfonylethyl", "descr":"reaction with methyl vinyl sulfone"},
	"UniMod:1370":{"unimod": "UniMod:1370", "mass_modification":19.013745
, "name":"Label:2H(3)+Oxidation", "descr":"Oxidised 2H(3) labelled Methionine"},
	"UniMod:1371":{"unimod": "UniMod:1371", "mass_modification":51.103441
, "name":"Trimethyl:2H(9)", "descr":"3-fold methylation with deuterated methyl groups"},
	"UniMod:1372":{"unimod": "UniMod:1372", "mass_modification":44.017274
, "name":"Acetyl:13C(2)", "descr":"heavy acetylation"},
	"UniMod:1375":{"unimod": "UniMod:1375", "mass_modification":470.163556
, "name":"dHex(1)Hex(2)", "descr":"Hex2dHex1"},
	"UniMod:1376":{"unimod": "UniMod:1376", "mass_modification":632.216379
, "name":"dHex(1)Hex(3)", "descr":"Hex3dHex1"},
	"UniMod:1377":{"unimod": "UniMod:1377", "mass_modification":794.269203
, "name":"dHex(1)Hex(4)", "descr":"Hex4dHex1"},
	"UniMod:1378":{"unimod": "UniMod:1378", "mass_modification":956.322026
, "name":"dHex(1)Hex(5)", "descr":"Hex5dHex1"},
	"UniMod:1379":{"unimod": "UniMod:1379", "mass_modification":1118.37485
, "name":"dHex(1)Hex(6)", "descr":"Hex6dHex1"},
	"UniMod:1381":{"unimod": "UniMod:1381", "mass_modification":120.0245
, "name":"ethylsulfonylethyl", "descr":"reaction with ethyl vinyl sulfone"},
	"UniMod:1382":{"unimod": "UniMod:1382", "mass_modification":168.0245
, "name":"phenylsulfonylethyl", "descr":"reaction with phenyl vinyl sulfone"},
	"UniMod:1383":{"unimod": "UniMod:1383", "mass_modification":231.02966
, "name":"PyridoxalPhosphateH2", "descr":"PLP bound to lysine reduced by sodium borohydride (NaBH4) to create amine linkage"},
	"UniMod:1384":{"unimod": "UniMod:1384", "mass_modification":33.969094
, "name":"Homocysteic_acid", "descr":"methionine oxidation to homocysteic acid"},
	"UniMod:1385":{"unimod": "UniMod:1385", "mass_modification":15.010899
, "name":"Hydroxamic_acid", "descr":"ADP-ribosylation followed by conversion to hydroxamic acid via hydroxylamine"},
	"UniMod:1390":{"unimod": "UniMod:1390", "mass_modification":141.042593
, "name":"Oxidation+NEM", "descr":"N-ethylmaleimide on cysteine sulfenic acid"},
	"UniMod:1391":{"unimod": "UniMod:1391", "mass_modification":471.131802
, "name":"NHS-fluorescein", "descr":"fluorescein-hexanoate-NHS hydrolysis"},
	"UniMod:1392":{"unimod": "UniMod:1392", "mass_modification":217.162932
, "name":"DiART6plex", "descr":"Representative mass and accurate mass for 114"},
	"UniMod:1393":{"unimod": "UniMod:1393", "mass_modification":217.156612
, "name":"DiART6plex115", "descr":"Accurate mass for DiART6plex 115"},
	"UniMod:1394":{"unimod": "UniMod:1394", "mass_modification":217.168776
, "name":"DiART6plex116/119", "descr":"Accurate mass for DiART6plex 116 and 119"},
	"UniMod:1395":{"unimod": "UniMod:1395", "mass_modification":217.162456
, "name":"DiART6plex117", "descr":"Accurate mass for DiART6plex 117"},
	"UniMod:1396":{"unimod": "UniMod:1396", "mass_modification":217.175096
, "name":"DiART6plex118", "descr":"Accurate mass for DiART6plex 118"},
	"UniMod:1397":{"unimod": "UniMod:1397", "mass_modification":133.052764
, "name":"Iodoacetanilide", "descr":"iodoacetanilide derivative"},
	"UniMod:1398":{"unimod": "UniMod:1398", "mass_modification":139.072893
, "name":"Iodoacetanilide:13C(6)", "descr":"13C labelled iodoacetanilide derivative"},
	"UniMod:1399":{"unimod": "UniMod:1399", "mass_modification":364.076278
, "name":"Dap-DSP", "descr":"Diaminopimelic acid-DSP monolinked"},
	"UniMod:1400":{"unimod": "UniMod:1400", "mass_modification":275.100502
, "name":"MurNAc", "descr":"N-Acetylmuramic acid"},
	"UniMod:1405":{"unimod": "UniMod:1405", "mass_modification":1705.73189
, "name":"EEEDVIEVYQEQTGG", "descr":"Sumoylation by SUMO-1 after Cyanogen bromide (CNBr) cleavage"},
	"UniMod:1402":{"unimod": "UniMod:1402", "mass_modification":11.032077
, "name":"Label:2H(7)15N(4)", "descr":"Label:2H(7)15N(4)"},
	"UniMod:1403":{"unimod": "UniMod:1403", "mass_modification":7.034695
, "name":"Label:2H(6)15N(1)", "descr":"Label:2H(6)15N(1)"},
	"UniMod:1406":{"unimod": "UniMod:1406", "mass_modification":1662.700924
, "name":"EDEDTIDVFQQQTGG", "descr":"Sumoylation by SUMO-2/3 after Cyanogen bromide (CNBr) cleavage"},
	"UniMod:1408":{"unimod": "UniMod:1408", "mass_modification":2204.772441
, "name":"Hex(5)HexNAc(4)NeuAc(2)", "descr":"A2G2S2/G2S2"},
	"UniMod:1409":{"unimod": "UniMod:1409", "mass_modification":1913.677025
, "name":"Hex(5)HexNAc(4)NeuAc(1)", "descr":"A2G2S1/G2S1"},
	"UniMod:1410":{"unimod": "UniMod:1410", "mass_modification":2059.734933
, "name":"dHex(1)Hex(5)HexNAc(4)NeuAc(1)", "descr":"FA2G2S1/G2FS1"},
	"UniMod:1411":{"unimod": "UniMod:1411", "mass_modification":2350.83035
, "name":"dHex(1)Hex(5)HexNAc(4)NeuAc(2)", "descr":"FA2G2S2/G2FS2"},
	"UniMod:1412":{"unimod": "UniMod:1412", "mass_modification":283.036187
, "name":"s-GlcNAc", "descr":"O3S1HexNAc1"},
	"UniMod:1413":{"unimod": "UniMod:1413", "mass_modification":404.071978
, "name":"PhosphoHex(2)", "descr":"H1O3P1Hex2"},
	"UniMod:1414":{"unimod": "UniMod:1414", "mass_modification":54.113505
, "name":"Trimethyl:13C(3)2H(9)", "descr":"3-fold methylation with fully labelled methyl groups"},
	"UniMod:1419":{"unimod": "UniMod:1419", "mass_modification":-18.023584
, "name":"15N-oxobutanoic", "descr":"Loss of ammonia (15N)"},
	"UniMod:1421":{"unimod": "UniMod:1421", "mass_modification":128.131349
, "name":"spermidine", "descr":"spermidine adduct"},
	"UniMod:1423":{"unimod": "UniMod:1423", "mass_modification":473.219571
, "name":"Biotin:Thermo-21330", "descr":"Biotin_PEG4"},
	"UniMod:1428":{"unimod": "UniMod:1428", "mass_modification":426.137341
, "name":"Hex(1)Pent(2)", "descr":"Hex Pent(2)"},
	"UniMod:1425":{"unimod": "UniMod:1425", "mass_modification":132.042259
, "name":"Pentose", "descr":"Pentose"},
	"UniMod:1426":{"unimod": "UniMod:1426", "mass_modification":294.095082
, "name":"Hex(1)Pent(1)", "descr":"Hex Pent"},
	"UniMod:1427":{"unimod": "UniMod:1427", "mass_modification":338.084912
, "name":"Hex(1)HexA(1)", "descr":"Hex HexA"},
	"UniMod:1429":{"unimod": "UniMod:1429", "mass_modification":445.098527
, "name":"Hex(1)HexNAc(1)Phos(1)", "descr":"Hex HexNAc Phos"},
	"UniMod:1430":{"unimod": "UniMod:1430", "mass_modification":445.089011
, "name":"Hex(1)HexNAc(1)Sulf(1)", "descr":"Hex HexNAc Sulf"},
	"UniMod:1431":{"unimod": "UniMod:1431", "mass_modification":453.14824
, "name":"Hex(1)NeuAc(1)", "descr":"Hex NeuAc ---OR--- HexNAc Kdn"},
	"UniMod:1432":{"unimod": "UniMod:1432", "mass_modification":469.143155
, "name":"Hex(1)NeuGc(1)", "descr":"Hex NeuGc"},
	"UniMod:1433":{"unimod": "UniMod:1433", "mass_modification":609.238118
, "name":"HexNAc(3)", "descr":"HexNAc(3)"},
	"UniMod:1434":{"unimod": "UniMod:1434", "mass_modification":494.174789
, "name":"HexNAc(1)NeuAc(1)", "descr":"HexNAc NeuAc"},
	"UniMod:1435":{"unimod": "UniMod:1435", "mass_modification":510.169704
, "name":"HexNAc(1)NeuGc(1)", "descr":"HexNAc NeuGc"},
	"UniMod:1444":{"unimod": "UniMod:1444", "mass_modification":615.201064
, "name":"Hex(2)NeuAc(1)", "descr":"Hex(2) NeuAc ---OR--- Hex HexNAc Kdn"},
	"UniMod:1436":{"unimod": "UniMod:1436", "mass_modification":525.205755
, "name":"Hex(1)HexNAc(1)dHex(1)Me(1)", "descr":"Hex HexNAc dHex Me"},
	"UniMod:1437":{"unimod": "UniMod:1437", "mass_modification":539.221405
, "name":"Hex(1)HexNAc(1)dHex(1)Me(2)", "descr":"Hex HexNAc dHex Me(2)"},
	"UniMod:1789":{"unimod": "UniMod:1789", "mass_modification":155.094629
, "name":"Xlink:DSS[155]", "descr":"Ammonium-quenched monolink of DSS/BS3 crosslinker"},
	"UniMod:1438":{"unimod": "UniMod:1438", "mass_modification":527.18502
, "name":"Hex(2)HexNAc(1)", "descr":"Hex(2) HexNAc"},
	"UniMod:1439":{"unimod": "UniMod:1439", "mass_modification":541.164284
, "name":"Hex(1)HexA(1)HexNAc(1)", "descr":"Hex HexA HexNAc"},
	"UniMod:1440":{"unimod": "UniMod:1440", "mass_modification":541.20067
, "name":"Hex(2)HexNAc(1)Me(1)", "descr":"Hex(2) HexNAc Me"},
	"UniMod:1441":{"unimod": "UniMod:1441", "mass_modification":558.1796
, "name":"Hex(1)Pent(3)", "descr":"Hex Pent(3)"},
	"UniMod:1442":{"unimod": "UniMod:1442", "mass_modification":585.190499
, "name":"Hex(1)NeuAc(1)Pent(1)", "descr":"Hex NeuAc Pent"},
	"UniMod:1443":{"unimod": "UniMod:1443", "mass_modification":607.141834
, "name":"Hex(2)HexNAc(1)Sulf(1)", "descr":"Hex(2) HexNAc Sulf"},
	"UniMod:1445":{"unimod": "UniMod:1445", "mass_modification":616.221465
, "name":"dHex(2)Hex(2)", "descr":"Hex2 dHex2"},
	"UniMod:1446":{"unimod": "UniMod:1446", "mass_modification":646.195644
, "name":"dHex(1)Hex(2)HexA(1)", "descr":"dHex Hex(2) HexA"},
	"UniMod:1447":{"unimod": "UniMod:1447", "mass_modification":648.168383
, "name":"Hex(1)HexNAc(2)Sulf(1)", "descr":"Hex HexNAc(2) Sulf"},
	"UniMod:1448":{"unimod": "UniMod:1448", "mass_modification":648.211294
, "name":"Hex(4)", "descr":"Hex(4)"},
	"UniMod:1449":{"unimod": "UniMod:1449", "mass_modification":1008.36456
, "name":"dHex(1)Hex(2)HexNAc(2)Pent(1)", "descr":"dHex Hex(2) HexNAc(2) Pent"},
	"UniMod:1450":{"unimod": "UniMod:1450", "mass_modification":1021.359809
, "name":"Hex(2)HexNAc(2)NeuAc(1)", "descr":"Hex(2) HexNAc(2) NeuAc ---OR--- dHex Hex HexNAc(2) NeuGc"},
	"UniMod:1451":{"unimod": "UniMod:1451", "mass_modification":1024.359475
, "name":"Hex(3)HexNAc(2)Pent(1)", "descr":"Hex(3) HexNAc(2) Pent"},
	"UniMod:1452":{"unimod": "UniMod:1452", "mass_modification":1054.370039
, "name":"Hex(4)HexNAc(2)", "descr":"Hex(4) HexNAc(2)"},
	"UniMod:1453":{"unimod": "UniMod:1453", "mass_modification":1129.390834
, "name":"dHex(1)Hex(4)HexNAc(1)Pent(1)", "descr":"dHex Hex(4) HexNAc Pent"},
	"UniMod:1454":{"unimod": "UniMod:1454", "mass_modification":1170.417383
, "name":"dHex(1)Hex(3)HexNAc(2)Pent(1)", "descr":"dHex Hex(3) HexNAc(2) Pent"},
	"UniMod:1455":{"unimod": "UniMod:1455", "mass_modification":1183.412632
, "name":"Hex(3)HexNAc(2)NeuAc(1)", "descr":"Hex(3) HexNAc(2) NeuAc"},
	"UniMod:1456":{"unimod": "UniMod:1456", "mass_modification":1186.412298
, "name":"Hex(4)HexNAc(2)Pent(1)", "descr":"Hex(4) HexNAc(2) Pent"},
	"UniMod:1457":{"unimod": "UniMod:1457", "mass_modification":1227.438847
, "name":"Hex(3)HexNAc(3)Pent(1)", "descr":"Hex(3) HexNAc(3) Pent"},
	"UniMod:1458":{"unimod": "UniMod:1458", "mass_modification":1296.389194
, "name":"Hex(5)HexNAc(2)Phos(1)", "descr":"Hex(5) HexNAc(2) Phos"},
	"UniMod:1459":{"unimod": "UniMod:1459", "mass_modification":1332.470207
, "name":"dHex(1)Hex(4)HexNAc(2)Pent(1)", "descr":"dHex Hex(4) HexNAc(2) Pent"},
	"UniMod:1460":{"unimod": "UniMod:1460", "mass_modification":1337.449137
, "name":"Hex(7)HexNAc(1)", "descr":"Hex(7) HexNAc"},
	"UniMod:1461":{"unimod": "UniMod:1461", "mass_modification":1345.465456
, "name":"Hex(4)HexNAc(2)NeuAc(1)", "descr":"Hex(4) HexNAc(2) NeuAc ---OR--- Hex(3) HexNAc(2) dHex NeuGc"},
	"UniMod:1462":{"unimod": "UniMod:1462", "mass_modification":1362.480772
, "name":"dHex(1)Hex(5)HexNAc(2)", "descr":"dHex Hex(5) HexNAc(2)"},
	"UniMod:1463":{"unimod": "UniMod:1463", "mass_modification":1373.496756
, "name":"dHex(1)Hex(3)HexNAc(3)Pent(1)", "descr":"dHex Hex(3) HexNAc(3) Pent"},
	"UniMod:1464":{"unimod": "UniMod:1464", "mass_modification":1378.432776
, "name":"Hex(3)HexNAc(4)Sulf(1)", "descr":"Hex(3) HexNAc(4) Sulf"},
	"UniMod:1465":{"unimod": "UniMod:1465", "mass_modification":1378.475686
, "name":"Hex(6)HexNAc(2)", "descr":"M6/Man6"},
	"UniMod:1466":{"unimod": "UniMod:1466", "mass_modification":1389.491671
, "name":"Hex(4)HexNAc(3)Pent(1)", "descr":"Hex(4) HexNAc(3) Pent"},
	"UniMod:1467":{"unimod": "UniMod:1467", "mass_modification":1403.507321
, "name":"dHex(1)Hex(4)HexNAc(3)", "descr":"dHex Hex(4) HexNAc(3)"},
	"UniMod:1468":{"unimod": "UniMod:1468", "mass_modification":1419.502235
, "name":"Hex(5)HexNAc(3)", "descr":"Hex(5) HexNAc(3)"},
	"UniMod:1469":{"unimod": "UniMod:1469", "mass_modification":1430.51822
, "name":"Hex(3)HexNAc(4)Pent(1)", "descr":"Hex(3) HexNAc(4) Pent"},
	"UniMod:1470":{"unimod": "UniMod:1470", "mass_modification":1458.442017
, "name":"Hex(6)HexNAc(2)Phos(1)", "descr":"Hex(6) HexNAc(2) Phos"},
	"UniMod:1471":{"unimod": "UniMod:1471", "mass_modification":1483.464135
, "name":"dHex(1)Hex(4)HexNAc(3)Sulf(1)", "descr":"dHex Hex(4) HexNAc(3) Sulf"},
	"UniMod:1472":{"unimod": "UniMod:1472", "mass_modification":1494.52303
, "name":"dHex(1)Hex(5)HexNAc(2)Pent(1)", "descr":"dHex Hex(5) HexNAc(2) Pent"},
	"UniMod:1473":{"unimod": "UniMod:1473", "mass_modification":1499.501961
, "name":"Hex(8)HexNAc(1)", "descr":"Hex(8) HexNAc"},
	"UniMod:1474":{"unimod": "UniMod:1474", "mass_modification":1505.539015
, "name":"dHex(1)Hex(3)HexNAc(3)Pent(2)", "descr":"dHex Hex(3) HexNAc(3) Pent(2)"},
	"UniMod:1475":{"unimod": "UniMod:1475", "mass_modification":1519.554665
, "name":"dHex(2)Hex(3)HexNAc(3)Pent(1)", "descr":"dHex(2) Hex(3) HexNAc(3) Pent"},
	"UniMod:1476":{"unimod": "UniMod:1476", "mass_modification":1524.490684
, "name":"dHex(1)Hex(3)HexNAc(4)Sulf(1)", "descr":"dHex Hex(3) HexNAc(4) Sulf"},
	"UniMod:1477":{"unimod": "UniMod:1477", "mass_modification":1524.533595
, "name":"dHex(1)Hex(6)HexNAc(2)", "descr":"dHex Hex(6) HexNAc(2)"},
	"UniMod:1478":{"unimod": "UniMod:1478", "mass_modification":1535.549579
, "name":"dHex(1)Hex(4)HexNAc(3)Pent(1)", "descr":"dHex Hex(4) HexNAc(3) Pent"},
	"UniMod:1479":{"unimod": "UniMod:1479", "mass_modification":1540.485599
, "name":"Hex(4)HexNAc(4)Sulf(1)", "descr":"Hex(4) HexNAc(4) Sulf"},
	"UniMod:1480":{"unimod": "UniMod:1480", "mass_modification":1540.52851
, "name":"Hex(7)HexNAc(2)", "descr":"M7/Man7"},
	"UniMod:1481":{"unimod": "UniMod:1481", "mass_modification":1549.56523
, "name":"dHex(2)Hex(4)HexNAc(3)", "descr":"dHex(2) Hex(4) HexNAc(3)"},
	"UniMod:1482":{"unimod": "UniMod:1482", "mass_modification":1551.544494
, "name":"Hex(5)HexNAc(3)Pent(1)", "descr":"Hex(5) HexNAc(3) Pent"},
	"UniMod:1483":{"unimod": "UniMod:1483", "mass_modification":1564.539743
, "name":"Hex(4)HexNAc(3)NeuGc(1)", "descr":"Hex(4) HexNAc(3) NeuGc"},
	"UniMod:1484":{"unimod": "UniMod:1484", "mass_modification":1565.560144
, "name":"dHex(1)Hex(5)HexNAc(3)", "descr":"dHex Hex(5) HexNAc(3)"},
	"UniMod:1485":{"unimod": "UniMod:1485", "mass_modification":1576.576129
, "name":"dHex(1)Hex(3)HexNAc(4)Pent(1)", "descr":"dHex Hex(3) HexNAc(4) Pent"},
	"UniMod:1486":{"unimod": "UniMod:1486", "mass_modification":1581.512148
, "name":"Hex(3)HexNAc(5)Sulf(1)", "descr":"Hex(3) HexNAc(5) Sulf"},
	"UniMod:1487":{"unimod": "UniMod:1487", "mass_modification":1581.555059
, "name":"Hex(6)HexNAc(3)", "descr":"Hex(6) HexNAc(3)"},
	"UniMod:1488":{"unimod": "UniMod:1488", "mass_modification":1589.571378
, "name":"Hex(3)HexNAc(4)NeuAc(1)", "descr":"Hex(3) HexNAc(4) NeuAc ---OR--- Hex(2) HexNAc(4) dHex NeuGc"},
	"UniMod:1489":{"unimod": "UniMod:1489", "mass_modification":1592.571043
, "name":"Hex(4)HexNAc(4)Pent(1)", "descr":"Hex(4) HexNAc(4) Pent"},
	"UniMod:1490":{"unimod": "UniMod:1490", "mass_modification":1620.494841
, "name":"Hex(7)HexNAc(2)Phos(1)", "descr":"Hex(7) HexNAc(2) Phos"},
	"UniMod:1491":{"unimod": "UniMod:1491", "mass_modification":1620.602343
, "name":"Hex(4)HexNAc(4)Me(2)Pent(1)", "descr":"Hex(4) HexNAc(4) Me(2) Pent"},
	"UniMod:1492":{"unimod": "UniMod:1492", "mass_modification":1637.581274
, "name":"dHex(1)Hex(3)HexNAc(3)Pent(3)", "descr":"dHex Hex(3) HexNAc(3) Pent(3) ---OR--- Hex(4) HexNAc(2) dHex(2) NeuAc"},
	"UniMod:1493":{"unimod": "UniMod:1493", "mass_modification":1645.516959
, "name":"dHex(1)Hex(5)HexNAc(3)Sulf(1)", "descr":"dHex Hex(5) HexNAc(3) Sulf"},
	"UniMod:1494":{"unimod": "UniMod:1494", "mass_modification":1651.596924
, "name":"dHex(2)Hex(3)HexNAc(3)Pent(2)", "descr":"dHex(2) Hex(3) HexNAc(3) Pent(2)"},
	"UniMod:1495":{"unimod": "UniMod:1495", "mass_modification":1661.52139
, "name":"Hex(6)HexNAc(3)Phos(1)", "descr":"Hex(6) HexNAc(3) Phos"},
	"UniMod:1496":{"unimod": "UniMod:1496", "mass_modification":1663.608157
, "name":"Hex(4)HexNAc(5)", "descr":"Hex(4) HexNAc(5)"},
	"UniMod:1497":{"unimod": "UniMod:1497", "mass_modification":1665.612574
, "name":"dHex(3)Hex(3)HexNAc(3)Pent(1)", "descr":"dHex(3) Hex(3) HexNAc(3) Pent"},
	"UniMod:1498":{"unimod": "UniMod:1498", "mass_modification":1681.607488
, "name":"dHex(2)Hex(4)HexNAc(3)Pent(1)", "descr":"dHex(2) Hex(4) HexNAc(3) Pent"},
	"UniMod:1499":{"unimod": "UniMod:1499", "mass_modification":1686.543508
, "name":"dHex(1)Hex(4)HexNAc(4)Sulf(1)", "descr":"dHex Hex(4) HexNAc(4) Sulf"},
	"UniMod:1500":{"unimod": "UniMod:1500", "mass_modification":1686.586419
, "name":"dHex(1)Hex(7)HexNAc(2)", "descr":"dHex Hex(7) HexNAc(2)"},
	"UniMod:1501":{"unimod": "UniMod:1501", "mass_modification":1694.602737
, "name":"dHex(1)Hex(4)HexNAc(3)NeuAc(1)", "descr":"dHex Hex(4) HexNAc(3) NeuAc ---OR--- dHex(2) Hex(3) HexNAc(3) NeuGc"},
	"UniMod:1502":{"unimod": "UniMod:1502", "mass_modification":1700.461172
, "name":"Hex(7)HexNAc(2)Phos(2)", "descr":"Hex(7) HexNAc(2) Phos(2)"},
	"UniMod:1503":{"unimod": "UniMod:1503", "mass_modification":1702.538423
, "name":"Hex(5)HexNAc(4)Sulf(1)", "descr":"Hex(5) HexNAc(4) Sulf"},
	"UniMod:1504":{"unimod": "UniMod:1504", "mass_modification":1702.581333
, "name":"Hex(8)HexNAc(2)", "descr":"M8/Man8"},
	"UniMod:1505":{"unimod": "UniMod:1505", "mass_modification":1708.618387
, "name":"dHex(1)Hex(3)HexNAc(4)Pent(2)", "descr":"dHex Hex(3) HexNAc(4) Pent(2)"},
	"UniMod:1506":{"unimod": "UniMod:1506", "mass_modification":1710.597652
, "name":"dHex(1)Hex(4)HexNAc(3)NeuGc(1)", "descr":"dHex Hex(4) HexNAc(3) NeuGc ---OR--- Hex(5) HexNAc(3) NeuAc"},
	"UniMod:1507":{"unimod": "UniMod:1507", "mass_modification":1722.634037
, "name":"dHex(2)Hex(3)HexNAc(4)Pent(1)", "descr":"dHex(2) Hex(3) HexNAc(4) Pent"},
	"UniMod:1508":{"unimod": "UniMod:1508", "mass_modification":1727.570057
, "name":"dHex(1)Hex(3)HexNAc(5)Sulf(1)", "descr":"dHex Hex(3) HexNAc(5) Sulf"},
	"UniMod:1509":{"unimod": "UniMod:1509", "mass_modification":1727.612968
, "name":"dHex(1)Hex(6)HexNAc(3)", "descr":"dHex Hex(6) HexNAc(3)"},
	"UniMod:1510":{"unimod": "UniMod:1510", "mass_modification":1735.629286
, "name":"dHex(1)Hex(3)HexNAc(4)NeuAc(1)", "descr":"dHex Hex(3) HexNAc(4) NeuAc"},
	"UniMod:1511":{"unimod": "UniMod:1511", "mass_modification":1736.649688
, "name":"dHex(3)Hex(3)HexNAc(4)", "descr":"dHex(3) Hex(3) HexNAc(4)"},
	"UniMod:1512":{"unimod": "UniMod:1512", "mass_modification":1738.628952
, "name":"dHex(1)Hex(4)HexNAc(4)Pent(1)", "descr":"dHex Hex(4) HexNAc(4) Pent"},
	"UniMod:1513":{"unimod": "UniMod:1513", "mass_modification":1743.564972
, "name":"Hex(4)HexNAc(5)Sulf(1)", "descr":"Hex(4) HexNAc(5) Sulf"},
	"UniMod:1514":{"unimod": "UniMod:1514", "mass_modification":1743.607882
, "name":"Hex(7)HexNAc(3)", "descr":"Hex(7) HexNAc(3)"},
	"UniMod:1515":{"unimod": "UniMod:1515", "mass_modification":1774.559552
, "name":"dHex(1)Hex(4)HexNAc(3)NeuAc(1)Sulf(1)", "descr":"dHex Hex(4) HexNAc(3) NeuAc Sulf"},
	"UniMod:1516":{"unimod": "UniMod:1516", "mass_modification":1782.655167
, "name":"Hex(5)HexNAc(4)Me(2)Pent(1)", "descr":"Hex(5) HexNAc(4) Me(2) Pent"},
	"UniMod:1517":{"unimod": "UniMod:1517", "mass_modification":1784.591521
, "name":"Hex(3)HexNAc(6)Sulf(1)", "descr":"Hex(3) HexNAc(6) Sulf"},
	"UniMod:1518":{"unimod": "UniMod:1518", "mass_modification":1807.569782
, "name":"dHex(1)Hex(6)HexNAc(3)Sulf(1)", "descr":"dHex Hex(6) HexNAc(3) Sulf"},
	"UniMod:1519":{"unimod": "UniMod:1519", "mass_modification":1809.666066
, "name":"dHex(1)Hex(4)HexNAc(5)", "descr":"dHex Hex(4) HexNAc(5)"},
	"UniMod:1520":{"unimod": "UniMod:1520", "mass_modification":1821.549047
, "name":"dHex(1)Hex(5)HexA(1)HexNAc(3)Sulf(1)", "descr":"dHex Hex(5) HexA HexNAc(3) Sulf"},
	"UniMod:1521":{"unimod": "UniMod:1521", "mass_modification":1823.574213
, "name":"Hex(7)HexNAc(3)Phos(1)", "descr":"Hex(7) HexNAc(3) Phos"},
	"UniMod:1522":{"unimod": "UniMod:1522", "mass_modification":1826.681382
, "name":"Hex(6)HexNAc(4)Me(3)", "descr":"Hex(6) HexNAc(4) Me(3)"},
	"UniMod:1523":{"unimod": "UniMod:1523", "mass_modification":1832.601417
, "name":"dHex(2)Hex(4)HexNAc(4)Sulf(1)", "descr":"dHex(2) Hex(4) HexNAc(4) Sulf"},
	"UniMod:1524":{"unimod": "UniMod:1524", "mass_modification":1839.640245
, "name":"Hex(4)HexNAc(3)NeuAc(2)", "descr":"Hex(4) HexNAc(3) NeuAc(2)"},
	"UniMod:1525":{"unimod": "UniMod:1525", "mass_modification":1840.660646
, "name":"dHex(1)Hex(3)HexNAc(4)Pent(3)", "descr":"dHex Hex(3) HexNAc(4) Pent(3)"},
	"UniMod:1526":{"unimod": "UniMod:1526", "mass_modification":1843.660312
, "name":"dHex(2)Hex(5)HexNAc(3)Pent(1)", "descr":"dHex(2) Hex(5) HexNAc(3) Pent"},
	"UniMod:1527":{"unimod": "UniMod:1527", "mass_modification":1848.596331
, "name":"dHex(1)Hex(5)HexNAc(4)Sulf(1)", "descr":"dHex Hex(5) HexNAc(4) Sulf"},
	"UniMod:1528":{"unimod": "UniMod:1528", "mass_modification":1854.676296
, "name":"dHex(2)Hex(3)HexNAc(4)Pent(2)", "descr":"dHex(2) Hex(3) HexNAc(4) Pent(2)"},
	"UniMod:1529":{"unimod": "UniMod:1529", "mass_modification":1856.655561
, "name":"dHex(1)Hex(5)HexNAc(3)NeuAc(1)", "descr":"dHex Hex(5) HexNAc(3) NeuAc"},
	"UniMod:1530":{"unimod": "UniMod:1530", "mass_modification":1864.548335
, "name":"Hex(3)HexNAc(6)Sulf(2)", "descr":"Hex(3) HexNAc(6) Sulf(2)"},
	"UniMod:1531":{"unimod": "UniMod:1531", "mass_modification":1864.634157
, "name":"Hex(9)HexNAc(2)", "descr":"M9/Man9"},
	"UniMod:1532":{"unimod": "UniMod:1532", "mass_modification":1866.68753
, "name":"Hex(4)HexNAc(6)", "descr":"Hex(4) HexNAc(6)"},
	"UniMod:1533":{"unimod": "UniMod:1533", "mass_modification":1868.691946
, "name":"dHex(3)Hex(3)HexNAc(4)Pent(1)", "descr":"dHex(3) Hex(3) HexNAc(4) Pent"},
	"UniMod:1534":{"unimod": "UniMod:1534", "mass_modification":1872.650475
, "name":"dHex(1)Hex(5)HexNAc(3)NeuGc(1)", "descr":"dHex Hex(5) HexNAc(3) NeuGc ---OR--- Hex(6) HexNAc(3) NeuAc"},
	"UniMod:1535":{"unimod": "UniMod:1535", "mass_modification":1884.686861
, "name":"dHex(2)Hex(4)HexNAc(4)Pent(1)", "descr":"dHex(2) Hex(4) HexNAc(4) Pent"},
	"UniMod:1536":{"unimod": "UniMod:1536", "mass_modification":1889.62288
, "name":"dHex(1)Hex(4)HexNAc(5)Sulf(1)", "descr":"dHex Hex(4) HexNAc(5) Sulf"},
	"UniMod:1537":{"unimod": "UniMod:1537", "mass_modification":1889.665791
, "name":"dHex(1)Hex(7)HexNAc(3)", "descr":"dHex Hex(7) HexNAc(3)"},
	"UniMod:1538":{"unimod": "UniMod:1538", "mass_modification":1900.681776
, "name":"dHex(1)Hex(5)HexNAc(4)Pent(1)", "descr":"dHex Hex(5) HexNAc(4) Pent"},
	"UniMod:1539":{"unimod": "UniMod:1539", "mass_modification":1901.505861
, "name":"dHex(1)Hex(5)HexA(1)HexNAc(3)Sulf(2)", "descr":"dHex Hex(5) HexA HexNAc(3) Sulf(2)"},
	"UniMod:1540":{"unimod": "UniMod:1540", "mass_modification":1907.714079
, "name":"Hex(3)HexNAc(7)", "descr":"Hex(3) HexNAc(7)"},
	"UniMod:1541":{"unimod": "UniMod:1541", "mass_modification":1914.697426
, "name":"dHex(2)Hex(5)HexNAc(4)", "descr":"dHex(2) Hex(5) HexNAc(4)"},
	"UniMod:1542":{"unimod": "UniMod:1542", "mass_modification":1920.617461
, "name":"dHex(2)Hex(4)HexNAc(3)NeuAc(1)Sulf(1)", "descr":"dHex(2) Hex(4) HexNAc(3) NeuAc Sulf"},
	"UniMod:1543":{"unimod": "UniMod:1543", "mass_modification":1928.553146
, "name":"dHex(1)Hex(5)HexNAc(4)Sulf(2)", "descr":"dHex Hex(5) HexNAc(4) Sulf(2)"},
	"UniMod:1544":{"unimod": "UniMod:1544", "mass_modification":1928.713076
, "name":"dHex(1)Hex(5)HexNAc(4)Me(2)Pent(1)", "descr":"dHex Hex(5) HexNAc(4) Me(2) Pent"},
	"UniMod:1545":{"unimod": "UniMod:1545", "mass_modification":1929.671939
, "name":"Hex(5)HexNAc(4)NeuGc(1)", "descr":"Hex(5) HexNAc(4) NeuGc"},
	"UniMod:1546":{"unimod": "UniMod:1546", "mass_modification":1930.64943
, "name":"dHex(1)Hex(3)HexNAc(6)Sulf(1)", "descr":"dHex Hex(3) HexNAc(6) Sulf"},
	"UniMod:1547":{"unimod": "UniMod:1547", "mass_modification":1930.69234
, "name":"dHex(1)Hex(6)HexNAc(4)", "descr":"dHex Hex(6) HexNAc(4)"},
	"UniMod:1548":{"unimod": "UniMod:1548", "mass_modification":1936.612375
, "name":"dHex(1)Hex(5)HexNAc(3)NeuAc(1)Sulf(1)", "descr":"dHex Hex(5) HexNAc(3) NeuAc Sulf"},
	"UniMod:1549":{"unimod": "UniMod:1549", "mass_modification":1946.687255
, "name":"Hex(7)HexNAc(4)", "descr":"Hex(7) HexNAc(4)"},
	"UniMod:1550":{"unimod": "UniMod:1550", "mass_modification":1952.60729
, "name":"dHex(1)Hex(5)HexNAc(3)NeuGc(1)Sulf(1)", "descr":"dHex Hex(5) HexNAc(3) NeuGc Sulf"},
	"UniMod:1551":{"unimod": "UniMod:1551", "mass_modification":1954.703574
, "name":"Hex(4)HexNAc(5)NeuAc(1)", "descr":"Hex(4) HexNAc(5) NeuAc"},
	"UniMod:1552":{"unimod": "UniMod:1552", "mass_modification":1958.72364
, "name":"Hex(6)HexNAc(4)Me(3)Pent(1)", "descr":"Hex(6) HexNAc(4) Me(3) Pent"},
	"UniMod:1553":{"unimod": "UniMod:1553", "mass_modification":1969.622606
, "name":"dHex(1)Hex(7)HexNAc(3)Sulf(1)", "descr":"dHex Hex(7) HexNAc(3) Sulf"},
	"UniMod:1554":{"unimod": "UniMod:1554", "mass_modification":1969.632122
, "name":"dHex(1)Hex(7)HexNAc(3)Phos(1)", "descr":"dHex Hex(7) HexNAc(3) Phos"},
	"UniMod:1555":{"unimod": "UniMod:1555", "mass_modification":1971.718889
, "name":"dHex(1)Hex(5)HexNAc(5)", "descr":"dHex Hex(5) HexNAc(5)"},
	"UniMod:1556":{"unimod": "UniMod:1556", "mass_modification":1977.638925
, "name":"dHex(1)Hex(4)HexNAc(4)NeuAc(1)Sulf(1)", "descr":"dHex Hex(4) HexNAc(4) NeuAc Sulf"},
	"UniMod:1557":{"unimod": "UniMod:1557", "mass_modification":1978.659326
, "name":"dHex(3)Hex(4)HexNAc(4)Sulf(1)", "descr":"dHex(3) Hex(4) HexNAc(4) Sulf"},
	"UniMod:1558":{"unimod": "UniMod:1558", "mass_modification":1987.670893
, "name":"Hex(3)HexNAc(7)Sulf(1)", "descr":"Hex(3) HexNAc(7) Sulf"},
	"UniMod:1559":{"unimod": "UniMod:1559", "mass_modification":1987.713804
, "name":"Hex(6)HexNAc(5)", "descr":"A3G3"},
	"UniMod:1560":{"unimod": "UniMod:1560", "mass_modification":1993.633839
, "name":"Hex(5)HexNAc(4)NeuAc(1)Sulf(1)", "descr":"Hex(5) HexNAc(4) NeuAc Sulf"},
	"UniMod:1561":{"unimod": "UniMod:1561", "mass_modification":1995.730123
, "name":"Hex(3)HexNAc(6)NeuAc(1)", "descr":"Hex(3) HexNAc(6) NeuAc"},
	"UniMod:1562":{"unimod": "UniMod:1562", "mass_modification":1996.750524
, "name":"dHex(2)Hex(3)HexNAc(6)", "descr":"dHex(2) Hex(3) HexNAc(6)"},
	"UniMod:1563":{"unimod": "UniMod:1563", "mass_modification":672.222527
, "name":"Hex(1)HexNAc(1)NeuGc(1)", "descr":"Hex HexNAc NeuGc"},
	"UniMod:1564":{"unimod": "UniMod:1564", "mass_modification":673.242928
, "name":"dHex(1)Hex(2)HexNAc(1)", "descr":"dHex Hex(2) HexNAc"},
	"UniMod:1565":{"unimod": "UniMod:1565", "mass_modification":689.194932
, "name":"HexNAc(3)Sulf(1)", "descr":"HexNAc(3) Sulf"},
	"UniMod:1566":{"unimod": "UniMod:1566", "mass_modification":689.237843
, "name":"Hex(3)HexNAc(1)", "descr":"Hex(3) HexNAc"},
	"UniMod:1567":{"unimod": "UniMod:1567", "mass_modification":695.157878
, "name":"Hex(1)HexNAc(1)Kdn(1)Sulf(1)", "descr":"Hex HexNAc Kdn Sulf"},
	"UniMod:1568":{"unimod": "UniMod:1568", "mass_modification":697.254162
, "name":"HexNAc(2)NeuAc(1)", "descr":"HexNAc(2) NeuAc"},
	"UniMod:1570":{"unimod": "UniMod:1570", "mass_modification":703.217108
, "name":"HexNAc(1)Kdn(2)", "descr":"HexNAc Kdn(2) ---OR--- Hex(2) HexNAc HexA"},
	"UniMod:1571":{"unimod": "UniMod:1571", "mass_modification":703.253493
, "name":"Hex(3)HexNAc(1)Me(1)", "descr":"Hex(3) HexNAc Me"},
	"UniMod:1572":{"unimod": "UniMod:1572", "mass_modification":712.136808
, "name":"Hex(2)HexA(1)Pent(1)Sulf(1)", "descr":"Hex(2) HexA Pent Sulf"},
	"UniMod:1573":{"unimod": "UniMod:1573", "mass_modification":713.249076
, "name":"HexNAc(2)NeuGc(1)", "descr":"HexNAc(2) NeuGc"},
	"UniMod:1575":{"unimod": "UniMod:1575", "mass_modification":728.177625
, "name":"Hex(4)Phos(1)", "descr":"Hex(4) Phos"},
	"UniMod:1577":{"unimod": "UniMod:1577", "mass_modification":736.184427
, "name":"Hex(1)HexNAc(1)NeuAc(1)Sulf(1)", "descr":"Hex HexNAc NeuAc Sulf"},
	"UniMod:1578":{"unimod": "UniMod:1578", "mass_modification":744.243657
, "name":"Hex(1)HexA(1)HexNAc(2)", "descr":"Hex HexA HexNAc(2)"},
	"UniMod:1579":{"unimod": "UniMod:1579", "mass_modification":753.199743
, "name":"dHex(1)Hex(2)HexNAc(1)Sulf(1)", "descr":"dHex Hex(2) HexNAc Sulf"},
	"UniMod:1580":{"unimod": "UniMod:1580", "mass_modification":755.296027
, "name":"dHex(1)HexNAc(3)", "descr":"dHex HexNAc(3)"},
	"UniMod:1581":{"unimod": "UniMod:1581", "mass_modification":761.258973
, "name":"dHex(1)Hex(1)HexNAc(1)Kdn(1)", "descr":"dHex Hex HexNAc Kdn ---OR--- Hex(2) dHex NeuAc"},
	"UniMod:1582":{"unimod": "UniMod:1582", "mass_modification":771.290941
, "name":"Hex(1)HexNAc(3)", "descr":"Hex HexNAc(3)"},
	"UniMod:1583":{"unimod": "UniMod:1583", "mass_modification":777.210976
, "name":"HexNAc(2)NeuAc(1)Sulf(1)", "descr":"HexNAc(2) NeuAc Sulf"},
	"UniMod:1584":{"unimod": "UniMod:1584", "mass_modification":778.274288
, "name":"dHex(2)Hex(3)", "descr":"dHex(2) Hex(3)"},
	"UniMod:1585":{"unimod": "UniMod:1585", "mass_modification":783.173922
, "name":"Hex(2)HexA(1)HexNAc(1)Sulf(1)", "descr":"Hex(2) HexA HexNAc Sulf"},
	"UniMod:1586":{"unimod": "UniMod:1586", "mass_modification":792.253553
, "name":"dHex(2)Hex(2)HexA(1)", "descr":"dHex(2) Hex(2) HexA"},
	"UniMod:1587":{"unimod": "UniMod:1587", "mass_modification":794.226292
, "name":"dHex(1)Hex(1)HexNAc(2)Sulf(1)", "descr":"dHex Hex HexNAc(2) Sulf"},
	"UniMod:1588":{"unimod": "UniMod:1588", "mass_modification":802.285522
, "name":"dHex(1)Hex(1)HexNAc(1)NeuAc(1)", "descr":"dHex Hex HexNAc NeuAc"},
	"UniMod:1589":{"unimod": "UniMod:1589", "mass_modification":810.221207
, "name":"Hex(2)HexNAc(2)Sulf(1)", "descr":"Hex(2) HexNAc(2) Sulf"},
	"UniMod:1590":{"unimod": "UniMod:1590", "mass_modification":810.264117
, "name":"Hex(5)", "descr":"Hex(5)"},
	"UniMod:1591":{"unimod": "UniMod:1591", "mass_modification":812.31749
, "name":"HexNAc(4)", "descr":"HexNAc(4)"},
	"UniMod:1592":{"unimod": "UniMod:1592", "mass_modification":817.260035
, "name":"HexNAc(1)NeuGc(2)", "descr":"HexNAc NeuGc(2)"},
	"UniMod:1593":{"unimod": "UniMod:1593", "mass_modification":818.280436
, "name":"dHex(1)Hex(1)HexNAc(1)NeuGc(1)", "descr":"dHex Hex HexNAc NeuGc ---OR--- Hex(2) HexNAc NeuAc"},
	"UniMod:1594":{"unimod": "UniMod:1594", "mass_modification":819.300837
, "name":"dHex(2)Hex(2)HexNAc(1)", "descr":"dHex(2) Hex(2) HexNAc"},
	"UniMod:1595":{"unimod": "UniMod:1595", "mass_modification":834.275351
, "name":"Hex(2)HexNAc(1)NeuGc(1)", "descr":"Hex(2) HexNAc NeuGc"},
	"UniMod:1596":{"unimod": "UniMod:1596", "mass_modification":835.295752
, "name":"dHex(1)Hex(3)HexNAc(1)", "descr":"dHex Hex(3) HexNAc"},
	"UniMod:1597":{"unimod": "UniMod:1597", "mass_modification":849.275017
, "name":"dHex(1)Hex(2)HexA(1)HexNAc(1)", "descr":"dHex Hex(2) HexA HexNAc"},
	"UniMod:1598":{"unimod": "UniMod:1598", "mass_modification":851.247756
, "name":"Hex(1)HexNAc(3)Sulf(1)", "descr":"Hex HexNAc(3) Sulf"},
	"UniMod:1599":{"unimod": "UniMod:1599", "mass_modification":851.290667
, "name":"Hex(4)HexNAc(1)", "descr":"Hex(4) HexNAc"},
	"UniMod:1600":{"unimod": "UniMod:1600", "mass_modification":859.306985
, "name":"Hex(1)HexNAc(2)NeuAc(1)", "descr":"Hex HexNAc(2) NeuAc"},
	"UniMod:1602":{"unimod": "UniMod:1602", "mass_modification":875.3019
, "name":"Hex(1)HexNAc(2)NeuGc(1)", "descr":"Hex HexNAc(2) NeuGc"},
	"UniMod:1604":{"unimod": "UniMod:1604", "mass_modification":890.230448
, "name":"Hex(5)Phos(1)", "descr":"Hex(5) Phos"},
	"UniMod:1606":{"unimod": "UniMod:1606", "mass_modification":907.316881
, "name":"dHex(2)Hex(1)HexNAc(1)Kdn(1)", "descr":"dHex(2) Hex HexNAc Kdn"},
	"UniMod:1607":{"unimod": "UniMod:1607", "mass_modification":915.252567
, "name":"dHex(1)Hex(3)HexNAc(1)Sulf(1)", "descr":"dHex Hex(3) HexNAc Sulf"},
	"UniMod:1608":{"unimod": "UniMod:1608", "mass_modification":917.34885
, "name":"dHex(1)Hex(1)HexNAc(3)", "descr":"dHex Hex HexNAc(3)"},
	"UniMod:1609":{"unimod": "UniMod:1609", "mass_modification":929.231831
, "name":"dHex(1)Hex(2)HexA(1)HexNAc(1)Sulf(1)", "descr":"dHex Hex(2) HexA HexNAc Sulf"},
	"UniMod:1610":{"unimod": "UniMod:1610", "mass_modification":933.343765
, "name":"Hex(2)HexNAc(3)", "descr":"Hex(2) HexNAc(3)"},
	"UniMod:1611":{"unimod": "UniMod:1611", "mass_modification":939.2638
, "name":"Hex(1)HexNAc(2)NeuAc(1)Sulf(1)", "descr":"Hex HexNAc(2) NeuAc Sulf"},
	"UniMod:1612":{"unimod": "UniMod:1612", "mass_modification":940.327112
, "name":"dHex(2)Hex(4)", "descr":"dHex(2) Hex(4)"},
	"UniMod:1786":{"unimod": "UniMod:1786", "mass_modification":698.238177
, "name":"Hex(1)HexNAc(1)NeuAc(1)Ac(1)", "descr":"Ac Hex HexNAc NeuAc"},
	"UniMod:1614":{"unimod": "UniMod:1614", "mass_modification":948.34343
, "name":"dHex(2)HexNAc(2)Kdn(1)", "descr":"dHex(2) HexNAc(2) Kdn"},
	"UniMod:1615":{"unimod": "UniMod:1615", "mass_modification":956.279116
, "name":"dHex(1)Hex(2)HexNAc(2)Sulf(1)", "descr":"dHex Hex(2) HexNAc(2) Sulf"},
	"UniMod:1616":{"unimod": "UniMod:1616", "mass_modification":958.375399
, "name":"dHex(1)HexNAc(4)", "descr":"dHex HexNAc(4)"},
	"UniMod:1617":{"unimod": "UniMod:1617", "mass_modification":963.317944
, "name":"Hex(1)HexNAc(1)NeuAc(1)NeuGc(1)", "descr":"Hex HexNAc NeuAc NeuGc"},
	"UniMod:1618":{"unimod": "UniMod:1618", "mass_modification":964.338345
, "name":"dHex(1)Hex(1)HexNAc(2)Kdn(1)", "descr":"dHex Hex HexNAc(2) Kdn ---OR--- Hex(2) HexNAc dHex NeuAc"},
	"UniMod:1619":{"unimod": "UniMod:1619", "mass_modification":979.312859
, "name":"Hex(1)HexNAc(1)NeuGc(2)", "descr":"Hex HexNAc NeuGc(2)"},
	"UniMod:1620":{"unimod": "UniMod:1620", "mass_modification":989.333594
, "name":"Hex(1)HexNAc(1)NeuAc(2)Ac(1)", "descr":"Ac Hex HexNAc NeuAc(2)"},
	"UniMod:1621":{"unimod": "UniMod:1621", "mass_modification":995.332925
, "name":"dHex(2)Hex(2)HexA(1)HexNAc(1)", "descr":"dHex(2) Hex(2) HexA HexNAc"},
	"UniMod:1622":{"unimod": "UniMod:1622", "mass_modification":997.305665
, "name":"dHex(1)Hex(1)HexNAc(3)Sulf(1)", "descr":"dHex Hex HexNAc(3) Sulf"},
	"UniMod:1623":{"unimod": "UniMod:1623", "mass_modification":1003.232225
, "name":"Hex(2)HexA(1)NeuAc(1)Pent(1)Sulf(1)", "descr":"Hex(2) HexA NeuAc Pent Sulf"},
	"UniMod:1624":{"unimod": "UniMod:1624", "mass_modification":1005.364894
, "name":"dHex(1)Hex(1)HexNAc(2)NeuAc(1)", "descr":"dHex Hex HexNAc(2) NeuAc"},
	"UniMod:1625":{"unimod": "UniMod:1625", "mass_modification":1011.32784
, "name":"dHex(1)Hex(3)HexA(1)HexNAc(1)", "descr":"dHex Hex(3) HexA HexNAc"},
	"UniMod:1626":{"unimod": "UniMod:1626", "mass_modification":1013.300579
, "name":"Hex(2)HexNAc(3)Sulf(1)", "descr":"Hex(2) HexNAc(3) Sulf"},
	"UniMod:1627":{"unimod": "UniMod:1627", "mass_modification":1013.34349
, "name":"Hex(5)HexNAc(1)", "descr":"Hex(5) HexNAc"},
	"UniMod:1628":{"unimod": "UniMod:1628", "mass_modification":1015.396863
, "name":"HexNAc(5)", "descr":"HexNAc(5)"},
	"UniMod:1630":{"unimod": "UniMod:1630", "mass_modification":1031.344159
, "name":"Hex(1)HexNAc(1)NeuAc(2)Ac(2)", "descr":"Ac(2) Hex HexNAc NeuAc(2)"},
	"UniMod:1631":{"unimod": "UniMod:1631", "mass_modification":1037.354723
, "name":"Hex(2)HexNAc(2)NeuGc(1)", "descr":"Hex(2) HexNAc(2) NeuGc"},
	"UniMod:1632":{"unimod": "UniMod:1632", "mass_modification":1050.16311
, "name":"Hex(5)Phos(3)", "descr":"Hex(5) Phos(3)"},
	"UniMod:1633":{"unimod": "UniMod:1633", "mass_modification":1052.283272
, "name":"Hex(6)Phos(1)", "descr":"Hex(6) Phos"},
	"UniMod:1634":{"unimod": "UniMod:1634", "mass_modification":1052.354389
, "name":"dHex(1)Hex(2)HexA(1)HexNAc(2)", "descr":"dHex Hex(2) HexA HexNAc(2)"},
	"UniMod:1635":{"unimod": "UniMod:1635", "mass_modification":1061.310475
, "name":"dHex(2)Hex(3)HexNAc(1)Sulf(1)", "descr":"dHex(2) Hex(3) HexNAc Sulf"},
	"UniMod:1636":{"unimod": "UniMod:1636", "mass_modification":1062.386358
, "name":"Hex(1)HexNAc(3)NeuAc(1)", "descr":"Hex HexNAc(3) NeuAc"},
	"UniMod:1637":{"unimod": "UniMod:1637", "mass_modification":1063.406759
, "name":"dHex(2)Hex(1)HexNAc(3)", "descr":"dHex(2) Hex HexNAc(3)"},
	"UniMod:1638":{"unimod": "UniMod:1638", "mass_modification":1078.381273
, "name":"Hex(1)HexNAc(3)NeuGc(1)", "descr":"Hex HexNAc(3) NeuGc"},
	"UniMod:1639":{"unimod": "UniMod:1639", "mass_modification":1085.321709
, "name":"dHex(1)Hex(1)HexNAc(2)NeuAc(1)Sulf(1)", "descr":"dHex Hex HexNAc(2) NeuAc Sulf"},
	"UniMod:1640":{"unimod": "UniMod:1640", "mass_modification":1091.284655
, "name":"dHex(1)Hex(3)HexA(1)HexNAc(1)Sulf(1)", "descr":"dHex Hex(3) HexA HexNAc Sulf"},
	"UniMod:1641":{"unimod": "UniMod:1641", "mass_modification":1093.380938
, "name":"dHex(1)Hex(1)HexA(1)HexNAc(3)", "descr":"dHex Hex HexA HexNAc(3)"},
	"UniMod:1642":{"unimod": "UniMod:1642", "mass_modification":1101.316623
, "name":"Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "descr":"Hex(2) HexNAc(2) NeuAc Sulf"},
	"UniMod:1643":{"unimod": "UniMod:1643", "mass_modification":1102.337025
, "name":"dHex(2)Hex(2)HexNAc(2)Sulf(1)", "descr":"dHex(2) Hex(2) HexNAc(2) Sulf"},
	"UniMod:1644":{"unimod": "UniMod:1644", "mass_modification":1110.396254
, "name":"dHex(2)Hex(1)HexNAc(2)Kdn(1)", "descr":"dHex(2) Hex HexNAc(2) Kdn ---OR--- Hex(2) HexNAc dHex(2) NeuAc"},
	"UniMod:1645":{"unimod": "UniMod:1645", "mass_modification":1120.428223
, "name":"dHex(1)Hex(1)HexNAc(4)", "descr":"dHex Hex HexNAc(4)"},
	"UniMod:1646":{"unimod": "UniMod:1646", "mass_modification":1136.423137
, "name":"Hex(2)HexNAc(4)", "descr":"Hex(2) HexNAc(4)"},
	"UniMod:1647":{"unimod": "UniMod:1647", "mass_modification":1141.365682
, "name":"Hex(2)HexNAc(1)NeuGc(2)", "descr":"Hex(2) HexNAc NeuGc(2)"},
	"UniMod:1648":{"unimod": "UniMod:1648", "mass_modification":1143.406484
, "name":"dHex(2)Hex(4)HexNAc(1)", "descr":"dHex(2) Hex(4) HexNAc"},
	"UniMod:1649":{"unimod": "UniMod:1649", "mass_modification":1150.402402
, "name":"Hex(1)HexNAc(2)NeuAc(2)", "descr":"Hex HexNAc(2) NeuAc(2)"},
	"UniMod:1650":{"unimod": "UniMod:1650", "mass_modification":1151.422803
, "name":"dHex(2)Hex(1)HexNAc(2)NeuAc(1)", "descr":"dHex(2) Hex HexNAc(2) NeuAc"},
	"UniMod:1651":{"unimod": "UniMod:1651", "mass_modification":1159.358488
, "name":"dHex(1)Hex(2)HexNAc(3)Sulf(1)", "descr":"dHex Hex(2) HexNAc(3) Sulf"},
	"UniMod:1652":{"unimod": "UniMod:1652", "mass_modification":1161.454772
, "name":"dHex(1)HexNAc(5)", "descr":"dHex HexNAc(5)"},
	"UniMod:1653":{"unimod": "UniMod:1653", "mass_modification":1167.417718
, "name":"dHex(2)Hex(1)HexNAc(2)NeuGc(1)", "descr":"dHex(2) Hex HexNAc(2) NeuGc ---OR--- Hex(2) HexNAc(2) dHex NeuAc ---OR--- Hex HexNAc(3) dHex Kdn"},
	"UniMod:1654":{"unimod": "UniMod:1654", "mass_modification":1168.438119
, "name":"dHex(3)Hex(2)HexNAc(2)", "descr":"dHex(3) Hex(2) HexNAc(2)"},
	"UniMod:1655":{"unimod": "UniMod:1655", "mass_modification":1175.353403
, "name":"Hex(3)HexNAc(3)Sulf(1)", "descr":"Hex(3) HexNAc(3) Sulf"},
	"UniMod:1656":{"unimod": "UniMod:1656", "mass_modification":1182.293839
, "name":"dHex(2)Hex(2)HexNAc(2)Sulf(2)", "descr":"dHex(2) Hex(2) HexNAc(2) Sulf(2)"},
	"UniMod:1657":{"unimod": "UniMod:1657", "mass_modification":1183.412632
, "name":"dHex(1)Hex(2)HexNAc(2)NeuGc(1)", "descr":"dHex Hex(2) HexNAc(2) NeuGc ---OR--- Hex(3) HexNAc(2) NeuAc"},
	"UniMod:1658":{"unimod": "UniMod:1658", "mass_modification":1208.444267
, "name":"dHex(1)Hex(1)HexNAc(3)NeuAc(1)", "descr":"dHex Hex HexNAc(3) NeuAc"},
	"UniMod:1659":{"unimod": "UniMod:1659", "mass_modification":1212.215934
, "name":"Hex(6)Phos(3)", "descr":"Hex(6) Phos(3)"},
	"UniMod:1660":{"unimod": "UniMod:1660", "mass_modification":1214.407213
, "name":"dHex(1)Hex(3)HexA(1)HexNAc(2)", "descr":"dHex Hex(3) HexA HexNAc(2)"},
	"UniMod:1661":{"unimod": "UniMod:1661", "mass_modification":1224.439181
, "name":"dHex(1)Hex(1)HexNAc(3)NeuGc(1)", "descr":"dHex Hex HexNAc(3) NeuGc ---OR--- Hex(2) HexNAc(3) NeuAc"},
	"UniMod:1662":{"unimod": "UniMod:1662", "mass_modification":1230.359217
, "name":"Hex(1)HexNAc(2)NeuAc(2)Sulf(1)", "descr":"Hex HexNAc(2) NeuAc(2) Sulf"},
	"UniMod:1663":{"unimod": "UniMod:1663", "mass_modification":1237.342563
, "name":"dHex(2)Hex(3)HexA(1)HexNAc(1)Sulf(1)", "descr":"dHex(2) Hex(3) HexA HexNAc Sulf"},
	"UniMod:1664":{"unimod": "UniMod:1664", "mass_modification":1238.418446
, "name":"Hex(1)HexNAc(1)NeuAc(3)", "descr":"Hex HexNAc NeuAc(3)"},
	"UniMod:1665":{"unimod": "UniMod:1665", "mass_modification":1240.434096
, "name":"Hex(2)HexNAc(3)NeuGc(1)", "descr":"Hex(2) HexNAc(3) NeuGc"},
	"UniMod:1666":{"unimod": "UniMod:1666", "mass_modification":1247.374532
, "name":"dHex(1)Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "descr":"dHex Hex(2) HexNAc(2) NeuAc Sulf"},
	"UniMod:1667":{"unimod": "UniMod:1667", "mass_modification":1256.454163
, "name":"dHex(3)Hex(1)HexNAc(2)Kdn(1)", "descr":"dHex(3) Hex HexNAc(2) Kdn"},
	"UniMod:1668":{"unimod": "UniMod:1668", "mass_modification":1264.389848
, "name":"dHex(2)Hex(3)HexNAc(2)Sulf(1)", "descr":"dHex(2) Hex(3) HexNAc(2) Sulf"},
	"UniMod:1669":{"unimod": "UniMod:1669", "mass_modification":1272.449077
, "name":"dHex(2)Hex(2)HexNAc(2)Kdn(1)", "descr":"dHex(2) Hex(2) HexNAc(2) Kdn"},
	"UniMod:1670":{"unimod": "UniMod:1670", "mass_modification":1278.369113
, "name":"dHex(2)Hex(2)HexA(1)HexNAc(2)Sulf(1)", "descr":"dHex(2) Hex(2) HexA HexNAc(2) Sulf"},
	"UniMod:1671":{"unimod": "UniMod:1671", "mass_modification":1282.481046
, "name":"dHex(1)Hex(2)HexNAc(4)", "descr":"dHex Hex(2) HexNAc(4)"},
	"UniMod:1672":{"unimod": "UniMod:1672", "mass_modification":1286.40319
, "name":"Hex(1)HexNAc(1)NeuGc(3)", "descr":"Hex HexNAc NeuGc(3)"},
	"UniMod:1673":{"unimod": "UniMod:1673", "mass_modification":1288.401081
, "name":"dHex(1)Hex(1)HexNAc(3)NeuAc(1)Sulf(1)", "descr":"dHex Hex HexNAc(3) NeuAc Sulf"},
	"UniMod:1674":{"unimod": "UniMod:1674", "mass_modification":1294.364027
, "name":"dHex(1)Hex(3)HexA(1)HexNAc(2)Sulf(1)", "descr":"dHex Hex(3) HexA HexNAc(2) Sulf"},
	"UniMod:1675":{"unimod": "UniMod:1675", "mass_modification":1296.460311
, "name":"dHex(1)Hex(1)HexNAc(2)NeuAc(2)", "descr":"dHex Hex HexNAc(2) NeuAc(2)"},
	"UniMod:1676":{"unimod": "UniMod:1676", "mass_modification":1297.480712
, "name":"dHex(3)HexNAc(3)Kdn(1)", "descr":"dHex(3) HexNAc(3) Kdn"},
	"UniMod:1678":{"unimod": "UniMod:1678", "mass_modification":1304.395996
, "name":"Hex(2)HexNAc(3)NeuAc(1)Sulf(1)", "descr":"Hex(2) HexNAc(3) NeuAc Sulf"},
	"UniMod:1679":{"unimod": "UniMod:1679", "mass_modification":1305.416397
, "name":"dHex(2)Hex(2)HexNAc(3)Sulf(1)", "descr":"dHex(2) Hex(2) HexNAc(3) Sulf"},
	"UniMod:1680":{"unimod": "UniMod:1680", "mass_modification":1307.512681
, "name":"dHex(2)HexNAc(5)", "descr":"dHex(2) HexNAc(5)"},
	"UniMod:1681":{"unimod": "UniMod:1681", "mass_modification":1312.455225
, "name":"Hex(2)HexNAc(2)NeuAc(2)", "descr":"Hex(2) HexNAc(2) NeuAc(2)"},
	"UniMod:1682":{"unimod": "UniMod:1682", "mass_modification":1313.475627
, "name":"dHex(2)Hex(2)HexNAc(2)NeuAc(1)", "descr":"dHex(2) Hex(2) HexNAc(2) NeuAc ---OR--- Hex HexNAc(3) dHex(2) Kdn"},
	"UniMod:1683":{"unimod": "UniMod:1683", "mass_modification":1321.411312
, "name":"dHex(1)Hex(3)HexNAc(3)Sulf(1)", "descr":"dHex Hex(3) HexNAc(3) Sulf"},
	"UniMod:1684":{"unimod": "UniMod:1684", "mass_modification":1329.470541
, "name":"dHex(2)Hex(2)HexNAc(2)NeuGc(1)", "descr":"dHex(2) Hex(2) HexNAc(2) NeuGc ---OR--- Hex(3) HexNAc(2) dHex NeuAc ---OR--- Hex(2) HexNAc(3) dHex Kdn"},
	"UniMod:1685":{"unimod": "UniMod:1685", "mass_modification":1339.50251
, "name":"Hex(2)HexNAc(5)", "descr":"Hex(2) HexNAc(5)"},
	"UniMod:1686":{"unimod": "UniMod:1686", "mass_modification":1345.465456
, "name":"dHex(1)Hex(3)HexNAc(2)NeuGc(1)", "descr":"dHex Hex(3) HexNAc(2) NeuGc"},
	"UniMod:1687":{"unimod": "UniMod:1687", "mass_modification":1353.481775
, "name":"Hex(1)HexNAc(3)NeuAc(2)", "descr":"Hex HexNAc(3) NeuAc(2)"},
	"UniMod:1688":{"unimod": "UniMod:1688", "mass_modification":1370.49709
, "name":"dHex(1)Hex(2)HexNAc(3)NeuAc(1)", "descr":"dHex Hex(2) HexNAc(3) NeuAc"},
	"UniMod:1689":{"unimod": "UniMod:1689", "mass_modification":1371.517491
, "name":"dHex(3)Hex(2)HexNAc(3)", "descr":"dHex(3) Hex(2) HexNAc(3)"},
	"UniMod:1690":{"unimod": "UniMod:1690", "mass_modification":1374.268757
, "name":"Hex(7)Phos(3)", "descr":"Hex(7) Phos(3)"},
	"UniMod:1691":{"unimod": "UniMod:1691", "mass_modification":1376.460036
, "name":"dHex(1)Hex(4)HexA(1)HexNAc(2)", "descr":"dHex Hex(4) HexA HexNAc(2)"},
	"UniMod:1692":{"unimod": "UniMod:1692", "mass_modification":1386.492005
, "name":"Hex(3)HexNAc(3)NeuAc(1)", "descr":"Hex(3) HexNAc(3) NeuAc ---OR--- Hex(2) HexNAc(3) dHex NeuGc ---OR--- Hex(2) HexNAc(4) Kdn"},
	"UniMod:1693":{"unimod": "UniMod:1693", "mass_modification":1390.439301
, "name":"dHex(1)Hex(3)HexA(2)HexNAc(2)", "descr":"dHex Hex(3) HexA(2) HexNAc(2)"},
	"UniMod:1694":{"unimod": "UniMod:1694", "mass_modification":1392.41204
, "name":"Hex(2)HexNAc(2)NeuAc(2)Sulf(1)", "descr":"Hex(2) HexNAc(2) NeuAc(2) Sulf"},
	"UniMod:1695":{"unimod": "UniMod:1695", "mass_modification":1393.432441
, "name":"dHex(2)Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "descr":"dHex(2) Hex(2) HexNAc(2) NeuAc Sulf"},
	"UniMod:1696":{"unimod": "UniMod:1696", "mass_modification":1402.48692
, "name":"Hex(3)HexNAc(3)NeuGc(1)", "descr":"Hex(3) HexNAc(3) NeuGc"},
	"UniMod:1697":{"unimod": "UniMod:1697", "mass_modification":1402.512072
, "name":"dHex(4)Hex(1)HexNAc(2)Kdn(1)", "descr":"dHex(4) Hex HexNAc(2) Kdn"},
	"UniMod:1698":{"unimod": "UniMod:1698", "mass_modification":1418.506986
, "name":"dHex(3)Hex(2)HexNAc(2)Kdn(1)", "descr":"dHex(3) Hex(2) HexNAc(2) Kdn"},
	"UniMod:1699":{"unimod": "UniMod:1699", "mass_modification":1424.427021
, "name":"dHex(3)Hex(2)HexA(1)HexNAc(2)Sulf(1)", "descr":"dHex(3) Hex(2) HexA HexNAc(2) Sulf"},
	"UniMod:1700":{"unimod": "UniMod:1700", "mass_modification":1427.518554
, "name":"Hex(2)HexNAc(4)NeuAc(1)", "descr":"Hex(2) HexNAc(4) NeuAc"},
	"UniMod:1701":{"unimod": "UniMod:1701", "mass_modification":1428.538955
, "name":"dHex(2)Hex(2)HexNAc(4)", "descr":"dHex(2) Hex(2) HexNAc(4)"},
	"UniMod:1702":{"unimod": "UniMod:1702", "mass_modification":1440.421936
, "name":"dHex(2)Hex(3)HexA(1)HexNAc(2)Sulf(1)", "descr":"dHex(2) Hex(3) HexA HexNAc(2) Sulf"},
	"UniMod:1703":{"unimod": "UniMod:1703", "mass_modification":1443.538621
, "name":"dHex(4)HexNAc(3)Kdn(1)", "descr":"dHex(4) HexNAc(3) Kdn"},
	"UniMod:1705":{"unimod": "UniMod:1705", "mass_modification":1448.456013
, "name":"Hex(2)HexNAc(1)NeuGc(3)", "descr":"Hex(2) HexNAc NeuGc(3)"},
	"UniMod:1706":{"unimod": "UniMod:1706", "mass_modification":1449.501567
, "name":"dHex(4)Hex(1)HexNAc(1)Kdn(2)", "descr":"dHex(4) Hex HexNAc Kdn(2)"},
	"UniMod:1707":{"unimod": "UniMod:1707", "mass_modification":1450.453905
, "name":"dHex(1)Hex(2)HexNAc(3)NeuAc(1)Sulf(1)", "descr":"dHex Hex(2) HexNAc(3) NeuAc Sulf"},
	"UniMod:1708":{"unimod": "UniMod:1708", "mass_modification":1458.513134
, "name":"dHex(1)Hex(2)HexNAc(2)NeuAc(2)", "descr":"dHex Hex(2) HexNAc(2) NeuAc(2)"},
	"UniMod:1709":{"unimod": "UniMod:1709", "mass_modification":1459.533535
, "name":"dHex(3)Hex(1)HexNAc(3)Kdn(1)", "descr":"dHex(3) Hex HexNAc(3) Kdn"},
	"UniMod:1711":{"unimod": "UniMod:1711", "mass_modification":1466.44882
, "name":"Hex(3)HexNAc(3)NeuAc(1)Sulf(1)", "descr":"Hex(3) HexNAc(3) NeuAc Sulf"},
	"UniMod:1712":{"unimod": "UniMod:1712", "mass_modification":1474.508049
, "name":"Hex(3)HexNAc(2)NeuAc(2)", "descr":"Hex(3) HexNAc(2) NeuAc(2)"},
	"UniMod:1713":{"unimod": "UniMod:1713", "mass_modification":1482.443734
, "name":"Hex(3)HexNAc(3)NeuGc(1)Sulf(1)", "descr":"Hex(3) HexNAc(3) NeuGc Sulf"},
	"UniMod:1714":{"unimod": "UniMod:1714", "mass_modification":1490.502964
, "name":"dHex(1)Hex(2)HexNAc(2)NeuGc(2)", "descr":"dHex Hex(2) HexNAc(2) NeuGc(2)"},
	"UniMod:1715":{"unimod": "UniMod:1715", "mass_modification":1491.523365
, "name":"dHex(2)Hex(3)HexNAc(2)NeuGc(1)", "descr":"dHex(2) Hex(3) HexNAc(2) NeuGc ---OR--- Hex(4) HexNAc(2) dHex NeuAc"},
	"UniMod:1716":{"unimod": "UniMod:1716", "mass_modification":1497.4434
, "name":"dHex(1)Hex(3)HexA(1)HexNAc(3)Sulf(1)", "descr":"dHex Hex(3) HexA HexNAc(3) Sulf"},
	"UniMod:1717":{"unimod": "UniMod:1717", "mass_modification":1515.534598
, "name":"Hex(2)HexNAc(3)NeuAc(2)", "descr":"Hex(2) HexNAc(3) NeuAc(2)"},
	"UniMod:1718":{"unimod": "UniMod:1718", "mass_modification":1516.554999
, "name":"dHex(2)Hex(2)HexNAc(3)NeuAc(1)", "descr":"dHex(2) Hex(2) HexNAc(3) NeuAc"},
	"UniMod:1719":{"unimod": "UniMod:1719", "mass_modification":1517.5754
, "name":"dHex(4)Hex(2)HexNAc(3)", "descr":"dHex(4) Hex(2) HexNAc(3)"},
	"UniMod:1720":{"unimod": "UniMod:1720", "mass_modification":1531.529513
, "name":"Hex(2)HexNAc(3)NeuAc(1)NeuGc(1)", "descr":"Hex(2) HexNAc(3) NeuAc NeuGc"},
	"UniMod:1721":{"unimod": "UniMod:1721", "mass_modification":1532.549914
, "name":"dHex(2)Hex(2)HexNAc(3)NeuGc(1)", "descr":"dHex(2) Hex(2) HexNAc(3) NeuGc ---OR--- Hex(3) HexNAc(3) dHex NeuAc ---OR--- Hex(2) HexNAc(4) dHex Kdn"},
	"UniMod:1722":{"unimod": "UniMod:1722", "mass_modification":1533.570315
, "name":"dHex(3)Hex(3)HexNAc(3)", "descr":"dHex(3) Hex(3) HexNAc(3)"},
	"UniMod:1723":{"unimod": "UniMod:1723", "mass_modification":1536.321581
, "name":"Hex(8)Phos(3)", "descr":"Hex(8) Phos(3)"},
	"UniMod:1724":{"unimod": "UniMod:1724", "mass_modification":1538.469949
, "name":"dHex(1)Hex(2)HexNAc(2)NeuAc(2)Sulf(1)", "descr":"dHex Hex(2) HexNAc(2) NeuAc(2) Sulf"},
	"UniMod:1725":{"unimod": "UniMod:1725", "mass_modification":1547.524427
, "name":"Hex(2)HexNAc(3)NeuGc(2)", "descr":"Hex(2) HexNAc(3) NeuGc(2)"},
	"UniMod:1726":{"unimod": "UniMod:1726", "mass_modification":1564.564895
, "name":"dHex(4)Hex(2)HexNAc(2)Kdn(1)", "descr":"dHex(4) Hex(2) HexNAc(2) Kdn"},
	"UniMod:1727":{"unimod": "UniMod:1727", "mass_modification":1573.576463
, "name":"dHex(1)Hex(2)HexNAc(4)NeuAc(1)", "descr":"dHex Hex(2) HexNAc(4) NeuAc"},
	"UniMod:1728":{"unimod": "UniMod:1728", "mass_modification":1574.596864
, "name":"dHex(3)Hex(2)HexNAc(4)", "descr":"dHex(3) Hex(2) HexNAc(4)"},
	"UniMod:1729":{"unimod": "UniMod:1729", "mass_modification":1593.493521
, "name":"Hex(1)HexNAc(1)NeuGc(4)", "descr":"Hex HexNAc NeuGc(4)"},
	"UniMod:1730":{"unimod": "UniMod:1730", "mass_modification":1605.591444
, "name":"dHex(4)Hex(1)HexNAc(3)Kdn(1)", "descr":"dHex(4) Hex HexNAc(3) Kdn"},
	"UniMod:1732":{"unimod": "UniMod:1732", "mass_modification":1620.442414
, "name":"Hex(4)HexNAc(4)Sulf(2)", "descr":"Hex(4) HexNAc(4) Sulf(2)"},
	"UniMod:1733":{"unimod": "UniMod:1733", "mass_modification":1621.586359
, "name":"dHex(3)Hex(2)HexNAc(3)Kdn(1)", "descr":"dHex(3) Hex(2) HexNAc(3) Kdn ---OR--- Hex(3) HexNAc(2) dHex(3) NeuAc"},
	"UniMod:1735":{"unimod": "UniMod:1735", "mass_modification":1631.618328
, "name":"dHex(2)Hex(2)HexNAc(5)", "descr":"dHex(2) Hex(2) HexNAc(5)"},
	"UniMod:1736":{"unimod": "UniMod:1736", "mass_modification":1643.501309
, "name":"dHex(2)Hex(3)HexA(1)HexNAc(3)Sulf(1)", "descr":"dHex(2) Hex(3) HexA HexNAc(3) Sulf"},
	"UniMod:1737":{"unimod": "UniMod:1737", "mass_modification":1659.496223
, "name":"dHex(1)Hex(4)HexA(1)HexNAc(3)Sulf(1)", "descr":"dHex Hex(4) HexA HexNAc(3) Sulf"},
	"UniMod:1738":{"unimod": "UniMod:1738", "mass_modification":1677.587422
, "name":"Hex(3)HexNAc(3)NeuAc(2)", "descr":"Hex(3) HexNAc(3) NeuAc(2)"},
	"UniMod:1739":{"unimod": "UniMod:1739", "mass_modification":1678.607823
, "name":"dHex(2)Hex(3)HexNAc(3)NeuAc(1)", "descr":"dHex(2) Hex(3) HexNAc(3) NeuAc ---OR--- Hex(2) HexNAc(4) dHex(2) Kdn"},
	"UniMod:1740":{"unimod": "UniMod:1740", "mass_modification":1679.628224
, "name":"dHex(4)Hex(3)HexNAc(3)", "descr":"dHex(4) Hex(3) HexNAc(3)"},
	"UniMod:1742":{"unimod": "UniMod:1742", "mass_modification":1698.374404
, "name":"Hex(9)Phos(3)", "descr":"Hex(9) Phos(3)"},
	"UniMod:1743":{"unimod": "UniMod:1743", "mass_modification":1713.671426
, "name":"dHex(2)HexNAc(7)", "descr":"dHex(2) HexNAc(7)"},
	"UniMod:1744":{"unimod": "UniMod:1744", "mass_modification":1755.546345
, "name":"Hex(2)HexNAc(1)NeuGc(4)", "descr":"Hex(2) HexNAc NeuGc(4)"},
	"UniMod:1745":{"unimod": "UniMod:1745", "mass_modification":1757.544236
, "name":"Hex(3)HexNAc(3)NeuAc(2)Sulf(1)", "descr":"Hex(3) HexNAc(3) NeuAc(2) Sulf"},
	"UniMod:1746":{"unimod": "UniMod:1746", "mass_modification":1793.671151
, "name":"dHex(2)Hex(3)HexNAc(5)", "descr":"dHex(2) Hex(3) HexNAc(5)"},
	"UniMod:1747":{"unimod": "UniMod:1747", "mass_modification":1797.593295
, "name":"dHex(1)Hex(2)HexNAc(2)NeuGc(3)", "descr":"dHex Hex(2) HexNAc(2) NeuGc(3)"},
	"UniMod:1748":{"unimod": "UniMod:1748", "mass_modification":1805.554132
, "name":"dHex(2)Hex(4)HexA(1)HexNAc(3)Sulf(1)", "descr":"dHex(2) Hex(4) HexA HexNAc(3) Sulf"},
	"UniMod:1749":{"unimod": "UniMod:1749", "mass_modification":1806.630015
, "name":"Hex(2)HexNAc(3)NeuAc(3)", "descr":"Hex(2) HexNAc(3) NeuAc(3)"},
	"UniMod:1750":{"unimod": "UniMod:1750", "mass_modification":1823.64533
, "name":"dHex(1)Hex(3)HexNAc(3)NeuAc(2)", "descr":"dHex Hex(3) HexNAc(3) NeuAc(2)"},
	"UniMod:1751":{"unimod": "UniMod:1751", "mass_modification":1824.665732
, "name":"dHex(3)Hex(3)HexNAc(3)NeuAc(1)", "descr":"dHex(3) Hex(3) HexNAc(3) NeuAc"},
	"UniMod:1752":{"unimod": "UniMod:1752", "mass_modification":1854.614759
, "name":"Hex(2)HexNAc(3)NeuGc(3)", "descr":"Hex(2) HexNAc(3) NeuGc(3)"},
	"UniMod:1753":{"unimod": "UniMod:1753", "mass_modification":1860.427228
, "name":"Hex(10)Phos(3)", "descr":"Hex(10) Phos(3)"},
	"UniMod:1754":{"unimod": "UniMod:1754", "mass_modification":1864.67188
, "name":"dHex(1)Hex(2)HexNAc(4)NeuAc(2)", "descr":"dHex Hex(2) HexNAc(4) NeuAc(2)"},
	"UniMod:1755":{"unimod": "UniMod:1755", "mass_modification":1900.583852
, "name":"Hex(1)HexNAc(1)NeuGc(5)", "descr":"Hex HexNAc NeuGc(5)"},
	"UniMod:1756":{"unimod": "UniMod:1756", "mass_modification":1911.53783
, "name":"Hex(4)HexNAc(4)NeuAc(1)Sulf(2)", "descr":"Hex(4) HexNAc(4) NeuAc Sulf(2)"},
	"UniMod:1757":{"unimod": "UniMod:1757", "mass_modification":1927.532745
, "name":"Hex(4)HexNAc(4)NeuGc(1)Sulf(2)", "descr":"Hex(4) HexNAc(4) NeuGc Sulf(2)"},
	"UniMod:1758":{"unimod": "UniMod:1758", "mass_modification":1969.703239
, "name":"dHex(2)Hex(3)HexNAc(3)NeuAc(2)", "descr":"dHex(2) Hex(3) HexNAc(3) NeuAc(2)"},
	"UniMod:1759":{"unimod": "UniMod:1759", "mass_modification":1991.494645
, "name":"Hex(4)HexNAc(4)NeuAc(1)Sulf(3)", "descr":"Hex(4) HexNAc(4) NeuAc Sulf(3)"},
	"UniMod:1760":{"unimod": "UniMod:1760", "mass_modification":1022.38021
, "name":"dHex(2)Hex(2)HexNAc(2)", "descr":"dHex(2) Hex(2) HexNAc(2)"},
	"UniMod:1761":{"unimod": "UniMod:1761", "mass_modification":1038.375125
, "name":"dHex(1)Hex(3)HexNAc(2)", "descr":"dHex Hex(3) HexNAc(2)"},
	"UniMod:1762":{"unimod": "UniMod:1762", "mass_modification":1079.401674
, "name":"dHex(1)Hex(2)HexNAc(3)", "descr":"dHex Hex(2) HexNAc(3)"},
	"UniMod:1763":{"unimod": "UniMod:1763", "mass_modification":1095.396588
, "name":"Hex(3)HexNAc(3)", "descr":"Hex(3) HexNAc(3)"},
	"UniMod:1764":{"unimod": "UniMod:1764", "mass_modification":1118.331939
, "name":"dHex(1)Hex(3)HexNAc(2)Sulf(1)", "descr":"dHex Hex(3) HexNAc(2) Sulf"},
	"UniMod:1765":{"unimod": "UniMod:1765", "mass_modification":1184.433033
, "name":"dHex(2)Hex(3)HexNAc(2)", "descr":"dHex(2) Hex(3) HexNAc(2)"},
	"UniMod:1766":{"unimod": "UniMod:1766", "mass_modification":1200.427948
, "name":"dHex(1)Hex(4)HexNAc(2)", "descr":"dHex Hex(4) HexNAc(2)"},
	"UniMod:1767":{"unimod": "UniMod:1767", "mass_modification":1225.459583
, "name":"dHex(2)Hex(2)HexNAc(3)", "descr":"dHex(2) Hex(2) HexNAc(3)"},
	"UniMod:1768":{"unimod": "UniMod:1768", "mass_modification":1241.454497
, "name":"dHex(1)Hex(3)HexNAc(3)", "descr":"dHex Hex(3) HexNAc(3)"},
	"UniMod:1769":{"unimod": "UniMod:1769", "mass_modification":1257.449412
, "name":"Hex(4)HexNAc(3)", "descr":"Hex(4) HexNAc(3)"},
	"UniMod:1770":{"unimod": "UniMod:1770", "mass_modification":1346.485857
, "name":"dHex(2)Hex(4)HexNAc(2)", "descr":"dHex(2) Hex(4) HexNAc(2)"},
	"UniMod:1771":{"unimod": "UniMod:1771", "mass_modification":1387.512406
, "name":"dHex(2)Hex(3)HexNAc(3)", "descr":"dHex(2) Hex(3) HexNAc(3)"},
	"UniMod:1772":{"unimod": "UniMod:1772", "mass_modification":1501.555334
, "name":"Hex(3)HexNAc(5)", "descr":"A3"},
	"UniMod:1773":{"unimod": "UniMod:1773", "mass_modification":1548.544828
, "name":"Hex(4)HexNAc(3)NeuAc(1)", "descr":"Hex(4) HexNAc(3) NeuAc ---OR--- Hex(3) HexNAc(4) Kdn"},
	"UniMod:1774":{"unimod": "UniMod:1774", "mass_modification":1590.591779
, "name":"dHex(2)Hex(3)HexNAc(4)", "descr":"dHex(2) Hex(3) HexNAc(4)"},
	"UniMod:1775":{"unimod": "UniMod:1775", "mass_modification":1647.613242
, "name":"dHex(1)Hex(3)HexNAc(5)", "descr":"dHex Hex(3) HexNAc(5)"},
	"UniMod:1776":{"unimod": "UniMod:1776", "mass_modification":1704.634706
, "name":"Hex(3)HexNAc(6)", "descr":"A4"},
	"UniMod:1777":{"unimod": "UniMod:1777", "mass_modification":1751.624201
, "name":"Hex(4)HexNAc(4)NeuAc(1)", "descr":"Hex(4) HexNAc(4) NeuAc"},
	"UniMod:1778":{"unimod": "UniMod:1778", "mass_modification":1752.644602
, "name":"dHex(2)Hex(4)HexNAc(4)", "descr":"dHex(2) Hex(4) HexNAc(4) ---OR--- Hex(4) HexNAc(4) dHex Pent Me"},
	"UniMod:1779":{"unimod": "UniMod:1779", "mass_modification":1784.634431
, "name":"Hex(6)HexNAc(4)", "descr":"Hex(6) HexNAc(4)"},
	"UniMod:1780":{"unimod": "UniMod:1780", "mass_modification":1825.660981
, "name":"Hex(5)HexNAc(5)", "descr":"Hex(5) HexNAc(5)"},
	"UniMod:1781":{"unimod": "UniMod:1781", "mass_modification":1850.692615
, "name":"dHex(1)Hex(3)HexNAc(6)", "descr":"dHex Hex(3) HexNAc(6)"},
	"UniMod:1782":{"unimod": "UniMod:1782", "mass_modification":1897.68211
, "name":"dHex(1)Hex(4)HexNAc(4)NeuAc(1)", "descr":"dHex Hex(4) HexNAc(4) NeuAc ---OR--- Hex(3) HexNAc(5) dHex Kdn"},
	"UniMod:1783":{"unimod": "UniMod:1783", "mass_modification":1898.702511
, "name":"dHex(3)Hex(4)HexNAc(4)", "descr":"dHex(3) Hex(4) HexNAc(4)"},
	"UniMod:1784":{"unimod": "UniMod:1784", "mass_modification":1938.708659
, "name":"dHex(1)Hex(3)HexNAc(5)NeuAc(1)", "descr":"dHex Hex(3) HexNAc(5) NeuAc"},
	"UniMod:1785":{"unimod": "UniMod:1785", "mass_modification":1955.723975
, "name":"dHex(2)Hex(4)HexNAc(5)", "descr":"dHex(2) Hex(4) HexNAc(5)"},
	"UniMod:1799":{"unimod": "UniMod:1799", "mass_modification":469.228496
, "name":"NQIGG", "descr":"SUMOylation by Giardia lamblia"},
	"UniMod:1800":{"unimod": "UniMod:1800", "mass_modification":122.036779
, "name":"Carboxyethylpyrrole", "descr":"Carboxyethylpyrrole"},
	"UniMod:1801":{"unimod": "UniMod:1801", "mass_modification":493.116152
, "name":"Fluorescein-tyramine", "descr":"Fluorescein-tyramine adduct by peroxidase activity"},
	"UniMod:1840":{"unimod": "UniMod:1840", "mass_modification":2092.745164
, "name":"dHex(1)Hex(7)HexNAc(4)", "descr":"Fucosylated biantennary + 2 alphaGal"},
	"UniMod:1839":{"unimod": "UniMod:1839", "mass_modification":454.210387
, "name":"betaFNA", "descr":"beta-Funaltrexamine"},
	"UniMod:1838":{"unimod": "UniMod:1838", "mass_modification":224.250401
, "name":"Brij58", "descr":"Brij 58 synthetic polymer terminus"},
	"UniMod:1837":{"unimod": "UniMod:1837", "mass_modification":168.187801
, "name":"Brij35", "descr":"Brij 35 synthetic polymer terminus"},
	"UniMod:1836":{"unimod": "UniMod:1836", "mass_modification":188.156501
, "name":"Triton", "descr":"Triton synthetic polymer terminus"},
	"UniMod:1835":{"unimod": "UniMod:1835", "mass_modification":263.237491
, "name":"Tween80", "descr":"Tween 80 synthetic polymer terminus"},
	"UniMod:1834":{"unimod": "UniMod:1834", "mass_modification":165.164326
, "name":"Tween20", "descr":"Tween 20 synthetic polymer terminus"},
	"UniMod:1831":{"unimod": "UniMod:1831", "mass_modification":104.071154
, "name":"Tris", "descr":"tris adduct causes 104 Da addition at asparagine-succinimide intermediate"},
	"UniMod:1830":{"unimod": "UniMod:1830", "mass_modification":361.146012
, "name":"Biotin-tyramide", "descr":"Biotin-Phenol"},
	"UniMod:1829":{"unimod": "UniMod:1829", "mass_modification":411.259403
, "name":"LRGG+dimethyl", "descr":"LeudimethylArgGlyGly"},
	"UniMod:1825":{"unimod": "UniMod:1825", "mass_modification":324.035867
, "name":"RNPXL", "descr":"Simulate peptide-RNA conjugates"},
	"UniMod:1824":{"unimod": "UniMod:1824", "mass_modification":86.036779
, "name":"GEE", "descr":"transamidation of glycine ethyl ester to glutamine"},
	"UniMod:1826":{"unimod": "UniMod:1826", "mass_modification":-3.994915
, "name":"Glu->pyro-Glu+Methyl", "descr":"Pyro-Glu from E + Methylation"},
	"UniMod:1827":{"unimod": "UniMod:1827", "mass_modification":-0.979006
, "name":"Glu->pyro-Glu+Methyl:2H(2)13C(1)", "descr":"Pyro-Glu from E + Methylation Medium"},
	"UniMod:1828":{"unimod": "UniMod:1828", "mass_modification":397.243753
, "name":"LRGG+methyl", "descr":"LeumethylArgGlyGly"},
	"UniMod:1833":{"unimod": "UniMod:1833", "mass_modification":220.182715
, "name":"NP40", "descr":"NP-40 synthetic polymer terminus"},
	"UniMod:1832":{"unimod": "UniMod:1832", "mass_modification":452.034807
, "name":"IASD", "descr":"Iodoacetamide derivative of stilbene (reaction product with thiol)"},
	"UniMod:1841":{"unimod": "UniMod:1841", "mass_modification":389.090154
, "name":"Biotin:Thermo-21328", "descr":"EZ-Link Sulfo-NHS-SS-Biotin"},
	"UniMod:1843":{"unimod": "UniMod:1843", "mass_modification":305.041287
, "name":"PhosphoCytidine", "descr":"Cytidine monophosphate"},
	"UniMod:1845":{"unimod": "UniMod:1845", "mass_modification":41.001397
, "name":"AzidoF", "descr":"Azidophenylalanine"},
	"UniMod:1846":{"unimod": "UniMod:1846", "mass_modification":71.073499
, "name":"Dimethylaminoethyl", "descr":"Cys alkylation by dimethylaminoethyl halide"},
	"UniMod:1848":{"unimod": "UniMod:1848", "mass_modification":114.031694
, "name":"Gluratylation", "descr":"Glutarylation"},
	"UniMod:1849":{"unimod": "UniMod:1849", "mass_modification":86.036779
, "name":"hydroxyisobutyryl", "descr":"2-hydroxyisobutyrylation"},
	"UniMod:1868":{"unimod": "UniMod:1868", "mass_modification":107.979873
, "name":"MeMePhosphorothioate", "descr":"S-Methyl Methyl phosphorothioate"},
	"UniMod:1870":{"unimod": "UniMod:1870", "mass_modification":52.911464
, "name":"Cation:Fe[III]", "descr":"Replacement of 3 protons by iron"},
	"UniMod:1871":{"unimod": "UniMod:1871", "mass_modification":151.996571
, "name":"DTT", "descr":"DTT adduct of cysteine"},
	"UniMod:1872":{"unimod": "UniMod:1872", "mass_modification":161.09664
, "name":"DYn-2", "descr":"Sulfenic Acid specific probe"},
	"UniMod:1878":{"unimod": "UniMod:1878", "mass_modification":176.01433
, "name":"Xlink:DSSO[176]", "descr":"Water-quenched monolink of DSSO crosslinker"},
	"UniMod:1873":{"unimod": "UniMod:1873", "mass_modification":98.073165
, "name":"MesitylOxide", "descr":"Acetone chemical artifact"},
	"UniMod:1877":{"unimod": "UniMod:1877", "mass_modification":259.141973
, "name":"Xlink:DSS[259]", "descr":"Tris-quenched monolink of DSS/BS3 crosslinker"},
	"UniMod:1875":{"unimod": "UniMod:1875", "mass_modification":30.010565
, "name":"methylol", "descr":"formaldehyde induced modifications"},
	"UniMod:1879":{"unimod": "UniMod:1879", "mass_modification":175.030314
, "name":"Xlink:DSSO[175]", "descr":"Ammonia-quenched monolink of DSSO crosslinker"},
	"UniMod:1880":{"unimod": "UniMod:1880", "mass_modification":279.077658
, "name":"Xlink:DSSO[279]", "descr":"Tris-quenched monolink of DSSO crosslinker"},
	"UniMod:1881":{"unimod": "UniMod:1881", "mass_modification":54.010565
, "name":"Xlink:DSSO[54]", "descr":"Alkene fragment of DSSO crosslinker"},
	"UniMod:1882":{"unimod": "UniMod:1882", "mass_modification":85.982635
, "name":"Xlink:DSSO[86]", "descr":"Thiol fragment of DSSO crosslinker"},
	"UniMod:1883":{"unimod": "UniMod:1883", "mass_modification":103.9932
, "name":"Xlink:DSSO[104]", "descr":"Sulfenic acid fragment of DSSO crosslinker"},
	"UniMod:1885":{"unimod": "UniMod:1885", "mass_modification":111.032028
, "name":"Xlink:BuUrBu[111]", "descr":"BuUr fragment of BuUrBu crosslinker"},
	"UniMod:1886":{"unimod": "UniMod:1886", "mass_modification":85.052764
, "name":"Xlink:BuUrBu[85]", "descr":"Bu fragment of BuUrBu crosslinker"},
	"UniMod:1888":{"unimod": "UniMod:1888", "mass_modification":214.095357
, "name":"Xlink:BuUrBu[214]", "descr":"Water quenched monolink of BuUrBu crosslinker"},
	"UniMod:1889":{"unimod": "UniMod:1889", "mass_modification":317.158686
, "name":"Xlink:BuUrBu[317]", "descr":"Tris quenched monolink of BuUrBu crosslinker"},
	"UniMod:1896":{"unimod": "UniMod:1896", "mass_modification":158.003765
, "name":"Xlink:DSSO[158]", "descr":"Intact DSSO crosslinker"},
	"UniMod:1898":{"unimod": "UniMod:1898", "mass_modification":138.06808
, "name":"Xlink:DSS[138]", "descr":"Intact DSS/BS3 crosslinker"},
	"UniMod:1899":{"unimod": "UniMod:1899", "mass_modification":196.084792
, "name":"Xlink:BuUrBu[196]", "descr":"Intact BuUrBu crosslinker"},
	"UniMod:1900":{"unimod": "UniMod:1900", "mass_modification":172.01289
, "name":"Xlink:DTBP[172]", "descr":"Intact DTBP crosslinker"},
	"UniMod:1901":{"unimod": "UniMod:1901", "mass_modification":113.995309
, "name":"Xlink:DST[114]", "descr":"Intact DST crosslinker"},
	"UniMod:1902":{"unimod": "UniMod:1902", "mass_modification":173.980921
, "name":"Xlink:DTSSP[174]", "descr":"Intact DSP/DTSSP crosslinker"},
	"UniMod:1903":{"unimod": "UniMod:1903", "mass_modification":219.089543
, "name":"Xlink:SMCC[219]", "descr":"Intact SMCC cross-link"},
	"UniMod:1910":{"unimod": "UniMod:1910", "mass_modification":23.958063
, "name":"Cation:Al[III]", "descr":"Replacement of 3 protons by aluminium"},
	"UniMod:1906":{"unimod": "UniMod:1906", "mass_modification":113.047679
, "name":"Xlink:BS2G[113]", "descr":"Ammonium-quenched monolink of BS2-G crosslinker"},
	"UniMod:1907":{"unimod": "UniMod:1907", "mass_modification":114.031694
, "name":"Xlink:BS2G[114]", "descr":"Water-quenched monolink of BS2-G crosslinker"},
	"UniMod:1908":{"unimod": "UniMod:1908", "mass_modification":217.095023
, "name":"Xlink:BS2G[217]", "descr":"Tris-quenched monolink of BS2-G crosslinker"},
	"UniMod:1911":{"unimod": "UniMod:1911", "mass_modification":139.110947
, "name":"Xlink:DMP[139]", "descr":"Ammonia quenched monolink of DMP crosslinker"},
	"UniMod:1912":{"unimod": "UniMod:1912", "mass_modification":122.084398
, "name":"Xlink:DMP[122]", "descr":"Intact DMP crosslinker"},
	"UniMod:1913":{"unimod": "UniMod:1913", "mass_modification":21.98435
, "name":"glyoxalAGE", "descr":"glyoxal-derived AGE"},
	"UniMod:1914":{"unimod": "UniMod:1914", "mass_modification":-32.008456
, "name":"Met->AspSA", "descr":"Methionine oxidation to aspartic semialdehyde"},
	"UniMod:1915":{"unimod": "UniMod:1915", "mass_modification":-30.010565
, "name":"Decarboxylation", "descr":"Decarboxylation"},
	"UniMod:1916":{"unimod": "UniMod:1916", "mass_modification":-10.031969
, "name":"Aspartylurea", "descr":"Aspartylurea"},
	"UniMod:1917":{"unimod": "UniMod:1917", "mass_modification":4.97893
, "name":"Formylasparagine", "descr":"In Bachi as Formylaspargine (typo?)"},
	"UniMod:1918":{"unimod": "UniMod:1918", "mass_modification":13.979265
, "name":"Carbonyl", "descr":"aldehyde and ketone modifications"},
	"UniMod:1922":{"unimod": "UniMod:1922", "mass_modification":18.010565
, "name":"Pro->HAVA", "descr":"Proline oxidation to 5-hydroxy-2-aminovaleric acid"},
	"UniMod:1920":{"unimod": "UniMod:1920", "mass_modification":310.047738
, "name":"AFB1_Dialdehyde", "descr":"adduction of aflatoxin B1 Dialdehyde to lysine"},
	"UniMod:1923":{"unimod": "UniMod:1923", "mass_modification":27.958529
, "name":"Delta:H(-4)O(2)", "descr":"Tryptophan oxidation to beta-unsaturated-2,4-bis-tryptophandione"},
	"UniMod:1924":{"unimod": "UniMod:1924", "mass_modification":43.953444
, "name":"Delta:H(-4)O(3)", "descr":"Tryptophan oxidation to hydroxy-bis-tryptophandione"},
	"UniMod:1925":{"unimod": "UniMod:1925", "mass_modification":63.979659
, "name":"Delta:O(4)", "descr":"Tryptophan oxidation to dihydroxy-N-formaylkynurenine"},
	"UniMod:1926":{"unimod": "UniMod:1926", "mass_modification":72.021129
, "name":"Delta:H(4)C(3)O(2)", "descr":"methylglyoxal-derived carboxyethyllysine"},
	"UniMod:1927":{"unimod": "UniMod:1927", "mass_modification":80.026215
, "name":"Delta:H(4)C(5)O(1)", "descr":"methylglyoxal-derived argpyrimidine"},
	"UniMod:1928":{"unimod": "UniMod:1928", "mass_modification":122.073165
, "name":"Delta:H(10)C(8)O(1)", "descr":"crotonaldehyde-derived dimethyl-FDP-lysine"},
	"UniMod:1929":{"unimod": "UniMod:1929", "mass_modification":154.026609
, "name":"Delta:H(6)C(7)O(4)", "descr":"methylglyoxal-derived tetrahydropyrimidine"},
	"UniMod:1932":{"unimod": "UniMod:1932", "mass_modification":404.062462
, "name":"Hex(2)Sulf(1)", "descr":"Hex(2) O(3) S"},
	"UniMod:1930":{"unimod": "UniMod:1930", "mass_modification":264.084518
, "name":"Pent(2)", "descr":"Pent(2)"},
	"UniMod:1931":{"unimod": "UniMod:1931", "mass_modification":335.121631
, "name":"Pent(1)HexNAc(1)", "descr":"Pent HexNAc"},
	"UniMod:1933":{"unimod": "UniMod:1933", "mass_modification":440.152991
, "name":"Hex(1)Pent(2)Me(1)", "descr":"Hex:1 Pent:2 Me:1"},
	"UniMod:1934":{"unimod": "UniMod:1934", "mass_modification":486.11556
, "name":"HexNAc(2)Sulf(1)", "descr":"HexNAc(2) Sulf"},
	"UniMod:1935":{"unimod": "UniMod:1935", "mass_modification":572.19525
, "name":"Hex(1)Pent(3)Me(1)", "descr":"Hex Pent(3) Me"},
	"UniMod:1936":{"unimod": "UniMod:1936", "mass_modification":588.190165
, "name":"Hex(2)Pent(2)", "descr":"Hex(2) Pent(2)"},
	"UniMod:1937":{"unimod": "UniMod:1937", "mass_modification":602.205815
, "name":"Hex(2)Pent(2)Me(1)", "descr":"Hex(2) Pent(2) Me"},
	"UniMod:1938":{"unimod": "UniMod:1938", "mass_modification":824.243382
, "name":"Hex(4)HexA(1)", "descr":"Hex(4) HexA"},
	"UniMod:1939":{"unimod": "UniMod:1939", "mass_modification":835.259366
, "name":"Hex(2)HexNAc(1)Pent(1)HexA(1)", "descr":"Hex(2) HexNAc Pent HexA"},
	"UniMod:1940":{"unimod": "UniMod:1940", "mass_modification":865.269931
, "name":"Hex(3)HexNAc(1)HexA(1)", "descr":"Hex(3) HexNAc HexA"},
	"UniMod:1941":{"unimod": "UniMod:1941", "mass_modification":940.284201
, "name":"Hex(1)HexNAc(2)dHex(2)Sulf(1)", "descr":"Hex HexNAc(2) dHex(2) Sulf"},
	"UniMod:1942":{"unimod": "UniMod:1942", "mass_modification":961.302294
, "name":"HexA(2)HexNAc(3)", "descr":"HexA(2) HexNAc(3)"},
	"UniMod:1943":{"unimod": "UniMod:1943", "mass_modification":970.301291
, "name":"dHex(1)Hex(4)HexA(1)", "descr":"dHex Hex(4) HexA"},
	"UniMod:1944":{"unimod": "UniMod:1944", "mass_modification":986.296206
, "name":"Hex(5)HexA(1)", "descr":"Hex(5) HexA"},
	"UniMod:1945":{"unimod": "UniMod:1945", "mass_modification":1027.322755
, "name":"Hex(4)HexA(1)HexNAc(1)", "descr":"Hex(4) HexA HexNAc"},
	"UniMod:1946":{"unimod": "UniMod:1946", "mass_modification":1127.41157
, "name":"dHex(3)Hex(3)HexNAc(1)", "descr":"dHex(3) Hex(3) HexNAc"},
	"UniMod:1947":{"unimod": "UniMod:1947", "mass_modification":1175.396314
, "name":"Hex(6)HexNAc(1)", "descr":"Hex(6) HexNAc"},
	"UniMod:1948":{"unimod": "UniMod:1948", "mass_modification":1200.385037
, "name":"Hex(1)HexNAc(4)dHex(1)Sulf(1)", "descr":"Sulf dHex Hex HexNAc(4)"},
	"UniMod:1949":{"unimod": "UniMod:1949", "mass_modification":1255.433762
, "name":"dHex(1)Hex(2)HexNAc(1)NeuAc(2)", "descr":"dHex Hex(2) HexNAc NeuAc(2)"},
	"UniMod:1950":{"unimod": "UniMod:1950", "mass_modification":1330.490942
, "name":"dHex(3)Hex(3)HexNAc(2)", "descr":"dHex(3) Hex(3) HexNAc(2)"},
	"UniMod:1951":{"unimod": "UniMod:1951", "mass_modification":1346.442946
, "name":"dHex(2)Hex(1)HexNAc(4)Sulf(1)", "descr":"dHex(2) Hex HexNAc(4) Sulf"},
	"UniMod:1952":{"unimod": "UniMod:1952", "mass_modification":1442.394675
, "name":"dHex(1)Hex(2)HexNAc(4)Sulf(2)", "descr":"dHex Hex(2) HexNAc(4) Sulf(2)"},
	"UniMod:1953":{"unimod": "UniMod:1953", "mass_modification":1458.475412
, "name":"Hex(9)", "descr":"Hex(9)"},
	"UniMod:1954":{"unimod": "UniMod:1954", "mass_modification":1467.469221
, "name":"dHex(2)Hex(3)HexNAc(3)Sulf(1)", "descr":"Sulf dHex(2) Hex(3) HexNAc(3)"},
	"UniMod:1955":{"unimod": "UniMod:1955", "mass_modification":1522.554331
, "name":"dHex(2)Hex(5)HexNAc(2)Me(1)", "descr":"Me dHex(2) Hex(5) HexNAc(2)"},
	"UniMod:1956":{"unimod": "UniMod:1956", "mass_modification":1588.452584
, "name":"dHex(2)Hex(2)HexNAc(4)Sulf(2)", "descr":"Sulf(2) dHex(2) Hex(2) HexNAc(4)"},
	"UniMod:1957":{"unimod": "UniMod:1957", "mass_modification":1661.554784
, "name":"Hex(9)HexNAc(1)", "descr":"Hex(9) HexNAc"},
	"UniMod:1958":{"unimod": "UniMod:1958", "mass_modification":1734.510493
, "name":"dHex(3)Hex(2)HexNAc(4)Sulf(2)", "descr":"dHex(3) Hex(2) HexNAc(4) Sulf(2)"},
	"UniMod:1959":{"unimod": "UniMod:1959", "mass_modification":1767.619116
, "name":"Hex(4)HexNAc(4)NeuGc(1)", "descr":"Hex(4) HexNAc(4) NeuGc"},
	"UniMod:1960":{"unimod": "UniMod:1960", "mass_modification":1767.644268
, "name":"dHex(4)Hex(3)HexNAc(2)NeuAc(1)", "descr":"dHex(4) Hex(3) HexNAc(2) NeuAc(1)"},
	"UniMod:1961":{"unimod": "UniMod:1961", "mass_modification":1792.65075
, "name":"Hex(3)HexNAc(5)NeuAc(1)", "descr":"Hex(3) HexNAc(5) NeuAc(1)"},
	"UniMod:1962":{"unimod": "UniMod:1962", "mass_modification":1823.607608
, "name":"Hex(10)HexNAc(1)", "descr":"Hex(10) HexNAc(1)"},
	"UniMod:1963":{"unimod": "UniMod:1963", "mass_modification":1848.639242
, "name":"dHex(1)Hex(8)HexNAc(2)", "descr":"dHex Hex(8) HexNAc(2)"},
	"UniMod:1964":{"unimod": "UniMod:1964", "mass_modification":1880.666794
, "name":"Hex(3)HexNAc(4)NeuAc(2)", "descr":"Hex(3) HexNAc(4) NeuAc(2)"},
	"UniMod:1965":{"unimod": "UniMod:1965", "mass_modification":1881.687195
, "name":"dHex(2)Hex(3)HexNAc(4)NeuAc(1)", "descr":"dHex(2) Hex(3) HexNAc(4) NeuAc"},
	"UniMod:1966":{"unimod": "UniMod:1966", "mass_modification":1914.654515
, "name":"dHex(2)Hex(2)HexNAc(6)Sulf(1)", "descr":"dHex(2) Hex(2) HexNAc(6) Sulf"},
	"UniMod:1967":{"unimod": "UniMod:1967", "mass_modification":1955.687589
, "name":"Hex(5)HexNAc(4)NeuAc(1)Ac(1)", "descr":"Hex(5) HexNAc(4) NeuAc Ac"},
	"UniMod:1968":{"unimod": "UniMod:1968", "mass_modification":1968.682838
, "name":"Hex(3)HexNAc(3)NeuAc(3)", "descr":"Hex(3) HexNAc(3) NeuAc(3)"},
	"UniMod:1969":{"unimod": "UniMod:1969", "mass_modification":1997.698154
, "name":"Hex(5)HexNAc(4)NeuAc(1)Ac(2)", "descr":"Hex(5) HexNAc(4) NeuAc Ac(2)"},
	"UniMod:1970":{"unimod": "UniMod:1970", "mass_modification":162.125595
, "name":"Unknown:162", "descr":"Unidentified modification of 162.1258 found in open search"},
	"UniMod:1971":{"unimod": "UniMod:1971", "mass_modification":176.744957
, "name":"Unknown:177", "descr":"Unidentified modification of 176.7462 found in open search"},
	"UniMod:1972":{"unimod": "UniMod:1972", "mass_modification":210.16198
, "name":"Unknown:210", "descr":"Unidentified modification of 210.1616 found in open search"},
	"UniMod:1973":{"unimod": "UniMod:1973", "mass_modification":216.099774
, "name":"Unknown:216", "descr":"Unidentified modification of 216.1002 found in open search"},
	"UniMod:1974":{"unimod": "UniMod:1974", "mass_modification":234.073953
, "name":"Unknown:234", "descr":"Unidentified modification of 234.0742 found in open search"},
	"UniMod:1975":{"unimod": "UniMod:1975", "mass_modification":248.19876
, "name":"Unknown:248", "descr":"Unidentified modification of 248.1986 found in open search"},
	"UniMod:1976":{"unimod": "UniMod:1976", "mass_modification":249.981018
, "name":"Unknown:250", "descr":"Unidentified modification of 249.981 found in open search"},
	"UniMod:1977":{"unimod": "UniMod:1977", "mass_modification":301.986514
, "name":"Unknown:302", "descr":"Unidentified modification of 301.9864 found in open search"},
	"UniMod:1978":{"unimod": "UniMod:1978", "mass_modification":306.095082
, "name":"Unknown:306", "descr":"Unidentified modification of 306.0952 found in open search"},
	"UniMod:1979":{"unimod": "UniMod:1979", "mass_modification":420.051719
, "name":"Unknown:420", "descr":"Unidentified modification of 420.0506 found in open search"},
	"UniMod:1986":{"unimod": "UniMod:1986", "mass_modification":152.006087
, "name":"Diethylphosphothione", "descr":"O-diethylphosphothione"},
	"UniMod:1990":{"unimod": "UniMod:1990", "mass_modification":330.136176
, "name":"CIGG", "descr":"Ubiquitin D (FAT10) leaving after chymotrypsin digestion Cys-Ile-Gly-Gly"},
	"UniMod:1991":{"unimod": "UniMod:1991", "mass_modification":1324.6308
, "name":"GNLLFLACYCIGG", "descr":"Ubiquitin D (FAT10) leaving after trypsin digestion Gly-Asn-Leu-Leu-Phe-Leu-Ala-Cys-Tyr-Cys-Ile-Gly-Gly"},
	"UniMod:1987":{"unimod": "UniMod:1987", "mass_modification":123.974787
, "name":"Dimethylphosphothione", "descr":"O-dimethylphosphothione"},
	"UniMod:1989":{"unimod": "UniMod:1989", "mass_modification":109.959137
, "name":"monomethylphosphothione", "descr":"O-methylphosphothione"},
	"UniMod:1993":{"unimod": "UniMod:1993", "mass_modification":581.211328
, "name":"TMPP-Ac:13C(9)", "descr":"heavy tris(2,4,6-trimethoxyphenyl)phosphonium acetic acid N-hydroxysuccinimide ester derivative"},
	"UniMod:2036":{"unimod": "UniMod:2036", "mass_modification":160.084792
, "name":"Lys+O(2)", "descr":"Photo-induced Lysine adduct"},
	"UniMod:2001":{"unimod": "UniMod:2001", "mass_modification":320.100836
, "name":"ZQG", "descr":"carbobenzoxy-L-glutaminyl-glycine"},
	"UniMod:1999":{"unimod": "UniMod:1999", "mass_modification":55.989829
, "name":"Xlink:DST[56]", "descr":"DST crosslinker cleaved by sodium periodate"},
	"UniMod:2006":{"unimod": "UniMod:2006", "mass_modification":203.950987
, "name":"Haloxon", "descr":"O-Dichloroethylphosphate"},
	"UniMod:2008":{"unimod": "UniMod:2008", "mass_modification":92.997965
, "name":"Methamidophos-O", "descr":"O-methyl amino phosphinate"},
	"UniMod:2014":{"unimod": "UniMod:2014", "mass_modification":12.995249
, "name":"Nitrene", "descr":"Loss of O2; nitro photochemical decomposition"},
	"UniMod:2015":{"unimod": "UniMod:2015", "mass_modification":235.176741
, "name":"shTMT", "descr":"Super Heavy Tandem Mass Tag"},
	"UniMod:2016":{"unimod": "UniMod:2016", "mass_modification":304.207146
, "name":"TMTpro", "descr":"TMTpro 16plex Tandem Mass Tag"},
	"UniMod:2017":{"unimod": "UniMod:2017", "mass_modification":295.189592
, "name":"TMTpro_zero", "descr":"Native TMTpro Tandem Mass Tag"},
	"UniMod:2041":{"unimod": "UniMod:2041", "mass_modification":186.008196
, "name":"3-hydroxybenzyl-phosphate", "descr":"3-hydroxybenzyl phosphate"},
	"UniMod:2028":{"unimod": "UniMod:2028", "mass_modification":2861.000054
, "name":"Hex(6)HexNAc(5)NeuAc(3)", "descr":"A3G3S3"},
	"UniMod:2025":{"unimod": "UniMod:2025", "mass_modification":332.19876
, "name":"Andro-H2O", "descr":"andrographolide with the loss of H2O"},
	"UniMod:2027":{"unimod": "UniMod:2027", "mass_modification":169.048741
, "name":"His+O(2)", "descr":"Photo-induced histidine adduct"},
	"UniMod:2029":{"unimod": "UniMod:2029", "mass_modification":2352.846
, "name":"Hex(7)HexNAc(6)", "descr":"A4G4"},
	"UniMod:2033":{"unimod": "UniMod:2033", "mass_modification":163.030314
, "name":"Met+O(2)", "descr":"Photo-induced Methionine Adduct"},
	"UniMod:2034":{"unimod": "UniMod:2034", "mass_modification":89.011293
, "name":"Gly+O(2)", "descr":"Photo-induced Glycine Adduct"},
	"UniMod:2037":{"unimod": "UniMod:2037", "mass_modification":161.032422
, "name":"Glu+O(2)", "descr":"Photo-induced Glutamate adduct"},
	"UniMod:2040":{"unimod": "UniMod:2040", "mass_modification":1482.77
, "name":"MBS+peptide", "descr":"MBS_233p24 plus peptide 1250p53"},
	"UniMod:2042":{"unimod": "UniMod:2042", "mass_modification":155.997631
, "name":"phenyl-phosphate", "descr":"phenyl phosphate"},
	"UniMod:2044":{"unimod": "UniMod:2044", "mass_modification":244.069536
, "name":"RBS-ID_Uridine", "descr":"RNA-protein UVC-crosslinked, hydrofluoride-digested uridine adduct"},
	"UniMod:2054":{"unimod": "UniMod:2054", "mass_modification":226.058972
, "name":"pRBS-ID_4-thiouridine", "descr":"RNA-protein UVA-crosslinked, hydrofluoride-digested 4-thiouridine adduct"},
	"UniMod:2053":{"unimod": "UniMod:2053", "mass_modification":690.24316
, "name":"Biotin:Aha-PC", "descr":"Intact PC Biotin Alkyne tag"},
	"UniMod:2062":{"unimod": "UniMod:2062", "mass_modification":296.184841
, "name":"DBIA", "descr":"desthiobiotinylation of cysteine with DBIA probe"},
	"UniMod:2055":{"unimod": "UniMod:2055", "mass_modification":265.081104
, "name":"pRBS-ID_6-thioguanosine", "descr":"RNA-protein UVA-crosslinked, hydrofluoride-digested 6-thioguanosine adduct"},
	"UniMod:2057":{"unimod": "UniMod:2057", "mass_modification":221.081695
, "name":"6C-CysPAT", "descr":"Iodoacetamido-LC-Phosphonic Acid derivative"},
	"UniMod:2058":{"unimod": "UniMod:2058", "mass_modification":209.97181
, "name":"Xlink:DSPP[210]", "descr":"Intact DSPP/TBDSPP crosslinker"},
	"UniMod:2059":{"unimod": "UniMod:2059", "mass_modification":227.982375
, "name":"Xlink:DSPP[228]", "descr":"Water-quenched monolink of DSPP/TBDSPP crosslinker"},
	"UniMod:2060":{"unimod": "UniMod:2060", "mass_modification":331.045704
, "name":"Xlink:DSPP[331]", "descr":"Tris-quenched monolink of DSPP/TBDSPP crosslinker"},
	"UniMod:2061":{"unimod": "UniMod:2061", "mass_modification":225.990534
, "name":"Xlink:DSPP[226]", "descr":"Ammonia-quenched monolink of DSPP/TBDSPP crosslinker"},
	"UniMod:2067":{"unimod": "UniMod:2067", "mass_modification":580.333296
, "name":"Mono_Nγ-propargyl-L-Gln_desthiobiotin", "descr":"Monomodification of Nγ-propargyl-L-Gln probe with clicked desthiobiotin-azide"},
	"UniMod:2068":{"unimod": "UniMod:2068", "mass_modification":709.375889
, "name":"Di_L-Glu_Nγ-propargyl-L-Gln_desthiobiotin", "descr":"Dimodification of L-Glu and Nγ-propargyl-L-Gln probe with clicked desthiobiotin-azide"},
	"UniMod:2069":{"unimod": "UniMod:2069", "mass_modification":708.391873
, "name":"Di_L-Gln_Nγ-propargyl-L-Gln_desthiobiotin", "descr":"Dimodification of L-Gln and Nγ-propargyl-L-Gln probe with clicked desthiobiotin-azide"},
	"UniMod:2070":{"unimod": "UniMod:2070", "mass_modification":128.058578
, "name":"L-Gln", "descr":"Monomodification with glutamine"},
	"UniMod:2072":{"unimod": "UniMod:2072", "mass_modification":88.016044
, "name":"Glyceroyl", "descr":"Glyceroylation"}
}
