#import "template.typ": *
#import "@preview/fletcher:0.5.8" as fletcher: diagram, node, edge
#import fletcher.shapes: diamond, brace, cylinder

#show: doc => conf(
  authors: (
    (
      name: "Olivier Langella",
    ),
  ),
  toc: true,
  lang: "en",
  font: "Roboto",
  date: "14/02/2025",
  years: (2024, 2025),
  version: "3.0",
  "CBOR format documentation",
  doc
)


= PSM CBOR format

psm CBOR format is documented in PAPPSOms++ project.

#set text(10pt)
#diagram(
	node-stroke: .1em,
	node-fill: gradient.radial(blue.lighten(80%), blue, center: (30%, 20%), radius: 80%),
	spacing: 4em,
	node((0,0), `mzIdentML`, shape: diamond, fill: none, name: <mzidfile>),
	node((1,0), `mzid2cbor`, radius: 3em, name: <mzid2cbor>),
	node((2,0), `PSM cbor file`, shape: diamond, fill: none, name: <cborfile>),
	node((3,0), `cbor-grouping`, radius: 3em, name: <cbor-grouping>),
	edge(<mzidfile>, <mzid2cbor>, ``, "-|>"),
	edge(<mzid2cbor>,<cborfile>, ``, "-|>"),
	edge(<cborfile>, <cbor-grouping>, ``, "-|>"),
)


= Command line interface

#code-block("mzid2cbor -i identification.mzid -o results.cbor", "bash")


== MzIdentML to CBOR



= grouping CBOR format


It could be something like that :
#let code_grouping = read("grouping.json")
#code-block(code_grouping, "json", title: "Grouping cbor file format")


#remarque(qui: "Thierry", "I think it's a good idea to add a block to define label expressed at top level to replicate the information, probably witrh psimod or unimod strings")
#remarque(qui: "Olivier", "What do you mean ?")
#remarque(qui: "Thierry", "did you expect to add the origin of data (identification engine and filters)")
#remarque(qui: "Olivier", "It needs to be linked somehow to the PSM cbor original file")
#remarque(qui: "Thierry", "i don't see the observed mass in psm list is it a feature?" )
#remarque(qui: "Olivier", "Observed mass is really linked to the PSMs, I would prefer that information to be retrieved from PSM CBOR file")

