/*
 Copyright (C) 2014 Ronald C Beavis, all rights reserved
 X! tandem
 This software is a component of the X! proteomics software
 development project

Use of this software governed by the Artistic license, as reproduced here:

The Artistic License for all X! software, binaries and documentation

Preamble
The intent of this document is to state the conditions under which a
Package may be copied, such that the Copyright Holder maintains some
semblance of artistic control over the development of the package,
while giving the users of the package the right to use and distribute
the Package in a more-or-less customary fashion, plus the right to
make reasonable modifications.

Definitions
"Package" refers to the collection of files distributed by the Copyright
  Holder, and derivatives of that collection of files created through
  textual modification.

"Standard Version" refers to such a Package if it has not been modified,
  or has been modified in accordance with the wishes of the Copyright
  Holder as specified below.

"Copyright Holder" is whoever is named in the copyright or copyrights
  for the package.

"You" is you, if you're thinking about copying or distributing this Package.

"Reasonable copying fee" is whatever you can justify on the basis of
  media cost, duplication charges, time of people involved, and so on.
  (You will not be required to justify it to the Copyright Holder, but
  only to the computing community at large as a market that must bear
  the fee.)

"Freely Available" means that no fee is charged for the item itself,
  though there may be fees involved in handling the item. It also means
  that recipients of the item may redistribute it under the same
  conditions they received it.

1. You may make and give away verbatim copies of the source form of the
Standard Version of this Package without restriction, provided that
you duplicate all of the original copyright notices and associated
disclaimers.

2. You may apply bug fixes, portability fixes and other modifications
derived from the Public Domain or from the Copyright Holder. A
Package modified in such a way shall still be considered the Standard
Version.

3. You may otherwise modify your copy of this Package in any way, provided
that you insert a prominent notice in each changed file stating how and
when you changed that file, and provided that you do at least ONE of the
following:

a.	place your modifications in the Public Domain or otherwise make them
  Freely Available, such as by posting said modifications to Usenet
  or an equivalent medium, or placing the modifications on a major
  archive site such as uunet.uu.net, or by allowing the Copyright Holder
  to include your modifications in the Standard Version of the Package.
b.	use the modified Package only within your corporation or organization.
c.	rename any non-standard executables so the names do not conflict
  with standard executables, which must also be provided, and provide
  a separate manual page for each non-standard executable that clearly
  documents how it differs from the Standard Version.
d.	make other distribution arrangements with the Copyright Holder.

4. You may distribute the programs of this Package in object code or
executable form, provided that you do at least ONE of the following:

a.	distribute a Standard Version of the executables and library files,
  together with instructions (in the manual page or equivalent) on
  where to get the Standard Version.
b.	accompany the distribution with the machine-readable source of the
  Package with your modifications.
c.	give non-standard executables non-standard names, and clearly
  document the differences in manual pages (or equivalent), together
  with instructions on where to get the Standard Version.
d.	make other distribution arrangements with the Copyright Holder.

5. You may charge a reasonable copying fee for any distribution of
this Package. You may charge any fee you choose for support of
this Package. You may not charge a fee for this Package itself.
However, you may distribute this Package in aggregate with other
(possibly commercial) programs as part of a larger (possibly
commercial) software distribution provided that you do not a
dvertise this Package as a product of your own. You may embed this
Package's interpreter within an executable of yours (by linking);
this shall be construed as a mere form of aggregation, provided that
the complete Standard Version of the interpreter is so embedded.

6. The scripts and library files supplied as input to or produced as
output from the programs of this Package do not automatically fall
under the copyright of this Package, but belong to whomever generated
them, and may be sold commercially, and may be aggregated with this
Package. If such scripts or library files are aggregated with this
Package via the so-called "undump" or "unexec" methods of producing
a binary executable image, then distribution of such an image shall
neither be construed as a distribution of this Package nor shall it
fall under the restrictions of Paragraphs 3 and 4, provided that you
do not represent such an executable image as a Standard Version of
this Package.

7. C subroutines (or comparably compiled subroutines in other languages)
supplied by you and linked into this Package in order to emulate
subroutines and variables of the language defined by this Package
shall not be considered part of this Package, but are the equivalent
of input as in Paragraph 6, provided these subroutines do not change
the language in any way that would cause it to fail the regression
tests for the language.

8. Aggregation of this Package with a commercial distribution is always
permitted provided that the use of this Package is embedded; that is,
when no overt attempt is made to make this Package's interfaces visible
to the end user of the commercial distribution. Such use shall not be
construed as a distribution of this Package.

9. The name of the Copyright Holder may not be used to endorse or promote
products derived from this software without specific prior written permission.

10. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

The End
*/

#pragma once


#include <QFile>

// File version: 2014-09-25

/*
 * the mreport object provides the functionality to export all of the
 * information collected in mprocess to an XML file. The file path was defined
 * in the original XML input parameter file. The file produced by mreport can be
 * used as an input parameter file to repeat a protein modeling session at a
 * later time.
 */
#include <map>
#include <set>
#include <pappsomspp/core/msfile/msfileaccessor.h>
#include <pappsomspp/core/amino_acid/aamodification.h>
#include <pappsomspp/core/processing/xml/mzidentmlwriter.h>


class mscore;
class msequtilities;

class mzid_report
{
  public:
  mzid_report(const QString &sample_name,
              const pappso::MsFileAccessor *mp_msFileAccessor,
              mscore &score);
  virtual ~mzid_report(void);

  // These methods are called to create the mzIndentML file

  bool start(XmlParameter &_x, XmlParameter &_y); // call this method first
  bool analysis_collection(vector<mspectrum> &_vs, vector<string> &_vp);
  bool analysis_protocol_collection(XmlParameter &_x);
  bool data_collection(vector<mspectrum> &_vs,
                       vector<string> &_vp,
                       XmlParameter &_x);
  bool sequence_collection(vector<mspectrum> &_vs, vector<string> &_vp);
  bool end(void); // call this method last

  private:
  private:
  static const QString m_reversedProteinSequenceStringEndsWith;

  bool add_header();
  bool analysis_mods(string &_v, bool _b);
  bool add_dbsequence(vector<mspectrum> &_vs);
  bool add_peptide_evidence(vector<mspectrum> &_vs);
  bool add_peptides(vector<mspectrum> &_vs);
  bool add_inputs(const pappso::MsFileAccessor *msfile,
                  vector<mspectrum> &_vs,
                  vector<string> &_vp,
                  XmlParameter &_x);
  bool
  add_analysis(vector<mspectrum> &_vs, vector<string> &_vp, XmlParameter &_x);
  pappso::AaModificationP getPsiMod(double _m) const;
  bool get_unimod(int _m, string &_u, string &_d);
  bool load_unimod(void);
  bool parse_description(const string &_s, QString &_acc, QString &_desc);
  bool getPerformanceMap(const string &_k, string &_v);

  // string m_strPath; // output file path
  // ofstream m_ofOut; // the output file stream

  int
  get_unimod_mass(double _m) const
  {
    return (int)(1000 * _m + 0.5);
  };

  private:
  static const QString m_processFlavor;
  const pappso::MsFileAccessor *mp_msFileAccessor = nullptr;
  QString m_sampleName;
  xMap m_performanceMap;

  QFile *m_outputFile;
  pappso::MzIdentMlWriter *m_outputStream;
  mscore &m_Score; // mscore used to generate scores in report
  string m_strRegex;
  // map<int, string> m_mapUnimod;
  // map<int, string> m_mapUnimodDescriptions;
  map<QString, QString> m_mapIdsToPeptides;
  map<int, pappso::AaModificationP> m_mapAaModificationP;


  enum class EnumReverseSearchType : std::int8_t
  {
    no_decoy = 0, ///< no builtin decoy search
    reversed_sequences_added =
      1, ///< builtin decoy search : reverse each protein sequence
    only_score_on_reversed =
      2 ///< only search on builtin decoy (reversed proteins)
  };

  EnumReverseSearchType m_enumReverseSearchType =
    EnumReverseSearchType::no_decoy;
};
