/**
 * \file output/peptidomscboroutput.h
 * \date 12/09/2025
 * \author Olivier Langella
 * \brief cbor output for peptidoms
 */


/*
 * PeptidOMS, Spectra to protein alignment tool
 * Copyright (C) 2025  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#pragma once

#include <pappsomspp/core/processing/cbor/cborstreamwriter.h>
#include <pappsomspp/core/processing/cbor/psm/psmproteinmap.h>
#include <pappsomspp/core/msrun/msrunreader.h>
#include <QBuffer>
#include <QFileInfo>
/**
 * @todo write docs
 */
class PeptidOmsCborOutput
{
  public:
  /**
   * Default constructor
   */
  PeptidOmsCborOutput(pappso::cbor::CborStreamWriter *p_cbor_stream_writer,
                      const QJsonObject &json_parameters,
                      const QString &algoname);

  /**
   * Destructor
   */
  virtual ~PeptidOmsCborOutput();


  virtual void close();

  void setTargetFastaFiles(const std::vector<QFileInfo> &fasta_fileinfo_list);

  virtual void setMsRunReaderSPtr(pappso::MsRunReaderSPtr msrun_reader);

  pappso::cbor::CborStreamWriter *getScanCborWriter();

  pappso::cbor::psm::PsmProteinMap &getPsmProteinMap();

  private:
  pappso::cbor::CborStreamWriter *mp_cborWriter;
  pappso::cbor::psm::PsmProteinMap m_psmProteinMap;
  QBuffer *mpa_bufferAfterProteinMap                              = nullptr;
  pappso::cbor::CborStreamWriter *mpa_bufferWriterAfterProteinMap = nullptr;
  pappso::MsRunReaderSPtr msp_msrunReader;
};
