/**
 * \file output/odspsm.h
 * \date 19/07/2025
 * \author Olivier Langella
 * \brief ODS PSM export
 */


/*
 * SpecGlobTool, Spectra to peptide alignment tool
 * Copyright (C) 2023  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include <pappsomspp/core/processing/cbor/psm/psmfilereaderbase.h>
#include <pappsomspp/core/processing/uimonitor/uimonitorinterface.h>
#include <odsstream/calcwriterinterface.h>

#pragma once

class OdsPsm : public pappso::cbor::psm::PsmFileReaderBase
{
  public:
  OdsPsm(CalcWriterInterface &output);

  virtual ~OdsPsm();


  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;
  void psmReady(pappso::UiMonitorInterface &monitor [[maybe_unused]]) override;

  void close() override;

  private:
  CalcWriterInterface &m_output;
};
