/**
 * \file output/odsmatrix.cpp
 * \date 25/11/2023
 * \author Olivier Langella
 * \brief ODS matrix export
 */


/*
 * SpecGlobTool, Spectra to peptide alignment tool
 * Copyright (C) 2023  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include "odsmatrix.h"
#include <pappsomspp/core/utils.h>

OdsMatrix::OdsMatrix()
{
}

OdsMatrix::~OdsMatrix()
{
}

void
OdsMatrix::write(CalcWriterInterface *p_writer,
                 const pappso::specglob::SpectralAlignment &spectral_alignment)
{
  p_writer->writeSheet("Matrix");
  auto spectrum = spectral_alignment.getExperimentalSpectrumCsp();

  p_writer->writeEmptyCell();

  p_writer->writeEmptyCell();

  for(auto spectrum_point : *(spectrum.get()))
    {
      p_writer->writeCell(pappso::Utils::toString(spectrum_point.type));
    }
  p_writer->writeLine();
  p_writer->writeEmptyCell();

  p_writer->writeEmptyCell();

  for(auto spectrum_point : *(spectrum.get()))
    {
      p_writer->writeCell(spectrum_point.peak_mz);
    }
  p_writer->writeLine();
  auto peptide = spectral_alignment.getPeptideSpectraCsp();

  std::size_t i = 0;

  auto matrix = spectral_alignment.getMatrix();
  auto itpep  = matrix.begin1();
  for(auto &peptide_point : *(peptide.get()))
    {
      p_writer->writeCell(peptide_point.mz);
      if(i == 0)
        p_writer->writeEmptyCell();
      else
        {
          if(i > peptide.get()->getPeptideSp().get()->size())
            p_writer->writeEmptyCell();
          else
            p_writer->writeCell(peptide.get()
                                  ->getPeptideSp()
                                  .get()
                                  ->getConstAa(i - 1)
                                  .toProForma());
        }

      for(auto itj = itpep.begin(); itj != itpep.end(); itj++)
        {
          p_writer->writeCell((*itj).score);
        }

      p_writer->writeLine();

      i++;
      itpep++;
    }
}
