/**
 * \file output/odsfeatures.h
 * \date 20/08/2025
 * \author Olivier Langella
 * \brief ODS PSM export
 */


/*
 * SpecGlobTool, Spectra to peptide alignment tool
 * Copyright (C) 2023  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include <pappsomspp/core/processing/cbor/cborstreamwriter.h>
#include <pappsomspp/core/processing/cbor/psm/psmfilereaderbase.h>
#include <pappsomspp/core/processing/cbor/psm/psmfilescanprocessandcopy.h>
#include <pappsomspp/core/processing/uimonitor/uimonitorinterface.h>
#include <odsstream/calcwriterinterface.h>

#pragma once

class OdsFeaturesBase
{

  public:
  OdsFeaturesBase(CalcWriterInterface &output);
  virtual ~OdsFeaturesBase();


  void writePsmLine(const QString &sample_name,
                    const QString &psm_proforma,
                    const QCborMap &cborScanId,
                    const QCborMap &cborScanPrecursor,
                    const QCborMap &cborScanPsmEval,
                    bool target_or_decoy);

  double getPrecursorMass(double mz_prec, uint charge) const;

  protected:
  CalcWriterInterface &m_output;
};

class OdsFeatures : public pappso::cbor::psm::PsmFileReaderBase,
                    public OdsFeaturesBase
{
  public:
  OdsFeatures(CalcWriterInterface &output);

  virtual ~OdsFeatures();

  void psmReady(pappso::UiMonitorInterface &monitor [[maybe_unused]]) override;

  void close() override;
};


class OdsFeaturesReadAndCopy
  : public pappso::cbor::psm::PsmFileScanProcessAndCopy,
    public OdsFeaturesBase
{
  public:
  OdsFeaturesReadAndCopy(pappso::cbor::CborStreamWriter *cbor_output_p,
                         CalcWriterInterface &output);

  virtual ~OdsFeaturesReadAndCopy();
  void close() override;

  protected:
  void processBufferScan(pappso::UiMonitorInterface &monitor) override;
  virtual pappso::cbor::psm::CborScanMapBase *newCborScanMap() override;
};
