#import "template.typ": *
#import "@preview/fletcher:0.5.8": *

#show: doc => conf(
  authors: (
    (
      name: "Olivier Langella",
    ),
  ),
  toc: true,
  lang: "en",
  font: "Roboto",
  date: "11/07/2025",
  years: (2025),
  version: "0.1",
  "SpecGlobTool documentation",
  doc
)

#let specglobtool = "SpecGlobTool"
#let specoms = "SpecOMS"

= Introduction

#specglobtool aligns MS2 fragmentation spectra and a peptide sequence. It finds the best explanation
of experimental peaks given a peptide sequence and is able to deal with precursor mass delta.
Algorithm is described in @prunier_fast_2023.

= PSM CBOR file workflow

#set text(10pt)
#diagram(
	node-stroke: .1em,
	node-fill: gradient.radial(blue.lighten(80%), blue, center: (30%, 20%), radius: 80%),
	spacing: 4em,
	edge((-1,0.5), <specoms>, "r", "-|>", `mzML`, label-pos: 0, label-side: center),
	edge((-1,-0.5), <specoms>, "r", "-|>", `Fasta`, label-pos: 0, label-side: center),
	node((0,0), `specoms`, radius: 2em, name: <specoms>),
	edge(``, "-|>"),
	node((1,0), `specglobtool`, radius: 3em, name: <specglobtool>),
	edge(``, "-|>"),
	node((2,0), `psmfeatures`, radius: 3em),
	edge(``, "-|>"),
	node((3,0), `ODS export`, radius: 2em),
	node((2,1), `deeplc mumble`, radius: 2em, name: <deeplc>),
	edge(<specglobtool>, <deeplc>, ``, "-|>"),
)


= Command line interface

#specglobtool works on a PSM CBOR file as input and produces a new PSM CBOR file as output.

#code-block("specglobtool -p params.json -i input.cbor -o output.cbor", "bash")

#specglobtool works also using UNIX pipes
#code-block("cat input.cbor | specglobtool -p params.json > output.cbor", "bash")



= JSON parameter file

#specglobtool parameters are specified in a JSON file

#let code_psm = read("json/specglob_parameters.json")
#code-block(code_psm, "json", title: "JSON parameter file")



= Tests for #specglobtool

First you need a PSM CBOR file. Currently, you have to use #specoms


#code-block("specoms -p /gorgone/pappso/versions_logiciels_pappso/deepprot/v0.0.11/B73/ion_enhancer_params.ods -m /gorgone/pappso/moulon/raw/20250424_deepprot_langella_mzml/20200218_RD_mais_deeprot_1.mzML /gorgone/pappso/moulon/users/archives_users/Luciana/deepprot_project/luciana/maize_genotypes/no_redundant_db/panAnnotation.B73.v1.0.d12.19.fasta.transdecoder.pep.renamed.NR.fa /gorgone/pappso/moulon/database/contaminants_standarts.fasta -o /gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/specoms/specoms_1_F2_vs_B73.cbor -a", "bash")


Run specglobtool on existing cbor PSM file :

#code-block("specglobtool -i /gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/specoms/specoms_1_F2_vs_B73.cbor -o new_specoms_1_F2_vs_B73.cbor -c 10 -p ../doc/typst/parameters.json", "bash")

Export results to JSON file :

#code-block("specglobtool-export -i new_specoms_1_F2_vs_B73.cbor --json new_specoms_1_F2_vs_B73.json", "bash")

Export results to ODS file :

#code-block("specglobtool-export -i new_specoms_1_F2_vs_B73.cbor --ods new_specoms_1_F2_vs_B73.ods", "bash")


= #specglobtool PSM score using TIDD

== Computing PSM features to filter specglobtool results

#code-block("psmfeatures -i new_specoms_1_F2_vs_B73.cbor -o new_specoms_1_F2_vs_B73_with_features.cbor -c 10", "bash")

Parameters to compute features can be described in a JSON file :

#let code_psm = read("json/features_parameters.json")
#code-block(code_psm, "json", title: "JSON parameter file to compute features")

== Export PSM features for SVM process

#code-block("psmfeatures-export -i new_specoms_1_F2_vs_B73_with_features.cbor --tsvd svm_F2_vs_B73", "bash")

This command creates a directory called "svm_F2_vs_B73" containing data and Rscript to run the Support Vector Machine algorithm.



#bibliography(style:"frontiers", "bibliography.bib")
