/**
 * \file tests/matrix.cpp
 * \date 11/11/2023
 * \author Olivier Langella
 * \brief tests on boost matrix
 */


/*
 * SpecGlobTool, Spectra to peptide alignment tool
 * Copyright (C) 2023  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
// ./tests/catch2-only-tests [matrix] -s


#include <QDebug>
#include <QString>
#include <catch2/catch_test_macros.hpp>
#include "config.h"
#include "common.h"
#include <boost/numeric/ublas/matrix.hpp>
#include <vector>

using boost::numeric::ublas::matrix;

matrix<int>
make_matrix(std::vector<std::vector<int>> values)
{
  auto the_matrix = matrix<int>(values.size(), values[0].size());

  // Copy 'values' into 'the_matrix', one row at a time
  auto iter1 = the_matrix.begin1();
  for(auto values_iter = values.begin(); values_iter != values.end();
      ++values_iter, ++iter1)
    std::copy(values_iter->begin(), values_iter->end(), iter1.begin());

  return the_matrix;
}

matrix<int>
make_matrix(int size1, int size2, int value)
{
  auto the_matrix = matrix<int>(size1, size2);

  for(auto iter1 = the_matrix.begin1(); iter1 != the_matrix.end1(); ++iter1)
    for(auto iter2 = iter1.begin(); iter2 != iter1.end(); ++iter2)
      *iter2 = value;

  return the_matrix;
}

TEST_CASE("test on boost matrix", "[matrix]")
{
  // Set the debugging message formatting pattern.scores to apply in comparisons
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));

  SECTION("..:: test on boost matrix ::..", "[matrix]")
  {


    matrix<int> the_matrix = make_matrix(
      {{1, 0, 2, 4, 3}, {4, 6, 5, 2, 1}, {4, 4, 5, 2, 1}, {5, 6, 8, 5, 3}});

    WARN("Print the matrix by rows:");
    auto iter1_previous_line = the_matrix.end1();
    for(auto iter1 = the_matrix.begin1(); iter1 != the_matrix.end1(); ++iter1)
      {
        QStringList row;
        for(auto iter2 = iter1.begin(); iter2 != iter1.end(); ++iter2)
          {
            row << QString("%1").arg(*iter2);

            if(iter2.index1() == 1 && iter2.index2() == 3)
              {
                QStringList prev_row;
                auto it_prevline = iter1 - 1;
                for(auto iterprev2 = it_prevline.rbegin()+2;
                    iterprev2 != it_prevline.rend();
                    ++iterprev2)
                  {
                    prev_row << QString("%1").arg(*iterprev2);
                  }
                qDebug() << "previous line " << prev_row.join(" ");
              }
          }
        qDebug() << row.join(" ");
      }
      /*
    auto iter1 = the_matrix.begin1()
    
    qDebug() << Qt::endl << "Print the matrix by columns:";
    for(auto iter2 = the_matrix.begin2(); iter2 != the_matrix.end2(); ++iter2)
      for(auto iter1 = iter2.begin(); iter1 != iter2.end(); ++iter1)
        qDebug() << *iter1 << " ";

    qDebug();
    */
  }
}
