
#include "common.h"

using namespace pappso;


/** @brief example of interface to count MS levels of all spectrum in an MSrun
 */
class MgfGetSpectrumByScanNumber
  : public pappso::SpectrumCollectionHandlerInterface
{
  public:
  MgfGetSpectrumByScanNumber(std::size_t scan)
  {
    m_scanNumber = scan;
  };
  virtual void
  setQualifiedMassSpectrum(
    const pappso::QualifiedMassSpectrum &spectrum) override
  {
    qDebug() << spectrum.getParameterValue(
      QualifiedMassSpectrumParameter::ScanNumber);
    if(spectrum.getParameterValue(QualifiedMassSpectrumParameter::ScanNumber)
         .toULongLong() == m_scanNumber)
      {
        m_spectrum = spectrum;
      }
  };
  virtual bool
  needPeakList() const override
  {
    return true;
  };

  const pappso::QualifiedMassSpectrum &
  getQualifiedMassSpectrum() const
  {
    return m_spectrum;
  };

  private:
  pappso::QualifiedMassSpectrum m_spectrum;
  std::size_t m_scanNumber;
};


QualifiedMassSpectrum
readMgf(const QString &filename, std::size_t scan)
{
  try
    {
      qDebug();
      MsFileAccessor accessor(filename, "msrun");
      qDebug();
      MsRunReaderSPtr reader =
        accessor.msRunReaderSPtr(accessor.getMsRunIds().front());
      qDebug() << accessor.getMsRunIds().front().get()->getXmlId();
      std::cout << __FILE__ << " " << __FUNCTION__ << " " << __LINE__ << " "
                << reader->spectrumListSize() << std::endl;
      QualifiedMassSpectrum spectrum_sp;
      if(scan == 0)
        spectrum_sp = reader->qualifiedMassSpectrum(0);
      else
        {
          MgfGetSpectrumByScanNumber handler(scan);
          reader->readSpectrumCollection(handler);
          spectrum_sp = handler.getQualifiedMassSpectrum();
        }
      return spectrum_sp;
    }
  catch(pappso::PappsoException &error)
    {
      std::cout << __FILE__ << " " << __FUNCTION__ << " " << __LINE__
                << QString("ERROR reading file %1 :")
                     .arg(filename)
                     .toStdString()
                     .c_str()
                << " " << error.what();
      throw error;
    }
}
