/**
 * \file psmfeatures.h
 * \date 20/08/2025
 * \author Olivier Langella
 * \brief CLI tool
 */


/*
 * SpecGlobTool, Spectra to peptide alignment tool
 * Copyright (C) 2025 Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#pragma once

#include <QDebug>

#include <QObject>
#include <QCoreApplication>
#include "config.h"
#include <pappsomspp/core/massspectrum/qualifiedmassspectrum.h>
#include <pappsomspp/core/peptide/peptide.h>
#include <pappsomspp/core/processing/uimonitor/uimonitorinterface.h>
#include <odsstream/odsdocwriter.h>
#include <odsstream/odsexception.h>
#include <QJsonObject>


class PsmFeaturesCli : public QObject
{
  Q_OBJECT

  private:
  QCoreApplication *app;

  public:
  explicit PsmFeaturesCli(QObject *parent = 0);
  /////////////////////////////////////////////////////////////
  /// Call this to quit application
  /////////////////////////////////////////////////////////////
  void quit();

  signals:
  /////////////////////////////////////////////////////////////
  /// Signal to finish, this is connected to Application Quit
  /////////////////////////////////////////////////////////////
  void finished();

  public slots:
  /////////////////////////////////////////////////////////////
  /// This is the slot that gets called from main to start everything
  /// but, everthing is set up in the Constructor
  /////////////////////////////////////////////////////////////
  void run();

  /////////////////////////////////////////////////////////////
  /// slot that get signal when that application is about to quit
  /////////////////////////////////////////////////////////////
  void aboutToQuitApp();

  private:
  QJsonObject readJsonFile(const QString &filename) const;
  void setCpuNumber(pappso::UiMonitorInterface &ui_monitor, uint cpu_number);
};
