/**
 * \file output/peptidomscboroutput.cpp
 * \date 12/09/2025
 * \author Olivier Langella
 * \brief cbor output for peptidoms
 */


/*
 * PeptidOMS, Spectra to protein alignment tool
 * Copyright (C) 2025  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include "peptidomscboroutput.h"
#include "../config.h"

PeptidOmsCborOutput::PeptidOmsCborOutput(
  pappso::cbor::CborStreamWriter *p_cbor_stream_writer,
  const QJsonObject &json_parameters,
  const QString &algoname)
  : mp_cborWriter(p_cbor_stream_writer)
{
  mp_cborWriter->startMap();
  mp_cborWriter->writeInformations("PeptidOMS", VERSION, "psm", algoname);


  mp_cborWriter->append("parameter_map");
  mp_cborWriter->startMap();
  mp_cborWriter->append(algoname);
  // mpa_writer->append("specoms");
  //  mpa_writer->append("test");
  QCborMap specoms_map;
  // qWarning() << json_map.keys();
  //  QJsonValue json_value(json_map);
  specoms_map = QCborMap::fromJsonObject(json_parameters);
  specoms_map.toCborValue().toCbor(*mp_cborWriter);
  mp_cborWriter->endMap();

  // QByteArray byteArray
  mpa_bufferAfterProteinMap = new QBuffer();
  mpa_bufferAfterProteinMap->open(QIODevice::ReadWrite);
  mpa_bufferWriterAfterProteinMap =
    new pappso::cbor::CborStreamWriter(mpa_bufferAfterProteinMap);
}

PeptidOmsCborOutput::~PeptidOmsCborOutput()
{
  delete mpa_bufferAfterProteinMap;
  delete mpa_bufferWriterAfterProteinMap;
}

void
PeptidOmsCborOutput::setMsRunReaderSPtr(pappso::MsRunReaderSPtr msrun_reader)
{
  msp_msrunReader = msrun_reader;

  // mpa_bufferWriterAfterProteinMap->append("sample_list");
  /*

  "sample_list": [
  {
  "name": "tandem2017_nopatch_20120906_balliau_extract_1_A01_urnb-1",
  "identification_file": {
  "name": "/home/langella/data1/tandem/
  tandem2017_nopatch_20120906_balliau_extract_1_A01_urnb-1.xml",
  },
  "peaklist_file": {
  "name": "tandem2017_nopatch_20120906_balliau_extract_1_A01_urnb-1.mzml"
  },
  "scan_list": [
  {
  */
  mpa_bufferWriterAfterProteinMap->startArray();

  mpa_bufferWriterAfterProteinMap->startMap();
  mpa_bufferWriterAfterProteinMap->append("name");
  mpa_bufferWriterAfterProteinMap->append(
    msp_msrunReader.get()->getMsRunId().get()->getSampleName());
  mpa_bufferWriterAfterProteinMap->append("peaklist_file");
  mpa_bufferWriterAfterProteinMap->startMap();
  mpa_bufferWriterAfterProteinMap->append("name");
  mpa_bufferWriterAfterProteinMap->append(
    msp_msrunReader.get()->getMsRunId().get()->getFileName());
  mpa_bufferWriterAfterProteinMap->endMap();

  mpa_bufferWriterAfterProteinMap->append("scan_list");
  mpa_bufferWriterAfterProteinMap->startArray();
}


void
PeptidOmsCborOutput::close()
{

  mpa_bufferWriterAfterProteinMap->endArray(); // end scan_list
  mpa_bufferWriterAfterProteinMap->endMap();   // end sample
  mpa_bufferWriterAfterProteinMap->endArray(); // end sample_list

  mp_cborWriter->append("protein_map");
  m_psmProteinMap.writeMap(*mp_cborWriter);

  // copy buffer

  mp_cborWriter->append("sample_list");

  // mpa_writer->startArray(); // sample_list
  // mpa_writer->endArray();   // end sample_list


  mpa_bufferAfterProteinMap->seek(0);
  // qWarning() << "size=" << mpa_buffer->data().size();

  mp_cborWriter->device()->write(mpa_bufferAfterProteinMap->data());
  /*
  QCborStreamReader cbor_reader(mpa_buffer->data());
  QCborValue map_tag;
  map_tag.fromCbor(cbor_reader);

  map_tag.toCbor(*mpa_writer);
  // map_tag.fromCbor(cbor_reader);

  qWarning() << map_tag.toString();
  //  map_tag.toCbor(*mpa_writer);
*/

  mp_cborWriter->endMap();
}


void
PeptidOmsCborOutput::setTargetFastaFiles(
  const std::vector<QFileInfo> &fasta_fileinfo_list)
{

  mp_cborWriter->append("target_fasta_files");
  mp_cborWriter->startArray();
  for(auto &fasta_file : fasta_fileinfo_list)
    {
      mp_cborWriter->append(fasta_file.absoluteFilePath());
    }
  mp_cborWriter->endArray();
}

pappso::cbor::CborStreamWriter *
PeptidOmsCborOutput::getScanCborWriter()
{
  return mpa_bufferWriterAfterProteinMap;
}

pappso::cbor::psm::PsmProteinMap &
PeptidOmsCborOutput::getPsmProteinMap()
{
  return m_psmProteinMap;
}
