/**
 * \file core/onescanprocessproteinmatcher.h
 * \date 08/10/2025
 * \author Olivier Langella
 * \brief Running protein matcher on one scan
 */


/*
 * PeptidOMS, Spectra to protein alignment tool
 * Copyright (C) 2025  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include <pappsomspp/core/massspectrum/qualifiedmassspectrum.h>
#include <pappsomspp/core/processing/cbor/cborstreamwriter.h>
#include <pappsomspp/core/processing/cbor/psm/psmproteinmap.h>

#pragma once

class RunningProteinMatcher;
/**
 * @todo write docs
 */
class OneScanProcessProteinMatcher
{
  public:
  /**
   * Default constructor
   */
  OneScanProcessProteinMatcher(
    RunningProteinMatcher *parent_p,
    pappso::QualifiedMassSpectrumCstSPtr qualified_mass_spectrum);


  OneScanProcessProteinMatcher(const OneScanProcessProteinMatcher &other);

  /**
   * Destructor
   */
  virtual ~OneScanProcessProteinMatcher();


  const pappso::QualifiedMassSpectrum &getQualifiedMassSpectrum() const;

  void process();


  /** @brief writes best PSMs
   *
   * writes only best best PSM scores in output and reduce protein map
   *
   */
  void writeCborStream(pappso::cbor::CborStreamWriter *p_writer,
                       std::size_t max_psm);


  void fillProteinMap(pappso::cbor::psm::PsmProteinMap &protein_map) const;
  private:
  struct OnePeptideResult
  {
    std::map<QString, QCborArray> map_protein2positions;
    QCborMap psm_eval;
  };
  void storeMatch(pappso::ProteinSp &protein_sp,
                  const std::vector<double> &convolution_score);

  private:
  RunningProteinMatcher *mp_parent;
  pappso::QualifiedMassSpectrumCstSPtr msp_qualifiedMassSpectrum;

  std::map<QString, OnePeptideResult> m_onePeptideResultMap;

  pappso::cbor::psm::PsmProteinMap m_proteinMap;


  std::vector<double> m_massDeltaList;

  std::vector<uint32_t> m_shortPeptideCodeList;
};
