Folders=c(
  "/Old_version",
  "/DynamicRangeFilter",
  "/HighPassFilter",
  "/DeisotopingFilter",
  "/UpFilter",
  "/WindowFilter",
  "/ParentFilter"
)

Folders=c(
  "/Old_Version",
  "/DeisotopingFilter_1",
  "/HighPassFilter_10000",
  "/Low",
  "/Low_WindowFilter",
  "/Parent_Plus_Dynamic"
)

Folders=c(
  "/Old_Version"
)

name = c(
  "Old",
  "Dynamic",
  "HighPass",
  "Deiso",
  "Up",
  "Window",
  "Parent"
)

name = c(
  "Old",
  "Deiso 1",
  "HighPass",
  "Low 150",
  "Low + Win",
  "Parent + Dyna"
)

name = c(
  "Old"
)

mgfs = c(
  "b1906_293T_proteinID_01A_QE3_122212",
  "b1922_293T_proteinID_02A_QE3_122212"
#  "b1923_293T_proteinID_03A_QE3_122212",
#  "b1924_293T_proteinID_04A_QE3_122212",
#  "b1925_293T_proteinID_05A_QE3_122212",
#  "b1926_293T_proteinID_06A_QE3_122212",
#  "b1927_293T_proteinID_07A_QE3_122212",
#  "b1928_293T_proteinID_08A_QE3_122212",
#  "b1929_293T_proteinID_09A_QE3_122212",
#  "b1930_293T_proteinID_10A_QE3_122212",
#  "b1931_293T_proteinID_11A_QE3_122212",
#  "b1932_293T_proteinID_12A_QE3_122212"
  
)

calc = function(i, f, n, res){
  file = paste(as.character(i), "/results.csv",sep=f)
  folder = paste("C:/Users/Alexandre/Desktop/git_repos/SpecOMS/deepprot/test/testFilters/",file,sep="")
  
  data <- read.csv(folder, sep=";", header = T)
  
  shmass = data$sharedMassesAfterSpecFit
  
  data = data[order(-shmass),]
  
  for(i in seq(max(shmass),min(shmass))){
    
    d = data[which(data$sharedMassesAfterSpecFit>=i),]
    
    Cible = length(which(d$proteinsOrigin=="Contaminant")) + 
            length(which(d$proteinsOrigin=="Target")) + 
            length(which(d$proteinsOrigin=="Contaminant and Target"))
    Miss =  length(which(d$proteinsOrigin=="Decoy")) +
            length(which(d$proteinsOrigin=="Multiple"))
    
    total = Cible + Miss 
    
    if((Miss*100)/total > 1){
      
      d = data[which(data$sharedMassesAfterSpecFit>=(i+1)),]

      Cible = length(which(d$proteinsOrigin=="Contaminant")) + 
              length(which(d$proteinsOrigin=="Target")) + 
              length(which(d$proteinsOrigin=="Contaminant and Target"))
      Miss =  length(which(d$proteinsOrigin=="Decoy")) +
              length(which(d$proteinsOrigin=="Multiple"))
      
      r = cbind(Cible,Miss,i+1)
      
      rownames(r) = n
      colnames(r) = c("Cont and target", "Miss", "FDR")
      res = rbind(res, r)
      
      return(res)
      
    }
    
  }
  
}

























results = list()
for(i in seq(1,12)){
  res = c()  
  for(j in seq(length(Folders))){
    try((res = calc(i, Folders[j], name[j], res)))
    print(res)
  }
  results[[i]] = as.matrix(res)
}
results





#pdf("C:/Users/Alexandre/Desktop/git_repos/SpecOMS/deepprot/test/testFilters/test.pdf")
#layout(mat = matrix(c(1,1,2,2,3,3,4,4,0,5,5,6,6,7,7,0), nrow = 2, byrow = TRUE))
#layout.show(n = 5)

par(mfrow=c(1,1))
par(mar=c(10.5, 2, 5.1, 2.1))

cpt = 1
par(oma = c(0, 0, 2, 0))
for(m in results){
   for(i in name){
     
     pvalue = "red"
     
     if( i == "Old"){
       old = m[i,1:2]
    
       xx = barplot(m[i,1:2], 
             ylim = c(0,max(m)+500),
             ylab = "number of occurences",
             col = c("green","red"),
             las = 3,
             cex.names = 1.5
           ) 

        mtext(side=3, line=2, at=-0.05, adj=0, cex=1.15, i)
        mtext(side=3,
              line=1,
              at=-0.1,
              adj=0,
              cex=0.7,
              paste("FDR = ",
                    min(m[i,3]),
                    sep=""
              )
        )

     } else{

       
         xx = barplot(m[i,1:2], 
                 ylim = c(0,max(m)+500),
                 col = c("green","red"),
                 las = 3,
                 yaxt = 'n',
                 cex.names = 1.5
        )

         mtext(side=3, line=2, at=-0.05, adj=0, cex=1.15, i)
         mtext(side=3,
               line=1,
               at=-0.1,
               adj=0,
               cex=0.7,
               paste("FDR = ",
                     min(m[i,3]),
                     sep=""
                     )
               )
         
     }
     text(x = xx, y = m[i,1:2], label = m[i,1:2], pos = 2, cex = 1.6, col = "black", srt = 270)
     if( i == "Parent" ){
        mtext(mgfs[cpt], outer = TRUE, cex = 1.3)
     }
   }
  cpt = cpt + 1
}

#dev.off()


