#!/usr/bin/env Rscript
args = commandArgs(trailingOnly=TRUE)

if (length(args)==0) {
  stop("At least one argument must be supplied (input file).n", call.=FALSE)
}

result_file <- args[1]

data <- read.csv(result_file, sep=";", header = T)
paste('total: ', length(data$proteinsOrigin), sep = "")
paste('decoy: ', length(which(data$proteinsOrigin=="Decoy")), sep = "")


countThreshold <- function (result_data, number_min) {

    res <- matrix(,0,4) 
   
    
    
    shmass = data$sharedMassesAfterSpecFit
  
  
    for(i in seq(max(shmass),min(shmass))){
        d = result_data[which(result_data$sharedMassesAfterSpecFit>=i),]
        total <- length(d$proteinsOrigin)
        decoy <- length(which(d$proteinsOrigin=="Decoy"))
        
        res <- rbind (res,c(total,decoy,i, decoy/total*100))
    }
      
    colnames(res) = c("Total", "Decoy", "peaks", "FDR")
    return(res)
}

print ( countThreshold(data, 15))
