#!/usr/bin/env Rscript
args = commandArgs(trailingOnly=TRUE)

if (length(args)==0) {
  stop("At least one argument must be supplied (input file).n", call.=FALSE)
}

result_file <- args[1]

data <- read.csv(result_file, sep="\t", header = T, dec =".")
#data <- read.csv("./eme_mc_decoy.csv", sep="\t", header = T, dec =",")


paste('total: ', length(data$mass.delta), sep = "")
paste('decoy: ', length(which(data$presence.in.target.database=="decoy")), sep = "")


countThreshold <- function (result_data) {
  
  res <- matrix(,0,4) 
  
  shmass = data$score.after.specfit
  
  
  for(i in seq(max(shmass),min(shmass))){
    d = result_data[which((result_data$score.after.specfit>=i)),]
    total <- length(d$mass.delta)
    decoy <- length(which(d$presence.in.target.database=="decoy"))
    
    res <- rbind (res,c(total,decoy,i, decoy/total*100))
  }
  
  colnames(res) = c("Total", "Decoy", "peaks", "FDR")
  return(as.data.frame(res))
}

selectFdr <- function (count_matrix, FDR_threshold) {
   only_good <- count_matrix[which(count_matrix$FDR < FDR_threshold),]
   return (only_good[which.min(only_good$peaks),])
}

print (" tout")
print ( countThreshold(data))


result_data_negative_delta <- data[which((data$mass.delta < 0) & (data$candidate.status != "zero_mass_delta")),]

  print (" delta < 0")
  count <- countThreshold(result_data_negative_delta)
  
print ("delta < 0, with FDR < 1%")
count <- countThreshold(result_data_negative_delta)
print ( count)

fdr_ok <- selectFdr(count, 1);
total <- fdr_ok$Total
decoy <- fdr_ok$Decoy
print (fdr_ok)
  
result_data_no_delta <- data[which(data$candidate.status == "zero_mass_delta"),]

    print (" delta == 0")
    count <- countThreshold(result_data_no_delta)
    print ( count)
   
print ("delta == 0, with FDR < 1%")
fdr_ok <- selectFdr(count, 1);
total <- total + fdr_ok$Total
decoy <- decoy + fdr_ok$Decoy
print (fdr_ok)

result_data_positive_delta <- data[which((data$mass.delta > 0) & (data$candidate.status != "zero_mass_delta")),]

  print (" delta > 0")
  count <- countThreshold(result_data_positive_delta)
  print (count)

print ("delta > 0, with FDR < 1%")
fdr_ok <- selectFdr(count, 1);
total <- total + fdr_ok$Total
decoy <- decoy + fdr_ok$Decoy
print (fdr_ok)

print (paste("Total 1% =", total))
print (paste("Decoy 1% =", decoy))
print (paste("Final FDR =", decoy/total*100))
print (paste("assignment % =", total / length(data$mass.delta) * 100))


library(plotly)

  d = data[which((data$score.after.specfit>=10) ),]
  d$mass.delta <- as.numeric(d$mass.delta)
  
  d = d[order(d$mass.delta),]
  d$num <- sequence(length(d$mass.delta))
p <- ggplot(d, aes(num, mass.delta)) +
  geom_line() +  # default is 2
  theme_grey(base_size=10)  # default is 12

pzoom <- ggplot(d, aes(num, mass.delta)) +
  geom_line() +  # default is 2
  theme_grey(base_size=10) + # default is 12
  xlim(4100, 4800) +
  ylim (-10, 490)


ggplot(d, aes(num, mass.delta)) +
  geom_line() +  # default is 2
  theme_grey(base_size=10) + # default is 12
  xlim(4100, 4560) +
  ylim (-10, 200)

#pdf(file = "../images/distribution_delta.pdf")
ggplotly(p)
#dev.off()

#ggsave("../images/distribution_delta.pdf", p, width = 30, height = 5)
