/**
 * \file output/psmcboroutput.h
 * \date 27/06/2026
 * \author Olivier Langella
 * \brief write psm in a simple cbor file
 */

/*******************************************************************************
 * Copyright (c) 2026 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of SpecOMS.
 *
 *     SpecOMS is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     SpecOMS is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with SpecOMS.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once

#include "outputinterface.h"
#include <QFile>
#include <QBuffer>
#include <pappsomspp/core/processing/cbor/cborstreamwriter.h>
#include <pappsomspp/core/processing/cbor/psm/psmproteinmap.h>
/**
 * @todo write docs
 */
class PsmCborOutput : public OutputInterface
{
  public:
  /**
   * Default constructor
   */
  PsmCborOutput(const QString &outputFileStr);

  /**
   * Destructor
   */
  virtual ~PsmCborOutput();


  virtual void
  setMsRunReaderSPtr(pappso::MsRunReaderSPtr msrun_reader) override;
  virtual void
  setDeepProtParams(const DeepProtParams &deepprot_params) override;
  virtual void close() override;

  virtual void
  setPeptideDatabaseSPtr(PeptideDatabaseSPtr &peptide_database) override;


  virtual void writePeptideCandidateList(
    const pappso::QualifiedMassSpectrum &experimental_spectrum_int,
    const std::vector<OutputPeptideCandidateStruct> &peptide_candidate_list,
    pappso::DeepProtMatchType match_type) override;

  private:
  void writeSampleHeader(
    pappso::cbor::CborStreamWriter *p_writer,
    const pappso::QualifiedMassSpectrum &experimental_spectrum_int);
  void writePeptideCandidate(
    pappso::cbor::CborStreamWriter *p_writer,
    const pappso::QualifiedMassSpectrum &experimental_spectrum_int,
    std::size_t candidate_size,
    const OutputPeptideCandidateStruct &speptide_candidate,
    pappso::DeepProtMatchType match_type);


  void writeSpecGlobEval(
    pappso::cbor::CborStreamWriter *p_writer,
    const pappso::QualifiedMassSpectrum &experimental_spectrum_int,
    const OutputPeptideCandidateStruct &speptide_candidate);

  private:
  QFile mpa_file;
  pappso::cbor::CborStreamWriter *mpa_writer = nullptr;
  bool m_headerOk                            = false;
  bool m_isSpecGlob                          = true;
  PeptideDatabaseSPtr msp_peptideDatabase    = nullptr;
  pappso::MsRunReaderSPtr msp_msrunReader    = nullptr;
  const DeepProtParams *mp_deepProtParams    = nullptr;
  pappso::MassSpectrumSPtr msp_realSpectrum  = nullptr;
  pappso::cbor::psm::PsmProteinMap m_psmProteinMap;
  QBuffer *mpa_buffer                              = nullptr;
  pappso::cbor::CborStreamWriter *mpa_bufferWriter = nullptr;
  QMutex m_mutex;
};

