/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.xxindex;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.XmlElementExtractor;
import psidev.psi.tools.xxindex.index.IndexElement;

@Deprecated
public class SimpleXmlElementExtractor
implements XmlElementExtractor {
    private static final Logger log = LoggerFactory.getLogger(SimpleXmlElementExtractor.class);
    protected static final Pattern xmlHeader = Pattern.compile(".*<\\?xml.+\\?>.*", 32);
    protected static final Pattern xmlEnc = Pattern.compile(".*encoding\\s*=\\s*[\"']([A-Za-z]([A-Za-z0-9._]|[-])*)[\"'](.*)", 32);
    private boolean useSystemDefaultEncoding;
    private Charset encoding;

    public SimpleXmlElementExtractor() {
        this.setUseSystemDefaultEncoding(false);
        this.setEncoding(Charset.forName("ASCII"));
    }

    public SimpleXmlElementExtractor(Charset encoding) {
        this();
        this.setEncoding(encoding);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    @Override
    public int setEncoding(String encoding) {
        int result;
        try {
            this.encoding = Charset.forName(encoding);
            result = 0;
        }
        catch (IllegalCharsetNameException icne) {
            log.error("Illegal encoding: " + encoding, (Throwable)icne);
            result = -1;
        }
        catch (UnsupportedCharsetException ucne) {
            log.error("Unsupported encoding: " + encoding, (Throwable)ucne);
            result = -2;
        }
        return result;
    }

    public boolean isUseSystemDefaultEncoding() {
        return this.useSystemDefaultEncoding;
    }

    public void setUseSystemDefaultEncoding(boolean useSystemDefaultEncoding) {
        this.useSystemDefaultEncoding = useSystemDefaultEncoding;
    }

    public String readString(IndexElement br, File file) throws IOException {
        return this.readString(br.getStart(), br.getStop(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes(long from, long to, File file) throws IOException {
        byte[] bytes;
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(file, "r");
            raf.seek(from);
            Long length = to - from;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Can not read more than 2147483647 bytes!");
            }
            bytes = new byte[length.intValue()];
            raf.read(bytes, 0, length.intValue());
        }
        return bytes;
    }

    @Override
    public String readString(long from, long to, File file) throws IOException {
        byte[] bytes = this.readBytes(from, to, file);
        byte[] newBytes = this.removeZeroBytes(bytes);
        return this.bytes2String(newBytes);
    }

    @Override
    public String detectFileEncoding(URL fileLocation) throws IOException {
        return this.detectFileEncoding(fileLocation, 1000);
    }

    @Override
    public String detectFileEncoding(URL fileLocation, int maxReadLength) throws IOException {
        InputStream in = fileLocation.openStream();
        int length = in.available();
        byte[] bytes = length > maxReadLength ? new byte[maxReadLength] : new byte[length];
        in.read(bytes);
        in.close();
        String fileStart = new String(bytes, "ASCII");
        Matcher mHead = xmlHeader.matcher(fileStart);
        if (!mHead.matches()) {
            log.debug("No XML header found for input: " + fileLocation);
            return null;
        }
        Matcher mEnc = xmlEnc.matcher(fileStart);
        if (!mEnc.matches()) {
            return null;
        }
        if (mEnc.groupCount() < 1) {
            return null;
        }
        String charsetName = mEnc.group(1);
        log.debug("Detected charset " + charsetName + " for input: " + fileLocation);
        return charsetName;
    }

    public byte[] removeZeroBytes(byte[] bytes) {
        byte[] result;
        byte[] temp = new byte[bytes.length];
        int count = 0;
        for (byte aByte : bytes) {
            if (aByte == 0) continue;
            temp[count] = aByte;
            ++count;
        }
        if (count != bytes.length) {
            result = new byte[count];
            System.arraycopy(temp, 0, result, 0, count);
        } else {
            result = temp;
        }
        return result;
    }

    public String bytes2String(byte[] bytes) throws UnsupportedEncodingException {
        if (this.isUseSystemDefaultEncoding()) {
            if (log.isDebugEnabled()) {
                log.info("Using system default for encoding.");
            }
            return new String(bytes);
        }
        if (this.getEncoding() == null) {
            throw new IllegalStateException("No character encoding available to convert the byte array!");
        }
        return new String(bytes, this.getEncoding().name());
    }
}

