/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.apl_parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.tools.apl_parser.model.PeakList;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;

public class AplFile
implements JMzReader {
    public static final Logger logger = LoggerFactory.getLogger(AplFile.class);
    public static final Pattern attributePattern = Pattern.compile("(\\w+)=(.*)\\s*");
    private File sourceFile;
    private List<IndexElement> index = new ArrayList<IndexElement>();
    private HashMap<Integer, PeakList> peakLists;
    private boolean useCache = false;

    public String getFormat() {
        return "Andromeda peaklist file";
    }

    public static Spectrum getIndexedSpectrum(File sourcefile, IndexElement indexElement) throws JMzReaderException {
        if (sourcefile == null) {
            throw new JMzReaderException("Required parameter sourcefile must not be null.");
        }
        if (indexElement == null) {
            throw new JMzReaderException("Required parameter indexElement must not be null.");
        }
        return AplFile.loadIndexedQueryFromFile(sourcefile, indexElement, 1);
    }

    public AplFile() {
    }

    public AplFile(File file) throws JMzReaderException {
        try {
            String line;
            this.sourceFile = file;
            String path = file.getAbsolutePath();
            BufferedRandomAccessFile braf = new BufferedRandomAccessFile(path, "r", 102400);
            boolean inMs2 = false;
            long lastPosition = 0L;
            long beginIonsIndex = 0L;
            while ((line = braf.getNextLine()) != null) {
                if (line.length() < 1) {
                    lastPosition = braf.getFilePointer();
                    continue;
                }
                if (!inMs2 && line.contains("peaklist start")) {
                    beginIonsIndex = lastPosition;
                    inMs2 = true;
                }
                if (inMs2 && line.contains("peaklist end")) {
                    inMs2 = false;
                    int size = (int)(braf.getFilePointer() - beginIonsIndex);
                    this.index.add(new IndexElementImpl(beginIonsIndex, size));
                    lastPosition = braf.getFilePointer();
                    continue;
                }
                lastPosition = braf.getFilePointer();
            }
            this.peakLists = new HashMap(this.index.size());
            braf.close();
        }
        catch (FileNotFoundException e) {
            throw new JMzReaderException("APLFile does not exist.", e);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from APL file.", e);
        }
    }

    public AplFile(File file, List<IndexElement> index) throws JMzReaderException {
        try {
            String line;
            this.sourceFile = file;
            this.index = index;
            BufferedRandomAccessFile reader = new BufferedRandomAccessFile(this.sourceFile, "r", 1024000);
            while (!((line = reader.getNextLine()) == null || line.length() >= 1 && line.contains("peaklist start"))) {
            }
            this.peakLists = new HashMap();
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw new JMzReaderException("AplFile does not exist.", e);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from APL file.", e);
        }
    }

    public void setPeakLists(List<PeakList> peakLists) {
        this.sourceFile = null;
        this.index.clear();
        for (int index = 0; index < peakLists.size(); ++index) {
            this.peakLists.put(index, peakLists.get(index));
        }
    }

    public int getPeakListCount() {
        return this.sourceFile != null ? this.index.size() : this.peakLists.size();
    }

    public PeakList getPeakList(int nIndex) throws JMzReaderException {
        if (this.peakLists.containsKey(nIndex)) {
            return this.peakLists.get(nIndex);
        }
        if (this.sourceFile == null) {
            throw new JMzReaderException("MS2 query with index " + (nIndex + 1) + " does not exist");
        }
        if (nIndex < 0 || nIndex > this.index.size() - 1) {
            throw new JMzReaderException("MS2 query with index " + (nIndex + 1) + " does not exist in the APL file");
        }
        PeakList query = this.loadIndexedQueryFromFile(nIndex);
        if (this.useCache) {
            this.peakLists.put(nIndex, query);
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PeakList loadIndexedQueryFromFile(File file, IndexElement indexElement, int index) throws JMzReaderException {
        try (RandomAccessFile accFile = new RandomAccessFile(file, "r");){
            byte[] byteBuffer = new byte[indexElement.getSize()];
            accFile.seek(indexElement.getStart());
            accFile.read(byteBuffer);
            String ms2Buffer = new String(byteBuffer);
            PeakList peakList = new PeakList(ms2Buffer, index);
            return peakList;
        }
        catch (FileNotFoundException e) {
            throw new JMzReaderException("APL file could not be found.", e);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from APL file", e);
        }
    }

    private PeakList loadIndexedQueryFromFile(int nQueryIndex) throws JMzReaderException {
        if (nQueryIndex < 0 || nQueryIndex > this.index.size() - 1) {
            throw new JMzReaderException("Tried to load non existing query from file");
        }
        IndexElement indexElement = this.index.get(nQueryIndex);
        return AplFile.loadIndexedQueryFromFile(this.sourceFile, indexElement, nQueryIndex + 1);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        Integer index = 0;
        while (index < 1000000) {
            if (this.peakLists.containsKey(index)) {
                string.append(this.peakLists.get(index).toString()).append('\n');
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return string.toString();
    }

    public PeakListIterator getPeakListIterator() {
        return new PeakListIterator();
    }

    public List<IndexElement> getIndex() {
        return new ArrayList<IndexElement>(this.index);
    }

    @Override
    public int getSpectraCount() {
        return this.getPeakListCount();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return false;
    }

    @Override
    public List<String> getSpectraIds() {
        ArrayList<String> ids = new ArrayList<String>(this.getPeakListCount());
        for (int id = 1; id <= this.getPeakListCount(); ++id) {
            ids.add(Integer.toString(id));
        }
        return ids;
    }

    @Override
    public Spectrum getSpectrumById(String id) throws JMzReaderException {
        int index = Integer.parseInt(id);
        return this.getPeakList(index - 1);
    }

    @Override
    public Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        return this.getPeakList(index - 1);
    }

    @Override
    public Iterator<Spectrum> getSpectrumIterator() {
        return new SpectrumIterator();
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        if (msLevel != 2) {
            return Collections.emptyList();
        }
        return new ArrayList<IndexElement>(this.index);
    }

    @Override
    public List<Integer> getMsLevels() {
        ArrayList<Integer> msLevels = new ArrayList<Integer>(1);
        msLevels.add(2);
        return msLevels;
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        HashMap<String, IndexElement> idToIndexMap = new HashMap<String, IndexElement>(this.index.size());
        for (int i = 0; i < this.index.size(); ++i) {
            idToIndexMap.put(String.format("%d", i + 1), this.index.get(i));
        }
        return idToIndexMap;
    }

    public class PeakListIterator
    implements Iterator<PeakList>,
    Iterable<PeakList> {
        private Integer currentPosition = 0;
        private ArrayList<Integer> keys = new ArrayList(AplFile.access$000(AplFile.this).keySet());

        @Override
        public Iterator<PeakList> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (AplFile.this.sourceFile == null) {
                return this.currentPosition < this.keys.size();
            }
            return this.currentPosition < AplFile.this.index.size();
        }

        @Override
        public PeakList next() {
            if (AplFile.this.sourceFile == null) {
                if (this.currentPosition < 0 || this.currentPosition >= this.keys.size()) {
                    throw new IllegalStateException(new IndexOutOfBoundsException());
                }
                Integer n = this.currentPosition;
                Integer n2 = this.currentPosition = Integer.valueOf(this.currentPosition + 1);
                Integer key = this.keys.get(n);
                if (!AplFile.this.peakLists.containsKey(key)) {
                    throw new IllegalStateException("Key not found in hashmap");
                }
                return (PeakList)AplFile.this.peakLists.get(key);
            }
            if (AplFile.this.peakLists.containsKey(this.currentPosition)) {
                return (PeakList)AplFile.this.peakLists.get(this.currentPosition);
            }
            try {
                PeakList query = AplFile.this.loadIndexedQueryFromFile(this.currentPosition);
                if (AplFile.this.useCache) {
                    AplFile.this.peakLists.put(this.currentPosition, query);
                }
                Integer n = this.currentPosition;
                Integer n3 = this.currentPosition = Integer.valueOf(this.currentPosition + 1);
                return query;
            }
            catch (JMzReaderException e) {
                throw new RuntimeException("Failed to load query from file.", e);
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Function not supported");
        }
    }

    private class SpectrumIterator
    implements Iterator<Spectrum> {
        Iterator<PeakList> it;

        public SpectrumIterator() {
            this.it = new PeakListIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Spectrum next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

