/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.ms2_parser;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.ms2_parser.model.Ms2Spectrum;

public class Ms2File
implements JMzReader {
    private File sourcefile;
    private List<IndexElement> index;
    private HashMap<String, String> header;

    public Ms2File(File sourcefile) throws JMzReaderException {
        this.sourcefile = sourcefile;
        this.indexFile();
    }

    public static Spectrum getIndexedSpectrum(File sourcefile, IndexElement indexElement) throws JMzReaderException {
        if (sourcefile == null) {
            throw new JMzReaderException("Invalid sourcefile parameter passed.");
        }
        if (indexElement == null) {
            throw new JMzReaderException("Required parameter indexElement missing.");
        }
        return Ms2File.readIndexSpectrumFromFile(sourcefile, indexElement, 0);
    }

    private void indexFile() throws JMzReaderException {
        this.index = new ArrayList<IndexElement>();
        this.header = new HashMap();
        try {
            String line;
            BufferedRandomAccessFile reader = new BufferedRandomAccessFile(this.sourcefile, "r", 1024000);
            Long lineOffset = 0L;
            Long lastSpecOffset = null;
            boolean inHeader = true;
            while ((line = reader.getNextLine()) != null) {
                if (inHeader && !line.startsWith("H")) {
                    inHeader = false;
                }
                if (inHeader) {
                    String[] fields = line.split("\t");
                    if (fields.length < 2 || fields.length > 3) {
                        throw new JMzReaderException("Invalid header line encountered: '" + line + '\'');
                    }
                    if (this.header.containsKey(fields[1])) {
                        int nNumber = 1;
                        while (this.header.containsKey(fields[1] + '_' + nNumber)) {
                            ++nNumber;
                        }
                        fields[1] = fields[1] + '_' + nNumber;
                    }
                    this.header.put(fields[1], fields.length == 3 ? fields[2] : "");
                }
                if (!inHeader && line.startsWith("S")) {
                    if (lastSpecOffset != null) {
                        int size = (int)(lineOffset - lastSpecOffset);
                        this.index.add(new IndexElementImpl(lastSpecOffset, size));
                    }
                    lastSpecOffset = lineOffset;
                }
                lineOffset = reader.getFilePointer();
            }
            if (lastSpecOffset != null) {
                int size = (int)(lineOffset - lastSpecOffset);
                this.index.add(new IndexElementImpl(lastSpecOffset, size));
            }
            reader.close();
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from file.", e);
        }
    }

    public HashMap<String, String> getHeader() {
        return this.header;
    }

    @Override
    public int getSpectraCount() {
        return this.index.size();
    }

    public String getCreationDate() {
        return this.header.get("CreationDate");
    }

    public String getExtractor() {
        return this.header.get("Extractor");
    }

    public String getExtractorVersion() {
        return this.header.get("ExtractorVersion");
    }

    public String getExtractorOptions() {
        return this.header.get("ExtractorOptions");
    }

    public Ms2Spectrum getSpectrum(int nIndex) throws JMzReaderException {
        return this.readSpectrumFromFile(nIndex - 1);
    }

    private Ms2Spectrum readSpectrumFromFile(int specIndex) throws JMzReaderException {
        if (specIndex < 0 || specIndex >= this.index.size()) {
            throw new JMzReaderException("Invalid spectrum index passed.");
        }
        IndexElement indexElement = this.index.get(specIndex);
        return Ms2File.readIndexSpectrumFromFile(this.sourcefile, indexElement, specIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Ms2Spectrum readIndexSpectrumFromFile(File file, IndexElement indexElement, int specIndex) throws JMzReaderException {
        if (indexElement == null) {
            throw new JMzReaderException("Invalid spectrum index passed.");
        }
        try (RandomAccessFile inputFile = new RandomAccessFile(file, "r");){
            inputFile.seek(indexElement.getStart());
            byte[] bytes = new byte[indexElement.getSize()];
            inputFile.read(bytes);
            String spectrum = new String(bytes);
            Ms2Spectrum ms2Spectrum = new Ms2Spectrum(spectrum, specIndex + 1);
            return ms2Spectrum;
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from file.", e);
        }
    }

    public Iterator<Ms2Spectrum> getMs2SpectrumIterator() {
        return new Ms2FileSpectrumIterator();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return false;
    }

    @Override
    public List<String> getSpectraIds() {
        ArrayList<String> ids = new ArrayList<String>(this.getSpectraCount());
        for (int id = 1; id <= this.getSpectraCount(); ++id) {
            ids.add(Integer.toString(id));
        }
        return ids;
    }

    @Override
    public Spectrum getSpectrumById(String id) throws JMzReaderException {
        int index = Integer.parseInt(id);
        return this.getSpectrum(index);
    }

    @Override
    public Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        return this.getSpectrum(index);
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        if (msLevel != 2) {
            return Collections.emptyList();
        }
        return new ArrayList<IndexElement>(this.index);
    }

    @Override
    public List<Integer> getMsLevels() {
        ArrayList<Integer> msLevels = new ArrayList<Integer>(2);
        msLevels.add(2);
        return msLevels;
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        HashMap<String, IndexElement> idToIndexMap = new HashMap<String, IndexElement>(this.index.size());
        for (int i = 1; i <= this.index.size(); ++i) {
            idToIndexMap.put(Integer.toString(i), this.index.get(i - 1));
        }
        return idToIndexMap;
    }

    @Override
    public Iterator<Spectrum> getSpectrumIterator() {
        return new SpectrumIterator();
    }

    private class Ms2FileSpectrumIterator
    implements Iterator<Ms2Spectrum>,
    Iterable<Ms2Spectrum> {
        int nCurrentSpectrum = 0;

        @Override
        public Iterator<Ms2Spectrum> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.nCurrentSpectrum < Ms2File.this.index.size();
        }

        @Override
        public Ms2Spectrum next() {
            try {
                return Ms2File.this.readSpectrumFromFile(this.nCurrentSpectrum++);
            }
            catch (JMzReaderException e) {
                throw new IllegalStateException("Failed to parse spectrum.", e);
            }
        }

        @Override
        public void remove() {
        }
    }

    private class SpectrumIterator
    implements Iterator<Spectrum> {
        private Ms2FileSpectrumIterator it;

        public SpectrumIterator() {
            this.it = new Ms2FileSpectrumIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Spectrum next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

