/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.pkl_parser;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.pkl_parser.model.PklSpectrum;

public class PklFile
implements JMzReader {
    private File sourceFile;
    private ArrayList<String> filenames;
    private Map<Integer, IndexElement> fileIndex;

    public PklFile(File sourceFile) throws JMzReaderException {
        this.sourceFile = sourceFile;
        if (sourceFile.isDirectory()) {
            this.loadDirectoryIndex();
        } else {
            try {
                this.indexFile();
            }
            catch (IOException e) {
                throw new JMzReaderException("Failed to read from PKL file", e);
            }
        }
    }

    public PklFile(File sourceFile, Map<Integer, IndexElement> fileIndex) throws JMzReaderException {
        if (!sourceFile.isFile()) {
            throw new JMzReaderException("Illegal call to PklFile(File sourceFile, HashMap<Integer, Long> fileIndex): sourceFile must point to a file.");
        }
        this.sourceFile = sourceFile;
        this.fileIndex = fileIndex;
    }

    private void indexFile() throws IOException {
        int size;
        String line;
        BufferedRandomAccessFile reader = new BufferedRandomAccessFile(this.sourceFile, "r", 1024000);
        this.fileIndex = new HashMap<Integer, IndexElement>();
        boolean emptyLineFound = true;
        int currentSpectrum = 1;
        long previousIndex = 0L;
        long offset = 0L;
        while ((line = reader.getNextLine()) != null) {
            if (emptyLineFound && line.trim().length() > 0) {
                offset = previousIndex;
                emptyLineFound = false;
            }
            if (line.trim().length() == 0) {
                if (offset >= 0L && previousIndex > 0L) {
                    size = (int)(previousIndex - offset);
                    this.fileIndex.put(currentSpectrum++, new IndexElementImpl(offset, size));
                }
                offset = -1L;
                emptyLineFound = true;
            }
            previousIndex = reader.getFilePointer();
        }
        if (offset >= 0L && reader.getFilePointer() > offset) {
            size = (int)(previousIndex - offset);
            this.fileIndex.put(currentSpectrum++, new IndexElementImpl(offset, size));
        }
        reader.close();
    }

    private void loadDirectoryIndex() {
        String[] pklFiles = this.sourceFile.list(new PklFileFilter());
        this.filenames = new ArrayList();
        Collections.addAll(this.filenames, pklFiles);
    }

    public static Spectrum getIndexedSpectrum(File sourcefile, IndexElement indexElement) throws JMzReaderException {
        if (sourcefile == null) {
            throw new JMzReaderException("Parameter sourcefile must not be null.");
        }
        if (indexElement == null) {
            throw new JMzReaderException("Parameter indexElement must not be null.");
        }
        String snipplet = PklFile.readSpectrumFromFile(indexElement, sourcefile);
        return new PklSpectrum(snipplet, 1);
    }

    @Override
    public int getSpectraCount() {
        return this.sourceFile.isDirectory() ? this.filenames.size() : this.fileIndex.size();
    }

    public PklSpectrum getSpectrum(Object index) throws JMzReaderException {
        IndexElement indexElement;
        if (this.sourceFile.isDirectory()) {
            if (!(index instanceof String)) {
                throw new JMzReaderException("For PKL file objects representing directories the spectrum index must be a filename");
            }
            File specFile = new File(this.sourceFile.getAbsoluteFile() + File.separator + index);
            return new PklSpectrum(specFile);
        }
        if (!(index instanceof Integer)) {
            index = Integer.parseInt(index.toString());
        }
        if ((indexElement = this.fileIndex.get(index)) == null) {
            throw new JMzReaderException("Spectrum with given index " + index + " does not exist");
        }
        String spec = PklFile.readSpectrumFromFile(indexElement, this.sourceFile);
        return new PklSpectrum(spec, (Integer)index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readSpectrumFromFile(IndexElement indexElement, File sourceFile) throws JMzReaderException {
        try (RandomAccessFile file = new RandomAccessFile(sourceFile, "r");){
            file.seek(indexElement.getStart());
            byte[] buffer = new byte[indexElement.getSize()];
            file.read(buffer);
            String string = new String(buffer);
            return string;
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to read from file", e);
        }
    }

    public Iterator<PklSpectrum> getPklSpectrumIterator() {
        return new PklFileSpectrumIterator();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return true;
    }

    @Override
    public Spectrum getSpectrumById(String id) throws JMzReaderException {
        return this.getSpectrum(id);
    }

    @Override
    public Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        return this.getSpectrum(index);
    }

    @Override
    public Iterator<Spectrum> getSpectrumIterator() {
        return new SpectrumIterator();
    }

    public Map<Integer, IndexElement> getFileIndex() {
        return this.sourceFile.isFile() ? this.fileIndex : null;
    }

    @Override
    public List<String> getSpectraIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.sourceFile.isDirectory()) {
            ids.addAll(this.filenames);
        } else {
            for (int i = 1; i <= this.fileIndex.size(); ++i) {
                ids.add(Integer.toString(i));
            }
        }
        return ids;
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        if (msLevel != 2) {
            return Collections.emptyList();
        }
        ArrayList<IndexElement> index = new ArrayList<IndexElement>(this.fileIndex.size());
        Integer i = 1;
        while (i <= this.fileIndex.size()) {
            if (this.fileIndex.containsKey(i)) {
                index.add(this.fileIndex.get(i));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return index;
    }

    @Override
    public List<Integer> getMsLevels() {
        ArrayList<Integer> msLevels = new ArrayList<Integer>(1);
        msLevels.add(2);
        return msLevels;
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        HashMap<String, IndexElement> idToIndexMap = new HashMap<String, IndexElement>(this.fileIndex.size());
        Integer i = 1;
        while (i <= this.fileIndex.size()) {
            if (this.fileIndex.containsKey(i)) {
                idToIndexMap.put(i.toString(), this.fileIndex.get(i));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return idToIndexMap;
    }

    public class PklFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".pkl");
        }
    }

    private class PklFileSpectrumIterator
    implements Iterator<PklSpectrum>,
    Iterable<PklSpectrum> {
        int currentIndex = 0;

        private PklFileSpectrumIterator() {
        }

        @Override
        public Iterator<PklSpectrum> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (PklFile.this.sourceFile.isDirectory()) {
                return this.currentIndex < PklFile.this.filenames.size();
            }
            return PklFile.this.fileIndex.containsKey(this.currentIndex + 1);
        }

        @Override
        public PklSpectrum next() {
            if (PklFile.this.sourceFile.isDirectory()) {
                String filename = (String)PklFile.this.filenames.get(this.currentIndex++);
                File specFile = new File(PklFile.this.sourceFile.getAbsolutePath() + File.separator + filename);
                try {
                    return new PklSpectrum(specFile);
                }
                catch (JMzReaderException e) {
                    throw new IllegalStateException("Failed to parse pkl spectrum", e);
                }
            }
            IndexElement indexElement = (IndexElement)PklFile.this.fileIndex.get(this.currentIndex++ + 1);
            try {
                String spec = PklFile.readSpectrumFromFile(indexElement, PklFile.this.sourceFile);
                return new PklSpectrum(spec, this.currentIndex);
            }
            catch (JMzReaderException e) {
                throw new IllegalStateException("Failed to parse pkl spectrum", e);
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Objects cannot be removed from PklFileSpectrumIterator.");
        }
    }

    private class SpectrumIterator
    implements Iterator<Spectrum> {
        private PklFileSpectrumIterator it;

        private SpectrumIterator() {
            this.it = new PklFileSpectrumIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Spectrum next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

