/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mzxml_parser;

import java.util.Map;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.CvParam;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.UserParam;
import uk.ac.ebi.pride.tools.mzxml_parser.MzXMLFile;
import uk.ac.ebi.pride.tools.mzxml_parser.MzXMLParsingException;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.Scan;

public class MzXMLSpectrum
implements Spectrum {
    private Long num;
    private Long charge;
    private Double precursorMz;
    private Double precursorIntensity;
    private Map<Double, Double> peakList;
    private ParamGroup paramGroup;
    private Long msLevel;

    public MzXMLSpectrum(Scan scan) throws MzXMLParsingException {
        if (scan.getPeaks().size() != 1) {
            throw new MzXMLParsingException("Multiple peak lists can not be modeled in a mzXMLSpectrum.");
        }
        this.peakList = MzXMLFile.convertPeaksToMap(scan.getPeaks().get(0));
        this.msLevel = scan.getMsLevel();
        this.num = scan.getNum();
        if (scan.getPrecursorMz().size() == 1) {
            this.precursorMz = scan.getPrecursorMz().get(0).getValue();
            this.precursorIntensity = scan.getPrecursorMz().get(0).getPrecursorIntensity();
            this.charge = scan.getPrecursorMz().get(0).getPrecursorCharge();
        }
        this.paramGroup = new ParamGroup();
        if (scan.getPolarity() != null) {
            this.paramGroup.addParam(new CvParam("scan polarity", scan.getPolarity(), "MS", "MS:1000465"));
        }
        if (scan.getScanType() != null) {
            this.paramGroup.addParam(new UserParam("scan type", scan.getScanType()));
        }
        if (scan.getFilterLine() != null) {
            this.paramGroup.addParam(new UserParam("filter line", scan.getFilterLine()));
        }
        if (scan.isCentroided() != null && scan.isCentroided().booleanValue()) {
            this.paramGroup.addParam(new CvParam("centroid spectrum", "true", "MS", "MS:1000127"));
        }
        if (scan.isDeisotoped() != null && scan.isDeisotoped().booleanValue()) {
            this.paramGroup.addParam(new CvParam("deisotoping", "true", "MS", "MS:1000033"));
        }
        if (scan.isChargeDeconvoluted()) {
            this.paramGroup.addParam(new CvParam("charge deconvolution", "true", "MS", "MS:1000034"));
        }
        if (scan.getRetentionTime() != null) {
            this.paramGroup.addParam(new CvParam("retention time", scan.getRetentionTime().toString(), "MS", "MS:1000894"));
        }
        if (scan.getIonisationEnergy() != null) {
            this.paramGroup.addParam(new UserParam("ionisation energy", scan.getIonisationEnergy().toString()));
        }
        if (scan.getCollisionEnergy() != null) {
            this.paramGroup.addParam(new CvParam("collision energy", scan.getCollisionEnergy().toString(), "MS", "MS:1000045"));
        }
        if (scan.getCidGasPressure() != null) {
            this.paramGroup.addParam(new CvParam("collision gas pressure", scan.getCidGasPressure().toString(), "MS", "MS:1000045"));
        }
        if (scan.getTotIonCurrent() != null) {
            this.paramGroup.addParam(new CvParam("total ion current", scan.getTotIonCurrent().toString(), "MS", "MS:1000285"));
        }
    }

    @Override
    public String getId() {
        return this.num.toString();
    }

    @Override
    public Integer getPrecursorCharge() {
        return this.charge != null ? Integer.valueOf(this.charge.intValue()) : null;
    }

    @Override
    public Double getPrecursorMZ() {
        return this.precursorMz;
    }

    @Override
    public Double getPrecursorIntensity() {
        return this.precursorIntensity;
    }

    @Override
    public Map<Double, Double> getPeakList() {
        return this.peakList;
    }

    @Override
    public Integer getMsLevel() {
        return this.msLevel.intValue();
    }

    @Override
    public ParamGroup getAdditional() {
        return this.paramGroup;
    }
}

