/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mzdata_parser.mzdata.unmarshaller;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.MzDataElement;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.MzDataObject;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.unmarshaller.MzDataUnmarshaller;

public class MzDataUnmarshallerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MzDataUnmarshallerFactory.class);
    private static MzDataUnmarshallerFactory instance = new MzDataUnmarshallerFactory();
    private static JAXBContext jc = null;

    private MzDataUnmarshallerFactory() {
    }

    public static MzDataUnmarshallerFactory getInstance() {
        return instance;
    }

    public MzDataUnmarshaller initializeUnmarshaller() {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)"uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model");
            }
            MzDataUnmarshallerImpl pum = new MzDataUnmarshallerImpl();
            logger.debug("Unmarshaller Initialized");
            return pum;
        }
        catch (JAXBException e) {
            logger.error("UnmarshallerFactory.initializeUnmarshaller", (Throwable)e);
            throw new IllegalStateException("Could not initialize unmarshaller", e);
        }
    }

    static /* synthetic */ JAXBContext access$100() {
        return jc;
    }

    private class MzDataUnmarshallerImpl
    implements MzDataUnmarshaller {
        private Unmarshaller unmarshaller = MzDataUnmarshallerFactory.access$100().createUnmarshaller();

        private MzDataUnmarshallerImpl() throws JAXBException {
        }

        @Override
        public synchronized <T extends MzDataObject> T unmarshal(String xmlSnippet, MzDataElement element) throws Exception {
            MzDataObject retval;
            try {
                if (xmlSnippet == null || element == null) {
                    return null;
                }
                JAXBElement holder = this.unmarshaller.unmarshal((Source)new SAXSource(new InputSource(new StringReader(xmlSnippet))), element.getClassType());
                retval = (MzDataObject)holder.getValue();
            }
            catch (JAXBException e) {
                throw new Exception("Error unmarshalling object: " + e.getMessage(), e);
            }
            return (T)retval;
        }
    }
}

