/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mzdata_parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import psidev.psi.tools.xxindex.StandardXpathAccess;
import psidev.psi.tools.xxindex.index.XpathIndex;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.mzdata_parser.MzDataSpectrum;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.CvLookup;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.MzData;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.MzDataElement;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.Spectrum;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.unmarshaller.MzDataUnmarshaller;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.unmarshaller.MzDataUnmarshallerFactory;

public class MzDataFile
implements JMzReader {
    private File sourcefile;
    private RandomAccessFile accessFile;
    private XpathIndex index;
    private StandardXpathAccess xpathAccess;
    private Map<Integer, List<psidev.psi.tools.xxindex.index.IndexElement>> msNScans;
    private List<String> spectraIds;
    private HashMap<String, String> mzDataAttributes;
    private static final Pattern xmlAttributePattern = Pattern.compile("(\\w+)=\"([^\"]*)\"");
    private Map<Integer, psidev.psi.tools.xxindex.index.IndexElement> idToIndexElementMap;
    MzDataUnmarshaller unmarshaller;

    public MzDataFile(File sourcefile) throws JMzReaderException {
        this.sourcefile = sourcefile;
        this.indexFile();
        this.unmarshaller = MzDataUnmarshallerFactory.getInstance().initializeUnmarshaller();
        this.readMzDataAttributes();
        this.initializeSpectraMaps();
    }

    public static uk.ac.ebi.pride.tools.jmzreader.model.Spectrum getIndexedSpectrum(File sourcefile, IndexElement indexElement) throws JMzReaderException {
        try {
            RandomAccessFile accessFile = new RandomAccessFile(sourcefile, "r");
            byte[] buffer = new byte[indexElement.getSize()];
            accessFile.seek(indexElement.getStart());
            accessFile.read(buffer);
            String snipplet = new String(buffer);
            MzDataUnmarshaller unmarshaller = MzDataUnmarshallerFactory.getInstance().initializeUnmarshaller();
            Spectrum mzDataSpectrum = (Spectrum)unmarshaller.unmarshal(snipplet, MzDataElement.SPECTRUM);
            return new MzDataSpectrum(mzDataSpectrum);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from mzData file.", e);
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to unmarshal mzData spectrum object.", e);
        }
    }

    private void initializeSpectraMaps() throws JMzReaderException {
        List spectra = this.index.getElements(MzDataElement.SPECTRUM.getXpath());
        this.idToIndexElementMap = new HashMap<Integer, psidev.psi.tools.xxindex.index.IndexElement>(spectra.size());
        this.spectraIds = new ArrayList<String>(spectra.size());
        this.msNScans = new HashMap<Integer, List<psidev.psi.tools.xxindex.index.IndexElement>>(spectra.size());
        for (psidev.psi.tools.xxindex.index.IndexElement spectrum : spectra) {
            Map<String, String> attributes = this.readElementAttributes(spectrum);
            int msLevel = this.readSpectrumMsLevel(spectrum);
            if (!attributes.containsKey("id")) {
                throw new JMzReaderException("Spectrum element with missing id attribute at line " + spectrum.getLineNumber());
            }
            this.idToIndexElementMap.put(Integer.parseInt(attributes.get("id")), spectrum);
            this.spectraIds.add(attributes.get("id"));
            if (!this.msNScans.containsKey(msLevel)) {
                this.msNScans.put(msLevel, new ArrayList());
            }
            this.msNScans.get(msLevel).add(spectrum);
        }
    }

    private void readMzDataAttributes() throws JMzReaderException {
        RandomAccessFile access = this.getRandomAccess();
        try {
            String line;
            this.mzDataAttributes = new HashMap();
            access.seek(0L);
            while ((line = access.readLine()) != null && !line.contains("<mzData")) {
            }
            if (line == null) {
                return;
            }
            Matcher matcher = xmlAttributePattern.matcher(line);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                if (name == null || value == null) continue;
                this.mzDataAttributes.put(name, value);
            }
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read mzData file.", e);
        }
    }

    private void indexFile() throws JMzReaderException {
        try {
            this.xpathAccess = new StandardXpathAccess(this.sourcefile, MzDataElement.getXpaths());
            this.index = this.xpathAccess.getIndex();
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to index mzData file.", e);
        }
    }

    private Integer readSpectrumMsLevel(psidev.psi.tools.xxindex.index.IndexElement indexElement) throws JMzReaderException {
        RandomAccessFile access = this.getRandomAccess();
        try {
            access.seek(indexElement.getStart());
            byte[] headerBuffer = new byte[500];
            access.read(headerBuffer);
            String headerString = new String(headerBuffer);
            do {
                int msLevelEnd;
                int msLevelIndex;
                if ((msLevelIndex = headerString.indexOf("msLevel=\"")) <= -1 || (msLevelEnd = headerString.indexOf(34, msLevelIndex + 10)) <= -1) continue;
                return Integer.parseInt(headerString.substring(msLevelIndex + 9, msLevelEnd));
            } while ((long)headerString.length() < indexElement.getStop() - indexElement.getStart());
            return -1;
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read mzData file.", e);
        }
    }

    private Map<String, String> readElementAttributes(psidev.psi.tools.xxindex.index.IndexElement indexElement) throws JMzReaderException {
        RandomAccessFile access = this.getRandomAccess();
        try {
            HashMap<String, String> foundAttributes = new HashMap<String, String>();
            access.seek(indexElement.getStart());
            byte[] headerBuffer = new byte[250];
            access.read(headerBuffer);
            StringBuilder headerString = new StringBuilder(new String(headerBuffer));
            while (!headerString.toString().contains(">")) {
                access.seek(indexElement.getStart() + (long)headerString.length());
                access.read(headerBuffer);
                headerString.append(new String(headerBuffer));
            }
            headerString = new StringBuilder(headerString.toString().replace("\n", ""));
            headerString = new StringBuilder(headerString.substring(0, headerString.toString().indexOf(62) + 1));
            Matcher matcher = xmlAttributePattern.matcher(headerString.toString());
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                if (name == null || value == null) continue;
                foundAttributes.put(name, value);
            }
            return foundAttributes;
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read mzData file.", e);
        }
    }

    private RandomAccessFile getRandomAccess() throws JMzReaderException {
        if (this.accessFile != null) {
            return this.accessFile;
        }
        try {
            this.accessFile = new RandomAccessFile(this.sourcefile, "r");
        }
        catch (FileNotFoundException e) {
            throw new JMzReaderException("Could not find mzData file '" + this.sourcefile.getPath() + '\'', e);
        }
        return this.accessFile;
    }

    public void closeRandomAccess() {
        if (this.accessFile != null) {
            try {
                this.accessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.accessFile = null;
        }
    }

    private String readSnipplet(psidev.psi.tools.xxindex.index.IndexElement indexElement) throws JMzReaderException {
        RandomAccessFile access = this.getRandomAccess();
        int length = (int)(indexElement.getStop() - indexElement.getStart());
        byte[] bytes = new byte[length];
        try {
            access.seek(indexElement.getStart());
            access.read(bytes);
            return new String(bytes);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from mzData file.", e);
        }
    }

    public Map<String, String> getMzDataAttributes() {
        return this.mzDataAttributes;
    }

    public List<CvLookup> getCvLookups() throws JMzReaderException {
        try {
            ArrayList<CvLookup> cvLookups = new ArrayList<CvLookup>();
            List indexElements = this.index.getElements(MzDataElement.CV_LOOKUP.getXpath());
            for (psidev.psi.tools.xxindex.index.IndexElement e : indexElements) {
                String xml = this.readSnipplet(e);
                CvLookup cvLookup = (CvLookup)this.unmarshaller.unmarshal(xml, MzDataElement.CV_LOOKUP);
                cvLookups.add(cvLookup);
            }
            return cvLookups;
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to unmarshall cvLookup object.", e);
        }
    }

    public MzData.Description getDescription() throws JMzReaderException {
        try {
            psidev.psi.tools.xxindex.index.IndexElement indexElement = (psidev.psi.tools.xxindex.index.IndexElement)this.index.getElements(MzDataElement.DESCRIPTION.getXpath()).get(0);
            String xml = this.readSnipplet(indexElement);
            return (MzData.Description)this.unmarshaller.unmarshal(xml, MzDataElement.DESCRIPTION);
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to unmarshall Desription object.", e);
        }
    }

    @Override
    public int getSpectraCount() {
        return this.spectraIds.size();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return false;
    }

    @Override
    public List<String> getSpectraIds() {
        return new ArrayList<String>(this.spectraIds);
    }

    public Spectrum getMzDataSpectrumById(int id) throws JMzReaderException {
        if (!this.idToIndexElementMap.containsKey(id)) {
            throw new JMzReaderException("Spectrum with id '" + id + "' does not exist.");
        }
        psidev.psi.tools.xxindex.index.IndexElement indexElement = this.idToIndexElementMap.get(id);
        if (indexElement == null) {
            throw new JMzReaderException("Failed to resolved id.");
        }
        String xml = this.readSnipplet(indexElement);
        try {
            return (Spectrum)this.unmarshaller.unmarshal(xml, MzDataElement.SPECTRUM);
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to unmarshal spectrum", e);
        }
    }

    @Override
    public uk.ac.ebi.pride.tools.jmzreader.model.Spectrum getSpectrumById(String id) throws JMzReaderException {
        Spectrum mzDataSpectrum = this.getMzDataSpectrumById(Integer.parseInt(id));
        return new MzDataSpectrum(mzDataSpectrum);
    }

    public Spectrum getMzDataSpectrumByIndex(int index) throws JMzReaderException {
        if (index < 1 || index > this.spectraIds.size()) {
            throw new JMzReaderException("Spectrum index " + index + " out of range. " + this.spectraIds.size() + " spectra loaded.");
        }
        String id = this.spectraIds.get(index - 1);
        psidev.psi.tools.xxindex.index.IndexElement indexElement = this.idToIndexElementMap.get(Integer.parseInt(id));
        String xml = this.readSnipplet(indexElement);
        try {
            return (Spectrum)this.unmarshaller.unmarshal(xml, MzDataElement.SPECTRUM);
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to unmarshal spectrum", e);
        }
    }

    @Override
    public uk.ac.ebi.pride.tools.jmzreader.model.Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        Spectrum mzDataSpectrum = this.getMzDataSpectrumByIndex(index);
        return new MzDataSpectrum(mzDataSpectrum);
    }

    @Override
    public Iterator<uk.ac.ebi.pride.tools.jmzreader.model.Spectrum> getSpectrumIterator() {
        return new SpectrumIterator();
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        if (!this.msNScans.containsKey(msLevel)) {
            return Collections.emptyList();
        }
        return this.convertIndexElements(this.msNScans.get(msLevel));
    }

    @Override
    public List<Integer> getMsLevels() {
        return new ArrayList<Integer>(this.msNScans.keySet());
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        HashMap<String, IndexElement> idToIndex = new HashMap<String, IndexElement>(this.idToIndexElementMap.size());
        for (Map.Entry<Integer, psidev.psi.tools.xxindex.index.IndexElement> integerIndexElementEntry : this.idToIndexElementMap.entrySet()) {
            psidev.psi.tools.xxindex.index.IndexElement e = integerIndexElementEntry.getValue();
            int size = (int)(e.getStop() - e.getStart());
            idToIndex.put(integerIndexElementEntry.getKey().toString(), new IndexElementImpl(e.getStart(), size));
        }
        return idToIndex;
    }

    private List<IndexElement> convertIndexElements(List<psidev.psi.tools.xxindex.index.IndexElement> index) {
        ArrayList<IndexElement> convertedIndex = new ArrayList<IndexElement>(index.size());
        for (psidev.psi.tools.xxindex.index.IndexElement e : index) {
            int size = (int)(e.getStop() - e.getStart());
            convertedIndex.add(new IndexElementImpl(e.getStart(), size));
        }
        return convertedIndex;
    }

    public Iterator<Spectrum> getMzDataSpectrumIterator() {
        return new MzDataSpectrumIterator();
    }

    private class MzDataSpectrumIterator
    implements Iterator<Spectrum> {
        private final Iterator<String> idIterator;

        private MzDataSpectrumIterator() {
            this.idIterator = MzDataFile.this.spectraIds.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.idIterator.hasNext();
        }

        @Override
        public Spectrum next() {
            String id = this.idIterator.next();
            psidev.psi.tools.xxindex.index.IndexElement indexElement = (psidev.psi.tools.xxindex.index.IndexElement)MzDataFile.this.idToIndexElementMap.get(Integer.parseInt(id));
            try {
                String xml = MzDataFile.this.readSnipplet(indexElement);
                return (Spectrum)MzDataFile.this.unmarshaller.unmarshal(xml, MzDataElement.SPECTRUM);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load spectrum from mzData file.", e);
            }
        }

        @Override
        public void remove() {
        }
    }

    private class SpectrumIterator
    implements Iterator<uk.ac.ebi.pride.tools.jmzreader.model.Spectrum> {
        private final MzDataSpectrumIterator iterator;

        private SpectrumIterator() {
            this.iterator = new MzDataSpectrumIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public uk.ac.ebi.pride.tools.jmzreader.model.Spectrum next() {
            Spectrum spectrum = this.iterator.next();
            return new MzDataSpectrum(spectrum);
        }

        @Override
        public void remove() {
        }
    }
}

