/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mzxml_parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import psidev.psi.tools.xxindex.StandardXpathAccess;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.XpathIndex;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.mzxml_parser.MzXMLParsingException;
import uk.ac.ebi.pride.tools.mzxml_parser.MzXMLSpectrum;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.DataProcessing;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.MsInstrument;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.MzXMLObject;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.MzXmlElement;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.ParentFile;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.Peaks;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.Scan;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.Separation;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.Spotting;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.unmarshaller.MzXMLUnmarshaller;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.unmarshaller.MzXMLUnmarshallerFactory;

public class MzXMLFile
implements JMzReader {
    private File sourcefile;
    private RandomAccessFile accessFile;
    private XpathIndex index;
    private StandardXpathAccess xpathAccess;
    private List<IndexElement> level1ScanIndexes;
    private List<IndexElement> level2ScanIndexes;
    private Map<Integer, List<IndexElement>> msNScans;
    private HashMap<String, String> runAttributes;
    private static final Pattern xmlAttributePattern = Pattern.compile("(\\w+)=\"([^\"]*)\"");
    private Map<Long, IndexElement> numToIndexMap;
    private MzXMLUnmarshaller unmarshaller;

    public MzXMLFile(File sourcefile) throws MzXMLParsingException {
        this.sourcefile = sourcefile;
        this.indexFile();
        this.unmarshaller = MzXMLUnmarshallerFactory.getInstance().initializeUnmarshaller();
        this.level1ScanIndexes = this.index.getElements(MzXmlElement.SCAN_LEVEL1.getXpath());
        this.level2ScanIndexes = this.index.getElements(MzXmlElement.SCAN_LEVEL2.getXpath());
        this.readMsRunAttributes();
        this.buildSpectraMaps();
        this.buildMsNIndexes();
    }

    private void buildSpectraMaps() throws MzXMLParsingException {
        Long num;
        Map<String, String> attributes;
        if (this.level1ScanIndexes == null || this.level2ScanIndexes == null) {
            return;
        }
        this.numToIndexMap = new HashMap<Long, IndexElement>(this.level1ScanIndexes.size() + this.level2ScanIndexes.size());
        for (IndexElement indexElement : this.level1ScanIndexes) {
            attributes = this.readElementAttributes(indexElement);
            if (!attributes.containsKey("num")) continue;
            num = Long.parseLong(attributes.get("num"));
            this.numToIndexMap.put(num, indexElement);
        }
        for (IndexElement indexElement : this.level2ScanIndexes) {
            attributes = this.readElementAttributes(indexElement);
            if (!attributes.containsKey("num")) continue;
            num = Long.parseLong(attributes.get("num"));
            this.numToIndexMap.put(num, indexElement);
        }
    }

    private Map<String, String> readElementAttributes(IndexElement indexElement) throws MzXMLParsingException {
        RandomAccessFile access = this.getRandomAccess();
        try {
            HashMap<String, String> foundAttributes = new HashMap<String, String>();
            access.seek(indexElement.getStart());
            byte[] headerBuffer = new byte[250];
            access.read(headerBuffer);
            StringBuilder headerString = new StringBuilder(new String(headerBuffer));
            while (!headerString.toString().contains(">")) {
                access.seek(indexElement.getStart() + (long)headerString.length());
                access.read(headerBuffer);
                headerString.append(new String(headerBuffer));
            }
            headerString = new StringBuilder(headerString.toString().replace("\n", ""));
            headerString = new StringBuilder(headerString.substring(0, headerString.toString().indexOf(62) + 1));
            Matcher matcher = xmlAttributePattern.matcher(headerString.toString());
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                if (name == null || value == null) continue;
                foundAttributes.put(name, value);
            }
            return foundAttributes;
        }
        catch (IOException e) {
            throw new MzXMLParsingException("Failed to read mzXML file.", e);
        }
    }

    private void readMsRunAttributes() throws MzXMLParsingException {
        RandomAccessFile access = this.getRandomAccess();
        try {
            String line;
            this.runAttributes = new HashMap();
            access.seek(0L);
            while ((line = access.readLine()) != null && !line.contains("<msRun")) {
            }
            if (line == null) {
                return;
            }
            Matcher matcher = xmlAttributePattern.matcher(line);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                if (name == null || value == null) continue;
                this.runAttributes.put(name, value);
            }
        }
        catch (IOException e) {
            throw new MzXMLParsingException("Failed to read mzXML file.", e);
        }
    }

    private void indexFile() throws MzXMLParsingException {
        try {
            this.xpathAccess = new StandardXpathAccess(this.sourcefile, MzXmlElement.getXpaths());
            this.index = this.xpathAccess.getIndex();
        }
        catch (IOException e) {
            throw new MzXMLParsingException("Failed to index mzXML file.", e);
        }
    }

    private void buildMsNIndexes() throws MzXMLParsingException {
        Integer msLevel;
        Map<String, String> attributes;
        this.msNScans = new HashMap<Integer, List<IndexElement>>();
        for (IndexElement element : this.level1ScanIndexes) {
            attributes = this.readElementAttributes(element);
            if (!attributes.containsKey("msLevel")) continue;
            msLevel = Integer.parseInt(attributes.get("msLevel"));
            if (!this.msNScans.containsKey(msLevel)) {
                this.msNScans.put(msLevel, new ArrayList(1));
            }
            this.msNScans.get(msLevel).add(element);
        }
        for (IndexElement element : this.level2ScanIndexes) {
            attributes = this.readElementAttributes(element);
            if (!attributes.containsKey("msLevel")) continue;
            msLevel = Integer.parseInt(attributes.get("msLevel"));
            if (!this.msNScans.containsKey(msLevel)) {
                this.msNScans.put(msLevel, new ArrayList(1));
            }
            this.msNScans.get(msLevel).add(element);
        }
    }

    protected void finalize() throws Throwable {
        if (this.accessFile != null) {
            this.accessFile.close();
        }
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Spectrum getIndexedSpectrum(File sourcefile, uk.ac.ebi.pride.tools.jmzreader.model.IndexElement indexElement) throws JMzReaderException {
        try (RandomAccessFile access = new RandomAccessFile(sourcefile, "r");){
            byte[] bytes = new byte[indexElement.getSize()];
            access.seek(indexElement.getStart());
            access.read(bytes);
            String snipplet = new String(bytes);
            MzXMLUnmarshaller localUnmarshaller = MzXMLUnmarshallerFactory.getInstance().initializeUnmarshaller();
            Scan scan = (Scan)localUnmarshaller.unmarshal(snipplet, MzXmlElement.SCAN_LEVEL1);
            MzXMLSpectrum mzXMLSpectrum = new MzXMLSpectrum(scan);
            return mzXMLSpectrum;
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to read from mzXML file.", e);
        }
    }

    private RandomAccessFile getRandomAccess() throws MzXMLParsingException {
        if (this.accessFile != null) {
            return this.accessFile;
        }
        try {
            this.accessFile = new RandomAccessFile(this.sourcefile, "r");
        }
        catch (FileNotFoundException e) {
            throw new MzXMLParsingException("Could not find mzXML file '" + this.sourcefile.getPath() + '\'', e);
        }
        return this.accessFile;
    }

    public void closeRandomAccess() {
        if (this.accessFile != null) {
            try {
                this.accessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.accessFile = null;
        }
    }

    public List<ParentFile> getParentFile() throws MzXMLParsingException {
        return this.unmarshalList(MzXmlElement.PARENT_FILE);
    }

    public List<MsInstrument> getMsInstrument() throws MzXMLParsingException {
        return this.unmarshalList(MzXmlElement.MS_INSTRUMENT);
    }

    public List<DataProcessing> getDataProcessing() throws MzXMLParsingException {
        return this.unmarshalList(MzXmlElement.DATA_PROCESSING);
    }

    public Separation getSpearation() throws MzXMLParsingException {
        return (Separation)this.unmarshalFirstElement(MzXmlElement.SEPARATION);
    }

    public Spotting getSpotting() throws MzXMLParsingException {
        return (Spotting)this.unmarshalFirstElement(MzXmlElement.SPOTTING);
    }

    public static Map<Double, Double> convertPeaksToMap(Peaks peaks) throws MzXMLParsingException {
        double[] values;
        boolean zlibCompression;
        if (peaks == null || peaks.getValue() == null) {
            return Collections.emptyMap();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(peaks.getValue());
        boolean bl = zlibCompression = peaks.getCompressionType() != null && "zlib".equalsIgnoreCase(peaks.getCompressionType());
        if (zlibCompression) {
            Inflater decompresser = new Inflater();
            decompresser.setInput(byteBuffer.array());
            byte[] decompressedData = new byte[byteBuffer.capacity() * 10];
            try {
                int usedLength = decompresser.inflate(decompressedData);
                byteBuffer = ByteBuffer.wrap(decompressedData, 0, usedLength);
            }
            catch (DataFormatException e) {
                throw new MzXMLParsingException("Failed to decompress spectra data.", e);
            }
        }
        if (!"network".equalsIgnoreCase(peaks.getByteOrder())) {
            throw new MzXMLParsingException("Peak lists must be encoded using network (big-endian) byte order");
        }
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        if (peaks.getPrecision() != null && peaks.getPrecision() == 64L) {
            values = new double[byteBuffer.asDoubleBuffer().capacity()];
            byteBuffer.asDoubleBuffer().get(values);
        } else {
            FloatBuffer floats = byteBuffer.asFloatBuffer();
            values = new double[floats.capacity()];
            for (int index = 0; index < floats.capacity(); ++index) {
                values[index] = floats.get(index);
            }
        }
        if (values.length % 2 > 0) {
            throw new MzXMLParsingException("Different number of m/z and intensity values encountered in peak list.");
        }
        HashMap<Double, Double> peakList = new HashMap<Double, Double>(values.length / 2);
        for (int peakIndex = 0; peakIndex < values.length - 1; peakIndex += 2) {
            Double mz = values[peakIndex];
            Double intensity = values[peakIndex + 1];
            peakList.put(mz, intensity);
        }
        return peakList;
    }

    public Scan getScanByNum(Long scanNum) throws MzXMLParsingException {
        IndexElement indexElement = null;
        if (this.numToIndexMap.containsKey(scanNum)) {
            indexElement = this.numToIndexMap.get(scanNum);
        }
        if (indexElement == null) {
            throw new MzXMLParsingException("Element with num=\"" + scanNum + "\" could not be found.");
        }
        String snipplet = this.readSnipplet(indexElement);
        try {
            return (Scan)this.unmarshaller.unmarshal(snipplet, MzXmlElement.SCAN_LEVEL1);
        }
        catch (Exception e) {
            throw new MzXMLParsingException("Failed to unmarshl Scan object.", e);
        }
    }

    public Scan getScanByStringNum(String scanNum) throws MzXMLParsingException {
        try {
            Long num = Long.parseLong(scanNum);
            return this.getScanByNum(num);
        }
        catch (NumberFormatException e) {
            throw new MzXMLParsingException("Invalid spectra number passed.", e);
        }
    }

    public List<Long> getScanNumbers() {
        ArrayList<Long> scanNumbers = new ArrayList<Long>(this.numToIndexMap.keySet());
        Collections.sort(scanNumbers);
        return scanNumbers;
    }

    private <T extends MzXMLObject> List<T> unmarshalList(MzXmlElement element) throws MzXMLParsingException {
        try {
            List parentFileIndex = this.index.getElements(element.getXpath());
            ArrayList objects = new ArrayList(parentFileIndex.size());
            for (IndexElement indexElement : parentFileIndex) {
                String xmlSnipplet = this.readSnipplet(indexElement);
                Object object = this.unmarshaller.unmarshal(xmlSnipplet, element);
                objects.add(object);
            }
            return objects;
        }
        catch (Exception e) {
            throw new MzXMLParsingException("Failed to unmarshall mzXML object.", e);
        }
    }

    private <T extends MzXMLObject> T unmarshalFirstElement(MzXmlElement element) throws MzXMLParsingException {
        try {
            List parentFileIndex = this.index.getElements(element.getXpath());
            if (parentFileIndex.size() < 1) {
                return null;
            }
            String xmlSnipplet = this.readSnipplet((IndexElement)parentFileIndex.get(0));
            return this.unmarshaller.unmarshal(xmlSnipplet, element);
        }
        catch (Exception e) {
            throw new MzXMLParsingException("Failed to unmarshall mzXML object.", e);
        }
    }

    private String readSnipplet(IndexElement indexElement) throws MzXMLParsingException {
        RandomAccessFile access = this.getRandomAccess();
        int length = (int)(indexElement.getStop() - indexElement.getStart());
        byte[] bytes = new byte[length];
        try {
            access.seek(indexElement.getStart());
            access.read(bytes);
            return new String(bytes);
        }
        catch (IOException e) {
            throw new MzXMLParsingException("Failed to read from mzXML file.", e);
        }
    }

    public Map<String, String> getRunAttributes() {
        return this.runAttributes;
    }

    public int getMS1ScanCount() {
        if (this.msNScans.containsKey(1)) {
            return this.msNScans.get(1).size();
        }
        return 0;
    }

    public int getMS2ScanCount() {
        if (this.msNScans.containsKey(2)) {
            return this.msNScans.get(2).size();
        }
        return 0;
    }

    public MzXMLScanIterator geMS1ScanIterator() {
        return new MzXMLScanIterator(1);
    }

    public MzXMLScanIterator getMS2ScanIterator() {
        return new MzXMLScanIterator(2);
    }

    public MzXMLScanIterator getScanIterator() {
        return new MzXMLScanIterator(0);
    }

    @Override
    public int getSpectraCount() {
        return this.numToIndexMap.size();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return false;
    }

    @Override
    public List<String> getSpectraIds() {
        ArrayList<Long> nums = new ArrayList<Long>(this.getScanNumbers());
        ArrayList<String> ids = new ArrayList<String>(nums.size());
        for (Long num : nums) {
            ids.add(num.toString());
        }
        return ids;
    }

    @Override
    public Spectrum getSpectrumById(String id) throws JMzReaderException {
        try {
            Scan scan = this.getScanByStringNum(id);
            return new MzXMLSpectrum(scan);
        }
        catch (MzXMLParsingException e) {
            throw new JMzReaderException("Failed to parse spectrum", e);
        }
    }

    @Override
    public Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        if (index < 1 || index > this.numToIndexMap.size()) {
            throw new JMzReaderException("Spectrum index out of range.");
        }
        Long num = this.getScanNumbers().get(index - 1);
        IndexElement indexElement = this.numToIndexMap.get(num);
        if (indexElement == null) {
            throw new JMzReaderException("Spectrum with index " + index + " could not be found.");
        }
        try {
            String snipplet = this.readSnipplet(indexElement);
            Scan scan = (Scan)this.unmarshaller.unmarshal(snipplet, MzXmlElement.SCAN_LEVEL2);
            return new MzXMLSpectrum(scan);
        }
        catch (Exception e) {
            throw new JMzReaderException("Failed to parse spectrum", e);
        }
    }

    @Override
    public Iterator<Spectrum> getSpectrumIterator() {
        return new SpectrumIterator();
    }

    @Override
    public List<uk.ac.ebi.pride.tools.jmzreader.model.IndexElement> getMsNIndexes(int msLevel) {
        if (!this.msNScans.containsKey(msLevel)) {
            return Collections.emptyList();
        }
        return this.convertIndexElements(this.msNScans.get(msLevel));
    }

    @Override
    public List<Integer> getMsLevels() {
        return new ArrayList<Integer>(this.msNScans.keySet());
    }

    @Override
    public Map<String, uk.ac.ebi.pride.tools.jmzreader.model.IndexElement> getIndexElementForIds() {
        HashMap<String, uk.ac.ebi.pride.tools.jmzreader.model.IndexElement> idToIndexMap = new HashMap<String, uk.ac.ebi.pride.tools.jmzreader.model.IndexElement>(this.numToIndexMap.size());
        for (Map.Entry<Long, IndexElement> longIndexElementEntry : this.numToIndexMap.entrySet()) {
            IndexElement e = longIndexElementEntry.getValue();
            idToIndexMap.put(longIndexElementEntry.getKey().toString(), new IndexElementImpl(e.getStart(), (int)(e.getStop() - e.getStart())));
        }
        return idToIndexMap;
    }

    private List<uk.ac.ebi.pride.tools.jmzreader.model.IndexElement> convertIndexElements(List<IndexElement> elements) {
        ArrayList<uk.ac.ebi.pride.tools.jmzreader.model.IndexElement> convertedElements = new ArrayList<uk.ac.ebi.pride.tools.jmzreader.model.IndexElement>(elements.size());
        for (IndexElement e : elements) {
            int size = (int)(e.getStop() - e.getStart());
            convertedElements.add(new IndexElementImpl(e.getStart(), size));
        }
        return convertedElements;
    }

    public class SpectrumIterator
    implements Iterator<Spectrum> {
        Iterator<Long> numIterator;

        public SpectrumIterator() {
            this.numIterator = MzXMLFile.this.getScanNumbers().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.numIterator.hasNext();
        }

        @Override
        public Spectrum next() {
            Long num = this.numIterator.next();
            try {
                Scan scan = MzXMLFile.this.getScanByNum(num);
                return new MzXMLSpectrum(scan);
            }
            catch (MzXMLParsingException e) {
                throw new RuntimeException("Failed to parse spectrum " + num + ": " + e.getMessage(), e);
            }
        }

        @Override
        public void remove() {
        }
    }

    public class MzXMLScanIterator
    implements Iterable<Scan>,
    Iterator<Scan> {
        private int currentIndex = 0;
        private List<IndexElement> indexes;

        private MzXMLScanIterator(int msLevel) {
            this.indexes = msLevel == 0 ? MzXMLFile.this.index.getElements(MzXmlElement.SCAN_LEVEL1.getXpath()) : MzXMLFile.this.msNScans.getOrDefault(msLevel, Collections.EMPTY_LIST);
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.indexes.size();
        }

        @Override
        public Scan next() {
            IndexElement indexElement = this.indexes.get(this.currentIndex++);
            try {
                String snipplet = MzXMLFile.this.readSnipplet(indexElement);
                return (Scan)MzXMLFile.this.unmarshaller.unmarshal(snipplet, MzXmlElement.SCAN_LEVEL1);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse spectrum: " + e.getMessage(), e);
            }
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<Scan> iterator() {
            return this;
        }
    }
}

