/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mzdata_parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.CvParam;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.PeakListBinary;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.Precursor;
import uk.ac.ebi.pride.tools.mzdata_parser.mzdata.model.Spectrum;

public class MzDataSpectrum
implements uk.ac.ebi.pride.tools.jmzreader.model.Spectrum {
    private Integer precursorCharge = null;
    private Double precursorMz = null;
    private Double precursorIntensity = null;
    private Map<Double, Double> peakList;
    private int msLevel;
    private Integer id;
    private ParamGroup paramGroup;

    public MzDataSpectrum(Spectrum mzDataSpectrum) {
        this.id = mzDataSpectrum.getId();
        this.msLevel = mzDataSpectrum.getSpectrumDesc().getSpectrumSettings().getSpectrumInstrument().getMsLevel();
        this.paramGroup = new ParamGroup();
        this.extractPrecursorInformation(mzDataSpectrum);
        this.extractPeakList(mzDataSpectrum);
    }

    private void extractPrecursorInformation(Spectrum mzDataSpectrum) {
        if (mzDataSpectrum.getSpectrumDesc().getPrecursorList() == null) {
            return;
        }
        Precursor precursor = mzDataSpectrum.getSpectrumDesc().getPrecursorList().getPrecursor().get(0);
        for (CvParam cvParam : precursor.getIonSelection().getCvParams()) {
            String accession = cvParam.getAccession();
            String value = cvParam.getValue();
            if ("PSI:1000040".equals(accession) || "MS:1000744".equals(accession)) {
                this.precursorMz = Double.parseDouble(value);
                continue;
            }
            if ("PSI:1000041".equals(accession) || "MS:1000041".equals(accession)) {
                this.precursorCharge = Integer.parseInt(value);
                continue;
            }
            if ("PSI:1000042".equals(accession) || "MS:1000042".equals(accession)) {
                this.precursorIntensity = Double.parseDouble(value);
                continue;
            }
            this.paramGroup.addParam(new uk.ac.ebi.pride.tools.jmzreader.model.impl.CvParam(cvParam.getName(), cvParam.getValue(), cvParam.getCvLabel(), cvParam.getAccession()));
        }
        for (CvParam cvParam : precursor.getActivation().getCvParams()) {
            this.paramGroup.addParam(new uk.ac.ebi.pride.tools.jmzreader.model.impl.CvParam(cvParam.getName(), cvParam.getValue(), cvParam.getCvLabel(), cvParam.getAccession()));
        }
    }

    private void extractPeakList(Spectrum mzDataSpectrum) {
        int i;
        PeakListBinary.Data mzData = mzDataSpectrum.getMzArrayBinary().getData();
        PeakListBinary.Data intenData = mzDataSpectrum.getIntenArrayBinary().getData();
        ByteBuffer mzBuffer = ByteBuffer.wrap(mzData.getValue());
        ByteBuffer intenBuffer = ByteBuffer.wrap(intenData.getValue());
        if (mzData.getEndian().equalsIgnoreCase("little")) {
            mzBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            mzBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        if (intenData.getEndian().equalsIgnoreCase("little")) {
            intenBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            intenBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        ArrayList<Double> mz = new ArrayList<Double>();
        ArrayList<Double> inten = new ArrayList<Double>();
        int size = mzData.getPrecision().equals("32") ? 4 : 8;
        for (i = 0; i < mzBuffer.limit(); i += size) {
            mz.add(size == 4 ? Float.valueOf(mzBuffer.getFloat(i)).doubleValue() : mzBuffer.getDouble(i));
        }
        size = intenData.getPrecision().equals("32") ? 4 : 8;
        for (i = 0; i < intenBuffer.limit(); i += size) {
            inten.add(size == 4 ? Float.valueOf(intenBuffer.getFloat(i)).doubleValue() : intenBuffer.getDouble(i));
        }
        if (inten.size() != mz.size()) {
            throw new IllegalStateException("Different sizes encountered for intensity and m/z array (spectrum id = " + this.id + ')');
        }
        this.peakList = new HashMap<Double, Double>();
        for (i = 0; i < mz.size(); ++i) {
            this.peakList.put((Double)mz.get(i), (Double)inten.get(i));
        }
    }

    @Override
    public String getId() {
        return this.id.toString();
    }

    @Override
    public Integer getPrecursorCharge() {
        return this.precursorCharge;
    }

    @Override
    public Double getPrecursorMZ() {
        return this.precursorMz;
    }

    @Override
    public Double getPrecursorIntensity() {
        return this.precursorIntensity;
    }

    @Override
    public Map<Double, Double> getPeakList() {
        return this.peakList;
    }

    @Override
    public Integer getMsLevel() {
        return this.msLevel;
    }

    @Override
    public ParamGroup getAdditional() {
        return this.paramGroup;
    }
}

