/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mgf_parser.model;

import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;

public class PmfQuery {
    private Double mass;
    private Double intensity;

    public PmfQuery(Double mass, Double intensity) {
        this.mass = mass;
        this.intensity = intensity;
    }

    public PmfQuery(String mgfFileLine) throws JMzReaderException {
        String[] fields = mgfFileLine.split("\\s+");
        if (fields.length == 0) {
            throw new JMzReaderException("Malformatted line passed to generate PmfQuery object");
        }
        this.mass = Double.parseDouble(fields[0]);
        if (fields.length > 1) {
            this.intensity = Double.parseDouble(fields[1]);
        }
    }

    public Double getMass() {
        return this.mass;
    }

    public void setMass(Double mass) {
        this.mass = mass;
    }

    public Double getIntensity() {
        return this.intensity;
    }

    public void setIntensity(Double intensity) {
        this.intensity = intensity;
    }

    public String toString() {
        return this.mass.toString() + (this.intensity != null ? ' ' + this.intensity.toString() : "");
    }
}

