/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mgf_parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.mgf_parser.model.Ms2Query;
import uk.ac.ebi.pride.tools.mgf_parser.model.PmfQuery;

public class MgfFile
implements JMzReader {
    public static final Logger logger = LoggerFactory.getLogger(MgfFile.class);
    public static final String mgfCommentRegex = "^[#;!/].*";
    public static final Pattern attributePattern = Pattern.compile("(\\w+)\\[?\\d?\\]?\\s*=(.*)\\s*");
    private List<String> accessions;
    private String charge;
    private String enzyme;
    private String searchTitle;
    private String precursorRemoval;
    private String database;
    private Boolean performDecoySearch;
    private Boolean isErrorTolerant;
    private String format;
    private List<Integer> frames;
    private String instrument;
    private String variableModifications;
    private Double fragmentIonTolerance;
    private FragmentToleranceUnits fragmentIonToleranceUnit;
    private MassType massType;
    private String fixedMofications;
    private Double peptideIsotopeError;
    private Integer partials;
    private Double precursor;
    private String quantitation;
    private String maxHitsToReport;
    private ReportType reportType;
    private SearchType searchType;
    private String proteinMass;
    private String taxonomy;
    private Double peptideMassTolerance;
    private PeptideToleranceUnit peptideMassToleranceUnit;
    private List<String> userParameter;
    private String userMail;
    private String userName;
    private File sourceFile;
    private List<IndexElement> index = new ArrayList<IndexElement>();
    private List<PmfQuery> pmfQueries = new ArrayList<PmfQuery>();
    private HashMap<Integer, Ms2Query> ms2Queries = new HashMap();
    private boolean useCache = false;
    private boolean allowCustomTags = false;
    private static final boolean DEFAULT_ALLOW_CUSTOM_TAGS = false;
    private static final boolean DEFAULT_IGNORE_WRONG_PEAKS = false;
    private boolean disableCommentSupport = false;
    private boolean ignoreWrongPeaks = false;

    private void processAttribute(String name, String value) {
        if ("ACCESSION".equals(name)) {
            value = value.replace("\"", "");
            String[] accs = value.split(",");
            this.accessions = Arrays.asList(accs);
        } else if ("CHARGE".equals(name)) {
            this.charge = value;
        } else if ("CLE".equals(name)) {
            this.enzyme = value;
        } else if ("COM".equals(name)) {
            this.searchTitle = value;
        } else if ("CUTOUT".equals(name)) {
            this.precursorRemoval = value;
        } else if ("DB".equals(name)) {
            this.database = value;
        } else if ("DECOY".equals(name)) {
            this.performDecoySearch = value.equals("1");
        } else if ("ERRORTOLERANT".equals(name)) {
            this.isErrorTolerant = value.equals("1");
        } else if ("FORMAT".equals(name)) {
            this.format = value;
        } else if ("FRAMES".equals(name)) {
            String[] frames = value.split(",");
            this.frames = new ArrayList<Integer>();
            for (String frame : frames) {
                this.frames.add(Integer.parseInt(frame));
            }
        } else if ("INSTRUMENT".equals(name)) {
            this.instrument = value;
        } else if ("IT_MODS".equals(name)) {
            this.variableModifications = value;
        } else if ("ITOL".equals(name)) {
            this.fragmentIonTolerance = Double.parseDouble(value);
        } else if ("ITOLU".equals(name)) {
            this.fragmentIonToleranceUnit = value.equals("mmu") ? FragmentToleranceUnits.MMU : FragmentToleranceUnits.DA;
        } else if ("MASS".equals(name)) {
            this.massType = value.equals("Average") ? MassType.AVERAGE : MassType.MONOISOTOPIC;
        } else if ("MODS".equals(name)) {
            this.fixedMofications = value;
        } else if ("PEP_ISOTOPE_ERROR".equals(name)) {
            this.peptideIsotopeError = Double.parseDouble(value);
        } else if ("PFA".equals(name)) {
            this.partials = Integer.parseInt(value);
        } else if ("PRECURSOR".equals(name)) {
            this.precursor = Double.parseDouble(value);
        } else if ("QUANTITATION".equals(name)) {
            this.quantitation = value;
        } else if ("REPORT".equals(name)) {
            this.maxHitsToReport = value;
        } else if ("REPTYPE".equals(name)) {
            this.reportType = null;
            if ("protein".equalsIgnoreCase(value)) {
                this.reportType = ReportType.PROTEIN;
            }
            if ("peptide".equalsIgnoreCase(value)) {
                this.reportType = ReportType.PEPTIDE;
            }
            if ("archive".equalsIgnoreCase(value)) {
                this.reportType = ReportType.ARCHIVE;
            }
            if ("concise".equalsIgnoreCase(value)) {
                this.reportType = ReportType.CONCISE;
            }
            if ("select".equalsIgnoreCase(value)) {
                this.reportType = ReportType.SELECT;
            }
            if ("unassigned".equalsIgnoreCase(value)) {
                this.reportType = ReportType.UNASSIGNED;
            }
            if (this.reportType == null) {
                throw new IllegalStateException("Invalid report type set");
            }
        } else if ("SEARCH".equals(name)) {
            this.searchType = null;
            if ("PMF".equalsIgnoreCase(value)) {
                this.searchType = SearchType.PMF;
            }
            if ("SQ".equalsIgnoreCase(value)) {
                this.searchType = SearchType.SQ;
            }
            if ("MIS".equalsIgnoreCase(value)) {
                this.searchType = SearchType.MIS;
            }
            if (this.searchType == null) {
                throw new IllegalStateException("Invalid search type set");
            }
        } else if ("SEG".equals(name)) {
            this.proteinMass = value;
        } else if ("TAXONOMY".equals(name)) {
            this.taxonomy = value;
        } else if ("TOL".equals(name)) {
            this.peptideMassTolerance = Double.parseDouble(value);
        } else if ("TOLU".equals(name)) {
            this.peptideMassToleranceUnit = null;
            if ("%".equalsIgnoreCase(value)) {
                this.peptideMassToleranceUnit = PeptideToleranceUnit.PERCENT;
            }
            if ("ppm".equalsIgnoreCase(value)) {
                this.peptideMassToleranceUnit = PeptideToleranceUnit.PPM;
            }
            if ("mmu".equalsIgnoreCase(value)) {
                this.peptideMassToleranceUnit = PeptideToleranceUnit.MMU;
            }
            if ("Da".equalsIgnoreCase(value)) {
                this.peptideMassToleranceUnit = PeptideToleranceUnit.DA;
            }
            if (this.peptideMassToleranceUnit == null) {
                throw new IllegalStateException("Invalid peptide mass tolerance unit set");
            }
        } else if (name.startsWith("USER")) {
            if ("USEREMAIL".equals(name)) {
                this.userMail = value;
            } else if ("USERNAME".equals(name)) {
                this.userName = value;
            } else {
                if (this.userParameter == null) {
                    this.userParameter = new ArrayList<String>();
                }
                this.userParameter.add(value);
            }
        } else {
            if (!this.allowCustomTags) {
                throw new IllegalStateException("Unknown attribute '" + name + "' encountered");
            }
            logger.warn("Ignored custom tag: " + name);
        }
    }

    public static Spectrum getIndexedSpectrum(File sourcefile, IndexElement indexElement, boolean disableCommentSupport, boolean ignoreWrongPeaks) throws JMzReaderException {
        if (sourcefile == null) {
            throw new JMzReaderException("Required parameter sourcefile must not be null.");
        }
        if (indexElement == null) {
            throw new JMzReaderException("Required parameter indexElement must not be null.");
        }
        return MgfFile.loadIndexedQueryFromFile(sourcefile, indexElement, 1, disableCommentSupport, ignoreWrongPeaks);
    }

    public static Spectrum getIndexedSpectrum(File sourcefile, IndexElement indexElement, boolean ignoreWrongPeaks) throws JMzReaderException {
        return MgfFile.loadIndexedQueryFromFile(sourcefile, indexElement, 1, false, ignoreWrongPeaks);
    }

    public MgfFile() {
    }

    public MgfFile(File file) throws JMzReaderException {
        this(file, false, false);
    }

    public MgfFile(File file, boolean allowCustomTags, boolean ignoreWrongPeaks) throws JMzReaderException {
        this.setAllowCustomTags(allowCustomTags);
        this.ignoreWrongPeaks = ignoreWrongPeaks;
        try {
            String line;
            this.sourceFile = file;
            BufferedRandomAccessFile braf = new BufferedRandomAccessFile(this.sourceFile.getAbsolutePath(), "r", 102400);
            boolean inHeader = true;
            boolean inMs2 = false;
            long lastPosition = 0L;
            long beginIonsIndex = 0L;
            while ((line = braf.getNextLine()) != null) {
                if (!inMs2) {
                    line = line.replaceAll(mgfCommentRegex, "").trim();
                }
                if (line.length() < 1) {
                    lastPosition = braf.getFilePointer();
                    continue;
                }
                if (!inMs2 && line.contains("BEGIN IONS")) {
                    beginIonsIndex = lastPosition;
                    inMs2 = true;
                }
                if (inMs2 && line.contains("END IONS")) {
                    inMs2 = false;
                    int size = (int)(braf.getFilePointer() - beginIonsIndex);
                    this.index.add(new IndexElementImpl(beginIonsIndex, size));
                    lastPosition = braf.getFilePointer();
                    continue;
                }
                if (inMs2) {
                    lastPosition = braf.getFilePointer();
                    continue;
                }
                if (inHeader && line.contains("=")) {
                    Matcher matcher = attributePattern.matcher(line);
                    if (!matcher.find()) {
                        throw new JMzReaderException("Malformatted attribute encountered");
                    }
                    if (matcher.groupCount() != 2) {
                        throw new JMzReaderException("Malformatted attribute encountered");
                    }
                    this.processAttribute(matcher.group(1), matcher.group(2));
                    lastPosition = braf.getFilePointer();
                    continue;
                }
                if (!inHeader && line.contains("=")) {
                    throw new JMzReaderException("Attribute encountered at illegal position. Attributes must all be at the beginning of the file");
                }
                inHeader = false;
                if (!inHeader) {
                    PmfQuery query = new PmfQuery(line);
                    this.pmfQueries.add(query);
                }
                lastPosition = braf.getFilePointer();
            }
            braf.close();
        }
        catch (FileNotFoundException e) {
            throw new JMzReaderException("MgfFile does not exist.", e);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from mgf file.", e);
        }
    }

    public MgfFile(File file, List<IndexElement> index, boolean allowCustomTags, boolean ignoreWrongPeaks) throws JMzReaderException {
        this.setAllowCustomTags(allowCustomTags);
        this.ignoreWrongPeaks = ignoreWrongPeaks;
        try {
            String line;
            this.sourceFile = file;
            this.index = index;
            BufferedRandomAccessFile reader = new BufferedRandomAccessFile(this.sourceFile, "r", 1024000);
            boolean inHeader = true;
            while ((line = reader.getNextLine()) != null) {
                if ((line = line.replaceAll(mgfCommentRegex, "").trim()).length() < 1) continue;
                if (line.contains("BEGIN IONS")) break;
                if (inHeader && line.contains("=")) {
                    Matcher matcher = attributePattern.matcher(line);
                    if (!matcher.find()) {
                        throw new JMzReaderException("Malformatted attribute encountered");
                    }
                    if (matcher.groupCount() != 2) {
                        throw new JMzReaderException("Malformatted attribute encountered");
                    }
                    this.processAttribute(matcher.group(1), matcher.group(2));
                    continue;
                }
                if (!inHeader && line.contains("=")) {
                    throw new JMzReaderException("Attribute encountered at illegal position. Attributes must all be at the beginning of the file");
                }
                inHeader = false;
                if (inHeader) continue;
                PmfQuery query = new PmfQuery(line);
                this.pmfQueries.add(query);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw new JMzReaderException("MgfFile does not exist.", e);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from mgf file.", e);
        }
    }

    public MgfFile(File file, List<IndexElement> index) throws JMzReaderException {
        this(file, index, false, false);
    }

    public List<String> getAccessions() {
        return this.accessions;
    }

    public void setAccessions(List<String> accessions) {
        this.accessions = accessions;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public String getEnzyme() {
        return this.enzyme;
    }

    public void setEnzyme(String enzyme) {
        this.enzyme = enzyme;
    }

    public String getSearchTitle() {
        return this.searchTitle;
    }

    public void setSearchTitle(String searchTitle) {
        this.searchTitle = searchTitle;
    }

    public String getPrecursorRemoval() {
        return this.precursorRemoval;
    }

    public void setPrecursorRemoval(String precursorRemoval) {
        this.precursorRemoval = precursorRemoval;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public Boolean getPerformDecoySearch() {
        return this.performDecoySearch;
    }

    public void setPerformDecoySearch(Boolean performDecoySearch) {
        this.performDecoySearch = performDecoySearch;
    }

    public Boolean getIsErrorTolerant() {
        return this.isErrorTolerant;
    }

    public void setIsErrorTolerant(Boolean isErrorTolerant) {
        this.isErrorTolerant = isErrorTolerant;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public List<Integer> getFrames() {
        return this.frames;
    }

    public void setFrames(List<Integer> frames) {
        this.frames = frames;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public String getVariableModifications() {
        return this.variableModifications;
    }

    public void setVariableModifications(String variableModifications) {
        this.variableModifications = variableModifications;
    }

    public Double getFragmentIonTolerance() {
        return this.fragmentIonTolerance;
    }

    public void setFragmentIonTolerance(Double fragmentIonTolerance) {
        this.fragmentIonTolerance = fragmentIonTolerance;
    }

    public FragmentToleranceUnits getFragmentIonToleranceUnit() {
        return this.fragmentIonToleranceUnit;
    }

    public void setFragmentIonToleranceUnit(FragmentToleranceUnits fragmentIonToleranceUnit) {
        this.fragmentIonToleranceUnit = fragmentIonToleranceUnit;
    }

    public MassType getMassType() {
        return this.massType;
    }

    public void setMassType(MassType massType) {
        this.massType = massType;
    }

    public String getFixedMofications() {
        return this.fixedMofications;
    }

    public void setFixedMofications(String fixedMofications) {
        this.fixedMofications = fixedMofications;
    }

    public Double getPeptideIsotopeError() {
        return this.peptideIsotopeError;
    }

    public void setPeptideIsotopeError(Double peptideIsotopeError) {
        this.peptideIsotopeError = peptideIsotopeError;
    }

    public Integer getPartials() {
        return this.partials;
    }

    public void setPartials(Integer partials) {
        this.partials = partials;
    }

    public Double getPrecursor() {
        return this.precursor;
    }

    public void setPrecursor(Double precursor) {
        this.precursor = precursor;
    }

    public String getQuantitation() {
        return this.quantitation;
    }

    public void setQuantitation(String quantitation) {
        this.quantitation = quantitation;
    }

    public String getMaxHitsToReport() {
        return this.maxHitsToReport;
    }

    public void setMaxHitsToReport(String maxHitsToReport) {
        this.maxHitsToReport = maxHitsToReport;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public String getProteinMass() {
        return this.proteinMass;
    }

    public void setProteinMass(String proteinMass) {
        this.proteinMass = proteinMass;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public void setTaxonomy(String taxonomy) {
        this.taxonomy = taxonomy;
    }

    public Double getPeptideMassTolerance() {
        return this.peptideMassTolerance;
    }

    public void setPeptideMassTolerance(Double peptideMassTolerance) {
        this.peptideMassTolerance = peptideMassTolerance;
    }

    public PeptideToleranceUnit getPeptideMassToleranceUnit() {
        return this.peptideMassToleranceUnit;
    }

    public void setPeptideMassToleranceUnit(PeptideToleranceUnit peptideMassToleranceUnit) {
        this.peptideMassToleranceUnit = peptideMassToleranceUnit;
    }

    public List<String> getUserParameter() {
        return this.userParameter;
    }

    public void setUserParameter(List<String> userParameter) {
        this.userParameter = userParameter;
    }

    public String getUserMail() {
        return this.userMail;
    }

    public void setUserMail(String userMail) {
        this.userMail = userMail;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<PmfQuery> getPmfQueries() {
        return this.pmfQueries;
    }

    public void setPmfQueries(List<PmfQuery> pmfQueries) {
        this.pmfQueries = pmfQueries;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setMs2Queries(List<Ms2Query> ms2Queries) {
        this.sourceFile = null;
        this.index.clear();
        for (int index = 0; index < ms2Queries.size(); ++index) {
            this.ms2Queries.put(index, ms2Queries.get(index));
        }
    }

    public int getMs2QueryCount() {
        return this.sourceFile != null ? this.index.size() : this.ms2Queries.size();
    }

    public Ms2Query getMs2Query(int nIndex, boolean ignoreWrongPeaks) throws JMzReaderException {
        if (this.ms2Queries.containsKey(nIndex)) {
            return this.ms2Queries.get(nIndex);
        }
        if (this.sourceFile == null) {
            throw new JMzReaderException("MS2 query with index " + (nIndex + 1) + " does not exist");
        }
        if (nIndex < 0 || nIndex > this.index.size() - 1) {
            throw new JMzReaderException("MS2 query with index " + (nIndex + 1) + " does not exist in the MGF file");
        }
        Ms2Query query = this.loadIndexedQueryFromFile(nIndex, ignoreWrongPeaks);
        if (this.useCache) {
            this.ms2Queries.put(nIndex, query);
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Ms2Query loadIndexedQueryFromFile(File file, IndexElement indexElement, int index, boolean disableCommentSupport, boolean ignoreWrongPeaks) throws JMzReaderException {
        try (RandomAccessFile accFile = new RandomAccessFile(file, "r");){
            byte[] byteBuffer = new byte[indexElement.getSize()];
            accFile.seek(indexElement.getStart());
            accFile.read(byteBuffer);
            String ms2Buffer = new String(byteBuffer);
            Ms2Query ms2Query = new Ms2Query(ms2Buffer, index, disableCommentSupport, ignoreWrongPeaks);
            return ms2Query;
        }
        catch (FileNotFoundException e) {
            throw new JMzReaderException("MGF file could not be found.", e);
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to read from MGF file", e);
        }
    }

    private Ms2Query loadIndexedQueryFromFile(int nQueryIndex, boolean ignoreWrongPeaks) throws JMzReaderException {
        if (nQueryIndex < 0 || nQueryIndex > this.index.size() - 1) {
            throw new JMzReaderException("Tried to load non existing query from file");
        }
        IndexElement indexElement = this.index.get(nQueryIndex);
        return MgfFile.loadIndexedQueryFromFile(this.sourceFile, indexElement, nQueryIndex + 1, this.disableCommentSupport, ignoreWrongPeaks);
    }

    public void marshallToFile(File file) throws JMzReaderException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            String parameters = this.marshallAdditionalParameters();
            writer.write(parameters);
            for (PmfQuery q : this.pmfQueries) {
                writer.write(q.toString() + '\n');
            }
            writer.write("\n");
            Integer index = 0;
            while (index < 1000000) {
                if (this.ms2Queries.containsKey(index)) {
                    writer.write(this.ms2Queries.get(index).toString() + '\n');
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new JMzReaderException("Failed to write output file", e);
        }
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.marshallAdditionalParameters());
        for (PmfQuery q : this.pmfQueries) {
            string.append(q.toString()).append('\n');
        }
        if (this.pmfQueries.size() > 0) {
            string.append('\n');
        }
        Integer index = 0;
        while (index < 1000000) {
            if (this.ms2Queries.containsKey(index)) {
                string.append(this.ms2Queries.get(index).toString()).append('\n');
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return string.toString();
    }

    private String marshallAdditionalParameters() {
        int i;
        StringBuilder parameters = new StringBuilder();
        if (this.accessions != null && this.accessions.size() > 0) {
            parameters.append("ACCESSION=");
            for (i = 0; i < this.accessions.size(); ++i) {
                parameters.append(i > 0 ? "," : "").append('\"').append(this.accessions.get(i)).append('\"');
            }
            parameters.append('\n');
        }
        if (this.charge != null) {
            parameters.append("CHARGE=").append(this.charge).append('\n');
        }
        if (this.enzyme != null) {
            parameters.append("CLE=").append(this.enzyme).append('\n');
        }
        if (this.searchTitle != null) {
            parameters.append("COM=").append(this.searchTitle).append('\n');
        }
        if (this.precursorRemoval != null) {
            parameters.append("CUTOUT=").append(this.precursorRemoval).append('\n');
        }
        if (this.database != null) {
            parameters.append("DB=").append(this.database).append('\n');
        }
        if (this.performDecoySearch != null) {
            parameters.append("DECOY=").append(this.performDecoySearch != false ? "1" : "0").append('\n');
        }
        if (this.isErrorTolerant != null) {
            parameters.append("ERRORTOLERANT=").append(this.isErrorTolerant != false ? "1" : "0").append('\n');
        }
        if (this.format != null) {
            parameters.append("FORMAT=").append(this.format).append('\n');
        }
        if (this.frames != null && this.frames.size() > 0) {
            parameters.append("FRAMES=");
            for (i = 0; i < this.frames.size(); ++i) {
                parameters.append(i > 0 ? "," : "").append(this.frames.get(i).toString());
            }
            parameters.append('\n');
        }
        if (this.instrument != null) {
            parameters.append("INSTRUMENT=").append(this.instrument).append('\n');
        }
        if (this.variableModifications != null) {
            parameters.append("IT_MODS=").append(this.variableModifications).append('\n');
        }
        if (this.fragmentIonTolerance != null) {
            parameters.append("ITOL=").append(this.fragmentIonTolerance.toString()).append('\n');
        }
        if (this.fragmentIonToleranceUnit != null) {
            parameters.append("ITOLU=").append(this.fragmentIonToleranceUnit == FragmentToleranceUnits.MMU ? "mmu" : "Da").append('\n');
        }
        if (this.massType != null) {
            parameters.append("MASS=").append(this.massType == MassType.AVERAGE ? "Average" : "Monoisotopic").append('\n');
        }
        if (this.fixedMofications != null) {
            parameters.append("MODS=").append(this.fixedMofications).append('\n');
        }
        if (this.peptideIsotopeError != null) {
            parameters.append("PEP_ISOTOPE_ERROR=").append(this.peptideIsotopeError.toString()).append('\n');
        }
        if (this.partials != null) {
            parameters.append("PFA=").append(this.partials.toString()).append('\n');
        }
        if (this.precursor != null) {
            parameters.append("PRECURSOR=").append(this.precursor.toString()).append('\n');
        }
        if (this.quantitation != null) {
            parameters.append("QUANTITATION=").append(this.quantitation).append('\n');
        }
        if (this.maxHitsToReport != null) {
            parameters.append("REPORT=").append(this.maxHitsToReport).append('\n');
        }
        if (this.reportType != null) {
            parameters.append("REPTYPE=").append(this.reportType.toString()).append('\n');
        }
        if (this.searchType != null) {
            parameters.append("SEARCH=").append(this.searchType.toString()).append('\n');
        }
        if (this.proteinMass != null) {
            parameters.append("SEG=").append(this.proteinMass).append('\n');
        }
        if (this.taxonomy != null) {
            parameters.append("TAXONOMY=").append(this.taxonomy).append('\n');
        }
        if (this.peptideMassTolerance != null) {
            parameters.append("TOL=").append(this.peptideMassTolerance.toString()).append('\n');
        }
        if (this.peptideMassToleranceUnit != null) {
            parameters.append("TOLU=").append(this.peptideMassToleranceUnit.toString()).append('\n');
        }
        if (this.userMail != null) {
            parameters.append("USEREMAIL=").append(this.userMail).append('\n');
        }
        if (this.userName != null) {
            parameters.append("USERNAME=").append(this.userName).append('\n');
        }
        if (this.userParameter != null) {
            for (i = 0; i < this.userParameter.size(); ++i) {
                parameters.append("USER").append(i < 10 ? "0" : "").append(Integer.toString(i)).append('=').append(this.userParameter.get(i)).append('\n');
            }
        }
        return parameters.toString();
    }

    public Ms2QueryIterator getMs2QueryIterator() {
        return new Ms2QueryIterator();
    }

    public List<IndexElement> getIndex() {
        return new ArrayList<IndexElement>(this.index);
    }

    @Override
    public int getSpectraCount() {
        return this.getMs2QueryCount();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return false;
    }

    @Override
    public List<String> getSpectraIds() {
        ArrayList<String> ids = new ArrayList<String>(this.getMs2QueryCount());
        for (int id = 1; id <= this.getMs2QueryCount(); ++id) {
            ids.add(Integer.toString(id));
        }
        return ids;
    }

    @Override
    public Spectrum getSpectrumById(String id) throws JMzReaderException {
        int index = Integer.parseInt(id);
        return this.getMs2Query(index - 1, this.ignoreWrongPeaks);
    }

    @Override
    public Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        return this.getMs2Query(index - 1, this.ignoreWrongPeaks);
    }

    @Override
    public Iterator<Spectrum> getSpectrumIterator() {
        return new SpectrumIterator();
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        if (msLevel != 2) {
            return Collections.emptyList();
        }
        return new ArrayList<IndexElement>(this.index);
    }

    @Override
    public List<Integer> getMsLevels() {
        ArrayList<Integer> msLevels = new ArrayList<Integer>(1);
        msLevels.add(2);
        return msLevels;
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        HashMap<String, IndexElement> idToIndexMap = new HashMap<String, IndexElement>(this.index.size());
        for (int i = 0; i < this.index.size(); ++i) {
            idToIndexMap.put(String.format("%d", i + 1), this.index.get(i));
        }
        return idToIndexMap;
    }

    public void setAllowCustomTags(boolean allowCustomTags) {
        this.allowCustomTags = allowCustomTags;
    }

    public void setDisableCommentSupport(boolean disableCommentSupport) {
        this.disableCommentSupport = disableCommentSupport;
    }

    public class Ms2QueryIterator
    implements Iterator<Ms2Query>,
    Iterable<Ms2Query> {
        private Integer currentPosition = 0;
        private ArrayList<Integer> keys = new ArrayList(MgfFile.access$000(MgfFile.this).keySet());

        protected Ms2QueryIterator() {
        }

        @Override
        public Iterator<Ms2Query> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (MgfFile.this.sourceFile == null) {
                return this.currentPosition < this.keys.size();
            }
            return this.currentPosition < MgfFile.this.index.size();
        }

        @Override
        public Ms2Query next() {
            if (MgfFile.this.sourceFile == null) {
                if (this.currentPosition < 0 || this.currentPosition >= this.keys.size()) {
                    throw new IllegalStateException(new IndexOutOfBoundsException());
                }
                Integer n = this.currentPosition;
                Integer n2 = this.currentPosition = Integer.valueOf(this.currentPosition + 1);
                Integer key = this.keys.get(n);
                if (!MgfFile.this.ms2Queries.containsKey(key)) {
                    throw new IllegalStateException("Key not found in hashmap");
                }
                return (Ms2Query)MgfFile.this.ms2Queries.get(key);
            }
            if (MgfFile.this.ms2Queries.containsKey(this.currentPosition)) {
                return (Ms2Query)MgfFile.this.ms2Queries.get(this.currentPosition);
            }
            try {
                Ms2Query query = MgfFile.this.loadIndexedQueryFromFile(this.currentPosition, MgfFile.this.ignoreWrongPeaks);
                if (MgfFile.this.useCache) {
                    MgfFile.this.ms2Queries.put(this.currentPosition, query);
                }
                Integer n = this.currentPosition;
                Integer n3 = this.currentPosition = Integer.valueOf(this.currentPosition + 1);
                return query;
            }
            catch (JMzReaderException e) {
                throw new RuntimeException("Failed to load query from file.", e);
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Function not supported");
        }
    }

    private class SpectrumIterator
    implements Iterator<Spectrum> {
        Iterator<Ms2Query> it;

        public SpectrumIterator() {
            this.it = new Ms2QueryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Spectrum next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    public static enum PeptideToleranceUnit {
        PERCENT("%"),
        PPM("ppm"),
        MMU("mmu"),
        DA("Da");

        private String name;

        private PeptideToleranceUnit(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ReportType {
        PROTEIN("protein"),
        PEPTIDE("peptide"),
        ARCHIVE("archive"),
        CONCISE("concise"),
        SELECT("select"),
        UNASSIGNED("unassigned");

        private String name;

        private ReportType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SearchType {
        PMF("PMF"),
        SQ("SQ"),
        MIS("MIS");

        private String name;

        private SearchType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MassType {
        MONOISOTOPIC,
        AVERAGE;

    }

    public static enum FragmentToleranceUnits {
        DA,
        MMU;

    }
}

