/**
 * \file pappsomspp/core/processing/cbor/mzcbor/mzcborindexreader.h
 * \date 03/12/2025
 * \author Olivier Langella
 * \brief read mzcbor index file
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include "pappsomspp/core/processing/cbor/cborstreamreaderinterface.h"


namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @todo write docs
 */
class MzcborIndexReader : public CborStreamReaderInterface
{
  public:
  /**
   * Default constructor
   */
  MzcborIndexReader();

  /**
   * Destructor
   */
  virtual ~MzcborIndexReader();


  virtual void readCbor(QFile *cborp);

  virtual void close();

  bool isMzcborIndex() const;

  const std::vector<QString> &getRunIdList() const;
  const std::vector<std::vector<qint64>> &getRunAndSpectrumOffsetList() const;
  const std::vector<std::vector<QString>> &getRunAndSpectrumIdList() const;

  protected:
  void readRoot();

  private:
  bool m_isMzcborIndex = false;
  QString m_from;
  std::vector<QString> m_runIdList;
  std::vector<std::vector<qint64>> m_runAndSpectrumOffsetList;
  std::vector<std::vector<QString>> m_runAndSpectrumIdList;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
