/**
 * \file pappsomspp/core/processing/cbor/mzcbor/mzcborbuildindexreader.h
 * \date 24/11/2025
 * \author Olivier Langella
 * \brief read mzcbor to build an index
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once

#include "pappsomspp/core/processing/cbor/mzcbor/mzcborreaderbase.h"
#include "pappsomspp/core/msrun/spectrumcollectionhandlerinterface.h"
#include "pappsomspp/core/msrun/msrunreadconfig.h"
#include "pappsomspp/core/msrun/msrunid.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @todo write docs
 */
class MzcborBuildIndexReader : public MzcborReaderBase
{
  public:
  /**
   * Default constructor
   */
  MzcborBuildIndexReader(const MsRunIdCstSPtr &msrun_id);

  /**
   * Destructor
   */
  virtual ~MzcborBuildIndexReader();
  virtual void readCbor(QFile *cborp, pappso::UiMonitorInterface &monitor)override;

  const std::vector<qint64> &getSpectrumIndexPositionInFile() const;
  const std::map<QString, std::size_t> &getNativeId2SpectrumIndexMap() const;


  protected:
  /** @brief read only the targeted msrun
   */
  virtual void readMsrun() override;


  /** @brief only the spectrum list of targeted msrun, then stop parsing
   */
  void readSpectrumListAndLeave();


  /** @brief read each spectrum in the targeted msrun (msrunId)
   */
  void readSpectrum(qint64 position_of_spectrum_in_file, std::size_t index_count);
  
  


  private:
  MsRunIdCstSPtr mcsp_msRunId;
  QString m_xmlMzMlRunId;

  std::vector<qint64> m_spectrumIndexPositionInFile;
  std::map<QString, std::size_t> m_nativeId2SpectrumIndexMap;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
