/**
 * \file pappsomspp/processing/specglob/peptidemodel.h
 * \date 05/10/2025
 * \author Olivier Langella
 * \brief SpecPeptidOMS peptide model
 * \todo https://www.psidev.info/proforma
 *
 */


/*
 * SpecGlobTool, Spectra to peptide alignment tool
 * Copyright (C) 2025  Olivier Langella
 * <olivier.langella@universite-paris-saclay.fr>
 *
 * This program is free software: you can redistribute ipetide to spectrum
 * alignmentt and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include "pappsomspp/core/types.h"
#include "pappsomspp/core/amino_acid/aa.h"

namespace pappso
{
namespace specpeptidoms
{


struct AminoAcidModel
{
  pappso::Aa m_aminoAcid  = pappso::Aa('A');
  double m_massDifference = 0;
  bool m_skipped          = false;

  QString toProForma() const;
  QString toInterpretation() const;
};
/**
 * @brief modelize peptide sequence to facilitate rendering in bracket or proforma
 */
class PeptideModel : public std::vector<AminoAcidModel>
{
  public:
  /**
   * Default constructor
   */
  PeptideModel();

  /**
   * Destructor
   */
  virtual ~PeptideModel();

  void reset();

  void setCterShift(double mass_shift);
  void setNterShift(double mass_shift);

  QString toProForma() const;

  QString toInterpretation() const;

  void setPrecursorMass(double mass);

  double getPrecursorMass() const;

  static QString toProFormaMass(double mass);

  double getMass() const;

  /**
   * @brief Return the difference between the precursor's mass and the mass modelized by the
   * PeptideModel.
   */
  double getNonAlignedMass() const;

  private:
  double m_cterShift     = 0;
  double m_nterShift     = 0;
  double m_precursorMass = 0;
};

} // namespace specpeptidoms
} // namespace pappso
