
#pragma once

#include <QString>

#include <pwiz/data/msdata/MSData.hpp>

#include "pappsomspp/core/types.h"
#include "msfilereader.h"
#include "pappsomspp/core/msrun/msrunid.h"
#include "pappsomspp/core/processing/cbor/mzcbor/mzcborreaderbase.h"


namespace pappso
{

/**
 * @todo write docs
 */
class MzcborMsFileReader : MsFileReader
{

  public:
  MzcborMsFileReader(const QString &file_name);
  virtual ~MzcborMsFileReader();

  virtual Enums::MsDataFormat getFileFormat() override;

  virtual std::vector<MsRunIdCstSPtr> getMsRunIds(const QString &run_prefix) override;

  private:
  virtual std::size_t initialize();

  private:
  std::vector<pwiz::msdata::MSDataPtr> m_msDataPtrVector;

  pappso::cbor::mzcbor::MzcborReaderBase m_mzcborReaderBase;
};
} // namespace pappso
