#include "mzcbormsfilereader.h"

#include "pappsomspp/core/processing/uimonitor/uimonitorvoid.h"
#include "pappsomspp/core/utils.h"

namespace pappso
{


MzcborMsFileReader::MzcborMsFileReader(const QString &file_name) : MsFileReader{file_name}
{
  m_fileFormat = pappso::Enums::MsDataFormat::unknown;
  initialize();
}


MzcborMsFileReader::~MzcborMsFileReader()
{
}


Enums::MsDataFormat
MzcborMsFileReader::getFileFormat()
{
  // std::cout << __FILE__ << " @ " << __LINE__ << " " << __FUNCTION__ << " () "
  //        << std::setprecision(15) << "m_fileFormat: " << (int)m_fileFormat
  //      << std::endl;

  return m_fileFormat;
}

std::size_t
pappso::MzcborMsFileReader::initialize()
{

  pappso::UiMonitorVoid monitor;
  QFile mzcbor_file(m_fileName);
  mzcbor_file.open(QIODevice::ReadOnly);

  m_mzcborReaderBase.readCbor(&mzcbor_file, monitor);
  if(m_mzcborReaderBase.isMzcbor())
    {
      m_fileFormat = pappso::Enums::MsDataFormat::mzcbor;
    }
  m_mzcborReaderBase.close();
  mzcbor_file.close();

  qDebug() << m_mzcborReaderBase.getMsrunIdList().join(" ");

  return m_mzcborReaderBase.getMsrunIdList().size();
}


std::vector<MsRunIdCstSPtr>
MzcborMsFileReader::getMsRunIds(const QString &run_prefix)
{
  std::vector<MsRunIdCstSPtr> ms_run_ids;


  if(m_fileFormat == pappso::Enums::MsDataFormat::mzcbor)
    {

      std::size_t iter = 0;
      for(auto &msrun_id_str : m_mzcborReaderBase.getMsrunIdList())
        {
          MsRunId ms_run_id(m_fileName, msrun_id_str);


          // Set the MS data format as determined in initialize().
          ms_run_id.setMsDataFormat(m_fileFormat);

          // We need to set the unambiguous xmlId string.
          ms_run_id.setXmlId(
            QString("%1%2").arg(run_prefix).arg(Utils::getLexicalOrderedString(iter)));

          // Now set the sample name to the run id : we can not do that, this is not the use sample
          // name
          // ms_run_id.setSampleName(QString::fromStdString(ms_data_ptr->run.id));

          // And if it is possible, the real sample name because this one is for the
          // end user to recognize his sample:
          ms_run_id.setSampleName(msrun_id_str);


          ms_run_ids.push_back(std::make_shared<MsRunId>(ms_run_id));
          iter++;
        }
    }

  // std::size_t iter = 0;
  /*
    for(const pwiz::msdata::MSDataPtr & ms_data_ptr : m_msDataPtrVector)
      {
        MsRunId ms_run_id(m_fileName, QString::fromStdString(ms_data_ptr->run.id));

        // Set the MS data format as determined in initialize().
        ms_run_id.setMsDataFormat(m_fileFormat);

        // We need to set the unambiguous xmlId string.
        ms_run_id.setXmlId(QString("%1%2")
                             .arg(run_prefix)
                             .arg(Utils::getLexicalOrderedString(iter)));

        // Now set the sample name to the run id : we can not do that, this is not the use sample
    name
        //ms_run_id.setSampleName(QString::fromStdString(ms_data_ptr->run.id));

        // And if it is possible, the real sample name because this one is for the
        // end user to recognize his sample:
        if(ms_data_ptr->run.samplePtr != nullptr)
          {
            ms_run_id.setSampleName(
              QString::fromStdString(ms_data_ptr->run.samplePtr->name));
          }

        // qDebug() << __FILE__ << "@" << __LINE__ << __FUNCTION__ << "()"
        //<< "Current ms_run_id:" << ms_run_id.toString();

        // Finally make a shared pointer out of it and append it to the vector.
        ms_run_ids.push_back(std::make_shared<MsRunId>(ms_run_id));

        ++iter;
      }
  */
  return ms_run_ids;
}
} // namespace pappso
