[Setup]
AppName=i2MassChroQ

#define public winerootdir "z:"
; Set version number below
#define public version "1.3.2"
AppVersion={#version}

#define public arch "mingw64"
#define public platform "win7+"
#define sourceDir "z:/home/langella/developpement/git/i2masschroq/"
#define cmake_build_dir "z:/home/langella/developpement/git/i2masschroq/wbuild"

; Set version number below
AppVerName=i2MassChroQ version {#version}
DefaultDirName={pf}\i2MassChroQ
DefaultGroupName=i2MassChroQ
OutputDir="{#cmake_build_dir}"

; Set version number below
OutputBaseFilename=i2MassChroQ-{#arch}-{#platform}-v{#version}-setup

; Set version number below
OutputManifestFile=i2MassChroQ-{#arch}-{#platform}-v{#version}-setup-manifest.txt
ArchitecturesAllowed=x64
ArchitecturesInstallIn64BitMode=x64

LicenseFile="{#sourceDir}\COPYING"
AppCopyright="Copyright (C) 2016- Olivier Langella"

AllowNoIcons=yes
AlwaysShowComponentsList=yes
AllowRootDirectory=no
AllowCancelDuringInstall=yes
AppComments="i2MassChroQ, by Olivier Langella"
AppContact="Olivier Langella, research engineer at CNRS, France"
CloseApplications=yes
CreateUninstallRegKey=yes
DirExistsWarning=yes
WindowResizable=yes
; WizardImageFile="{#sourceDir}\images\splashscreen-innosetup.bmp"
WizardImageStretch=yes

[Dirs]
Name: "{app}"

[Files]
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/hdf5*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/icudt74.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/icuin74.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/icuuc74.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libboost_*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libbz2.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libcrypto-3-x64.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libexpat-1.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libfreetype-6.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libgcc_s_seh-1.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libglib-2.0-0.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libharfbuzz-*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libiconv-2.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libintl-8.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libjpeg-9.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libpng*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/liblzma-5.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libbrotli*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libpcre2-*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libstdc++-6.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libwinpthread-1.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/zlib1.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/bin/libzstd.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/qt6/bin/Qt6*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/mxe/usr/x86_64-w64-mingw32.shared/qt6/plugins/*"; DestDir: {app}/plugins; Flags: ignoreversion recursesubdirs
Source: "z:/opt/win64/liblzf-3.6/liblzf.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/win64/libquazip1-qt6-1.4/quazip/libquazip1-qt6.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/opt/win64/qcustomplot-2.1.0+dfsg1/libQCustomPlotQt6.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/home/langella/developpement/git/cutelee/wbuild/templates/lib/libCuteleeQt6Templates.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/home/langella/developpement/git/cutelee/wbuild/cutelee-qt6/6.1/*"; DestDir: {app}/cutelee-qt6/6.1; Flags: ignoreversion recursesubdirs;
Source: "z:/home/langella/developpement/git/libpwizlite/wbuild/src/libpwizlite.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/home/langella/developpement/git/libodsstream/wbuild/src/libodsstream.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/home/langella/developpement/git/pappsomspp/wbuild/src/pappsomspp/core/libpappsomspp-core.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;
Source: "z:/home/langella/developpement/git/pappsomspp/wbuild/src/pappsomspp/gui/libpappsomspp-gui.dll"; DestDir: {app}; Flags: ignoreversion recursesubdirs;

Source: "{#sourceDir}\README"; DestDir: {app}; Flags: isreadme; Components: i2MassChroQComp
Source: "{#sourceDir}\COPYING"; DestDir: {app}; Flags: isreadme; Components: i2MassChroQComp
Source: "{#sourceDir}\win64\i2MassChroQ_icon.ico"; DestDir: {app}; Components: i2MassChroQComp
Source: "{#cmake_build_dir}\i2MassChroQ_user_manual.pdf"; DestDir: {app};

Source: "{#cmake_build_dir}\src\i2MassChroQ.exe"; DestDir: {app}; Components: i2MassChroQComp
Source: "{#cmake_build_dir}\src\cli\masschroq3.exe"; DestDir: {app}; Components: i2MassChroQComp
Source: "{#cmake_build_dir}\src\cli\masschroq-export.exe"; DestDir: {app}; Components: i2MassChroQComp
Source: "{#cmake_build_dir}\src\mzxmlconverter.exe"; DestDir: {app}; Components: i2MassChroQComp
Source: "{#cmake_build_dir}\..\..\tandemng\wbuild\src\tandemng.exe"; DestDir: {app}; Components: i2MassChroQComp
Source: "{#cmake_build_dir}\..\..\tandemng\wbuild\src\2015\tandemng2015.exe"; DestDir: {app}; Components: i2MassChroQComp
Source: "{#cmake_build_dir}\..\..\tandemng\wbuild\src\2015p\tandemng2015p.exe"; DestDir: {app}; Components: i2MassChroQComp

[Icons]
Name: "{group}\i2MassChroQ"; Filename: "{app}\i2MassChroQ.exe"; WorkingDir: "{app}";IconFilename: "{app}\i2MassChroQ_icon.ico"
Name: "{group}\Uninstall i2MassChroQ"; Filename: "{uninstallexe}"

[Types]
Name: "i2MassChroQType"; Description: "Full installation"

[Components]
Name: "i2MassChroQComp"; Description: "i2MassChroQ files"; Types: i2MassChroQType

[Run]
;Filename: "{app}\README"; Description: "View the README file"; Flags: postinstall shellexec skipifsilent
Filename: "{app}\i2MassChroQ.exe"; Description: "Launch i2MassChroQ"; Flags: postinstall nowait unchecked
