{% if step == "libraries" %} # SdsXicAnalysisStep::quality_xic


capture.output(library("MCQR", verbose=FALSE), file=stderr())
message(paste("MCQRInfo: MCQR version :", packageVersion("MCQR")))
library("xtable")
library("svglite")
library("readODS")
if (library("MSstats",logical.return = T)) {
  message("required libraries are ready to use")
}

pimg_srcsvg <- function(path,prefix) {
  for(file_svg in list.files(path = path, pattern=paste(prefix,".*\\.svg",sep=""))){
    cat(paste("<p><img src=\"",path, file_svg, "\" /></p>\n",sep=""));
  }
}

pimg_srcpng <- function(path,prefix) {
  for(file_svg in list.files(path = path, pattern=paste(prefix,".*\\.png",sep=""))){
    cat(paste("<p><img src=\"",path, file_svg, "\" /></p>\n",sep=""));
  }
}


{% elif step == "load" %}

  cat("<h1>MSstats XIC Analysis</h1>")
  cat("<p>working directory: {{ tmp_path }}</p>")

  cat("<h2>Load XIC data</h2>")
  # Loading MassChroq data. NB: peptide intensities measured as peak areas are automatically log10-transformed.
  # Directory names must not include a trailing backslash or slash on Windows
  XICRAW <- mcq.read.masschroq(protFile = "{{protein_tsv_file}}", pepFile = "{{peptide_tsv_file}}")

  # Overview of the content of the 'XICRAW' object
  summary (XICRAW)
  save(XICRAW, file="{{ tmp_path }}xicraw_nometadata.rdata")
  

{% elif step == "merge_metadata" %}
  load(file="{{ tmp_path }}xicraw_nometadata.rdata")
  
  cat("<h1>Reading metadata file</h1>")
  cat("<h2>Columns \"Condition\" and \"BioReplicate\" specific to MSstats</h2>")
  # Importing the filled in metadata file
  capture.output(META <- mcq.read.metadata("{{ tmp_path }}metadata.ods"), file=stderr()) 
  # Attaching metadata to quantification data
  cat("<h1>Merging metadata</h1>")
  XICRAW <- mcq.add.metadata(XICRAW, metadata=META)

  # Overview of the content of the 'XICRAW' object
  summary (XICRAW)
  save(XICRAW, file="{{ tmp_path }}xicraw.rdata")
  cat("<h3>Chromatography checking</h3>")
  cat("<h4>Plot distribution of the width of chromatographic peaks</h4>")
  # Checking the distribution of the width of chromatographic peaks. Are there many very large peaks?
  svglite("{{ tmp_path }}peak_width.svg", width=14, height=12);
  capture.output(mcq.plot.peak.width(XICRAW, byFraction = FALSE), file=stderr())
  capture.output(dev.off(), file=stderr());
  pimg_srcsvg(path="{{ tmp_path }}",prefix="peak_width");
  
  cat("<h4>Plot distribution of the standard deviation of RT</h4>")
  # Checking the variability of the peptide-mz retention time (RT) by plotting the distribution of the standard deviation of RT. Are there many peptides-mz showing huge variations of their RT?
  svglite("{{ tmp_path }}rt_variability.svg", width=14, height=12);
  capture.output(mcq.plot.rt.variability(XICRAW, limit={{ upper_x_axis }}), file=stderr())
  capture.output(dev.off(), file=stderr());
  pimg_srcsvg(path="{{ tmp_path }}",prefix="rt_variability");

  cat("<h3>Plot injections checking</h3>")
  cat("<h4>Plot number of peptides by tracks and fraction</h4>")
  # Checking the number of chromatographic peaks quantified in each injection. Are there injections with much fewer peaks?
  svglite("{{ tmp_path }}injection_counts.svg", width=14, height=12);
  capture.output(mcq.plot.counts(XICRAW, overlay=TRUE), file=stderr())
  capture.output(dev.off(), file=stderr());
  pimg_srcsvg(path="{{ tmp_path }}",prefix="injection_counts");
  
  cat("<h4>Plot intensity profiles for selected factors</h4>")
  #  Checking the median intensity along the chromatography. Are there injections showing abnormal intensity profiles?
  svglite("{{ tmp_path }}intensity_profile.svg", width=14, height=12);
  capture.output(mcq.plot.intensity.profile(XICRAW, factorToColor=c({{ factors_color }}), RTinterval={{ rt_interval }}), file=stderr())
  capture.output(dev.off(), file=stderr());
  pimg_srcsvg(path="{{ tmp_path }}",prefix="intensity_profile");
  
  cat("<h4>Plot distribution of peptide intensities for each injection</h4>")
  # Checking the distribution of the peptide-mz log-intensities in each injection. Are there injections where intensities are not normally distributed?
  svglite("{{ tmp_path }}intensity_distribution%d.svg", width=14, height=12);
  capture.output(mcq.plot.intensity.distribution(XICRAW), file=stderr())
  capture.output(dev.off(), file=stderr());
  
  pimg_srcsvg(path="{{ tmp_path }}",prefix="intensity_distribution");


{% elif step == "mcqr_dubiousDataFilter" %}
  
  load(file="{{ tmp_path }}xicraw.rdata")
  cat("<h3>Before MCQR dubious data filter</h3>")
  summary(XICRAW)
  #############  If necessary, removing dubious chromatographic data
  # Removing peptides-mz showing too much variations of their retention time. These peptides-mz may occur from mis-identifications. Use the plot produced by the mcq.plot.rt.variability function to decide on the cut-off of standard deviation to use (e.g. here, 20 seconds).
  capture.output(XIC <- mcq.drop.variable.rt(XICRAW, cutoff={{ cutoff_rt }}), file=stderr())
    
  # Removing peptides-mz associated to very large chromatographic peaks. Use the plot produced by the mcq.plot.peak.width function to decide on the cut-off to use (e.g. here, 200 seconds). Don't be too stringent with this filter because the peak width is proportional to the peak height. A large peak may therefore simply correspond to a peptide-mz that is particularly intense in a given injection. 
  capture.output(XIC <- mcq.drop.wide.peaks(XIC, cutoff={{ cutoff_peaks }}), file=stderr())

  ############# Display of a summary of the 'XIC' object after removal of dubious peptides
  cat("<h3>After MCQR dubious data filter</h3>")
  summary(XIC)
  save(XIC, file="{{ tmp_path }}xic.rdata")

{% elif step == "msstats_dataProcess" %}
  

  if(file.exists("{{ tmp_path }}xic.rdata")){
    load(file="{{ tmp_path }}xic.rdata")
  } else {
    load(file="{{ tmp_path }}xicraw.rdata")
    XIC <- XICRAW
  }
  
  # drop shared peptides
  summary(XIC)
  ############# Removing shared peptides
  cat("<h1>Removing shared peptides</h1>")
  XIC <- mcq.drop.shared.peptides(XIC)
  summary(XIC)
  
  # Number of features and missing values
  
  cat("<h1>Conversion to MSstats input format</h1>")
  msstats <- mcq.get.msstats (XIC, condition="Condition",bioreplicate="BioReplicate")
  
  cat("writing msstats.tsv file")
  write.table(msstats, file = "{{ tmp_path }}msstats.tsv", sep = "\t", row.names = T, quote = T)
  
  cat("<h1>Running MSstats</h1>")
  quantData<-dataProcess(msstats,  
  logTrans = {{ dataprocess_logtrans }},
  normalization = "equalizeMedians", featureSubset="all", censoredInt = "0", verbose = FALSE)
  save(quantData, file="{{ tmp_path }}quantData_msstats.rdata")

{% elif step == "msstats_sampleQuantification" %}
  
  load(file="{{ tmp_path }}quantData_msstats.rdata")
  
  cat("<h1>MSstats quantification process on samples</h1>")
  sampleQuantification<-quantification(data=quantData,type="Sample")
  save(sampleQuantification, file="{{ tmp_path }}sampleQuantification.rdata")
  
  rownames.protein <- sampleQuantification$Protein
  tacp <- sampleQuantification
  tacp[is.na(tacp)] <- 0
  tacp$Protein <- NULL
  tacp <-as.matrix(tacp)
  rownames(tacp) <- rownames.protein
  # scale
  tacp <- t(scale(t(tacp)))
  distance <- function(x) as.dist(1 - cor(x, use ="pairwise.complete.obs" ))
  clust <- hclust(distance(t(tacp)))
  sampleQuantification$order <- clust$order
  sampleQuantification <- sampleQuantification[order(sampleQuantification$order), ]
  sampleQuantification$order <- NULL
  
  write.table(sampleQuantification, file = "{{ tmp_path }}sampleQuantification.tsv", sep = "\t", row.names = T, quote = T, )

  cat("<p>done</p>")
{% elif step == "msstats_groupQuantification" %}
  
  load(file="{{ tmp_path }}quantData_msstats.rdata")
  # (1) group quantification
  cat("<h1>MSstats quantification process on groups (for each condition described in metadata)</h1>")
  groupQuantification<-quantification(data=quantData,type="Group")
  save(groupQuantification, file="{{ tmp_path }}groupQuantification.rdata")
  
  
  rownames.protein <- groupQuantification$Protein
  tacp <- groupQuantification
  tacp[is.na(tacp)] <- 0
  tacp$Protein <- NULL
  tacp <-as.matrix(tacp)
  rownames(tacp) <- rownames.protein
  # scale
  tacp <- t(scale(t(tacp)))

  #distance <- function(x) as.dist(1 - cor(x, use ="pairwise.complete.obs" ))
  distance <- function(x) dist(t(x), method = "euclidean")
  
  clust <- hclust(distance(t(tacp)))
  
  groupQuantification$order <- clust$order
  groupQuantification <- groupQuantification[order(groupQuantification$order), ]
  groupQuantification$order <- NULL
  
  write.table(groupQuantification, file = "{{ tmp_path }}groupQuantification.tsv", sep = "\t", row.names = T, quote = T)

  cat("<p>done</p>")
{% endif %}
