/**
 * \file /gui/run/sage/sagerundialog.h
 * \date 08/05/2025
 * \author Olivier Langella
 * \brief dialog window to run Sage process
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once


#include <QDialog>
#include <QJsonDocument>
#include <QStringListModel>
#include <QFile>
#include <pappsomspp/core/precision.h>
#include "../../../core/sage_run/sagerunbatch.h"

namespace Ui
{
class SageRunDialog;
}

/**
 * @todo write docs
 */
class SageRunDialog : public QDialog
{
  Q_OBJECT
  public:
  explicit SageRunDialog(QWidget *parent);
  virtual ~SageRunDialog();

  SageRunBatch getSageRunBatch() const;

  protected slots:
  void selectFasta();
  void loadJson();
  void saveJson();
  void selectOutputDirectory();
  void selectMzFiles();
  void selectTdfFolder();
  void clearMzFiles();
  void selectSageBin();


  protected:
  void done(int r) override;
  bool checkBeforeRun();

  private:
  void loadJsonFile(QFile json_file);
  void json2ui();
  void ui2json();
  pappso::PrecisionPtr
  getPrecisionPtrFromJson(const QJsonObject &precision_json);
  QJsonObject getJsonPrecisionPtr(pappso::PrecisionPtr precision_ptr);


  const QJsonValue documentFind(const QString &key1, const QString &key2) const;

  private:
  Ui::SageRunDialog *ui;
  QJsonDocument m_jsonDocument;
  QStringListModel *mpa_mzFileList;
};
