/**
 * \file core/mcqr/mcqrmetadata.h
 * \date 13/01/2021
 * \author Thomas Renne
 * \brief Store metadata lines
 */

/*******************************************************************************
 * Copyright (c) 2021 Thomas Renne <thomas.renne@e.email>.
 *
 * This file is part of i2MassChroQ.
 *
 *     i2MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     i2MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with i2MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Thomas Renne <thomas.renne@e.email> - initial API and
 *implementation
 ******************************************************************************/

#pragma once
#include <QString>
#include <QVariant>

struct McqrMetadata
{
  QString m_msrunId;
  QString m_msrunFile;
  std::map<QString, QVariant> m_otherData;

  const QVariant &getQVariantByColumnName(const QString &name) const;

  /** tell if all metadata are empty
   */
  bool isMetadataEmpty();
};
