/**
 * \file mcql/input/cborstreamreader2json.h
 * \date 08/01/2025
 * \author Olivier Langella
 * \brief read cbor stream to produce JSON readable document
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of MassChroQ.
 *
 *     MassChroQ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     MassChroQ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with MassChroQ.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once

#include <QJsonObject>
#include <QStack>
#include <QFile>
#include <pappsomspp/core/processing/uimonitor/uimonitorinterface.h>
#include "cborstreamreaderbase.h"

namespace mcql
{
/**
 * @todo write docs
 */
class CborStreamReader2Json : public CborStreamReaderBase
{
  public:
  /**
   * Default constructor
   */
  CborStreamReader2Json();

  /**
   * Destructor
   */
  virtual ~CborStreamReader2Json();


  const QJsonObject &getJsonObject() const;

  protected:
  virtual void readEnd(pappso::UiMonitorInterface &monitor) override;
  virtual void readInformations(pappso::UiMonitorInterface &monitor) override;
  virtual void readProjectParameters() override;
  virtual void readActions(pappso::UiMonitorInterface &monitor) override;
  virtual void
  readIdentificationData(pappso::UiMonitorInterface &monitor) override;
  virtual void
  readMasschroqMethods(pappso::UiMonitorInterface &monitor) override;
  virtual void
  readQuantificationData(pappso::UiMonitorInterface &monitor) override;

  virtual void
  readAlignmentDataArray(pappso::UiMonitorInterface &monitor) override;


  private:
  void writeCborObject(const QString &name, const QCborValue &cbor_value);

  private:
  QJsonObject m_jsonRoot;
};

} // namespace mcql
