#import "template.typ": *

#let today = datetime.today()

#show: doc => conf(
  authors: (
    (
      name: "Benoît Valot",
    ),
    (
      name: "Olivier Langella",
    ),
    (
      name: "Thomas Renne",
    ),
    (
      name: "Filippo Rusconi",
    ),
    (
      name: "Michel Zivy",
    ),
  ),
  toc: true,
  lang: "en",
  font: "EB Garamond 12",
  date: today.display("[day]/[month]/[year]"),
  years: (2024, 2025),
  version: json("user-manual-version.json").i2m_version,
  subtitle: "Free and Open Source Protein Identification Software",
  "i2MassChroQ User Manual",
  doc
)


#include "chapters/a1_preface.typ"


#include "chapters/a2_generalities.typ"
#include "chapters/a3_fundamentals-in-bottom-up-proteomics.typ"
#include "chapters/a4_main-program-window.typ"
#include "chapters/a5_exploring-identification-data.typ"
#include "chapters/a6_exploring-post-translational-modification-data.typ"
#include "chapters/a7_advanced-proteomics-configurations.typ"
#include "chapters/a8_quantitative-proteomics.typ"
#include "chapters/a9_bruker-tims-tof-data-handling.typ"

#bibliography(style:"frontiers", "biblio.bib")
